/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.console;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.undo.UndoManager;
import org.jmol.api.JmolScriptEditorInterface;
import org.jmol.console.JmolConsole;
import org.jmol.i18n.GT;
import org.jmol.script.ScriptContext;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;

public final class ScriptEditor
extends JDialog
implements JmolScriptEditorInterface,
ActionListener {
    protected EditorTextPane editor;
    private JButton openButton;
    private JButton closeButton;
    private JButton loadButton;
    private JButton topButton;
    private JButton checkButton;
    private JButton runButton;
    private JButton pauseButton;
    private JButton haltButton;
    private JButton clearButton;
    private JButton stateButton;
    private JButton consoleButton;
    protected JButton stepButton;
    protected JButton resumeButton;
    private Viewer viewer;
    private JmolConsole jmolConsole;
    protected String title;
    protected String parsedData = "";
    protected ScriptContext parsedContext;
    protected SimpleAttributeSet attHighlight;
    protected SimpleAttributeSet attEcho;
    protected SimpleAttributeSet attError;
    private JPanel buttonPanel = new JPanel();
    protected String filename;
    private static String[] lastOpened = new String[]{"?.spt", null};

    public ScriptEditor() {
    }

    ScriptEditor(Viewer viewer, JFrame jFrame, JmolConsole jmolConsole) {
        super(jFrame, null, false);
        this.setAttributes();
        this.title = GT._((String)"Jmol Script Editor");
        this.setTitle(this.title);
        this.viewer = viewer;
        this.jmolConsole = jmolConsole;
        this.layoutWindow(this.getContentPane());
        this.setSize(745, 400);
        if (jFrame != null) {
            this.setLocationRelativeTo(jFrame);
        }
    }

    private void setAttributes() {
        this.attHighlight = new SimpleAttributeSet();
        StyleConstants.setBackground(this.attHighlight, Color.LIGHT_GRAY);
        StyleConstants.setForeground(this.attHighlight, Color.blue);
        StyleConstants.setBold(this.attHighlight, true);
        this.attEcho = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attEcho, Color.blue);
        StyleConstants.setBold(this.attEcho, true);
        this.attError = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attError, Color.red);
        StyleConstants.setBold(this.attError, true);
    }

    void layoutWindow(Container container) {
        this.editor = new EditorTextPane();
        this.editor.setDragEnabled(true);
        JScrollPane jScrollPane = new JScrollPane(this.editor);
        this.consoleButton = this.setButton(GT._((String)"Console"));
        if (!this.viewer.isApplet() || this.viewer.getBooleanProperty("_signedApplet")) {
            this.openButton = this.setButton(GT._((String)"Open"));
        }
        this.loadButton = this.setButton(GT._((String)"Script"));
        this.checkButton = this.setButton(GT._((String)"Check"));
        this.topButton = this.setButton(TextFormat.split((String)GT._((String)"Top[as in \"go to the top\" - (translators: remove this bracketed part]"), (char)'[')[0]);
        this.stepButton = this.setButton(GT._((String)"Step"));
        this.runButton = this.setButton(GT._((String)"Run"));
        this.pauseButton = this.setButton(GT._((String)"Pause"));
        this.pauseButton.setEnabled(true);
        this.resumeButton = this.setButton(GT._((String)"Resume"));
        this.resumeButton.setEnabled(false);
        this.haltButton = this.setButton(GT._((String)"Halt"));
        this.haltButton.setEnabled(false);
        this.clearButton = this.setButton(GT._((String)"Clear"));
        this.closeButton = this.setButton(GT._((String)"Close"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.buttonPanel, "Center");
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jPanel);
        jScrollPane.setMinimumSize(new Dimension(300, 300));
        jScrollPane.setPreferredSize(new Dimension(5000, 5000));
        jPanel.setMinimumSize(new Dimension(60, 60));
        jPanel.setMaximumSize(new Dimension(1000, 60));
        jPanel.setPreferredSize(new Dimension(60, 60));
        jSplitPane.setDividerSize(0);
        jSplitPane.setResizeWeight(0.95);
        container.add(jSplitPane);
    }

    private JButton setButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        this.buttonPanel.add(jButton);
        return jButton;
    }

    public void notifyScriptStart() {
        this.runButton.setEnabled(false);
        this.resumeButton.setEnabled(false);
        this.haltButton.setEnabled(true);
        this.pauseButton.setEnabled(true);
    }

    public void notifyScriptTermination() {
        this.runButton.setEnabled(true);
        this.pauseButton.setEnabled(false);
        this.resumeButton.setEnabled(false);
        this.haltButton.setEnabled(false);
        this.editor.editorDoc.clearHighlight();
        this.editor.setCaretPosition(this.editor.editorDoc.getLength());
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.viewer.getProperty("DATA_API", "scriptEditorState", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        if (bl) {
            this.editor.grabFocus();
        }
    }

    public String getText() {
        return this.editor.getText();
    }

    public void output(String string) {
        this.editor.clearContent(string);
    }

    public void dispose() {
        super.dispose();
    }

    public void notifyContext(ScriptContext scriptContext, Object[] objectArray) {
        this.haltButton.setEnabled(scriptContext.errorMessage == null);
        this.pauseButton.setEnabled(scriptContext.errorMessage == null);
        this.resumeButton.setEnabled(false);
        if (scriptContext.errorMessage == null) {
            this.setContext(scriptContext);
        }
    }

    private synchronized void setContext(ScriptContext scriptContext) {
        this.pauseButton.setEnabled(this.viewer.isScriptExecuting());
        if (scriptContext.script.indexOf("\u0001## EDITOR_IGNORE ##") >= 0) {
            return;
        }
        this.parsedContext = scriptContext;
        this.filename = scriptContext.scriptFileName;
        this.setTitle(this.title + this.parsedContext.contextPath);
        if (this.filename == null && scriptContext.functionName != null) {
            this.filename = "function " + scriptContext.functionName;
        }
        this.parsedData = this.editor.editorDoc.outputEcho(scriptContext.script);
        boolean bl = scriptContext.executionPaused || scriptContext.executionStepping;
        this.pauseButton.setEnabled(!bl && this.viewer.isScriptExecuting());
        this.resumeButton.setEnabled(bl);
        this.gotoCommand(scriptContext.pc, bl, this.attHighlight);
    }

    private void gotoCommand(int n, boolean bl, SimpleAttributeSet simpleAttributeSet) {
        ScriptContext scriptContext = this.parsedContext;
        try {
            try {
                int n2;
                int n3;
                this.setVisible(true);
                if (n < 0) {
                    n3 = 0;
                    n2 = this.editor.getDocument().getLength();
                } else if (scriptContext == null || scriptContext.aatoken == null) {
                    n2 = 0;
                    n3 = 0;
                } else if (n < scriptContext.aatoken.length) {
                    n3 = scriptContext.lineIndices[n][0];
                    n2 = scriptContext.lineIndices[n][1];
                } else {
                    n3 = n2 = this.editor.getDocument().getLength();
                }
                if (bl) {
                    this.editor.setCaretPosition(n3);
                    this.editor.editorDoc.doHighlight(n3, n2, simpleAttributeSet);
                }
            }
            catch (Exception exception) {
                this.editor.setCaretPosition(0);
            }
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.checkAction(actionEvent);
    }

    private synchronized void checkAction(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.consoleButton) {
            this.jmolConsole.setVisible(true);
            return;
        }
        if (object == this.openButton) {
            this.doOpen();
            return;
        }
        if (object == this.closeButton) {
            this.setVisible(false);
            return;
        }
        if (object == this.loadButton) {
            this.setContext(this.viewer.getScriptContext("SE loadButton"));
            return;
        }
        if (object == this.topButton) {
            this.gotoTop();
            return;
        }
        if (object == this.checkButton) {
            this.checkScript();
            return;
        }
        if (object == this.runButton) {
            this.notifyScriptStart();
            String string = this.editor.getText();
            this.jmolConsole.execute(string + "\u0001##");
            return;
        }
        if (object == this.pauseButton) {
            this.jmolConsole.execute("!pause\u0001##");
            return;
        }
        if (object == this.resumeButton) {
            this.doResume();
            return;
        }
        if (object == this.stepButton) {
            this.doStep();
            return;
        }
        if (object == this.clearButton) {
            this.editor.clearContent();
            return;
        }
        if (object == this.stateButton) {
            this.editor.clearContent(this.viewer.getStateInfo());
            return;
        }
        if (object == this.haltButton) {
            this.viewer.haltScriptExecution();
            return;
        }
    }

    private void doOpen() {
        this.viewer.getFileAsStringBin(lastOpened);
        this.editor.clearContent(lastOpened[1]);
        ScriptEditor.lastOpened[1] = null;
    }

    public void gotoTop() {
        this.editor.setCaretPosition(0);
        this.editor.grabFocus();
        this.gotoPosition(0, 0);
    }

    public void checkScript() {
        this.parsedContext = null;
        this.parseScript(this.editor.getText());
    }

    protected void parseScript(String string) {
        if (string == null || string.length() == 0) {
            this.parsedContext = null;
            this.parsedData = "";
            this.setTitle(this.title);
            return;
        }
        if (this.parsedContext == null || !string.equals(this.parsedData)) {
            this.parsedData = string;
            this.parsedContext = (ScriptContext)this.viewer.getProperty("DATA_API", "scriptCheck", (Object)string);
        }
        this.gotoParsedLine();
    }

    private void gotoParsedLine() {
        this.setTitle(this.title + " " + this.parsedContext.contextPath + " -- " + (this.parsedContext.aatoken == null ? "" : this.parsedContext.aatoken.length + " commands ") + (this.parsedContext.iCommandError < 0 ? "" : " ERROR: " + this.parsedContext.errorType));
        boolean bl = this.parsedContext.iCommandError >= 0;
        this.gotoCommand(bl ? this.parsedContext.iCommandError : 0, true, bl ? this.attError : this.attHighlight);
    }

    public void doStep() {
        boolean bl = this.viewer.getBooleanProperty("executionPaused");
        this.jmolConsole.execute(bl ? "!step\u0001##" : this.editor.getText() + "\u0001##SCRIPT_STEP\n##SCRIPT_START=" + this.editor.getCaretPosition());
    }

    protected void doResume() {
        this.editor.clearContent();
        this.jmolConsole.execute("!resume\u0001##");
    }

    private void gotoPosition(int n, int n2) {
        this.editor.scrollRectToVisible(new Rectangle(n, n2));
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    class EditorDocument
    extends DefaultStyledDocument {
        EditorTextPane EditorTextPane;
        protected UndoManager undo = new UndoManager();

        EditorDocument() {
            this.putProperty("__EndOfLine__", "\n");
            this.addUndoableEditListener(new MyUndoableEditListener());
        }

        void setEditorTextPane(EditorTextPane editorTextPane) {
            this.EditorTextPane = editorTextPane;
        }

        void doHighlight(int n, int n2, SimpleAttributeSet simpleAttributeSet) {
            this.clearHighlight();
            if (n >= n2) {
                return;
            }
            this.setCharacterAttributes(n, n2 - n, simpleAttributeSet, true);
            ScriptEditor.this.editor.select(n, n2);
            ScriptEditor.this.editor.setSelectedTextColor(simpleAttributeSet == ScriptEditor.this.attError ? Color.RED : Color.black);
        }

        void clearHighlight() {
            this.setCharacterAttributes(0, ScriptEditor.this.editor.editorDoc.getLength(), ScriptEditor.this.attEcho, true);
        }

        protected void undo() {
            try {
                this.undo.undo();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected void redo() {
            try {
                this.undo.redo();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void clearContent() {
            try {
                super.remove(0, this.getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        String outputEcho(String string) {
            this.clearContent();
            if (string == null) {
                return "";
            }
            if (!string.endsWith("\n")) {
                string = string + "\n";
            }
            try {
                super.insertString(0, string, ScriptEditor.this.attEcho);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
            return string;
        }

        protected class MyUndoableEditListener
        implements UndoableEditListener {
            protected MyUndoableEditListener() {
            }

            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                EditorDocument.this.undo.addEdit(undoableEditEvent.getEdit());
            }
        }
    }

    class EditorTextPane
    extends JTextPane {
        EditorDocument editorDoc;
        boolean checking;

        EditorTextPane() {
            super(new EditorDocument());
            this.checking = false;
            this.editorDoc = (EditorDocument)this.getDocument();
            this.editorDoc.setEditorTextPane(this);
        }

        public void clearContent() {
            ScriptEditor.this.filename = null;
            this.clearContent(null);
        }

        public synchronized void clearContent(String string) {
            this.editorDoc.outputEcho(string);
            ScriptEditor.this.parseScript(string);
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getID();
            if (n2 == 401) {
                switch (n) {
                    case 90: {
                        if (!keyEvent.isControlDown()) break;
                        if (keyEvent.isShiftDown()) {
                            ScriptEditor.this.editor.editorDoc.redo();
                        } else {
                            ScriptEditor.this.editor.editorDoc.undo();
                        }
                        return;
                    }
                    case 89: {
                        if (!keyEvent.isControlDown()) break;
                        ScriptEditor.this.editor.editorDoc.redo();
                        return;
                    }
                    case 116: {
                        if (ScriptEditor.this.stepButton.isEnabled()) {
                            ScriptEditor.this.doStep();
                        }
                        return;
                    }
                    case 119: {
                        if (ScriptEditor.this.resumeButton.isEnabled()) {
                            ScriptEditor.this.doResume();
                        }
                        return;
                    }
                }
            }
            super.processKeyEvent(keyEvent);
        }
    }
}

