/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.scriptext;

import java.io.Serializable;
import java.util.Map;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.constant.EnumVdw;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelCollection;
import org.jmol.script.JmolScriptExtension;
import org.jmol.script.SV;
import org.jmol.script.ScriptEvaluator;
import org.jmol.script.ScriptException;
import org.jmol.script.T;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.C;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.MeshSurface;
import org.jmol.util.P3;
import org.jmol.util.P4;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;
import org.jmol.viewer.JC;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptExt
implements JmolScriptExtension {
    private Viewer viewer;
    private ScriptEvaluator eval;
    private ShapeManager sm;
    private boolean chk;
    private String fullCommand;
    private String thisCommand;
    private T[] st;
    static final int ERROR_invalidArgument = 22;

    @Override
    public JmolScriptExtension init(Object object) {
        this.eval = (ScriptEvaluator)object;
        this.viewer = this.eval.viewer;
        this.sm = this.eval.sm;
        return this;
    }

    @Override
    public boolean dispatch(int n, boolean bl, T[] tArray) throws ScriptException {
        this.chk = this.eval.chk;
        this.fullCommand = this.eval.fullCommand;
        this.thisCommand = this.eval.thisCommand;
        this.st = tArray;
        switch (n) {
            case 23: {
                return this.cgo();
            }
            case 25: {
                return this.contact();
            }
            case 17: {
                return this.dipole();
            }
            case 22: {
                return this.draw();
            }
            case 24: 
            case 28: 
            case 29: {
                return this.isosurface(n);
            }
            case 26: {
                return this.lcaoCartoon();
            }
            case 27: {
                return this.mo(bl);
            }
            case 21: {
                return this.polyhedra();
            }
            case 4: {
                return this.struts();
            }
        }
        return false;
    }

    private BS atomExpressionAt(int n) throws ScriptException {
        return this.eval.atomExpressionAt(n);
    }

    private void error(int n) throws ScriptException {
        this.eval.error(n);
    }

    private void invArg() throws ScriptException {
        this.error(22);
    }

    private void invPO() throws ScriptException {
        this.error(23);
    }

    private Object getShapeProperty(int n, String string) {
        return this.eval.getShapeProperty(n, string);
    }

    private String parameterAsString(int n) throws ScriptException {
        return this.eval.parameterAsString(n);
    }

    private P3 centerParameter(int n) throws ScriptException {
        return this.eval.centerParameter(n);
    }

    private float floatParameter(int n) throws ScriptException {
        return this.eval.floatParameter(n);
    }

    private P3 getPoint3f(int n, boolean bl) throws ScriptException {
        return this.eval.getPoint3f(n, bl);
    }

    private P4 getPoint4f(int n) throws ScriptException {
        return this.eval.getPoint4f(n);
    }

    private int intParameter(int n) throws ScriptException {
        return this.eval.intParameter(n);
    }

    private boolean isFloatParameter(int n) {
        return this.eval.isFloatParameter(n);
    }

    private String setShapeId(int n, int n2, boolean bl) throws ScriptException {
        return this.eval.setShapeId(n, n2, bl);
    }

    private void setShapeProperty(int n, String string, Object object) {
        this.eval.setShapeProperty(n, string, object);
    }

    private String stringParameter(int n) throws ScriptException {
        return this.eval.stringParameter(n);
    }

    private int tokAt(int n) {
        return this.eval.tokAt(n);
    }

    private boolean cgo() throws ScriptException {
        this.sm.loadShape(23);
        if (this.tokAt(1) == 1073742001 && this.listIsosurface(23)) {
            return false;
        }
        int n = 0;
        String string = this.initIsosurface(23);
        boolean bl = string != null;
        boolean bl2 = bl && this.getShapeProperty(23, "ID") == null;
        boolean bl3 = false;
        JmolList<Object> jmolList = null;
        float f = Float.MAX_VALUE;
        this.eval.colorArgb[0] = Integer.MIN_VALUE;
        int n2 = 0;
        block10: for (int i = this.eval.iToken; i < this.eval.slen; ++i) {
            String string2 = null;
            Integer n3 = null;
            switch (this.eval.getToken((int)i).tok) {
                case 7: 
                case 0x10100040: 
                case 1073742195: {
                    if (jmolList != null || bl2) {
                        this.invArg();
                    }
                    jmolList = this.eval.listParameter(i, 2, Integer.MAX_VALUE);
                    i = this.eval.iToken;
                    continue block10;
                }
                case 1073742138: {
                    if (++i >= this.eval.slen) {
                        this.error(34);
                    }
                    switch (this.eval.getToken((int)i).tok) {
                        case 2: {
                            n2 = this.intParameter(i);
                            continue block10;
                        }
                        case 3: {
                            n2 = Math.round(this.floatParameter(i) * 100.0f);
                            continue block10;
                        }
                        default: {
                            this.error(34);
                            break;
                        }
                    }
                    break;
                }
                case 603979967: 
                case 1073742074: 
                case 1766856708: {
                    f = this.eval.getColorTrans(i, false);
                    i = this.eval.iToken;
                    bl = true;
                    continue block10;
                }
                case 1074790550: {
                    string = this.setShapeId(23, ++i, bl);
                    bl2 = this.getShapeProperty(23, "ID") == null;
                    i = this.eval.iToken;
                    break;
                }
                default: {
                    if (!this.eval.setMeshDisplayProperty(23, 0, this.eval.theTok)) {
                        if (this.eval.theTok == 0x101000B1 || T.tokAttr(this.eval.theTok, 0x40000000)) {
                            string = this.setShapeId(23, i, bl);
                            i = this.eval.iToken;
                            break;
                        }
                        this.invArg();
                    }
                    if (n == 0) {
                        n = i;
                    }
                    i = this.eval.iToken;
                    continue block10;
                }
            }
            boolean bl4 = bl = this.eval.theTok != 12291;
            if (jmolList != null && !bl3) {
                string2 = "points";
                n3 = n2;
                bl3 = true;
                n2 = 0;
            }
            if (string2 == null) continue;
            this.setShapeProperty(23, string2, n3);
        }
        this.eval.finalizeObject(23, this.eval.colorArgb[0], f, n2, jmolList != null, jmolList, n, null);
        return true;
    }

    private boolean contact() throws ScriptException {
        this.sm.loadShape(25);
        if (this.tokAt(1) == 1073742001 && this.listIsosurface(25)) {
            return false;
        }
        int n = 0;
        this.eval.iToken = 1;
        String string = this.initIsosurface(25);
        boolean bl = string != null;
        boolean bl2 = bl && this.getShapeProperty(25, "ID") == null;
        BS bS = null;
        BS bS2 = null;
        BS bS3 = null;
        RadiusData radiusData = null;
        float[] fArray = null;
        boolean bl3 = false;
        SB sB = new SB();
        int n2 = Integer.MAX_VALUE;
        int n3 = 135266319;
        int n4 = 0;
        float f = Float.NaN;
        float f2 = Float.NaN;
        boolean bl4 = true;
        Boolean bl5 = null;
        Object object = null;
        int n5 = 0;
        boolean bl6 = false;
        boolean bl7 = this.eval.iToken > 1;
        block27: for (int i = this.eval.iToken; i < this.eval.slen; ++i) {
            int n6 = this.eval.getToken((int)i).tok;
            switch (n6) {
                default: {
                    bl7 = true;
                    if (!this.eval.setMeshDisplayProperty(25, 0, this.eval.theTok)) {
                        if (this.eval.theTok != 0x101000B1 && !T.tokAttr(this.eval.theTok, 0x40000000)) {
                            this.invArg();
                        }
                        string = this.setShapeId(25, i, bl);
                        i = this.eval.iToken;
                        break;
                    }
                    if (n == 0) {
                        n = i;
                    }
                    i = this.eval.iToken;
                    continue block27;
                }
                case 1074790550: {
                    bl7 = true;
                    this.setShapeId(25, ++i, bl);
                    bl2 = this.getShapeProperty(25, "ID") == null;
                    i = this.eval.iToken;
                    break;
                }
                case 1766856708: {
                    switch (this.tokAt(i + 1)) {
                        case 1073741914: {
                            n6 = 0;
                            bl3 = true;
                            sB.append(" color density");
                            ++i;
                            break;
                        }
                        case 1141899272: {
                            n6 = 0;
                            bl6 = true;
                            sB.append(" color type");
                            ++i;
                        }
                    }
                    if (n6 == 0) break;
                }
                case 603979967: 
                case 1073742074: {
                    bl7 = true;
                    if (n5 == 0) {
                        n5 = i;
                    }
                    this.eval.setMeshDisplayProperty(25, i, this.eval.theTok);
                    i = this.eval.iToken;
                    break;
                }
                case 554176565: {
                    bl7 = true;
                    object = this.getCapSlabObject(i, false);
                    this.setShapeProperty(25, "slab", object);
                    i = this.eval.iToken;
                    break;
                }
                case 1073741914: {
                    bl3 = true;
                    sB.append(" density");
                    if (!this.isFloatParameter(i + 1)) break;
                    if (fArray == null) {
                        fArray = new float[]{-Math.abs(this.floatParameter(++i))};
                    }
                    sB.append(" " + -fArray[0]);
                    break;
                }
                case 1073742122: {
                    float f3 = this.floatParameter(++i);
                    if (!(f3 > 0.0f)) break;
                    sB.append(" resolution ").appendF(f3);
                    this.setShapeProperty(25, "resolution", Float.valueOf(f3));
                    break;
                }
                case 135266324: 
                case 1276118018: {
                    f = this.floatParameter(++i);
                    sB.append(" within ").appendF(f);
                    break;
                }
                case 2: 
                case 3: 
                case 0x101000A1: {
                    radiusData = this.eval.encodeRadiusParameter(i, false, false);
                    sB.append(" ").appendO(radiusData);
                    i = this.eval.iToken;
                    break;
                }
                case 1073741989: 
                case 1073741990: {
                    bl5 = n6 == 1073741989 ? Boolean.TRUE : Boolean.FALSE;
                    sB.append(" ").appendO(this.eval.theToken.value);
                    break;
                }
                case 0x400000C4: {
                    n2 = this.intParameter(++i);
                    break;
                }
                case 1073741881: 
                case 1612189718: 
                case 1649412120: {
                    n4 = n6;
                    sB.append(" ").appendO(this.eval.theToken.value);
                    break;
                }
                case 1073742136: {
                    if (this.isFloatParameter(i + 1)) {
                        f2 = this.floatParameter(++i);
                    }
                }
                case 3145756: 
                case 0x400000D4: 
                case 1074790451: {
                    bl4 = false;
                }
                case 4106: 
                case 135266319: 
                case 1073741961: 
                case 1276117510: {
                    n3 = n6;
                    sB.append(" ").appendO(this.eval.theToken.value);
                    if (n6 != 1073742136) break;
                    sB.append(" ").appendF(f2);
                    break;
                }
                case 1073742083: {
                    fArray = this.eval.floatParameterSet(++i, 1, 10);
                    i = this.eval.iToken;
                    break;
                }
                case 10: 
                case 0x100001: {
                    if (bl2 || bS2 != null) {
                        this.invArg();
                    }
                    bS3 = BSUtil.copy(this.atomExpressionAt(i));
                    i = this.eval.iToken;
                    if (bS == null) {
                        bS = bS3;
                    } else {
                        bS2 = bS3;
                    }
                    sB.append(" ").append(Escape.eBS(bS3));
                }
            }
            bl = this.eval.theTok != 12291;
        }
        if (!bl7 && bS == null) {
            this.error(13);
        }
        if (this.chk) {
            return false;
        }
        if (bS != null) {
            if (n4 == 1649412120 && radiusData == null) {
                radiusData = new RadiusData(null, 0.0f, RadiusData.EnumType.OFFSET, EnumVdw.AUTO);
            }
            RadiusData radiusData2 = radiusData == null ? new RadiusData(null, 0.26f, RadiusData.EnumType.OFFSET, EnumVdw.AUTO) : radiusData;
            bS2 = n3 == 0x400000D4 && bS2 == null && bl5 != null && bl5 != false ? bS : this.eval.setContactBitSets(bS, bS2, bl4, f, radiusData2, true);
            switch (n3) {
                case 1073742136: 
                case 1074790451: {
                    BS bS4 = this.eval.lookupIdentifierValue("solvent");
                    bS.andNot(bS4);
                    bS2.andNot(bS4);
                    bS2.andNot(bS);
                    break;
                }
                case 3145756: {
                    bS2.andNot(bS);
                    break;
                }
                case 0x400000D4: {
                    if (n2 == Integer.MAX_VALUE) {
                        n2 = 100;
                    }
                    this.setShapeProperty(25, "minset", n2);
                    sB.append(" minSet ").appendI(n2);
                    if (fArray != null) break;
                    fArray = new float[]{0.5f, 2.0f};
                }
            }
            if (bl5 != null) {
                fArray = fArray == null ? new float[2] : ArrayUtil.ensureLengthA(fArray, 2);
                fArray[1] = bl5 != false ? 1 : 2;
            }
            if (fArray != null) {
                sB.append(" parameters ").append(Escape.eAF(fArray));
            }
            this.setShapeProperty(25, "set", new Object[]{n4, n3, bl3, bl6, bS, bS2, radiusData, Float.valueOf(f2), fArray, sB.toString()});
            if (n5 > 0) {
                this.eval.setMeshDisplayProperty(25, n5, 0);
            }
        }
        if (n > 0 && !this.eval.setMeshDisplayProperty(25, n, 0)) {
            this.invArg();
        }
        if (object != null && bS != null) {
            this.setShapeProperty(25, "slab", object);
        }
        if (bS != null && (n3 == 0x400000D4 || bl4)) {
            Object object2 = this.getShapeProperty(25, "volume");
            if (Escape.isAD(object2)) {
                double[] dArray = (double[])object2;
                double d = 0.0;
                for (int i = 0; i < dArray.length; ++i) {
                    d += Math.abs(dArray[i]);
                }
                object2 = Float.valueOf((float)d);
            }
            int n7 = (Integer)this.getShapeProperty(25, "nSets");
            if (bl3 || n3 != 1276117510) {
                this.eval.showString((n7 == 0 ? "" : n7 + " contacts with ") + "net volume " + object2 + " A^3");
            }
        }
        return true;
    }

    private boolean dipole() throws ScriptException {
        String string = null;
        Object object = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.sm.loadShape(17);
        if (this.tokAt(1) == 1073742001 && this.listIsosurface(17)) {
            return false;
        }
        this.setShapeProperty(17, "init", null);
        if (this.eval.slen == 1) {
            this.setShapeProperty(17, "thisID", null);
            return false;
        }
        for (int i = 1; i < this.eval.slen; ++i) {
            string = null;
            object = null;
            switch (this.eval.getToken((int)i).tok) {
                case 0x10000D: {
                    string = "on";
                    break;
                }
                case 0x10000C: {
                    string = "off";
                    break;
                }
                case 12291: {
                    string = "delete";
                    break;
                }
                case 2: 
                case 3: {
                    string = "value";
                    object = Float.valueOf(this.floatParameter(i));
                    break;
                }
                case 10: {
                    string = "atomBitset";
                }
                case 0x100001: {
                    if (string == null) {
                        string = bl || bl2 ? "endSet" : "startSet";
                    }
                    object = this.atomExpressionAt(i);
                    i = this.eval.iToken;
                    bl = true;
                    break;
                }
                case 8: 
                case 0x10000A: {
                    P3 p3 = this.getPoint3f(i, true);
                    i = this.eval.iToken;
                    string = bl || bl2 ? "endCoord" : "startCoord";
                    object = p3;
                    bl2 = true;
                    break;
                }
                case 1678770178: {
                    string = "bonds";
                    break;
                }
                case 4102: {
                    string = "calculate";
                    break;
                }
                case 1074790550: {
                    this.setShapeId(17, ++i, bl3);
                    i = this.eval.iToken;
                    break;
                }
                case 135267329: {
                    string = "cross";
                    object = Boolean.TRUE;
                    break;
                }
                case 1073742040: {
                    string = "cross";
                    object = Boolean.FALSE;
                    break;
                }
                case 1073742066: {
                    float f = this.floatParameter(++i);
                    if (this.eval.theTok == 2) {
                        string = "offsetPercent";
                        object = (int)f;
                        break;
                    }
                    string = "offset";
                    object = Float.valueOf(f);
                    break;
                }
                case 0x400000F4: {
                    string = "offsetSide";
                    object = Float.valueOf(this.floatParameter(++i));
                    break;
                }
                case 1073742188: {
                    string = "value";
                    object = Float.valueOf(this.floatParameter(++i));
                    break;
                }
                case 1073742196: {
                    string = "width";
                    object = Float.valueOf(this.floatParameter(++i));
                    break;
                }
                default: {
                    if (this.eval.theTok == 0x101000B1 || T.tokAttr(this.eval.theTok, 0x40000000)) {
                        this.setShapeId(17, i, bl3);
                        i = this.eval.iToken;
                        break;
                    }
                    this.invArg();
                }
            }
            boolean bl4 = bl3 = this.eval.theTok != 12291 && this.eval.theTok != 4102;
            if (string == null) continue;
            this.setShapeProperty(17, string, object);
        }
        if (bl2 || bl) {
            this.setShapeProperty(17, "set", null);
        }
        return true;
    }

    private boolean draw() throws ScriptException {
        this.sm.loadShape(22);
        switch (this.tokAt(1)) {
            case 1073742001: {
                if (!this.listIsosurface(22)) break;
                return false;
            }
            case 1073742102: {
                this.eval.pointGroup();
                return false;
            }
            case 1052714: 
            case 0x8101011: 
            case 137363468: {
                this.plot(this.st);
                return false;
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        float f = Float.MAX_VALUE;
        this.eval.colorArgb[0] = Integer.MIN_VALUE;
        int n2 = 0;
        String string = "";
        int n3 = 0;
        P3 p3 = null;
        String string2 = this.initIsosurface(22);
        boolean bl6 = string2 != null;
        boolean bl7 = bl6 && this.getShapeProperty(22, "ID") == null;
        int[] nArray = null;
        int n4 = 0;
        block70: for (int i = this.eval.iToken; i < this.eval.slen; ++i) {
            String string3 = null;
            Object object = null;
            block5 : switch (this.eval.getToken((int)i).tok) {
                case 1614417948: 
                case 1679429641: {
                    if (this.chk) break;
                    JmolList<Object> jmolList = this.viewer.getPlaneIntersection(this.eval.theTok, null, (float)n2 / 100.0f, 0);
                    n2 = 0;
                    string3 = "polygon";
                    object = jmolList;
                    bl = true;
                    break;
                }
                case 4106: {
                    nArray = new int[4];
                    n4 = 4;
                    float[] fArray = this.eval.floatParameterSet(++i, 4, 4);
                    i = this.eval.iToken;
                    for (int j = 0; j < 4; ++j) {
                        nArray[j] = (int)fArray[j];
                    }
                    bl = true;
                    break;
                }
                case 0x44100001: 
                case 1678770178: {
                    if (nArray == null || n4 > (this.eval.theTok == 1095761924 ? 2 : 3)) {
                        n4 = 0;
                        nArray = new int[]{-1, -1, -1, -1};
                    }
                    nArray[n4++] = this.atomExpressionAt(++i).nextSetBit(0);
                    i = this.eval.iToken;
                    nArray[n4++] = this.eval.theTok == 1678770178 ? this.atomExpressionAt(++i).nextSetBit(0) : -1;
                    i = this.eval.iToken;
                    bl = true;
                    break;
                }
                case 554176565: {
                    switch (this.eval.getToken((int)(++i)).tok) {
                        case 0x100007: {
                            string3 = "slab";
                            object = this.eval.objectNameParameter(++i);
                            i = this.eval.iToken;
                            bl = true;
                            break block5;
                        }
                    }
                    this.invArg();
                    break;
                }
                case 135267842: {
                    switch (this.eval.getToken((int)(++i)).tok) {
                        case 1614417948: 
                        case 1679429641: {
                            n = this.eval.theTok;
                            bl4 = true;
                            continue block70;
                        }
                        case 0x100007: {
                            string3 = "intersect";
                            object = this.eval.objectNameParameter(++i);
                            i = this.eval.iToken;
                            bl4 = true;
                            bl = true;
                            break;
                        }
                        default: {
                            this.invArg();
                            break;
                        }
                    }
                    break;
                }
                case 1073742106: {
                    string3 = "polygon";
                    bl = true;
                    JmolList<Object> jmolList = new JmolList<Object>();
                    int n5 = 0;
                    int n6 = 0;
                    P3[] p3Array = null;
                    JmolList<SV> jmolList2 = null;
                    if (this.eval.isArrayParameter(++i)) {
                        p3Array = this.eval.getPointArray(i, -1);
                        n5 = p3Array.length;
                    } else {
                        n5 = Math.max(0, this.intParameter(i));
                        p3Array = new P3[n5];
                        for (int j = 0; j < n5; ++j) {
                            p3Array[j] = this.centerParameter(++this.eval.iToken);
                        }
                    }
                    switch (this.eval.getToken((int)(++this.eval.iToken)).tok) {
                        case 11: 
                        case 12: {
                            SV sV = SV.newScriptVariableToken(this.eval.theToken);
                            sV.toArray();
                            jmolList2 = sV.getList();
                            n6 = jmolList2.size();
                            break;
                        }
                        case 7: {
                            jmolList2 = ((SV)this.eval.theToken).getList();
                            n6 = jmolList2.size();
                            break;
                        }
                        default: {
                            n6 = Math.max(0, this.intParameter(this.eval.iToken));
                        }
                    }
                    int[][] nArray2 = ArrayUtil.newInt2(n6);
                    for (int j = 0; j < n6; ++j) {
                        float[] fArray;
                        float[] fArray2 = fArray = jmolList2 == null ? this.eval.floatParameterSet(++this.eval.iToken, 3, 4) : SV.flistValue((T)jmolList2.get(j), 0);
                        if (fArray.length < 3 || fArray.length > 4) {
                            this.invArg();
                        }
                        nArray2[j] = new int[]{(int)fArray[0], (int)fArray[1], (int)fArray[2], fArray.length == 3 ? 7 : (int)fArray[3]};
                    }
                    if (n5 > 0) {
                        jmolList.addLast(p3Array);
                        jmolList.addLast(nArray2);
                    } else {
                        jmolList = null;
                    }
                    object = jmolList;
                    i = this.eval.iToken;
                    break;
                }
                case 1297090050: {
                    String string4 = null;
                    int n7 = 0;
                    P4 p4 = null;
                    P3 p32 = null;
                    switch (this.tokAt(++i)) {
                        case 4: {
                            string4 = this.stringParameter(i);
                            break;
                        }
                        case 12: {
                            string4 = SV.sValue(this.eval.getToken(i));
                            break;
                        }
                        default: {
                            if (!this.eval.isCenterParameter(i)) {
                                n7 = this.intParameter(i++);
                            }
                            if (this.eval.isCenterParameter(i)) {
                                p3 = this.centerParameter(i);
                            }
                            if (this.eval.isCenterParameter(this.eval.iToken + 1)) {
                                p32 = this.centerParameter(++this.eval.iToken);
                            }
                            if (this.chk) {
                                return false;
                            }
                            i = this.eval.iToken;
                        }
                    }
                    BS bS = null;
                    if (p3 == null && i + 1 < this.eval.slen) {
                        p3 = this.centerParameter(++i);
                        bS = this.tokAt(i) == 10 || this.tokAt(i) == 0x100001 ? this.atomExpressionAt(i) : null;
                        i = this.eval.iToken + 1;
                    }
                    this.eval.checkLast(this.eval.iToken);
                    if (!this.chk) {
                        this.eval.runScript((String)this.viewer.getSymmetryInfo(bS, string4, n7, p3, p32, string2, 135176));
                    }
                    return false;
                }
                case 4115: {
                    bl5 = true;
                    continue block70;
                }
                case 8: 
                case 9: 
                case 0x10000A: {
                    if (this.eval.theTok == 9 || !this.eval.isPoint3f(i)) {
                        object = this.getPoint4f(i);
                        if (bl5) {
                            this.eval.checkLast(this.eval.iToken);
                            if (!this.chk) {
                                this.eval.runScript(Quaternion.newP4((P4)object).draw(string2 == null ? "frame" : string2, " " + string, p3 == null ? new P3() : p3, (float)n2 / 100.0f));
                            }
                            return false;
                        }
                        string3 = "planedef";
                    } else {
                        p3 = this.getPoint3f(i, true);
                        object = p3;
                        string3 = "coord";
                    }
                    i = this.eval.iToken;
                    bl = true;
                    break;
                }
                case 135266319: 
                case 135267841: {
                    Serializable serializable;
                    if (!bl && !bl4 && n == 0 && this.eval.theTok != 135267841) {
                        string3 = "plane";
                        break;
                    }
                    P4 p4 = this.eval.theTok == 135266319 ? this.eval.planeParameter(++i) : this.eval.hklParameter(++i);
                    i = this.eval.iToken;
                    if (n != 0) {
                        if (this.chk) break;
                        serializable = this.viewer.getPlaneIntersection(n, p4, (float)n2 / 100.0f, 0);
                        n2 = 0;
                        string3 = "polygon";
                        object = serializable;
                    } else {
                        object = p4;
                        string3 = "planedef";
                    }
                    bl = true;
                    break;
                }
                case 0x400000B0: {
                    string3 = "lineData";
                    object = this.eval.floatParameterSet(++i, 0, Integer.MAX_VALUE);
                    i = this.eval.iToken;
                    bl = true;
                    break;
                }
                case 10: 
                case 0x100001: {
                    string3 = "atomSet";
                    object = this.atomExpressionAt(i);
                    if (bl5) {
                        p3 = this.centerParameter(i);
                    }
                    i = this.eval.iToken;
                    bl = true;
                    break;
                }
                case 7: {
                    string3 = "modelBasedPoints";
                    object = SV.listValue(this.eval.theToken);
                    bl = true;
                    break;
                }
                case 0x10100030: 
                case 1073742195: {
                    break;
                }
                case 0x10100040: {
                    object = this.eval.xypParameter(i);
                    if (object != null) {
                        i = this.eval.iToken;
                        string3 = "coord";
                        bl = true;
                        break;
                    }
                    if (bl3) {
                        this.invArg();
                    }
                    bl3 = true;
                    break;
                }
                case 0x10100041: {
                    if (!bl3) {
                        this.invArg();
                    }
                    bl3 = false;
                    break;
                }
                case 1141899269: {
                    string3 = "reverse";
                    break;
                }
                case 4: {
                    object = this.stringParameter(i);
                    string3 = "title";
                    break;
                }
                case 135198: {
                    string3 = "vector";
                    break;
                }
                case 1141899267: {
                    object = Float.valueOf(this.floatParameter(++i));
                    string3 = "length";
                    break;
                }
                case 3: {
                    object = Float.valueOf(this.floatParameter(i));
                    string3 = "length";
                    break;
                }
                case 1095761933: {
                    string3 = "modelIndex";
                    object = this.intParameter(++i);
                    break;
                }
                case 2: {
                    if (bl3) {
                        string3 = "modelIndex";
                        object = this.intParameter(i);
                        break;
                    }
                    n2 = this.intParameter(i);
                    break;
                }
                case 1073742138: {
                    if (++i >= this.eval.slen) {
                        this.error(34);
                    }
                    switch (this.eval.getToken((int)i).tok) {
                        case 2: {
                            n2 = this.intParameter(i);
                            continue block70;
                        }
                        case 3: {
                            n2 = Math.round(this.floatParameter(i) * 100.0f);
                            continue block70;
                        }
                        default: {
                            this.error(34);
                            break;
                        }
                    }
                    break;
                }
                case 1074790550: {
                    string2 = this.setShapeId(22, ++i, bl6);
                    bl7 = this.getShapeProperty(22, "ID") == null;
                    i = this.eval.iToken;
                    break;
                }
                case 0x400000CC: {
                    string3 = "fixed";
                    object = Boolean.FALSE;
                    break;
                }
                case 1060869: {
                    string3 = "fixed";
                    object = Boolean.TRUE;
                    break;
                }
                case 1073742066: {
                    Serializable serializable = this.getPoint3f(++i, true);
                    i = this.eval.iToken;
                    string3 = "offset";
                    object = serializable;
                    break;
                }
                case 1073741906: {
                    string3 = "crossed";
                    break;
                }
                case 1073742196: {
                    object = Float.valueOf(this.floatParameter(++i));
                    string3 = "width";
                    string = string3 + " " + object;
                    break;
                }
                case 1073741998: {
                    string3 = "line";
                    object = Boolean.TRUE;
                    break;
                }
                case 0x40000054: {
                    string3 = "curve";
                    break;
                }
                case 0x40100010: {
                    string3 = "arc";
                    break;
                }
                case 1073741846: {
                    string3 = "arrow";
                    break;
                }
                case 1073741880: {
                    string3 = "circle";
                    break;
                }
                case 1073741912: {
                    string3 = "cylinder";
                    break;
                }
                case 1073742194: {
                    string3 = "vertices";
                    break;
                }
                case 0x400000E0: {
                    string3 = "nohead";
                    break;
                }
                case 1073741861: {
                    string3 = "isbarb";
                    break;
                }
                case 1073742130: {
                    string3 = "rotate45";
                    break;
                }
                case 1073742092: {
                    string3 = "perp";
                    break;
                }
                case 1073741916: 
                case 1666189314: {
                    boolean bl8 = this.eval.theTok == 1666189314;
                    float f2 = this.floatParameter(++i);
                    if (bl8) {
                        f2 *= 2.0f;
                    }
                    object = Float.valueOf(f2);
                    string3 = bl8 || this.tokAt(i) == 3 ? "width" : "diameter";
                    string = string3 + (this.tokAt(i) == 3 ? " " + f2 : " " + (int)f2);
                    break;
                }
                case 0x100007: {
                    if (this.tokAt(i + 2) == 0x10100040 || bl5) {
                        P3 p33 = p3 = this.centerParameter(i);
                        i = this.eval.iToken;
                        string3 = "coord";
                        object = p33;
                        bl = true;
                        break;
                    }
                    object = this.eval.objectNameParameter(++i);
                    string3 = "identifier";
                    bl = true;
                    break;
                }
                case 603979967: 
                case 1073742074: 
                case 1766856708: {
                    bl6 = true;
                    f = this.eval.getColorTrans(i, false);
                    i = this.eval.iToken;
                    continue block70;
                }
                default: {
                    if (!this.eval.setMeshDisplayProperty(22, 0, this.eval.theTok)) {
                        if (this.eval.theTok == 0x101000B1 || T.tokAttr(this.eval.theTok, 0x40000000)) {
                            string2 = this.setShapeId(22, i, bl6);
                            i = this.eval.iToken;
                            break;
                        }
                        this.invArg();
                    }
                    if (n3 == 0) {
                        n3 = i;
                    }
                    i = this.eval.iToken;
                    continue block70;
                }
            }
            boolean bl9 = bl6 = this.eval.theTok != 12291;
            if (bl && !bl2 && !bl5) {
                this.setShapeProperty(22, "points", n2);
                bl2 = true;
                n2 = 0;
            }
            if (bl && bl7) {
                this.invArg();
            }
            if (string3 == null) continue;
            this.setShapeProperty(22, string3, object);
        }
        this.eval.finalizeObject(22, this.eval.colorArgb[0], f, n2, bl, nArray, n3, null);
        return true;
    }

    private boolean isosurface(int n) throws ScriptException {
        Object object;
        Object object2;
        int n2;
        this.sm.loadShape(n);
        if (this.tokAt(1) == 1073742001 && this.listIsosurface(n)) {
            return false;
        }
        int n3 = 0;
        boolean bl = n == 24;
        boolean bl2 = n == 28;
        boolean bl3 = n == 29;
        boolean bl4 = n == 26;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = false;
        boolean bl16 = false;
        boolean bl17 = false;
        float[] fArray = null;
        String string = null;
        int n4 = Integer.MIN_VALUE;
        int n5 = 0;
        float f = Float.NaN;
        float f2 = Float.NaN;
        int n6 = 0;
        Boolean bl18 = null;
        int n7 = Integer.MAX_VALUE;
        BS bS = null;
        BS bS2 = null;
        BS bS3 = null;
        SB sB = new SB();
        P4 p4 = null;
        P3 p3 = null;
        String string2 = null;
        int n8 = this.chk ? 0 : Integer.MIN_VALUE;
        this.eval.setCursorWait(true);
        boolean bl19 = this.initIsosurface(n) != null;
        boolean bl20 = bl19 && this.getShapeProperty(n, "ID") == null;
        boolean bl21 = false;
        boolean bl22 = false;
        Object object3 = null;
        String string3 = null;
        String string4 = null;
        Object object4 = null;
        short[] sArray = null;
        JmolList<Object[]> jmolList = new JmolList<Object[]>();
        boolean bl23 = false;
        if (bl2 || bl3) {
            this.addShapeProperty(jmolList, "fileType", "Pmesh");
        }
        block106: for (n2 = this.eval.iToken; n2 < this.eval.slen; ++n2) {
            object2 = null;
            object = null;
            this.eval.getToken(n2);
            if (this.eval.theTok == 0x40000000) {
                string2 = this.parameterAsString(n2);
            }
            block1 : switch (this.eval.theTok) {
                case 603979871: {
                    Boolean bl24 = this.eval.getToken((int)(++n2)).tok == 0x10000D ? Boolean.TRUE : (bl18 = this.eval.theTok == 0x10000C ? Boolean.FALSE : null);
                    if (bl18 != null) continue block106;
                    this.invArg();
                    continue block106;
                }
                case 553648149: {
                    n7 = this.intParameter(++n2);
                    continue block106;
                }
                case 4128: {
                    object2 = "moveIsosurface";
                    if (this.tokAt(++n2) != 12) {
                        this.invArg();
                    }
                    object = this.eval.getToken((int)n2++).value;
                    break;
                }
                case 1073742066: {
                    object2 = "offset";
                    object = this.centerParameter(++n2);
                    n2 = this.eval.iToken;
                    break;
                }
                case 528432: {
                    object2 = "rotate";
                    this.eval.iToken = ++n2;
                    object = this.tokAt(this.eval.iToken) == 0x10000B ? null : this.getPoint4f(n2);
                    n2 = this.eval.iToken;
                    break;
                }
                case 0x60000004: {
                    object2 = "scale3d";
                    object = Float.valueOf(this.floatParameter(++n2));
                    break;
                }
                case 1073742090: {
                    sB.append(" periodic");
                    object2 = "periodic";
                    break;
                }
                case 266298: 
                case 0x8100010: 
                case 1073742078: {
                    object2 = this.eval.theToken.value.toString();
                    sB.append(" ").appendO(this.eval.theToken.value);
                    object = this.centerParameter(++n2);
                    sB.append(" ").append(Escape.eP((P3)object));
                    n2 = this.eval.iToken;
                    break;
                }
                case 1679429641: {
                    P3[] p3Array;
                    if (this.fullCommand.indexOf("# BBOX=") >= 0) {
                        String[] stringArray = TextFormat.split(Parser.getQuotedAttribute(this.fullCommand, "# BBOX"), ',');
                        p3Array = new P3[]{(P3)Escape.uP(stringArray[0]), (P3)Escape.uP(stringArray[1])};
                    } else if (this.eval.isCenterParameter(n2 + 1)) {
                        p3Array = new P3[]{this.getPoint3f(n2 + 1, true), this.getPoint3f(this.eval.iToken + 1, true)};
                        n2 = this.eval.iToken;
                    } else {
                        p3Array = this.viewer.getBoundBoxVertices();
                    }
                    sB.append(" boundBox " + Escape.eP(p3Array[0]) + " " + Escape.eP(p3Array[p3Array.length - 1]));
                    object2 = "boundingBox";
                    object = p3Array;
                    break;
                }
                case 135188: {
                    bl2 = true;
                    sB.append(" pmesh");
                    object2 = "fileType";
                    object = "Pmesh";
                    break;
                }
                case 135267842: {
                    bS2 = this.atomExpressionAt(++n2);
                    if (this.chk) {
                        bS = new BS();
                    } else if (this.tokAt(this.eval.iToken + 1) == 0x100001 || this.tokAt(this.eval.iToken + 1) == 10) {
                        bS = this.atomExpressionAt(++this.eval.iToken);
                        bS.and(this.viewer.getAtomsWithinRadius(5.0f, bS2, false, null));
                    } else {
                        bS = this.viewer.getAtomsWithinRadius(5.0f, bS2, true, null);
                        bS.andNot(this.viewer.getAtomBits(1095761934, bS2));
                    }
                    bS.andNot(bS2);
                    sB.append(" intersection ").append(Escape.eBS(bS2)).append(" ").append(Escape.eBS(bS));
                    n2 = this.eval.iToken;
                    if (this.tokAt(n2 + 1) == 135368713) {
                        ++n2;
                        Object[] objectArray = (Object[])this.eval.getToken((int)(++n2)).value;
                        sB.append(" function ").append(Escape.eS((String)objectArray));
                        if (!this.chk) {
                            this.addShapeProperty(jmolList, "func", objectArray.equals("a+b") || objectArray.equals("a-b") ? objectArray : this.createFunction("__iso__", "a,b", (String)objectArray));
                        }
                    } else {
                        bl17 = true;
                    }
                    object2 = "intersection";
                    object = new BS[]{bS2, bS};
                    break;
                }
                case 135266324: 
                case 1610625028: {
                    float f3;
                    boolean bl25;
                    boolean bl26 = bl25 = this.eval.theTok == 1610625028;
                    if (bl25) {
                        sB.append(" display");
                        n3 = n2;
                        int n9 = this.tokAt(n2 + 1);
                        if (n9 == 0) continue block106;
                        ++n2;
                        this.addShapeProperty(jmolList, "token", 0x10000D);
                        if (n9 == 10 || n9 == 0x100003) {
                            object2 = "bsDisplay";
                            if (n9 == 0x100003) {
                                sB.append(" all");
                            } else {
                                object = this.st[n2].value;
                                sB.append(" ").append(Escape.eBS((BS)object));
                            }
                            this.eval.checkLast(n2);
                            break;
                        }
                        if (n9 != 135266324) {
                            this.eval.iToken = n2;
                            this.invArg();
                        }
                    } else {
                        n6 = n2;
                    }
                    P3 p32 = null;
                    bS = null;
                    boolean bl27 = false;
                    if (this.tokAt(n2 + 1) == 0x100001) {
                        f3 = this.floatParameter(n2 + 3);
                        if (this.eval.isPoint3f(n2 + 4)) {
                            p32 = this.centerParameter(n2 + 4);
                            bl27 = true;
                            this.eval.iToken += 2;
                        } else if (this.eval.isPoint3f(n2 + 5)) {
                            p32 = this.centerParameter(n2 + 5);
                            bl27 = true;
                            this.eval.iToken += 2;
                        } else {
                            bS = this.eval.atomExpression(this.st, n2 + 5, this.eval.slen, true, false, false, true);
                            if (bS == null) {
                                this.invArg();
                            }
                        }
                    } else {
                        f3 = this.floatParameter(++n2);
                        p32 = this.centerParameter(++n2);
                    }
                    if (bl25) {
                        this.eval.checkLast(this.eval.iToken);
                    }
                    n2 = this.eval.iToken;
                    if (this.fullCommand.indexOf("# WITHIN=") >= 0) {
                        bS = Escape.uB(Parser.getQuotedAttribute(this.fullCommand, "# WITHIN"));
                    } else if (!bl27) {
                        BS bS4 = bS = this.eval.expressionResult instanceof BS ? (BS)this.eval.expressionResult : null;
                    }
                    if (this.chk) continue block106;
                    if (bS != null && n8 >= 0) {
                        bS.and(this.viewer.getModelUndeletedAtomsBitSet(n8));
                    }
                    if (p32 == null) {
                        p32 = this.viewer.getAtomSetCenter(bS);
                    }
                    this.getWithinDistanceVector(jmolList, f3, p32, bS, bl25);
                    sB.append(" within ").appendF(f3).append(" ").append(bS == null ? Escape.eP(p32) : Escape.eBS(bS));
                    continue block106;
                }
                case 1073742083: {
                    object2 = "parameters";
                    float[] fArray2 = this.eval.floatParameterSet(++n2, 1, 10);
                    n2 = this.eval.iToken;
                    object = fArray2;
                    sB.append(" parameters ").append(Escape.eAF(fArray2));
                    break;
                }
                case 1073742190: 
                case 1716520985: {
                    int n10;
                    int n11;
                    object3 = this.eval.theToken.value;
                    boolean bl28 = this.eval.theTok == 1073742190;
                    int n12 = this.tokAt(n2 + 1);
                    if (object4 == null) {
                        if (!(bl5 || bl7 || bl6)) {
                            this.addShapeProperty(jmolList, "sasurface", Float.valueOf(0.0f));
                            sB.append(" vdw");
                            bl5 = true;
                        }
                        object2 = "property";
                        if (bl18 == null) {
                            n11 = 1;
                            switch (n12) {
                                case 1095761923: 
                                case 1095761937: 
                                case 1095763969: 
                                case 1095763976: 
                                case 1766856708: {
                                    n11 = 0;
                                }
                            }
                            bl18 = n11 != 0 && this.viewer.getIsosurfacePropertySmoothing(false) == 1 ? Boolean.TRUE : Boolean.FALSE;
                        }
                        this.addShapeProperty(jmolList, "propertySmoothing", bl18);
                        sB.append(" isosurfacePropertySmoothing " + bl18);
                        if (bl18 == Boolean.TRUE) {
                            if (n7 == Integer.MAX_VALUE) {
                                n7 = this.viewer.getIsosurfacePropertySmoothing(true);
                            }
                            this.addShapeProperty(jmolList, "propertySmoothingPower", n7);
                            sB.append(" isosurfacePropertySmoothingPower " + n7);
                        }
                        if (this.viewer.global.rangeSelected) {
                            this.addShapeProperty(jmolList, "rangeSelected", Boolean.TRUE);
                        }
                    } else {
                        object2 = object4;
                    }
                    string2 = this.parameterAsString(n2);
                    sB.append(" ").append(string2);
                    if (string2.toLowerCase().indexOf("property_") == 0) {
                        fArray = new float[this.viewer.getAtomCount()];
                        if (this.chk) continue block106;
                        fArray = this.viewer.getDataFloat(string2);
                        if (fArray == null) {
                            this.invArg();
                        }
                        this.addShapeProperty(jmolList, (String)object2, fArray);
                        continue block106;
                    }
                    n11 = this.viewer.getAtomCount();
                    fArray = new float[n11];
                    if (bl28) {
                        String string5;
                        if ((string5 = this.parameterAsString(++n2)).length() == 0) {
                            fArray = this.eval.floatParameterSet(n2, n11, n11);
                        } else {
                            fArray = new float[n11];
                            if (!this.chk) {
                                Parser.parseStringInfestedFloatArray("" + this.eval.getParameter(string5, 4), null, fArray);
                            }
                        }
                        if (!this.chk) {
                            sB.append(" \"\" ").append(Escape.eAF(fArray));
                        }
                    } else {
                        this.eval.getToken(++n2);
                        if (!this.chk) {
                            sB.append(" " + this.eval.theToken.value);
                            Atom[] atomArray = this.viewer.modelSet.atoms;
                            this.viewer.autoCalculate(n12);
                            if (n12 != 1766856708) {
                                n10 = n11;
                                while (--n10 >= 0) {
                                    fArray[n10] = Atom.atomPropertyFloat(this.viewer, atomArray[n10], n12);
                                }
                            }
                        }
                        if (n12 == 1766856708) {
                            string4 = "inherit";
                        }
                        if (this.tokAt(n2 + 1) == 135266324) {
                            float f4 = this.floatParameter(n2 += 2);
                            sB.append(" within " + f4);
                            this.addShapeProperty(jmolList, "propertyDistanceMax", Float.valueOf(f4));
                        }
                    }
                    object = fArray;
                    break;
                }
                case 1095761933: 
                case 1095766028: {
                    if (bl5) {
                        this.invArg();
                    }
                    n8 = this.eval.theTok == 1095761933 ? this.intParameter(++n2) : this.eval.modelNumberParameter(++n2);
                    sB.append(" modelIndex " + n8);
                    if (n8 < 0) {
                        object2 = "fixed";
                        object = Boolean.TRUE;
                        break;
                    }
                    object2 = "modelIndex";
                    object = n8;
                    break;
                }
                case 135280132: {
                    int n10;
                    object2 = "select";
                    BS bS5 = this.atomExpressionAt(++n2);
                    object = bS5;
                    n2 = this.eval.iToken;
                    int n13 = n10 = this.tokAt(n2 + 1) == 1073742072 ? 1 : 0;
                    if (n10 != 0) {
                        ++n2;
                        BS bS6 = BSUtil.copy(bS5);
                        BSUtil.invertInPlace(bS6, this.viewer.getAtomCount());
                        this.addShapeProperty(jmolList, "ignore", bS6);
                        sB.append(" ignore ").append(Escape.eBS(bS6));
                    }
                    if (bl5 || bl7) {
                        sB.append(" select " + Escape.eBS(bS5));
                        break;
                    }
                    bS2 = (BS)object;
                    if (n8 >= 0 || bS2.nextSetBit(0) < 0) break;
                    n8 = this.viewer.getAtomModelIndex(bS2.nextSetBit(0));
                    break;
                }
                case 1085443: {
                    n4 = this.intParameter(++n2);
                    break;
                }
                case 12289: {
                    object2 = "center";
                    object = this.centerParameter(++n2);
                    sB.append(" center " + Escape.eP((P3)object));
                    n2 = this.eval.iToken;
                    break;
                }
                case 1073742147: 
                case 1766856708: {
                    boolean bl29;
                    bl19 = true;
                    boolean bl30 = bl29 = this.eval.theTok == 1073742147;
                    if (bl29) {
                        sB.append(" sign");
                        this.addShapeProperty(jmolList, "sign", Boolean.TRUE);
                    } else {
                        float f5;
                        if (this.tokAt(n2 + 1) == 1073741914) {
                            object2 = "colorDensity";
                            sB.append(" color density");
                            if (!this.isFloatParameter(++n2 + 1)) break;
                            f5 = this.floatParameter(++n2);
                            sB.append(" " + f5);
                            object = Float.valueOf(f5);
                            break;
                        }
                        if (this.eval.getToken((int)(n2 + 1)).tok == 4) {
                            if ((string4 = this.parameterAsString(++n2)).indexOf(" ") > 0 && (sArray = C.getColixArray(string4)) == null) {
                                this.error(4);
                            }
                        } else if (this.eval.theTok == 1073742018) {
                            ++n2;
                            sB.append(" color mesh");
                            int n14 = this.eval.getArgbParam(++n2);
                            this.addShapeProperty(jmolList, "meshcolor", n14);
                            sB.append(" ").append(Escape.escapeColor(n14));
                            n2 = this.eval.iToken;
                            continue block106;
                        }
                        if ((this.eval.theTok = this.tokAt(n2 + 1)) == 603979967 || this.eval.theTok == 1073742074) {
                            sB.append(" color");
                            string3 = this.setColorOptions(sB, n2 + 1, 24, -2);
                            n2 = this.eval.iToken;
                            continue block106;
                        }
                        switch (this.tokAt(n2 + 1)) {
                            case 0x40000002: 
                            case 1073742114: {
                                this.eval.getToken(++n2);
                                sB.append(" color range");
                                this.addShapeProperty(jmolList, "rangeAll", null);
                                if (this.tokAt(n2 + 1) == 0x100003) {
                                    ++n2;
                                    sB.append(" all");
                                    continue block106;
                                }
                                f5 = this.floatParameter(++n2);
                                float f6 = this.floatParameter(++n2);
                                this.addShapeProperty(jmolList, "red", Float.valueOf(f5));
                                this.addShapeProperty(jmolList, "blue", Float.valueOf(f6));
                                sB.append(" ").appendF(f5).append(" ").appendF(f6);
                                continue block106;
                            }
                            default: {
                                if (this.eval.isColorParam(n2 + 1)) {
                                    int n15 = this.eval.getArgbParam(n2 + 1);
                                    if (this.tokAt(n2 + 2) == 1074790746) {
                                        string4 = this.eval.getColorRange(n2 + 1);
                                        n2 = this.eval.iToken;
                                        break block1;
                                    }
                                }
                                sB.append(" color");
                            }
                        }
                    }
                    if (this.eval.isColorParam(n2 + 1)) {
                        int n16 = this.eval.getArgbParam(++n2);
                        sB.append(" ").append(Escape.escapeColor(n16));
                        n2 = this.eval.iToken;
                        this.addShapeProperty(jmolList, "colorRGB", n16);
                        bl19 = true;
                        if (this.eval.isColorParam(n2 + 1)) {
                            n16 = this.eval.getArgbParam(++n2);
                            n2 = this.eval.iToken;
                            this.addShapeProperty(jmolList, "colorRGB", n16);
                            sB.append(" ").append(Escape.escapeColor(n16));
                            bl8 = true;
                            continue block106;
                        }
                        if (!bl29) continue block106;
                        this.invPO();
                        continue block106;
                    }
                    if (bl29 || sArray != null) continue block106;
                    this.invPO();
                    continue block106;
                }
                case 135270422: {
                    if (!bl) {
                        this.invArg();
                    }
                    bl14 = !this.chk;
                    continue block106;
                }
                case 1229984263: {
                    if (this.tokAt(n2 + 1) == 4) continue block106;
                    this.invPO();
                    continue block106;
                }
                case 1112541195: 
                case 1649412120: {
                    sB.append(" ").appendO(this.eval.theToken.value);
                    RadiusData radiusData = this.eval.encodeRadiusParameter(n2, false, true);
                    sB.append(" ").appendO(radiusData);
                    if (Float.isNaN(radiusData.value)) {
                        radiusData.value = 100.0f;
                    }
                    object = radiusData;
                    object2 = "radius";
                    bl13 = true;
                    if (bl7) {
                        bl5 = false;
                    }
                    n2 = this.eval.iToken;
                    break;
                }
                case 135266319: {
                    bl6 = true;
                    object2 = "plane";
                    object = this.eval.planeParameter(++n2);
                    n2 = this.eval.iToken;
                    sB.append(" plane ").append(Escape.eP4((P4)object));
                    break;
                }
                case 1073742138: {
                    object2 = "scale";
                    object = Float.valueOf(this.floatParameter(++n2));
                    sB.append(" scale ").appendO(object);
                    break;
                }
                case 0x100003: {
                    if (bl19) {
                        this.invArg();
                    }
                    object2 = "thisID";
                    break;
                }
                case 1113198596: {
                    bl5 = true;
                    object = this.getPoint4f(++n2);
                    object2 = "ellipsoid";
                    n2 = this.eval.iToken;
                    sB.append(" ellipsoid ").append(Escape.eP4((P4)object));
                    break;
                }
                case 135267841: {
                    bl6 = true;
                    object2 = "plane";
                    object = this.eval.hklParameter(++n2);
                    n2 = this.eval.iToken;
                    sB.append(" plane ").append(Escape.eP4((P4)object));
                    break;
                }
                case 135182: {
                    int n17;
                    bl5 = true;
                    String string6 = this.parameterAsString(++n2);
                    this.addShapeProperty(jmolList, "lcaoType", string6);
                    sB.append(" lcaocartoon ").append(Escape.eS(string6));
                    switch (this.eval.getToken((int)(++n2)).tok) {
                        case 10: 
                        case 0x100001: {
                            object2 = "lcaoCartoon";
                            bS = this.atomExpressionAt(n2);
                            n2 = this.eval.iToken;
                            if (this.chk) continue block106;
                            n17 = bS.nextSetBit(0);
                            if (n17 < 0) {
                                this.error(14);
                            }
                            sB.append(" ({").appendI(n17).append("})");
                            n8 = this.viewer.getAtomModelIndex(n17);
                            this.addShapeProperty(jmolList, "modelIndex", n8);
                            V3[] v3Array = new V3[]{new V3(), new V3(), V3.newV(this.viewer.getAtomPoint3f(n17)), new V3()};
                            if (!string6.equalsIgnoreCase("s") && this.viewer.getHybridizationAndAxes(n17, v3Array[0], v3Array[1], string6) == null) {
                                return false;
                            }
                            object = v3Array;
                            break;
                        }
                        default: {
                            this.error(14);
                            break;
                        }
                    }
                    break;
                }
                case 0x121012: {
                    int n18;
                    int n19;
                    boolean bl31;
                    boolean bl32;
                    int n17 = Integer.MAX_VALUE;
                    int n20 = Integer.MAX_VALUE;
                    boolean bl33 = bl32 = this.tokAt(n2 + 1) == 0x101000A0;
                    if (bl32) {
                        ++n2;
                    }
                    float[] fArray3 = null;
                    switch (this.tokAt(++n2)) {
                        case 0: {
                            this.error(2);
                            break;
                        }
                        case 1073741914: {
                            sB.append("mo [1] squared ");
                            this.addShapeProperty(jmolList, "squareLinear", Boolean.TRUE);
                            fArray3 = new float[]{1.0f};
                            n17 = 0;
                            n20 = 0;
                            ++n2;
                            break;
                        }
                        case 1073741973: 
                        case 1073742008: {
                            n20 = this.moOffset(n2);
                            n17 = 0;
                            n2 = this.eval.iToken;
                            sB.append(" mo " + (bl32 ? "-" : "") + "HOMO ");
                            if (n20 > 0) {
                                sB.append("+");
                            }
                            if (n20 == 0) break;
                            sB.appendI(n20);
                            break;
                        }
                        case 2: {
                            n17 = this.intParameter(n2);
                            sB.append(" mo ").appendI(n17);
                            break;
                        }
                        default: {
                            if (!this.eval.isArrayParameter(n2)) break;
                            fArray3 = this.eval.floatParameterSet(n2, 1, Integer.MAX_VALUE);
                            n2 = this.eval.iToken;
                        }
                    }
                    boolean bl34 = bl31 = this.tokAt(n2 + 1) == 1073742156;
                    if (bl31) {
                        this.addShapeProperty(jmolList, "squareLinear", Boolean.TRUE);
                        sB.append(" squared");
                        if (fArray3 == null) {
                            fArray3 = new float[]{};
                        }
                    } else if (this.tokAt(n2 + 1) == 0x8100010) {
                        ++n2;
                        n19 = this.intParameter(++n2);
                        n18 = this.tokAt(n2 + 1) == 2 ? this.intParameter(++n2) : (int)(-System.currentTimeMillis()) % 10000;
                        this.addShapeProperty(jmolList, "monteCarloCount", n19);
                        this.addShapeProperty(jmolList, "randomSeed", n18);
                        sB.append(" points ").appendI(n19).appendC(' ').appendI(n18);
                    }
                    this.setMoData(jmolList, n17, fArray3, n20, bl32, n8, null);
                    bl5 = true;
                    continue block106;
                }
                case 0x400000D4: {
                    object2 = "nci";
                    sB.append(" " + (String)object2);
                    int n19 = this.tokAt(n2 + 1);
                    int n18 = n19 != 1229984263 && n19 != 4 && n19 != 1073742033 ? 1 : 0;
                    object = n18 != 0;
                    if (n18 == 0) break;
                    bl5 = true;
                    break;
                }
                case 0x400000C0: 
                case 1073742022: {
                    boolean bl35 = this.eval.theTok == 0x400000C0;
                    object2 = bl35 ? "mep" : "mlp";
                    sB.append(" " + (String)object2);
                    String string7 = null;
                    int n21 = -1;
                    bl5 = true;
                    if (this.tokAt(n2 + 1) == 2) {
                        n21 = this.intParameter(++n2);
                        sB.append(" " + n21);
                        this.addShapeProperty(jmolList, "mepCalcType", n21);
                    }
                    if (this.tokAt(n2 + 1) == 4) {
                        string7 = this.stringParameter(++n2);
                        sB.append(" /*file*/" + Escape.eS(string7));
                    } else if (this.tokAt(n2 + 1) == 1716520985) {
                        object4 = object2;
                        continue block106;
                    }
                    if (!this.chk) {
                        try {
                            fArray = string7 == null && bl35 ? this.viewer.getPartialCharges() : this.viewer.getAtomicPotentials(bl35, bS2, bS3, string7);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!this.chk && fArray == null) {
                        this.error(32);
                    }
                    object = fArray;
                    break;
                }
                case 1313866247: {
                    bl11 = !this.chk;
                    sB.append(" volume");
                    break;
                }
                case 1074790550: {
                    this.setShapeId(n, ++n2, bl19);
                    bl20 = this.getShapeProperty(n, "ID") == null;
                    n2 = this.eval.iToken;
                    break;
                }
                case 0x40000040: {
                    if (this.tokAt(n2 + 1) == 603979967) {
                        bl21 = true;
                        ++n2;
                    }
                    if ((string4 = this.parameterAsString(++n2).toLowerCase()).equals("sets")) {
                        sB.append(" colorScheme \"sets\"");
                        break;
                    }
                    if (!this.eval.isColorParam(n2)) break;
                    string4 = this.eval.getColorRange(n2);
                    n2 = this.eval.iToken;
                    break;
                }
                case 0x40000004: {
                    object2 = "addHydrogens";
                    object = Boolean.TRUE;
                    sB.append(" addHydrogens");
                    break;
                }
                case 0x4000000C: {
                    object2 = "angstroms";
                    sB.append(" angstroms");
                    break;
                }
                case 0x4000000E: {
                    object2 = "anisotropy";
                    object = this.getPoint3f(++n2, false);
                    sB.append(" anisotropy").append(Escape.eP((P3)object));
                    n2 = this.eval.iToken;
                    break;
                }
                case 1073741842: {
                    bl10 = !this.chk;
                    sB.append(" area");
                    break;
                }
                case 1073741850: 
                case 1073742076: {
                    bl5 = true;
                    if (bl8 && !bl9) {
                        sB.append(" phase \"_orb\"");
                        this.addShapeProperty(jmolList, "phase", "_orb");
                    }
                    float[] fArray4 = new float[7];
                    fArray4[0] = this.intParameter(++n2);
                    fArray4[1] = this.intParameter(++n2);
                    fArray4[2] = this.intParameter(++n2);
                    fArray4[3] = this.isFloatParameter(n2 + 1) ? this.floatParameter(++n2) : 6.0f;
                    sB.append(" atomicOrbital ").appendI((int)fArray4[0]).append(" ").appendI((int)fArray4[1]).append(" ").appendI((int)fArray4[2]).append(" ").appendF(fArray4[3]);
                    if (this.tokAt(n2 + 1) == 0x8100010) {
                        fArray4[4] = this.intParameter(n2 += 2);
                        fArray4[5] = this.tokAt(n2 + 1) == 3 ? this.floatParameter(++n2) : 0.0f;
                        fArray4[6] = this.tokAt(n2 + 1) == 2 ? this.intParameter(++n2) : (int)(-System.currentTimeMillis()) % 10000;
                        sB.append(" points ").appendI((int)fArray4[4]).appendC(' ').appendF(fArray4[5]).appendC(' ').appendI((int)fArray4[6]);
                    }
                    object2 = "hydrogenOrbital";
                    object = fArray4;
                    break;
                }
                case 1073741866: {
                    sB.append(" binary");
                    continue block106;
                }
                case 1073741868: {
                    sB.append(" blockData");
                    object2 = "blockData";
                    object = Boolean.TRUE;
                    break;
                }
                case 554176565: 
                case 1074790451: {
                    bl16 = true;
                    object2 = (String)this.eval.theToken.value;
                    object = this.getCapSlabObject(n2, false);
                    n2 = this.eval.iToken;
                    break;
                }
                case 0x40000034: {
                    float f7;
                    if (!bl) {
                        this.invArg();
                    }
                    bl12 = true;
                    if (this.chk) continue block106;
                    float f8 = this.isFloatParameter(n2 + 1) ? this.floatParameter(++n2) : 1.2f;
                    float f9 = f7 = this.isFloatParameter(n2 + 1) ? this.floatParameter(++n2) : 10.0f;
                    if (f7 > 10.0f) {
                        this.eval.integerOutOfRange(0, 10);
                    }
                    sB.append(" cavity ").appendF(f8).append(" ").appendF(f7);
                    this.addShapeProperty(jmolList, "envelopeRadius", Float.valueOf(f7));
                    this.addShapeProperty(jmolList, "cavityRadius", Float.valueOf(f8));
                    object2 = "cavity";
                    break;
                }
                case 0x40000048: 
                case 0x4000004C: {
                    P3 p33;
                    object2 = "contour";
                    sB.append(" contour");
                    switch (this.tokAt(n2 + 1)) {
                        case 0x40000060: {
                            object = this.eval.floatParameterSet(n2 + 2, 1, Integer.MAX_VALUE);
                            sB.append(" discrete ").append(Escape.eAF((float[])object));
                            n2 = this.eval.iToken;
                            break block1;
                        }
                        case 1073741981: {
                            p33 = this.getPoint3f(n2 + 2, false);
                            if (p33.z <= 0.0f || p33.y < p33.x) {
                                this.invArg();
                            }
                            if (p33.z == (float)((int)p33.z) && p33.z > p33.y - p33.x) {
                                p33.z = (p33.y - p33.x) / p33.z;
                            }
                            object = p33;
                            n2 = this.eval.iToken;
                            sB.append(" increment ").append(Escape.eP(p33));
                            break block1;
                        }
                    }
                    object = this.tokAt(n2 + 1) == 2 ? this.intParameter(++n2) : 0;
                    sB.append(" ").appendO(object);
                    break;
                }
                case 2: 
                case 3: 
                case 0x101000A1: 
                case 1073741910: {
                    sB.append(" cutoff ");
                    if (this.eval.theTok == 1073741910) {
                        ++n2;
                    }
                    if (this.tokAt(n2) == 0x101000A1) {
                        object2 = "cutoffPositive";
                        f2 = this.floatParameter(++n2);
                        object = Float.valueOf(f2);
                        sB.append("+").appendO(object);
                        break;
                    }
                    if (this.isFloatParameter(n2)) {
                        object2 = "cutoff";
                        f2 = this.floatParameter(n2);
                        object = Float.valueOf(f2);
                        sB.appendO(object);
                        break;
                    }
                    object2 = "cutoffRange";
                    object = this.eval.floatParameterSet(n2, 2, 2);
                    this.addShapeProperty(jmolList, "cutoff", Float.valueOf(0.0f));
                    sB.append(Escape.eAF((float[])object));
                    n2 = this.eval.iToken;
                    break;
                }
                case 1073741928: {
                    object2 = "downsample";
                    object = this.intParameter(++n2);
                    sB.append(" downsample ").appendO(object);
                    break;
                }
                case 1073741930: {
                    object2 = "eccentricity";
                    object = this.getPoint4f(++n2);
                    sB.append(" eccentricity ").append(Escape.eP4((P4)object));
                    n2 = this.eval.iToken;
                    break;
                }
                case 1074790508: {
                    sB.append(" ed");
                    this.setMoData(jmolList, -1, null, 0, false, n8, null);
                    bl5 = true;
                    continue block106;
                }
                case 0x20000004: 
                case 1073742041: {
                    sB.append(" ").appendO(this.eval.theToken.value);
                    object2 = "debug";
                    object = this.eval.theTok == 0x20000004 ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 1060869: {
                    sB.append(" fixed");
                    object2 = "fixed";
                    object = Boolean.TRUE;
                    break;
                }
                case 1073741962: {
                    sB.append(" fullPlane");
                    object2 = "fullPlane";
                    object = Boolean.TRUE;
                    break;
                }
                case 1073741966: 
                case 0x40000090: {
                    boolean bl36 = this.eval.theTok == 0x40000090;
                    object2 = "" + this.eval.theToken.value;
                    JmolList<Object> jmolList2 = new JmolList<Object>();
                    object = jmolList2;
                    bl5 = true;
                    bl15 = true;
                    sB.append(" ").append((String)object2);
                    String string8 = this.parameterAsString(++n2);
                    if (string8.equals("=")) {
                        sB.append(" =");
                        string8 = this.parameterAsString(++n2);
                        sB.append(" ").append(Escape.eS(string8));
                        jmolList2.addLast(string8);
                        if (this.chk) break;
                        this.addShapeProperty(jmolList, "func", this.createFunction("__iso__", "x,y,z", string8));
                        break;
                    }
                    String string9 = Parser.getQuotedAttribute(this.fullCommand, "# DATA" + (bl15 ? "2" : ""));
                    if (string9 == null) {
                        string9 = "inline";
                    } else {
                        string8 = string9;
                    }
                    boolean bl37 = string8.indexOf("data2d_") == 0;
                    boolean bl38 = string8.indexOf("data3d_") == 0;
                    bl22 = string8.equals("inline");
                    sB.append(" inline");
                    jmolList2.addLast(string8);
                    P3 p34 = this.getPoint3f(++n2, false);
                    sB.append(" ").append(Escape.eP(p34));
                    jmolList2.addLast(p34);
                    int n22 = ++this.eval.iToken;
                    P4 p42 = this.getPoint4f(n22);
                    jmolList2.addLast(p42);
                    sB.append(" ").append(Escape.eP4(p42));
                    int n23 = (int)p42.x;
                    int n24 = ++this.eval.iToken;
                    p42 = this.getPoint4f(n24);
                    jmolList2.addLast(p42);
                    sB.append(" ").append(Escape.eP4(p42));
                    int n25 = (int)p42.x;
                    p42 = this.getPoint4f(++this.eval.iToken);
                    jmolList2.addLast(p42);
                    sB.append(" ").append(Escape.eP4(p42));
                    int n26 = (int)p42.x;
                    if (n23 == 0 || n25 == 0 || n26 == 0) {
                        this.invArg();
                    }
                    if (!this.chk) {
                        float[][] fArray5 = null;
                        float[][][] fArray6 = null;
                        if (bl36) {
                            if (bl22) {
                                n23 = Math.abs(n23);
                                n25 = Math.abs(n25);
                                n26 = Math.abs(n26);
                                fArray6 = this.floatArraySetXYZ(++this.eval.iToken, n23, n25, n26);
                            } else {
                                fArray6 = bl38 ? this.viewer.getDataFloat3D(string8) : this.viewer.functionXYZ(string8, n23, n25, n26);
                            }
                            n23 = Math.abs(n23);
                            n25 = Math.abs(n25);
                            n26 = Math.abs(n26);
                            if (fArray6 == null) {
                                this.eval.iToken = n22;
                                this.eval.errorStr(53, "xyzdata is null.");
                            }
                            if (fArray6.length != n23 || fArray6[0].length != n25 || fArray6[0][0].length != n26) {
                                this.eval.iToken = n22;
                                this.eval.errorStr(53, "xyzdata[" + fArray6.length + "][" + fArray6[0].length + "][" + fArray6[0][0].length + "] is not of size [" + n23 + "][" + n25 + "][" + n26 + "]");
                            }
                            jmolList2.addLast(fArray6);
                            sB.append(" ").append(Escape.e(fArray6));
                        } else {
                            if (bl22) {
                                n23 = Math.abs(n23);
                                n25 = Math.abs(n25);
                                fArray5 = this.floatArraySet(++this.eval.iToken, n23, n25);
                            } else if (bl37) {
                                fArray5 = this.viewer.getDataFloat2D(string8);
                                n23 = fArray5 == null ? 0 : fArray5.length;
                                n25 = 3;
                            } else {
                                fArray5 = this.viewer.functionXY(string8, n23, n25);
                                n23 = Math.abs(n23);
                                n25 = Math.abs(n25);
                            }
                            if (fArray5 == null) {
                                this.eval.iToken = n22;
                                this.eval.errorStr(53, "fdata is null.");
                            }
                            if (fArray5.length != n23 && !bl37) {
                                this.eval.iToken = n22;
                                this.eval.errorStr(53, "fdata length is not correct: " + fArray5.length + " " + n23 + ".");
                            }
                            for (int i = 0; i < n23; ++i) {
                                if (fArray5[i] == null) {
                                    this.eval.iToken = n24;
                                    this.eval.errorStr(53, "fdata[" + i + "] is null.");
                                }
                                if (fArray5[i].length == n25) continue;
                                this.eval.iToken = n24;
                                this.eval.errorStr(53, "fdata[" + i + "] is not the right length: " + fArray5[i].length + " " + n25 + ".");
                            }
                            jmolList2.addLast(fArray5);
                            sB.append(" ").append(Escape.e(fArray5));
                        }
                    }
                    n2 = this.eval.iToken;
                    break;
                }
                case 1073741970: {
                    object2 = "gridPoints";
                    sB.append(" gridPoints");
                    break;
                }
                case 1073741976: {
                    object2 = "ignore";
                    bS3 = this.atomExpressionAt(++n2);
                    object = bS3;
                    sB.append(" ignore ").append(Escape.eBS(bS3));
                    n2 = this.eval.iToken;
                    break;
                }
                case 0x400000A0: {
                    object2 = "insideOut";
                    sB.append(" insideout");
                    break;
                }
                case 1073741986: 
                case 0x400000A4: 
                case 0x40000114: {
                    sB.append(" ").appendO(this.eval.theToken.value);
                    object2 = "pocket";
                    object = this.eval.theTok == 0x40000114 ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 1073742002: {
                    object2 = "lobe";
                    object = this.getPoint4f(++n2);
                    n2 = this.eval.iToken;
                    sB.append(" lobe ").append(Escape.eP4((P4)object));
                    bl5 = true;
                    break;
                }
                case 0x400000B4: 
                case 1073742006: {
                    object2 = "lp";
                    object = this.getPoint4f(++n2);
                    n2 = this.eval.iToken;
                    sB.append(" lp ").append(Escape.eP4((P4)object));
                    bl5 = true;
                    break;
                }
                case 0x10101C: {
                    if (bl7 || this.eval.slen == n2 + 1) {
                        this.invArg();
                    }
                    bl7 = true;
                    if ((bl12 || bl13 || bl17) && !bl5) {
                        bl5 = true;
                        this.addShapeProperty(jmolList, "bsSolvent", bl13 || bl17 ? new BS() : this.eval.lookupIdentifierValue("solvent"));
                        this.addShapeProperty(jmolList, "sasurface", Float.valueOf(0.0f));
                    }
                    if (sB.length() == 0) {
                        p4 = (P4)this.getShapeProperty(24, "plane");
                        if (p4 == null) {
                            if (this.getShapeProperty(24, "contours") != null) {
                                this.addShapeProperty(jmolList, "nocontour", null);
                            }
                        } else {
                            this.addShapeProperty(jmolList, "plane", p4);
                            sB.append("plane ").append(Escape.eP4(p4));
                            bl6 = true;
                            p4 = null;
                        }
                    } else if (!bl5 && !bl6) {
                        this.invArg();
                    }
                    sB.append("; isosurface map");
                    this.addShapeProperty(jmolList, "map", bl5 ? Boolean.TRUE : Boolean.FALSE);
                    break;
                }
                case 1073742014: {
                    object2 = "maxset";
                    object = this.intParameter(++n2);
                    sB.append(" maxSet ").appendO(object);
                    break;
                }
                case 0x400000C4: {
                    object2 = "minset";
                    object = this.intParameter(++n2);
                    sB.append(" minSet ").appendO(object);
                    break;
                }
                case 1073742112: {
                    bl5 = true;
                    object2 = "rad";
                    object = this.getPoint4f(++n2);
                    n2 = this.eval.iToken;
                    sB.append(" radical ").append(Escape.eP4((P4)object));
                    break;
                }
                case 0x400000CC: {
                    object2 = "fixed";
                    object = Boolean.FALSE;
                    sB.append(" modelBased");
                    break;
                }
                case 1073742029: 
                case 1073742136: 
                case 1613758488: {
                    float f10;
                    object3 = this.eval.theToken.value;
                    if (this.eval.theTok == 1073742029) {
                        object2 = "molecular";
                        sB.append(" molecular");
                        f10 = this.isFloatParameter(n2 + 1) ? this.floatParameter(++n2) : 1.4f;
                    } else {
                        this.addShapeProperty(jmolList, "bsSolvent", this.eval.lookupIdentifierValue("solvent"));
                        object2 = this.eval.theTok == 1073742136 ? "sasurface" : "solvent";
                        sB.append(" ").appendO(this.eval.theToken.value);
                        f10 = this.isFloatParameter(n2 + 1) ? this.floatParameter(++n2) : this.viewer.getFloat(0x22000032);
                    }
                    sB.append(" ").appendF(f10);
                    object = Float.valueOf(f10);
                    if (this.tokAt(n2 + 1) == 1073741961) {
                        this.addShapeProperty(jmolList, "doFullMolecular", null);
                        sB.append(" full");
                        ++n2;
                    }
                    bl5 = true;
                    break;
                }
                case 1073742033: {
                    this.addShapeProperty(jmolList, "fileType", "Mrc");
                    sB.append(" mrc");
                    continue block106;
                }
                case 0x400000EE: 
                case 0x400000F0: {
                    this.addShapeProperty(jmolList, "fileType", "Obj");
                    sB.append(" obj");
                    continue block106;
                }
                case 1073742034: {
                    this.addShapeProperty(jmolList, "fileType", "Msms");
                    sB.append(" msms");
                    continue block106;
                }
                case 1073742094: {
                    if (bl5) {
                        this.invArg();
                    }
                    object2 = "phase";
                    bl9 = true;
                    object = this.tokAt(n2 + 1) == 4 ? this.stringParameter(++n2) : "_orb";
                    sB.append(" phase ").append(Escape.eS((String)object));
                    break;
                }
                case 1073742104: 
                case 1073742122: {
                    object2 = "resolution";
                    object = Float.valueOf(this.floatParameter(++n2));
                    sB.append(" resolution ").appendO(object);
                    break;
                }
                case 1073742124: {
                    object2 = "reverseColor";
                    object = Boolean.TRUE;
                    sB.append(" reversecolor");
                    break;
                }
                case 1073742146: {
                    object2 = "sigma";
                    f = this.floatParameter(++n2);
                    object = Float.valueOf(f);
                    sB.append(" sigma ").appendO(object);
                    break;
                }
                case 1113198597: {
                    object2 = "geodesic";
                    object = Float.valueOf(this.floatParameter(++n2));
                    sB.append(" geosurface ").appendO(object);
                    bl5 = true;
                    break;
                }
                case 1073742154: {
                    object2 = "sphere";
                    object = Float.valueOf(this.floatParameter(++n2));
                    sB.append(" sphere ").appendO(object);
                    bl5 = true;
                    break;
                }
                case 1073742156: {
                    object2 = "squareData";
                    object = Boolean.TRUE;
                    sB.append(" squared");
                    break;
                }
                case 1073741983: {
                    object2 = !bl5 && !bl6 && !bl7 ? "readFile" : "mapColor";
                    string2 = this.stringParameter(++n2);
                    if (string2 == null) {
                        this.invArg();
                    }
                    if (bl2) {
                        string2 = TextFormat.replaceAllCharacter(string2, "{,}|", ' ');
                    }
                    if (this.eval.logMessages) {
                        Logger.debug("pmesh inline data:\n" + string2);
                    }
                    object = this.chk ? null : string2;
                    this.addShapeProperty(jmolList, "fileName", "");
                    sB.append(" INLINE ").append(Escape.eS(string2));
                    bl5 = true;
                    break;
                }
                case 4: {
                    String[] stringArray;
                    String string10;
                    boolean bl39 = !bl5 && !bl6;
                    object2 = bl39 && !bl7 ? "readFile" : "mapColor";
                    String string11 = this.parameterAsString(n2);
                    if (string11.startsWith("=") && string11.length() > 1) {
                        String[] stringArray2 = (String[])this.viewer.setLoadFormat(string11, '_', false);
                        string11 = stringArray2[0];
                        String string12 = string10 = !bl39 || !Float.isNaN(f2) ? null : stringArray2[1];
                        if (string10 != null && !this.chk && (f2 = SV.fValue(SV.getVariable(this.viewer.evaluateExpression(string10)))) > 0.0f) {
                            if (!Float.isNaN(f)) {
                                f2 *= f;
                                f = Float.NaN;
                                this.addShapeProperty(jmolList, "sigma", Float.valueOf(f));
                            }
                            this.addShapeProperty(jmolList, "cutoff", Float.valueOf(f2));
                            sB.append(" cutoff ").appendF(f2);
                        }
                        if (n6 == 0) {
                            object3 = "=xxxx";
                            if (n8 < 0) {
                                n8 = this.viewer.getCurrentModelIndex();
                            }
                            bS = this.viewer.getModelUndeletedAtomsBitSet(n8);
                            this.getWithinDistanceVector(jmolList, 2.0f, null, bS, false);
                            sB.append(" within 2.0 ").append(Escape.eBS(bS));
                        }
                        if (bl39) {
                            bl23 = true;
                        }
                    }
                    if (bl39 && this.viewer.getParameter("_fileType").equals("Pdb") && Float.isNaN(f) && Float.isNaN(f2)) {
                        this.addShapeProperty(jmolList, "sigma", Float.valueOf(-1.0f));
                        sB.append(" sigma -1.0");
                    }
                    if (string11.length() == 0) {
                        if (n8 < 0) {
                            n8 = this.viewer.getCurrentModelIndex();
                        }
                        string11 = this.eval.getFullPathName();
                        object = this.viewer.getModelAuxiliaryInfoValue(n8, "jmolSurfaceInfo");
                    }
                    int n27 = -1;
                    if (object == null && this.tokAt(n2 + 1) == 2) {
                        n27 = this.intParameter(++n2);
                        this.addShapeProperty(jmolList, "fileIndex", n27);
                    }
                    string10 = this.tokAt(n2 + 1) == 4 ? this.stringParameter(++n2) : null;
                    bl5 = true;
                    if (this.chk) break;
                    String string13 = null;
                    if (object == null) {
                        if (this.fullCommand.indexOf("# FILE" + n5 + "=") >= 0) {
                            string11 = Parser.getQuotedAttribute(this.fullCommand, "# FILE" + n5);
                            if (this.tokAt(n2 + 1) == 1073741848) {
                                n2 += 2;
                            }
                        } else if (this.tokAt(n2 + 1) == 1073741848) {
                            this.eval.iToken = n2 += 2;
                            string13 = this.viewer.getFilePath(this.stringParameter(n2), false);
                            stringArray = this.viewer.getFullPathNameOrError(string13);
                            string13 = stringArray[0];
                            if (this.viewer.getPathForAllFiles() != "") {
                                string11 = string13;
                                string13 = null;
                            } else {
                                this.addShapeProperty(jmolList, "localName", string13);
                                this.viewer.setPrivateKeyForShape(n);
                            }
                        }
                    }
                    if (!string11.startsWith("cache://") && string10 == null) {
                        stringArray = this.viewer.getFullPathNameOrError(string11);
                        string11 = stringArray[0];
                        if (stringArray[1] != null) {
                            this.eval.errorStr(17, string11 + ":" + stringArray[1]);
                        }
                    }
                    Logger.info("reading isosurface data from " + string11);
                    if (string10 != null) {
                        object = this.viewer.cacheGet(string11);
                        this.addShapeProperty(jmolList, "calculationType", string10);
                    }
                    if (object == null) {
                        this.addShapeProperty(jmolList, "fileName", string11);
                        if (string13 != null) {
                            string11 = string13;
                        }
                        if (n27 >= 0) {
                            sB.append(" ").appendI(n27);
                        }
                    }
                    sB.append(" /*file*/").append(Escape.eS(string11));
                    if (string10 == null) break;
                    sB.append(" ").append(Escape.eS(string10));
                    break;
                }
                case 4106: {
                    object2 = "connections";
                    switch (this.tokAt(++n2)) {
                        case 10: 
                        case 0x100001: {
                            object = new int[]{this.atomExpressionAt(n2).nextSetBit(0)};
                            break;
                        }
                        default: {
                            object = new int[]{(int)this.eval.floatParameterSet(n2, 1, 1)[0]};
                        }
                    }
                    n2 = this.eval.iToken;
                    break;
                }
                case 1095761923: {
                    object2 = "atomIndex";
                    object = this.intParameter(++n2);
                    break;
                }
                case 1073741999: {
                    object2 = "link";
                    sB.append(" link");
                    break;
                }
                case 0x400000AA: {
                    if (n != 24) {
                        this.invArg();
                    }
                    P3 p33 = this.getPoint3f(this.eval.iToken + 1, false);
                    n2 = this.eval.iToken;
                    if (p33.x <= 0.0f || p33.y <= 0.0f || p33.z <= 0.0f) break;
                    p33.x = (int)p33.x;
                    p33.y = (int)p33.y;
                    p33.z = (int)p33.z;
                    sB.append(" lattice ").append(Escape.eP(p33));
                    if (bl7) {
                        object2 = "mapLattice";
                        object = p33;
                        break;
                    }
                    p3 = p33;
                    break;
                }
                default: {
                    if (this.eval.theTok == 0x40000000) {
                        object2 = "thisID";
                        object = string2;
                    }
                    if (!this.eval.setMeshDisplayProperty(n, 0, this.eval.theTok)) {
                        if (T.tokAttr(this.eval.theTok, 0x40000000) && !bl19) {
                            this.setShapeId(n, n2, bl19);
                            n2 = this.eval.iToken;
                            break;
                        }
                        this.invArg();
                    }
                    if (n3 == 0) {
                        n3 = n2;
                    }
                    n2 = this.eval.slen - 1;
                }
            }
            boolean bl40 = bl19 = this.eval.theTok != 12291;
            if (bl20 && bl5) {
                this.invArg();
            }
            if (object2 == null) continue;
            this.addShapeProperty(jmolList, (String)object2, object);
        }
        if (!this.chk) {
            ColorEncoder colorEncoder;
            if ((bl12 || bl13) && !bl5) {
                bl5 = true;
                this.addShapeProperty(jmolList, "bsSolvent", bl13 ? new BS() : this.eval.lookupIdentifierValue("solvent"));
                this.addShapeProperty(jmolList, "sasurface", Float.valueOf(0.0f));
            }
            if (bl6 && !bl5 && !bl7) {
                this.addShapeProperty(jmolList, "nomap", Float.valueOf(0.0f));
                bl5 = true;
            }
            if (n4 >= -1) {
                this.addShapeProperty(jmolList, "getSurfaceSets", n4 - 1);
            }
            if (sArray != null) {
                this.addShapeProperty(jmolList, "colorDiscrete", sArray);
            } else if ("sets".equals(string4)) {
                this.addShapeProperty(jmolList, "setColorScheme", null);
            } else if (string4 != null && (colorEncoder = this.viewer.getColorEncoder(string4)) != null) {
                colorEncoder.isTranslucent = bl21;
                colorEncoder.hi = Float.MAX_VALUE;
                this.addShapeProperty(jmolList, "remapColor", colorEncoder);
            }
            if (bl5 && !bl4 && sB.indexOf(";") != 0) {
                jmolList.add(0, new Object[]{"newObject", null});
                int n28 = n2 = bS2 == null ? 1 : 0;
                if (n2 != 0) {
                    bS2 = BSUtil.copy(this.viewer.getSelectionSet(false));
                }
                if (n8 < 0) {
                    n8 = this.viewer.getCurrentModelIndex();
                }
                bS2.and(this.viewer.getModelUndeletedAtomsBitSet(n8));
                if (object3 != null) {
                    object2 = this.viewer.getModelBitSet(bS2, false);
                    if (((BS)object2).cardinality() != 1) {
                        this.eval.errorStr(30, "ISOSURFACE " + object3);
                    }
                    if (n2 != 0) {
                        jmolList.add(0, new Object[]{"select", bS2});
                        if (sB.indexOf("; isosurface map") == 0) {
                            sB = new SB().append("; isosurface map select ").append(Escape.eBS(bS2)).append(sB.substring(16));
                        }
                    }
                }
            }
            if (bl17 && !bl16) {
                if (!bl5) {
                    this.addShapeProperty(jmolList, "sasurface", Float.valueOf(0.0f));
                }
                if (!bl7) {
                    this.addShapeProperty(jmolList, "map", Boolean.TRUE);
                    this.addShapeProperty(jmolList, "select", bS);
                    this.addShapeProperty(jmolList, "sasurface", Float.valueOf(0.0f));
                }
                this.addShapeProperty(jmolList, "slab", this.getCapSlabObject(-100, false));
            }
            int n29 = n2 = bl5 && this.viewer.getBoolean(603979934) ? 1 : 0;
            if (n2 != 0) {
                Logger.startTimer("isosurface");
            }
            this.setShapeProperty(n, "setProperties", jmolList);
            if (n2 != 0) {
                this.eval.showString(Logger.getTimerMsg("isosurface", 0L));
            }
            if (bl23) {
                this.setShapeProperty(n, "token", 1073742018);
                this.setShapeProperty(n, "token", 1073742046);
                this.setShapeProperty(n, "token", 0x40000088);
                sB.append(" mesh nofill frontOnly");
            }
        }
        if (p3 != null) {
            this.setShapeProperty(24, "lattice", p3);
        }
        if (n3 > 0 && !this.eval.setMeshDisplayProperty(n, n3, 0)) {
            this.invArg();
        }
        if (this.chk) {
            return false;
        }
        Object object5 = null;
        object2 = null;
        if (bl10) {
            object5 = this.getShapeProperty(n, "area");
            if (object5 instanceof Float) {
                this.viewer.setFloatProperty("isosurfaceArea", ((Float)object5).floatValue());
            } else {
                this.viewer.setUserVariable("isosurfaceArea", SV.getVariableAD((double[])object5));
            }
        }
        if (bl11) {
            Object object6 = object2 = bl11 ? this.getShapeProperty(n, "volume") : null;
            if (object2 instanceof Float) {
                this.viewer.setFloatProperty("isosurfaceVolume", ((Float)object2).floatValue());
            } else {
                this.viewer.setUserVariable("isosurfaceVolume", SV.getVariableAD((double[])object2));
            }
        }
        if (!bl4) {
            object = null;
            if (bl7 && !bl5) {
                this.setShapeProperty(n, "finalize", sB.toString());
            } else if (bl5) {
                string = sB.toString();
                this.setShapeProperty(n, "finalize", (string.indexOf("; isosurface map") == 0 ? "" : " select " + Escape.eBS(bS2) + " ") + string);
                object = (String)this.getShapeProperty(n, "ID");
                if (object != null && !this.eval.tQuiet) {
                    float[] fArray7;
                    f2 = ((Float)this.getShapeProperty(n, "cutoff")).floatValue();
                    if (Float.isNaN(f2) && !Float.isNaN(f)) {
                        Logger.error("sigma not supported");
                    }
                    object = (String)object + " created";
                    if (bl) {
                        object = (String)object + " with cutoff=" + f2;
                    }
                    if ((fArray7 = (float[])this.getShapeProperty(n, "minMaxInfo"))[0] != Float.MAX_VALUE) {
                        object = (String)object + " min=" + fArray7[0] + " max=" + fArray7[1];
                    }
                    object = (String)object + "; " + JC.shapeClassBases[n].toLowerCase() + " count: " + this.getShapeProperty(n, "count");
                    object = (String)object + this.eval.getIsosurfaceDataRange(n, "\n");
                }
            }
            if (bl10 || bl11) {
                String string14;
                String string15;
                String string16 = bl10 ? "isosurfaceArea = " + (object5 instanceof Float ? "" + object5 : Escape.eAD((double[])object5)) : (string15 = null);
                String string17 = bl11 ? "isosurfaceVolume = " + (object2 instanceof Float ? "" + object2 : Escape.eAD((double[])object2)) : (string14 = null);
                if (object == null) {
                    if (bl10) {
                        this.eval.showString(string15);
                    }
                    if (bl11) {
                        this.eval.showString(string14);
                    }
                } else {
                    if (bl10) {
                        object = object + "\n" + string15;
                    }
                    if (bl11) {
                        object = (String)object + "\n" + string14;
                    }
                }
            }
            if (object != null) {
                this.eval.showString((String)object);
            }
        }
        if (string3 != null) {
            this.setShapeProperty(n, "translucency", string3);
        }
        this.setShapeProperty(n, "clear", null);
        if (bl14) {
            this.setShapeProperty(n, "cache", null);
        }
        return true;
    }

    private boolean lcaoCartoon() throws ScriptException {
        this.sm.loadShape(26);
        if (this.tokAt(1) == 1073742001 && this.listIsosurface(26)) {
            return false;
        }
        this.setShapeProperty(26, "init", this.fullCommand);
        if (this.eval.slen == 1) {
            this.setShapeProperty(26, "lcaoID", null);
            return false;
        }
        boolean bl = false;
        String string = null;
        block24: for (int i = 1; i < this.eval.slen; ++i) {
            String string2 = null;
            Object object = null;
            switch (this.eval.getToken((int)i).tok) {
                case 554176565: 
                case 1074790451: {
                    string2 = (String)this.eval.theToken.value;
                    if (this.tokAt(i + 1) == 0x10000C) {
                        this.eval.iToken = i + 1;
                    }
                    object = this.getCapSlabObject(i, true);
                    i = this.eval.iToken;
                    break;
                }
                case 12289: {
                    this.isosurface(26);
                    return false;
                }
                case 528432: {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    switch (this.eval.getToken((int)(++i)).tok) {
                        case 1112541205: {
                            f = this.floatParameter(++i) * ((float)Math.PI / 180);
                            break;
                        }
                        case 1112541206: {
                            f2 = this.floatParameter(++i) * ((float)Math.PI / 180);
                            break;
                        }
                        case 1112541207: {
                            f3 = this.floatParameter(++i) * ((float)Math.PI / 180);
                            break;
                        }
                        default: {
                            this.invArg();
                        }
                    }
                    string2 = "rotationAxis";
                    object = V3.new3(f, f2, f3);
                    break;
                }
                case 0x10000D: 
                case 3145768: 
                case 1610625028: {
                    string2 = "on";
                    break;
                }
                case 12294: 
                case 0x10000C: 
                case 3145770: {
                    string2 = "off";
                    break;
                }
                case 12291: {
                    string2 = "delete";
                    break;
                }
                case 10: 
                case 0x100001: {
                    string2 = "select";
                    object = this.atomExpressionAt(i);
                    i = this.eval.iToken;
                    break;
                }
                case 1766856708: {
                    string = this.setColorOptions(null, i + 1, 26, -2);
                    if (string != null) {
                        this.setShapeProperty(26, "settranslucency", string);
                    }
                    i = this.eval.iToken;
                    bl = true;
                    continue block24;
                }
                case 603979967: 
                case 1073742074: {
                    this.eval.setMeshDisplayProperty(26, i, this.eval.theTok);
                    i = this.eval.iToken;
                    bl = true;
                    continue block24;
                }
                case 4: 
                case 1113200651: {
                    object = this.parameterAsString(i).toLowerCase();
                    if (object.equals("spacefill")) {
                        object = "cpk";
                    }
                    string2 = "create";
                    if (!this.eval.optParameterAsString(i + 1).equalsIgnoreCase("molecular")) break;
                    ++i;
                    string2 = "molecular";
                    break;
                }
                case 135280132: {
                    if (this.tokAt(i + 1) == 10 || this.tokAt(i + 1) == 0x100001) {
                        string2 = "select";
                        object = this.atomExpressionAt(i + 1);
                        i = this.eval.iToken;
                        break;
                    }
                    string2 = "selectType";
                    if (!(object = this.parameterAsString(++i)).equals("spacefill")) break;
                    object = "cpk";
                    break;
                }
                case 1073742138: {
                    string2 = "scale";
                    object = Float.valueOf(this.floatParameter(++i));
                    break;
                }
                case 0x400000B4: 
                case 1073742006: {
                    string2 = "lonePair";
                    break;
                }
                case 1073742111: 
                case 1073742112: {
                    string2 = "radical";
                    break;
                }
                case 1073742029: {
                    string2 = "molecular";
                    break;
                }
                case 0x40000050: {
                    object = this.parameterAsString(++i);
                    string2 = "create";
                    if (!this.eval.optParameterAsString(i + 1).equalsIgnoreCase("molecular")) break;
                    ++i;
                    string2 = "molecular";
                    break;
                }
                case 1074790550: {
                    object = this.eval.getShapeNameParameter(++i);
                    i = this.eval.iToken;
                    if (bl) {
                        this.invArg();
                    }
                    string2 = "lcaoID";
                    break;
                }
                default: {
                    if (this.eval.theTok != 0x101000B1 && !T.tokAttr(this.eval.theTok, 0x40000000)) break;
                    if (this.eval.theTok != 0x101000B1) {
                        object = this.parameterAsString(i);
                    }
                    if (bl) {
                        this.invArg();
                    }
                    string2 = "lcaoID";
                }
            }
            if (this.eval.theTok != 12291) {
                bl = true;
            }
            if (string2 == null) {
                this.invArg();
            }
            this.setShapeProperty(26, string2, object);
        }
        this.setShapeProperty(26, "clear", null);
        return true;
    }

    private Object getCapSlabObject(int n, boolean bl) throws ScriptException {
        Object[] objectArray;
        if (n < 0) {
            return MeshSurface.getSlabWithinRange(n, 0.0f);
        }
        Object object = null;
        int n2 = this.tokAt(n);
        boolean bl2 = n2 == 554176565;
        int n3 = this.tokAt(n + 1);
        P4 p4 = null;
        P3[] p3Array = null;
        BS bS = null;
        Short s = null;
        Integer n4 = null;
        if (n3 == 603979967) {
            float f;
            float f2 = f = this.isFloatParameter(++n + 1) ? this.floatParameter(++n) : 0.5f;
            if (this.eval.isColorParam(n + 1)) {
                s = C.getColixTranslucent3(C.getColix(this.eval.getArgbParam(n + 1)), f != 0.0f, f);
                n = this.eval.iToken;
            } else {
                s = C.getColixTranslucent3((short)1, f != 0.0f, f);
            }
            n3 = this.tokAt(n + 1);
            switch (n3) {
                case 1073741938: 
                case 1073742018: {
                    n4 = n3;
                    n3 = this.tokAt(++n + 1);
                    break;
                }
                default: {
                    n4 = 1073741938;
                }
            }
        }
        switch (n3) {
            case 10: 
            case 0x100001: {
                object = this.atomExpressionAt(n + 1);
                n3 = 3;
                ++this.eval.iToken;
                break;
            }
            case 0x10000C: {
                this.eval.iToken = n + 1;
                return Integer.MIN_VALUE;
            }
            case 0x10000B: {
                this.eval.iToken = n + 1;
                break;
            }
            case 0x100007: {
                ++n;
                object = new Object[]{Float.valueOf(1.0f), this.parameterAsString(++n)};
                n3 = 1073742018;
                break;
            }
            case 135266324: {
                ++n;
                if (this.tokAt(++n) == 1073742114) {
                    float f = this.floatParameter(++n);
                    float f3 = this.floatParameter(++n);
                    object = new Object[]{Float.valueOf(f), Float.valueOf(f3)};
                    n3 = 1073742114;
                    break;
                }
                if (this.isFloatParameter(n)) {
                    float f = this.floatParameter(n);
                    if (this.eval.isCenterParameter(++n)) {
                        P3 p3 = this.centerParameter(n);
                        if (this.chk || !(this.eval.expressionResult instanceof BS)) {
                            p3Array = new P3[]{p3};
                        } else {
                            Atom[] atomArray = this.viewer.modelSet.atoms;
                            bS = (BS)this.eval.expressionResult;
                            p3Array = new P3[bS.cardinality()];
                            int n5 = 0;
                            int n6 = bS.nextSetBit(0);
                            while (n6 >= 0) {
                                p3Array[n5] = atomArray[n6];
                                n6 = bS.nextSetBit(n6 + 1);
                                ++n5;
                            }
                        }
                    } else {
                        p3Array = this.eval.getPointArray(n, -1);
                    }
                    if (p3Array.length == 0) {
                        this.eval.iToken = n;
                        this.invArg();
                    }
                    object = new Object[]{Float.valueOf(f), p3Array, bS};
                    break;
                }
                object = this.eval.getPointArray(n, 4);
                n3 = 1679429641;
                break;
            }
            case 1679429641: {
                this.eval.iToken = n + 1;
                object = BoxInfo.getCriticalPoints(this.viewer.getBoundBoxVertices(), null);
                break;
            }
            case 0x40000030: 
            case 1614417948: {
                this.eval.iToken = n + 1;
                SymmetryInterface symmetryInterface = this.viewer.getCurrentUnitCell();
                if (symmetryInterface == null) {
                    if (n3 != 1614417948) break;
                    this.invArg();
                    break;
                }
                p3Array = BoxInfo.getCriticalPoints(symmetryInterface.getUnitCellVertices(), symmetryInterface.getCartesianOffset());
                int n7 = (int)symmetryInterface.getUnitCellInfoType(6);
                V3 v3 = null;
                V3 v32 = null;
                switch (n7) {
                    case 3: {
                        break;
                    }
                    case 1: {
                        v32 = V3.newVsub(p3Array[2], p3Array[0]);
                        v32.scale(1000.0f);
                    }
                    case 2: {
                        v3 = V3.newVsub(p3Array[1], p3Array[0]);
                        v3.scale(1000.0f);
                        p3Array[0].sub(v3);
                        p3Array[1].scale(2000.0f);
                        if (n7 != 1) break;
                        p3Array[0].sub(v32);
                        p3Array[2].scale(2000.0f);
                    }
                }
                object = p3Array;
                break;
            }
            default: {
                float f;
                if (!bl && bl2 && this.isFloatParameter(n + 1)) {
                    float f4 = this.floatParameter(++n);
                    if (!this.isFloatParameter(n + 1)) {
                        return (int)f4;
                    }
                    float f5 = this.floatParameter(++n);
                    object = new Object[]{Float.valueOf(f4), Float.valueOf(f5)};
                    n3 = 1073742114;
                    break;
                }
                p4 = this.eval.planeParameter(++n);
                float f6 = f = this.isFloatParameter(this.eval.iToken + 1) ? this.floatParameter(++this.eval.iToken) : Float.NaN;
                if (!Float.isNaN(f)) {
                    p4.w -= f;
                }
                object = p4;
                n3 = 135266319;
            }
        }
        if (n4 == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = n4;
            objectArray = objectArray2;
            objectArray2[1] = s;
        }
        Object[] objectArray3 = objectArray;
        return MeshSurface.getSlabObject(n3, object, !bl2, objectArray3);
    }

    private boolean mo(boolean bl) throws ScriptException {
        int n = Integer.MAX_VALUE;
        boolean bl2 = false;
        BS bS = this.viewer.getVisibleFramesBitSet();
        JmolList<Object[]> jmolList = new JmolList<Object[]>();
        int n2 = 1;
        if (this.tokAt(1) == 1095766028 || this.tokAt(1) == 4115) {
            n2 = this.eval.modelNumberParameter(2);
            if (n2 < 0) {
                this.invArg();
            }
            bS.clearAll();
            bS.set(n2);
            n2 = 3;
        }
        int n3 = bS.nextSetBit(0);
        while (n3 >= 0) {
            this.sm.loadShape(27);
            int n4 = n2;
            if (this.tokAt(n4) == 1073742001 && this.listIsosurface(27)) {
                return true;
            }
            this.setShapeProperty(27, "init", n3);
            String string = null;
            int n5 = (Integer)this.getShapeProperty(27, "moNumber");
            float[] fArray = (float[])this.getShapeProperty(27, "moLinearCombination");
            if (bl) {
                return true;
            }
            if (n5 == 0) {
                n5 = Integer.MAX_VALUE;
            }
            String string2 = null;
            Object object = null;
            switch (this.eval.getToken((int)n4).tok) {
                case 554176565: 
                case 1074790451: {
                    string2 = (String)this.eval.theToken.value;
                    object = this.getCapSlabObject(n4, false);
                    n4 = this.eval.iToken;
                    break;
                }
                case 1073741914: {
                    string2 = "squareLinear";
                    object = Boolean.TRUE;
                    fArray = new float[]{1.0f};
                    n5 = 0;
                    n = 0;
                    break;
                }
                case 2: {
                    n5 = this.intParameter(n4);
                    fArray = this.moCombo(jmolList);
                    if (fArray != null || n5 >= 0) break;
                    fArray = new float[]{-100.0f, -n5};
                    break;
                }
                case 0x101000A0: {
                    switch (this.tokAt(++n4)) {
                        case 1073741973: 
                        case 1073742008: {
                            break;
                        }
                        default: {
                            this.invArg();
                        }
                    }
                    bl2 = true;
                }
                case 1073741973: 
                case 1073742008: {
                    n = this.moOffset(n4);
                    if (n == Integer.MAX_VALUE) {
                        this.invArg();
                    }
                    n5 = 0;
                    fArray = this.moCombo(jmolList);
                    break;
                }
                case 1073742037: {
                    n5 = 1073742037;
                    fArray = this.moCombo(jmolList);
                    break;
                }
                case 1073742108: {
                    n5 = 1073742108;
                    fArray = this.moCombo(jmolList);
                    break;
                }
                case 1766856708: {
                    this.setColorOptions(null, n4 + 1, 27, 2);
                    break;
                }
                case 135266319: {
                    string2 = "plane";
                    object = this.eval.planeParameter(n4 + 1);
                    break;
                }
                case 0x8100010: {
                    this.addShapeProperty(jmolList, "randomSeed", this.tokAt(n4 + 2) == 2 ? Integer.valueOf(this.intParameter(n4 + 2)) : null);
                    string2 = "monteCarloCount";
                    object = this.intParameter(n4 + 1);
                    break;
                }
                case 1073742138: {
                    string2 = "scale";
                    object = Float.valueOf(this.floatParameter(n4 + 1));
                    break;
                }
                case 1073741910: {
                    if (this.tokAt(n4 + 1) == 0x101000A1) {
                        string2 = "cutoffPositive";
                        object = Float.valueOf(this.floatParameter(n4 + 2));
                        break;
                    }
                    string2 = "cutoff";
                    object = Float.valueOf(this.floatParameter(n4 + 1));
                    break;
                }
                case 0x20000004: {
                    string2 = "debug";
                    break;
                }
                case 1073742054: {
                    string2 = "plane";
                    break;
                }
                case 1073742104: 
                case 1073742122: {
                    string2 = "resolution";
                    object = Float.valueOf(this.floatParameter(n4 + 1));
                    break;
                }
                case 1073742156: {
                    string2 = "squareData";
                    object = Boolean.TRUE;
                    break;
                }
                case 1073742168: {
                    if (n4 + 1 >= this.eval.slen || this.tokAt(n4 + 1) != 4) break;
                    string2 = "titleFormat";
                    object = this.parameterAsString(n4 + 1);
                    break;
                }
                case 0x40000000: {
                    this.invArg();
                    break;
                }
                default: {
                    if (this.eval.isArrayParameter(n4)) {
                        fArray = this.eval.floatParameterSet(n4, 1, Integer.MAX_VALUE);
                        if (this.tokAt(this.eval.iToken + 1) != 1073742156) break;
                        this.addShapeProperty(jmolList, "squareLinear", Boolean.TRUE);
                        ++this.eval.iToken;
                        break;
                    }
                    int n6 = this.eval.iToken;
                    if (!this.eval.setMeshDisplayProperty(27, 0, this.eval.theTok)) {
                        this.invArg();
                    }
                    this.setShapeProperty(27, "setProperties", jmolList);
                    this.eval.setMeshDisplayProperty(27, n6, this.tokAt(n6));
                    return true;
                }
            }
            if (string2 != null) {
                this.addShapeProperty(jmolList, string2, object);
            }
            if (n5 != Integer.MAX_VALUE || fArray != null) {
                if (this.tokAt(this.eval.iToken + 1) == 4) {
                    string = this.parameterAsString(++this.eval.iToken);
                }
                this.eval.setCursorWait(true);
                this.setMoData(jmolList, n5, fArray, n, bl2, n3, string);
                this.addShapeProperty(jmolList, "finalize", null);
            }
            if (jmolList.size() > 0) {
                this.setShapeProperty(27, "setProperties", jmolList);
            }
            jmolList.clear();
            n3 = bS.nextSetBit(n3 + 1);
        }
        return true;
    }

    private float[] moCombo(JmolList<Object[]> jmolList) {
        if (this.tokAt(this.eval.iToken + 1) != 1073742156) {
            return null;
        }
        this.addShapeProperty(jmolList, "squareLinear", Boolean.TRUE);
        ++this.eval.iToken;
        return new float[0];
    }

    private int moOffset(int n) throws ScriptException {
        int n2;
        boolean bl = this.eval.getToken((int)n).tok == 1073741973;
        int n3 = bl ? 0 : 1;
        if ((n2 = this.tokAt(++n)) == 2 && this.intParameter(n) < 0) {
            n3 += this.intParameter(n);
        } else if (n2 == 0x101000A1) {
            n3 += this.intParameter(++n);
        } else if (n2 == 0x101000A0) {
            n3 -= this.intParameter(++n);
        }
        return n3;
    }

    private void setMoData(JmolList<Object[]> jmolList, int n, float[] fArray, int n2, boolean bl, int n3, String string) throws ScriptException {
        Float f;
        Map map;
        int n4;
        if (this.chk) {
            return;
        }
        if (n3 < 0 && (n3 = this.viewer.getCurrentModelIndex()) < 0) {
            this.eval.errorStr(30, "MO isosurfaces");
        }
        Map map2 = (Map)this.viewer.getModelAuxiliaryInfoValue(n3, "moData");
        JmolList jmolList2 = null;
        int n5 = 0;
        if (fArray == null || fArray.length < 2) {
            int n6;
            if (fArray != null && fArray.length == 1) {
                n2 = 0;
            }
            if (map2 == null) {
                this.error(27);
            }
            int n7 = map2.containsKey("lastMoNumber") ? (Integer)map2.get("lastMoNumber") : 0;
            int n8 = n6 = map2.containsKey("lastMoCount") ? (Integer)map2.get("lastMoCount") : 1;
            if (n == 1073742108) {
                n = n7 - 1;
            } else if (n == 1073742037) {
                n = n7 + n6;
            }
            jmolList2 = (JmolList)map2.get("mos");
            int n9 = n5 = jmolList2 == null ? 0 : jmolList2.size();
            if (n5 == 0) {
                this.error(25);
            }
            if (n5 == 1 && n > 1) {
                this.error(29);
            }
            if (n2 != Integer.MAX_VALUE) {
                if (map2.containsKey("HOMO")) {
                    n = (Integer)map2.get("HOMO") + n2;
                } else {
                    n = -1;
                    for (n4 = 0; n4 < n5; ++n4) {
                        map = (Map)jmolList2.get(n4);
                        f = (Float)map.get("occupancy");
                        if (f != null) {
                            if (!(f.floatValue() < 0.5f)) continue;
                            n = n4;
                            break;
                        }
                        f = (Float)map.get("energy");
                        if (f == null) break;
                        if (!(f.floatValue() > 0.0f)) continue;
                        n = n4;
                        break;
                    }
                    if (n < 0) {
                        this.error(28);
                    }
                    n += n2;
                }
                Logger.info("MO " + n);
            }
            if (n < 1 || n > n5) {
                this.eval.errorStr(26, "" + n5);
            }
        }
        n = Math.abs(n);
        map2.put("lastMoNumber", n);
        map2.put("lastMoCount", 1);
        if (bl && fArray == null) {
            fArray = new float[]{-100.0f, n};
        }
        if (fArray != null && fArray.length < 2) {
            map = (Map)jmolList2.get(n - 1);
            f = (Float)map.get("energy");
            if (f == null) {
                fArray = new float[]{100.0f, n};
            } else {
                int n10;
                float f2 = f.floatValue();
                BS bS = BS.newN(n5);
                n4 = 0;
                boolean bl2 = fArray.length == 1 && fArray[0] == 1.0f;
                for (n10 = 0; n10 < n5; ++n10) {
                    f = (Float)((Map)jmolList2.get(n10)).get("energy");
                    if (f == null) continue;
                    float f3 = f.floatValue();
                    if (!(bl2 ? f3 <= f2 : f3 == f2)) continue;
                    bS.set(n10 + 1);
                    n4 += 2;
                }
                fArray = new float[n4];
                int n11 = 0;
                for (n10 = 0; n10 < n4; n10 += 2) {
                    fArray[n10] = 1.0f;
                    n11 = bS.nextSetBit(n11 + 1);
                    fArray[n10 + 1] = n11;
                }
                map2.put("lastMoNumber", bS.nextSetBit(0));
                map2.put("lastMoCount", n4 / 2);
            }
            this.addShapeProperty(jmolList, "squareLinear", Boolean.TRUE);
        }
        this.addShapeProperty(jmolList, "moData", map2);
        if (string != null) {
            this.addShapeProperty(jmolList, "title", string);
        }
        this.addShapeProperty(jmolList, "molecularOrbital", fArray != null ? fArray : (float[])Math.abs(n));
        this.addShapeProperty(jmolList, "clear", null);
    }

    @Override
    public String plot(T[] tArray) throws ScriptException {
        String string;
        Object object;
        int n;
        int n2 = this.viewer.getCurrentModelIndex();
        if (n2 < 0) {
            this.eval.errorStr(30, "plot");
        }
        n2 = this.viewer.getJmolDataSourceFrame(n2);
        int n3 = tArray.length - 1;
        boolean bl = tArray != this.st;
        T[] tArray2 = this.st;
        if (bl) {
            this.st = tArray;
        }
        int n4 = bl ? 4148 : tArray[0].tok;
        int n5 = bl || n4 == 0x8101011 || n4 == 1052714 ? 0 : 1;
        String string2 = null;
        boolean bl2 = true;
        boolean bl3 = false;
        switch (n4) {
            case 4133: 
            case 1052714: 
            case 0x8101011: {
                break;
            }
            case 135176: {
                bl2 = false;
                bl3 = true;
                break;
            }
            case 4148: {
                bl2 = false;
                break;
            }
            case 135270421: {
                bl2 = false;
                if (ScriptEvaluator.tokAtArray(n3, tArray) == 4) {
                    string2 = this.stringParameter(n3--);
                    break;
                }
                if (ScriptEvaluator.tokAtArray(n3 - 1, tArray) == 0x100008) {
                    string2 = this.parameterAsString(n3 - 2) + "." + this.parameterAsString(n3);
                    n3 -= 3;
                    break;
                }
                this.st = tArray2;
                this.eval.iToken = this.st.length;
                this.error(13);
            }
        }
        String string3 = "";
        Object[] objectArray = null;
        String string4 = "";
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        BS bS = BSUtil.copy(this.viewer.getSelectionSet(false));
        String string5 = "; select " + Escape.eBS(bS) + ";\n ";
        String string6 = this.eval.optParameterAsString(n3).toLowerCase();
        P3 p3 = null;
        P3 p32 = null;
        int n9 = ScriptEvaluator.tokAtArray(n5, tArray);
        if (n9 == 4) {
            n9 = T.getTokFromName((String)tArray[n5].value);
        }
        switch (n9) {
            default: {
                this.eval.iToken = 1;
                this.invArg();
                break;
            }
            case 135270407: {
                this.eval.iToken = 1;
                string6 = "data";
                string5 = "";
                break;
            }
            case 1716520985: {
                this.eval.iToken = n5 + 1;
                n6 = this.tokAt(this.eval.iToken++);
                if (!T.tokAttr(n6, 0x40500000) || !T.tokAttr(n7 = this.tokAt(this.eval.iToken++), 0x40500000)) {
                    this.invArg();
                }
                if (T.tokAttr(n8 = this.tokAt(this.eval.iToken), 0x40500000)) {
                    ++this.eval.iToken;
                } else {
                    n8 = 0;
                }
                if (this.tokAt(this.eval.iToken) == 32) {
                    p3 = this.getPoint3f(++this.eval.iToken, false);
                    ++this.eval.iToken;
                }
                if (this.tokAt(this.eval.iToken) == 64) {
                    p32 = this.getPoint3f(++this.eval.iToken, false);
                    ++this.eval.iToken;
                }
                string6 = "property " + T.nameOf(n6) + " " + T.nameOf(n7) + (n8 == 0 ? "" : " " + T.nameOf(n8));
                if (bS.nextSetBit(0) < 0) {
                    bS = this.viewer.getModelUndeletedAtomsBitSet(n2);
                }
                string4 = "select " + Escape.eBS(bS) + ";\n ";
                break;
            }
            case 1052714: {
                if (string6.equalsIgnoreCase("draw")) {
                    bl3 = true;
                    string6 = this.eval.optParameterAsString(--n3).toLowerCase();
                }
                bl7 = n3 > n5 && string6.startsWith("r");
                string6 = "ramachandran" + (bl7 ? " r" : "") + (n4 == 135176 ? " draw" : "");
                break;
            }
            case 0x8101011: 
            case 137363468: {
                string3 = " \"" + this.viewer.getQuaternionFrame() + "\"";
                string4 = "set quaternionFrame" + string3 + ";\n  ";
                bl4 = true;
                if (string6.equalsIgnoreCase("draw")) {
                    bl3 = true;
                    string6 = this.eval.optParameterAsString(--n3).toLowerCase();
                }
                bl5 = string6.startsWith("deriv") || string6.startsWith("diff");
                boolean bl8 = bl6 = bl5 && string6.indexOf("2") > 0;
                if (bl5) {
                    --n3;
                }
                if (string6.equalsIgnoreCase("helix") || string6.equalsIgnoreCase("axis")) {
                    bl3 = true;
                    bl5 = true;
                    n3 = -1;
                }
                if ((string6 = ((n3 <= n5 ? "" : this.eval.optParameterAsString(n3)) + "w").substring(0, 1)).equals("a") || string6.equals("r")) {
                    bl5 = true;
                }
                if (!Parser.isOneOf(string6, ";w;x;y;z;r;a;")) {
                    this.eval.evalError("QUATERNION [w,x,y,z,a,r] [difference][2]", null);
                }
                string6 = "quaternion " + string6 + (bl5 ? " difference" : "") + (bl6 ? "2" : "") + (bl3 ? " draw" : "");
            }
        }
        this.st = tArray2;
        if (this.chk) {
            return "";
        }
        if (bl2 && (n = this.viewer.getJmolDataFrameIndex(n2, string4 = string4 + "plot " + string6)) > 0 && n4 != 135270421 && n4 != 4148) {
            this.viewer.setCurrentModelIndexClear(n, true);
            return "";
        }
        float[] fArray = null;
        float[] fArray2 = null;
        float[] fArray3 = null;
        P3 p33 = P3.new3(1.0f, 1.0f, 1.0f);
        if (n9 == 1716520985) {
            int n10;
            fArray = this.eval.getBitsetPropertyFloat(bS, n6 | 0xE0, p3 == null ? Float.NaN : p3.x, p32 == null ? Float.NaN : p32.x);
            fArray2 = this.eval.getBitsetPropertyFloat(bS, n7 | 0xE0, p3 == null ? Float.NaN : p3.y, p32 == null ? Float.NaN : p32.y);
            if (n8 != 0) {
                fArray3 = this.eval.getBitsetPropertyFloat(bS, n8 | 0xE0, p3 == null ? Float.NaN : p3.z, p32 == null ? Float.NaN : p32.z);
            }
            if (p3 == null) {
                p3 = P3.new3(ScriptExt.getMinMax(fArray, false, n6), ScriptExt.getMinMax(fArray2, false, n7), ScriptExt.getMinMax(fArray3, false, n8));
            }
            if (p32 == null) {
                p32 = P3.new3(ScriptExt.getMinMax(fArray, true, n6), ScriptExt.getMinMax(fArray2, true, n7), ScriptExt.getMinMax(fArray3, true, n8));
            }
            Logger.info("plot min/max: " + p3 + " " + p32);
            object = P3.newP(p32);
            ((Tuple3f)object).add(p3);
            ((Tuple3f)object).scale(0.5f);
            p33.setT(p32);
            p33.sub(p3);
            p33.set(p33.x / 200.0f, p33.y / 200.0f, p33.z / 200.0f);
            if (T.tokAttr(n6, 1095761920)) {
                p33.x = 1.0f;
                ((P3)object).x = 0.0f;
            } else if ((double)p33.x > 0.1 && p33.x <= 10.0f) {
                p33.x = 1.0f;
            }
            if (T.tokAttr(n7, 1095761920)) {
                p33.y = 1.0f;
                ((P3)object).y = 0.0f;
            } else if ((double)p33.y > 0.1 && p33.y <= 10.0f) {
                p33.y = 1.0f;
            }
            if (T.tokAttr(n8, 1095761920)) {
                p33.z = 1.0f;
                ((P3)object).z = 0.0f;
            } else if ((double)p33.z > 0.1 && p33.z <= 10.0f) {
                p33.z = 1.0f;
            }
            if (n8 == 0) {
                p33.z = 0.0f;
                p32.z = 0.0f;
                p3.z = 0.0f;
                ((P3)object).z = 0.0f;
            }
            for (n10 = 0; n10 < fArray.length; ++n10) {
                fArray[n10] = (fArray[n10] - ((P3)object).x) / p33.x;
            }
            for (n10 = 0; n10 < fArray2.length; ++n10) {
                fArray2[n10] = (fArray2[n10] - ((P3)object).y) / p33.y;
            }
            if (n8 != 0) {
                for (n10 = 0; n10 < fArray3.length; ++n10) {
                    fArray3[n10] = (fArray3[n10] - ((P3)object).z) / p33.z;
                }
            }
            objectArray = new Object[]{bS, fArray, fArray2, fArray3, p3, p32, p33, object};
        }
        if (n4 == 135270421) {
            return this.viewer.writeFileData(string2, "PLOT_" + string6, n2, objectArray);
        }
        Object object2 = object = string6.equals("data") ? "1 0 H 0 0 0 # Jmol PDB-encoded data" : this.viewer.getPdbData(n2, string6, objectArray);
        if (n4 == 4148) {
            return object;
        }
        if (Logger.debugging) {
            Logger.debug((String)object);
        }
        if (n4 == 135176) {
            this.eval.runScript((String)object);
            return "";
        }
        String[] stringArray = this.viewer.getFileInfo();
        boolean bl9 = this.viewer.getBoolean(603979792);
        this.viewer.setAppendNew(true);
        boolean bl10 = object != null && this.viewer.openStringInlineParamsAppend((String)object, null, true) == null;
        this.viewer.setAppendNew(bl9);
        this.viewer.setFileInfo(stringArray);
        if (!bl10) {
            return "";
        }
        int n11 = this.viewer.getModelCount();
        this.viewer.setJmolDataFrame(string4, n2, n11 - 1);
        if (n9 != 1716520985) {
            string4 = string4 + ";\n" + string5;
        }
        ModelCollection.StateScript stateScript = this.viewer.addStateScript(string4, true, false);
        float f = 150.0f;
        switch (n9) {
            default: {
                string = "frame 0.0; frame last; reset;select visible;wireframe only;";
                f = 10.0f;
                break;
            }
            case 1716520985: {
                this.viewer.setFrameTitle(n11 - 1, string6 + " plot for model " + this.viewer.getModelNumberDotted(n2));
                float f2 = 3.0f;
                string = "frame 0.0; frame last; reset;select visible; spacefill " + f2 + "; wireframe 0;" + "draw plotAxisX" + n11 + " {100 -100 -100} {-100 -100 -100} \"" + T.nameOf(n6) + "\";" + "draw plotAxisY" + n11 + " {-100 100 -100} {-100 -100 -100} \"" + T.nameOf(n7) + "\";";
                if (n8 == 0) break;
                string = string + "draw plotAxisZ" + n11 + " {-100 -100 100} {-100 -100 -100} \"" + T.nameOf(n8) + "\";";
                break;
            }
            case 1052714: {
                this.viewer.setFrameTitle(n11 - 1, "ramachandran plot for model " + this.viewer.getModelNumberDotted(n2));
                string = "frame 0.0; frame last; reset;select visible; color structure; spacefill 3.0; wireframe 0;draw ramaAxisX" + n11 + " {100 0 0} {-100 0 0} \"phi\";" + "draw ramaAxisY" + n11 + " {0 100 0} {0 -100 0} \"psi\";";
                break;
            }
            case 0x8101011: 
            case 137363468: {
                this.viewer.setFrameTitle(n11 - 1, string6.replace('w', ' ') + string3 + " for model " + this.viewer.getModelNumberDotted(n2));
                String string7 = C.getHexCode(this.viewer.getColixBackgroundContrast());
                string = "frame 0.0; frame last; reset;select visible; wireframe 0; spacefill 3.0; isosurface quatSphere" + n11 + " color " + string7 + " sphere 100.0 mesh nofill frontonly translucent 0.8;" + "draw quatAxis" + n11 + "X {100 0 0} {-100 0 0} color red \"x\";" + "draw quatAxis" + n11 + "Y {0 100 0} {0 -100 0} color green \"y\";" + "draw quatAxis" + n11 + "Z {0 0 100} {0 0 -100} color blue \"z\";" + "color structure;" + "draw quatCenter" + n11 + "{0 0 0} scale 0.02;";
            }
        }
        this.eval.runScript(string + string5);
        stateScript.setModelIndex(this.viewer.getCurrentModelIndex());
        this.viewer.setRotationRadius(f, true);
        this.sm.loadShape(30);
        this.eval.showString("frame " + this.viewer.getModelNumberDotted(n11 - 1) + (string6.length() > 0 ? " created: " + string6 + (bl4 ? string3 : "") : ""));
        return "";
    }

    private static float getMinMax(float[] fArray, boolean bl, int n) {
        if (fArray == null) {
            return 0.0f;
        }
        switch (n) {
            case 1112539144: 
            case 1112539145: 
            case 1112539146: {
                return bl ? 180 : -180;
            }
            case 1112539141: 
            case 1112539152: {
                return bl ? 360 : 0;
            }
            case 1112539150: {
                return bl ? 1 : -1;
            }
        }
        float f = bl ? -1.0E10f : 1.0E10f;
        int n2 = fArray.length;
        while (--n2 >= 0) {
            float f2 = fArray[n2];
            if (Float.isNaN(f2) || bl != f2 > f) continue;
            f = f2;
        }
        return f;
    }

    private boolean polyhedra() throws ScriptException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        int n2 = 0;
        this.sm.loadShape(21);
        this.setShapeProperty(21, "init", Boolean.TRUE);
        String string = "centers";
        String string2 = "radius_";
        float f = Float.MAX_VALUE;
        this.eval.colorArgb[0] = Integer.MIN_VALUE;
        block15: for (int i = 1; i < this.eval.slen; ++i) {
            String string3 = null;
            Object object = null;
            switch (this.eval.getToken((int)i).tok) {
                case 12291: 
                case 0x10000C: 
                case 0x10000D: {
                    if (i + 1 != this.eval.slen || bl || n2 > 1 || n2 == 0 && "to".equals(string)) {
                        this.error(18);
                    }
                    string3 = this.eval.theTok == 0x10000C ? "off" : (this.eval.theTok == 0x10000D ? "on" : "delete");
                    bl2 = true;
                    break;
                }
                case 0x10100030: 
                case 269484436: {
                    continue block15;
                }
                case 1678770178: {
                    if (n2 > 0) {
                        this.invPO();
                    }
                    bl = true;
                    string3 = "bonds";
                    break;
                }
                case 1666189314: {
                    string2 = "radius";
                    continue block15;
                }
                case 2: 
                case 3: {
                    if (n2 > 0 && !bl5) {
                        this.invPO();
                    }
                    if (this.eval.theTok == 2 && string2 == "radius_") {
                        string3 = "nVertices";
                        object = this.intParameter(i);
                        bl = true;
                        break;
                    }
                    string3 = string2 == "radius_" ? "radius" : string2;
                    object = Float.valueOf(this.floatParameter(i));
                    string2 = "radius_";
                    bl5 = false;
                    bl = true;
                    break;
                }
                case 10: 
                case 0x100001: {
                    if (bl3) {
                        this.invPO();
                    }
                    if (++n2 > 2) {
                        this.error(2);
                    }
                    if ("to".equals(string)) {
                        bl = true;
                    }
                    string3 = string;
                    string = "to";
                    object = this.atomExpressionAt(i);
                    i = this.eval.iToken;
                    break;
                }
                case 1074790746: {
                    if (n2 > 1) {
                        this.invPO();
                    }
                    if (this.tokAt(i + 1) == 10 || this.tokAt(i + 1) == 0x100001 && !bl) {
                        string3 = "toBitSet";
                        object = this.atomExpressionAt(++i);
                        i = this.eval.iToken;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.error(19);
                    }
                    string = "to";
                    continue block15;
                }
                case 1073741937: {
                    if (!bl) {
                        this.error(19);
                    }
                    string2 = "faceCenterOffset";
                    bl5 = true;
                    continue block15;
                }
                case 0x40000064: {
                    if (n2 == 0) {
                        this.error(19);
                    }
                    string2 = "distanceFactor";
                    bl5 = true;
                    continue block15;
                }
                case 603979967: 
                case 1073742074: 
                case 1766856708: {
                    f = this.eval.getColorTrans(i, true);
                    i = this.eval.iToken;
                    continue block15;
                }
                case 1073741886: 
                case 1073741948: {
                    string3 = "collapsed";
                    Object object2 = object = this.eval.theTok == 1073741886 ? Boolean.TRUE : Boolean.FALSE;
                    if (bl3) {
                        this.error(18);
                    }
                    bl3 = true;
                    break;
                }
                case 1073741933: 
                case 0x40000084: 
                case 1073742044: {
                    if (bl4) {
                        this.error(18);
                    }
                    string3 = this.parameterAsString(i);
                    bl4 = true;
                    break;
                }
                case 1073741964: {
                    n = this.eval.theTok;
                    continue block15;
                }
                default: {
                    if (this.eval.isColorParam(i)) {
                        this.eval.colorArgb[0] = this.eval.getArgbParam(i);
                        i = this.eval.iToken;
                        continue block15;
                    }
                    this.invArg();
                }
            }
            this.setShapeProperty(21, string3, object);
            if (!bl2) continue;
            return false;
        }
        if (!(bl || bl3 || bl4 || n != 0)) {
            this.error(19);
        }
        if (bl) {
            this.setShapeProperty(21, "generate", null);
        }
        if (this.eval.colorArgb[0] != Integer.MIN_VALUE) {
            this.setShapeProperty(21, "colorThis", this.eval.colorArgb[0]);
        }
        if (f != Float.MAX_VALUE) {
            this.eval.setShapeTranslucency(21, "", "translucentThis", f, null);
        }
        if (n != 0) {
            this.setShapeProperty(21, "token", n);
        }
        this.setShapeProperty(21, "init", Boolean.FALSE);
        return true;
    }

    private boolean struts() throws ScriptException {
        boolean bl = this.tokAt(1) == 1073742072 || this.tokAt(1) == 0x10000D || this.eval.slen == 1;
        int n = this.eval.getMadParameter();
        if (bl) {
            n = Math.round(this.viewer.getFloat(570425406) * 2000.0f);
        }
        this.setShapeProperty(1, "type", 32768);
        this.eval.setShapeSizeBs(1, n, null);
        this.setShapeProperty(1, "type", 1023);
        return true;
    }

    private String initIsosurface(int n) throws ScriptException {
        this.setShapeProperty(n, "init", this.fullCommand);
        this.eval.iToken = 0;
        int n2 = this.tokAt(1);
        int n3 = this.tokAt(2);
        if (n2 == 12291 || n3 == 12291 && this.tokAt(++this.eval.iToken) == 0x100003) {
            this.setShapeProperty(n, "delete", null);
            this.eval.iToken += 2;
            if (this.eval.slen > this.eval.iToken) {
                this.setShapeProperty(n, "init", this.fullCommand);
                this.setShapeProperty(n, "thisID", "+PREVIOUS_MESH+");
            }
            return null;
        }
        this.eval.iToken = 1;
        if (!this.eval.setMeshDisplayProperty(n, 0, n2)) {
            this.setShapeProperty(n, "thisID", "+PREVIOUS_MESH+");
            if (n != 22) {
                this.setShapeProperty(n, "title", new String[]{this.thisCommand});
            }
            if (n2 != 1074790550 && (n3 == 0x101000B1 || n2 == 0x101000B1 && this.eval.setMeshDisplayProperty(n, 0, n3))) {
                String string = this.setShapeId(n, 1, false);
                ++this.eval.iToken;
                return string;
            }
        }
        return null;
    }

    private void getWithinDistanceVector(JmolList<Object[]> jmolList, float f, P3 p3, BS bS, boolean bl) {
        JmolList<P3> jmolList2 = new JmolList<P3>();
        P3[] p3Array = new P3[2];
        if (bS == null) {
            P3 p32 = P3.new3(f, f, f);
            P3 p33 = P3.newP(p3);
            p33.sub(p32);
            p32.add(p3);
            p3Array[0] = p33;
            p3Array[1] = p32;
            jmolList2.addLast(p3);
        } else {
            BoxInfo boxInfo = this.viewer.getBoxInfo(bS, -Math.abs(f));
            p3Array[0] = boxInfo.getBoundBoxVertices()[0];
            p3Array[1] = boxInfo.getBoundBoxVertices()[7];
            if (bS.cardinality() == 1) {
                jmolList2.addLast(this.viewer.getAtomPoint3f(bS.nextSetBit(0)));
            }
        }
        if (jmolList2.size() == 1 && !bl) {
            this.addShapeProperty(jmolList, "withinDistance", Float.valueOf(f));
            this.addShapeProperty(jmolList, "withinPoint", jmolList2.get(0));
        }
        this.addShapeProperty(jmolList, bl ? "displayWithin" : "withinPoints", new Object[]{Float.valueOf(f), p3Array, bS, jmolList2});
    }

    private String setColorOptions(SB sB, int n, int n2, int n3) throws ScriptException {
        this.eval.getToken(n);
        String string = "opaque";
        if (this.eval.theTok == 603979967) {
            string = "translucent";
            if (n3 < 0) {
                float f = this.isFloatParameter(n + 1) ? this.floatParameter(++n) : Float.MAX_VALUE;
                this.eval.setShapeTranslucency(n2, null, "translucent", f, null);
                if (sB != null) {
                    sB.append(" translucent");
                    if (f != Float.MAX_VALUE) {
                        sB.append(" ").appendF(f);
                    }
                }
            } else {
                this.eval.setMeshDisplayProperty(n2, n, this.eval.theTok);
            }
        } else if (this.eval.theTok == 1073742074) {
            if (n3 >= 0) {
                this.eval.setMeshDisplayProperty(n2, n, this.eval.theTok);
            }
        } else {
            --this.eval.iToken;
        }
        n3 = Math.abs(n3);
        for (int i = 0; i < n3; ++i) {
            if (this.eval.isColorParam(this.eval.iToken + 1)) {
                int n4 = this.eval.getArgbParam(++this.eval.iToken);
                this.setShapeProperty(n2, "colorRGB", n4);
                if (sB == null) continue;
                sB.append(" ").append(Escape.escapeColor(n4));
                continue;
            }
            if (this.eval.iToken >= n) break;
            this.invArg();
        }
        return string;
    }

    private void addShapeProperty(JmolList<Object[]> jmolList, String string, Object object) {
        if (this.chk) {
            return;
        }
        jmolList.addLast(new Object[]{string, object});
    }

    private Object[] createFunction(String string, String string2, String string3) {
        ScriptEvaluator scriptEvaluator = new ScriptEvaluator();
        scriptEvaluator.setViewer(this.viewer);
        try {
            scriptEvaluator.compileScript(null, "function " + string + "(" + string2 + ") { return " + string3 + "}", false);
            JmolList<SV> jmolList = new JmolList<SV>();
            for (int i = 0; i < string2.length(); i += 2) {
                jmolList.addLast(SV.newVariable(3, Float.valueOf(0.0f)).setName(string2.substring(i, i + 1)));
            }
            return new Object[]{scriptEvaluator.aatoken[0][1].value, jmolList};
        }
        catch (Exception exception) {
            return null;
        }
    }

    private float[][] floatArraySet(int n, int n2, int n3) throws ScriptException {
        int n4;
        if ((n4 = this.tokAt(n++)) == 1073742195) {
            n4 = this.tokAt(n++);
        }
        if (n4 != 0x10100040) {
            this.invArg();
        }
        float[][] fArray = ArrayUtil.newFloat2(n2);
        int n5 = 0;
        block5: while (n4 != 0x10100041) {
            n4 = this.eval.getToken((int)n).tok;
            switch (n4) {
                case 0x10100041: 
                case 1073742195: {
                    continue block5;
                }
                case 0x10100030: {
                    ++n;
                    continue block5;
                }
                case 0x10100040: {
                    ++n;
                    float[] fArray2 = new float[n3];
                    fArray[n5++] = fArray2;
                    for (int i = 0; i < n3; ++i) {
                        fArray2[i] = this.floatParameter(n++);
                        if (this.tokAt(n) != 0x10100030) continue;
                        ++n;
                    }
                    if (this.tokAt(n++) != 0x10100041) {
                        this.invArg();
                    }
                    n4 = 0;
                    if (n5 != n2 || this.tokAt(n) == 0x10100041) continue block5;
                    this.invArg();
                    continue block5;
                }
            }
            this.invArg();
        }
        return fArray;
    }

    private float[][][] floatArraySetXYZ(int n, int n2, int n3, int n4) throws ScriptException {
        int n5;
        if ((n5 = this.tokAt(n++)) == 1073742195) {
            n5 = this.tokAt(n++);
        }
        if (n5 != 0x10100040 || n2 <= 0) {
            this.invArg();
        }
        float[][][] fArray = ArrayUtil.newFloat3(n2, -1);
        int n6 = 0;
        block5: while (n5 != 0x10100041) {
            n5 = this.eval.getToken((int)n).tok;
            switch (n5) {
                case 0x10100041: 
                case 1073742195: {
                    continue block5;
                }
                case 0x10100030: {
                    ++n;
                    continue block5;
                }
                case 0x10100040: {
                    fArray[n6++] = this.floatArraySet(n, n3, n4);
                    n = ++this.eval.iToken;
                    n5 = 0;
                    if (n6 != n2 || this.tokAt(n) == 0x10100041) continue block5;
                    this.invArg();
                    continue block5;
                }
            }
            this.invArg();
        }
        return fArray;
    }

    private boolean listIsosurface(int n) throws ScriptException {
        this.eval.checkLength23();
        if (!this.chk) {
            this.eval.showString((String)this.getShapeProperty(n, "list" + (this.tokAt(2) == 0 ? "" : " " + this.eval.getToken((int)2).value)));
        }
        return true;
    }
}

