/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.rendercgo;

import org.jmol.renderspecial.DrawRenderer;
import org.jmol.shape.Mesh;
import org.jmol.shapecgo.CGO;
import org.jmol.shapecgo.CGOMesh;
import org.jmol.util.C;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.P3;
import org.jmol.util.P3i;

public class CGORenderer
extends DrawRenderer {
    private CGOMesh cgoMesh;
    private JmolList<Object> cmds;
    private P3 pt3 = new P3();
    private short colix0;
    private short colix1;
    private short colix2;
    private short normix0;
    private short normix1;
    private short normix2;
    private short normix;
    private boolean doColor;
    private int ptNormal;
    private int ptColor;

    protected boolean render() {
        this.needTranslucent = false;
        this.imageFontScaling = this.viewer.getImageFontScaling();
        CGO cGO = (CGO)this.shape;
        int n = cGO.meshCount;
        while (--n >= 0) {
            this.cgoMesh = (CGOMesh)cGO.meshes[n];
            this.renderMesh(this.cgoMesh);
        }
        return this.needTranslucent;
    }

    public boolean renderMesh(Mesh mesh) {
        int n;
        this.mesh = mesh;
        this.cmds = this.cgoMesh.cmds;
        if (this.cmds == null || !this.cgoMesh.visible) {
            return false;
        }
        if (!this.g3d.setColix(this.cgoMesh.colix)) {
            this.needTranslucent = true;
            return true;
        }
        int n2 = this.cmds.size();
        int n3 = -1;
        int n4 = 0;
        this.ptNormal = 0;
        this.ptColor = 0;
        this.doColor = !mesh.useColix;
        for (int i = 0; i < n2 && (n = this.cgoMesh.getInt(i)) != 0; ++i) {
            int n5 = CGOMesh.getSize(n);
            if (n5 < 0) {
                Logger.error("CGO unknown type: " + n);
                return false;
            }
            switch (n) {
                default: {
                    System.out.println("CGO ? " + n);
                    break;
                }
                case 28: {
                    break;
                }
                case 1: {
                    this.getPoint(i + 2, this.pt0, this.pt0i);
                    this.getPoint(i + 5, this.pt1, this.pt1i);
                    this.drawLine(1, 2, false, this.pt0, this.pt1, this.pt0i, this.pt1i);
                    n5 = 8;
                    break;
                }
                case 2: {
                    n3 = this.cgoMesh.getInt(i + 1);
                    n4 = 0;
                    break;
                }
                case 3: {
                    if (n3 == 2 && n4 >= 3) {
                        this.drawLine(1, 2, false, this.pt1, this.pt3, this.pt1i, this.pt3i);
                    }
                    n4 = 0;
                    break;
                }
                case 10: {
                    break;
                }
                case 6: {
                    this.getColix(true);
                    break;
                }
                case 5: {
                    this.normix = this.getNormix();
                    break;
                }
                case 4: {
                    if (n4++ == 0) {
                        this.getPoint(i, this.pt0, this.pt0i);
                    }
                    block12 : switch (n3) {
                        case -1: {
                            break;
                        }
                        case 0: {
                            this.drawLine(1, 1, false, this.pt0, this.pt0, this.pt0i, this.pt0i);
                            break;
                        }
                        case 1: {
                            if (n4 != 2) break;
                            this.getPoint(i, this.pt1, this.pt1i);
                            this.drawLine(1, 2, false, this.pt0, this.pt0, this.pt1i, this.pt1i);
                            n4 = 0;
                            break;
                        }
                        case 2: 
                        case 3: {
                            if (n4 == 1) {
                                if (n3 != 2) break;
                                this.vTemp.setT(this.pt0);
                                this.pt3i.setT(this.pt0i);
                                break;
                            }
                            this.getPoint(i, this.pt1, this.pt1i);
                            P3 p3 = this.pt0;
                            this.pt0 = this.pt1;
                            this.pt1 = p3;
                            P3i p3i = this.pt0i;
                            this.pt0i = this.pt1i;
                            this.pt1i = p3i;
                            this.drawLine(1, 2, false, this.pt0, this.pt1, this.pt0i, this.pt1i);
                            break;
                        }
                        case 4: {
                            switch (n4) {
                                case 1: {
                                    this.normix2 = this.normix0 = this.normix;
                                    this.normix1 = this.normix0;
                                    this.colix2 = this.colix0 = this.colix;
                                    this.colix1 = this.colix0;
                                    break;
                                }
                                case 2: {
                                    this.getPoint(i, this.pt1, this.pt1i);
                                    break;
                                }
                                case 3: {
                                    this.getPoint(i, this.pt2, this.pt2i);
                                    this.fillTriangle();
                                    n4 = 0;
                                }
                            }
                            break;
                        }
                        case 5: {
                            P3i p3i;
                            P3 p3;
                            switch (n4) {
                                case 1: {
                                    this.normix2 = this.normix0 = this.normix;
                                    this.normix1 = this.normix0;
                                    this.colix2 = this.colix0 = this.colix;
                                    this.colix1 = this.colix0;
                                    break block12;
                                }
                                case 2: {
                                    this.getPoint(i, this.pt2, this.pt2i);
                                    break block12;
                                }
                            }
                            if (n4 % 2 == 0) {
                                p3 = this.pt0;
                                this.pt0 = this.pt2;
                                p3i = this.pt0i;
                                this.pt0i = this.pt2i;
                            } else {
                                p3 = this.pt1;
                                this.pt1 = this.pt2;
                                p3i = this.pt1i;
                                this.pt1i = this.pt2i;
                            }
                            this.pt2 = p3;
                            this.pt2i = p3i;
                            this.getPoint(i, this.pt2, this.pt2i);
                            this.fillTriangle();
                            break;
                        }
                        case 6: {
                            switch (n4) {
                                case 1: {
                                    this.normix2 = this.normix0 = this.normix;
                                    this.normix1 = this.normix0;
                                    this.colix2 = this.colix0 = this.colix;
                                    this.colix1 = this.colix0;
                                    this.pt1.setT(this.pt0);
                                    this.pt1i.setT(this.pt0i);
                                    break block12;
                                }
                                case 2: {
                                    this.getPoint(i, this.pt0, this.pt0i);
                                    break block12;
                                }
                            }
                            this.pt2.setT(this.pt0);
                            this.pt2i.setT(this.pt0i);
                            this.getPoint(i, this.pt0, this.pt0i);
                            this.fillTriangle();
                        }
                    }
                    break;
                }
                case 14: {
                    this.getPoint(i, this.pt0, this.pt0i);
                    this.getPoint(i + 3, this.pt1, this.pt1i);
                    this.width = this.cgoMesh.getFloat(i + 7);
                    this.getColix(true);
                    this.getColix(false);
                    this.drawLine(1, 2, false, this.pt0, this.pt1, this.pt0i, this.pt1i);
                    this.width = 0.0f;
                    break;
                }
                case 8: {
                    this.getPoint(i, this.pt0, this.pt0i);
                    this.getPoint(i + 3, this.pt1, this.pt1i);
                    this.getPoint(i + 6, this.pt2, this.pt2i);
                    this.normix0 = this.getNormix();
                    this.normix1 = this.getNormix();
                    this.normix2 = this.getNormix();
                    this.colix0 = this.getColix(false);
                    this.colix1 = this.getColix(false);
                    this.colix2 = this.getColix(false);
                    this.fillTriangle();
                }
            }
            i += n5;
        }
        return true;
    }

    private short getNormix() {
        return (Short)this.cgoMesh.nList.get(this.ptNormal++);
    }

    private short getColix(boolean bl) {
        if (this.doColor) {
            this.colix = C.copyColixTranslucency(this.cgoMesh.colix, (Short)this.cgoMesh.cList.get(this.ptColor++));
            if (bl) {
                this.g3d.setColix(this.colix);
            }
        }
        return this.colix;
    }

    private void getPoint(int n, P3 p3, P3i p3i) {
        this.cgoMesh.getPoint(n, p3);
        this.viewer.transformPtScr(p3, p3i);
    }

    private void fillTriangle() {
        this.g3d.fillTriangle3CN(this.pt0i, this.colix0, this.normix0, this.pt1i, this.colix1, this.normix1, this.pt2i, this.colix2, this.normix2);
    }
}

