/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import org.jmol.api.JmolRendererInterface;
import org.jmol.api.JmolRepaintManager;
import org.jmol.modelset.ModelSet;
import org.jmol.render.ShapeRenderer;
import org.jmol.shape.Shape;
import org.jmol.util.BS;
import org.jmol.util.GData;
import org.jmol.util.Logger;
import org.jmol.util.Rectangle;
import org.jmol.viewer.JC;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.Viewer;

public class RepaintManager
implements JmolRepaintManager {
    private Viewer viewer;
    private ShapeManager shapeManager;
    private ShapeRenderer[] renderers;
    private final BS bsTranslucent = BS.newN(36);
    public int holdRepaint = 0;
    private boolean repaintPending;

    public void set(Viewer viewer, ShapeManager shapeManager) {
        this.viewer = viewer;
        this.shapeManager = shapeManager;
    }

    public boolean isRepaintPending() {
        return this.repaintPending;
    }

    public void pushHoldRepaint(String string) {
        ++this.holdRepaint;
    }

    public void popHoldRepaint(boolean bl, String string) {
        --this.holdRepaint;
        if (this.holdRepaint <= 0) {
            this.holdRepaint = 0;
            if (bl) {
                this.repaintPending = true;
                this.repaintNow(string);
            }
        }
    }

    public synchronized void requestRepaintAndWait(String string) {
        try {
            this.repaintNow(string);
            this.wait(this.viewer.global.repaintWaitMs);
            if (this.repaintPending) {
                Logger.error("repaintManager requestRepaintAndWait timeout");
                this.repaintDone();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean repaintIfReady(String string) {
        if (this.repaintPending) {
            return false;
        }
        this.repaintPending = true;
        if (this.holdRepaint == 0) {
            this.repaintNow(string);
        }
        return true;
    }

    private void repaintNow(String string) {
        if (!this.viewer.haveDisplay) {
            return;
        }
        this.viewer.apiPlatform.repaint(this.viewer.getDisplay());
    }

    public synchronized void repaintDone() {
        this.repaintPending = false;
        this.notify();
    }

    public void clear(int n) {
        if (this.renderers == null) {
            return;
        }
        if (n >= 0) {
            this.renderers[n] = null;
        } else {
            for (int i = 0; i < 36; ++i) {
                this.renderers[i] = null;
            }
        }
    }

    private ShapeRenderer getRenderer(int n) {
        if (this.renderers[n] != null) {
            return this.renderers[n];
        }
        String string = JC.getShapeClassName(n, true) + "Renderer";
        try {
            Class<?> clazz = Class.forName(string);
            ShapeRenderer shapeRenderer = (ShapeRenderer)clazz.newInstance();
            shapeRenderer.setViewerG3dShapeID(this.viewer, n);
            this.renderers[n] = shapeRenderer;
            return this.renderers[n];
        }
        catch (Exception exception) {
            Logger.errorEx("Could not instantiate renderer:" + string, exception);
            return null;
        }
    }

    public void render(GData gData, ModelSet modelSet, boolean bl, int[] nArray) {
        boolean bl2 = this.viewer.getBoolean(603979934);
        try {
            Object object;
            JmolRendererInterface jmolRendererInterface = (JmolRendererInterface)((Object)gData);
            jmolRendererInterface.renderBackground(null);
            if (bl) {
                this.bsTranslucent.clearAll();
                if (nArray != null) {
                    jmolRendererInterface.renderCrossHairs(nArray, this.viewer.getScreenWidth(), this.viewer.getScreenHeight(), this.viewer.getNavigationOffset(), this.viewer.getNavigationDepthPercent());
                }
                if ((object = this.viewer.getRubberBandSelection()) != null && jmolRendererInterface.setColix(this.viewer.getColixRubberband())) {
                    jmolRendererInterface.drawRect(((Rectangle)object).x, ((Rectangle)object).y, 0, 0, ((Rectangle)object).width, ((Rectangle)object).height);
                }
            }
            if (this.renderers == null) {
                this.renderers = new ShapeRenderer[36];
            }
            object = null;
            for (int i = 0; i < 36 && jmolRendererInterface.currentlyRendering(); ++i) {
                Shape shape = this.shapeManager.getShape(i);
                if (shape == null) continue;
                if (bl2) {
                    object = "rendering " + JC.getShapeClassName(i, false);
                    Logger.startTimer((String)object);
                }
                if ((bl || this.bsTranslucent.get(i)) && this.getRenderer(i).renderShape(jmolRendererInterface, modelSet, shape)) {
                    this.bsTranslucent.set(i);
                }
                if (!bl2) continue;
                Logger.checkTimer((String)object, false);
            }
            jmolRendererInterface.renderAllStrings(null);
        }
        catch (Exception exception) {
            if (!this.viewer.isJS) {
                exception.printStackTrace();
            }
            Logger.error("rendering error? " + exception);
        }
    }

    public String renderExport(String string, GData gData, ModelSet modelSet, String string2) {
        boolean bl;
        boolean bl2 = this.viewer.getBoolean(603979934);
        this.viewer.finalizeTransformParameters();
        this.shapeManager.finalizeAtoms(null, null);
        this.shapeManager.transformAtoms();
        JmolRendererInterface jmolRendererInterface = this.viewer.initializeExporter(string, string2);
        boolean bl3 = bl = jmolRendererInterface != null;
        if (!bl) {
            Logger.error("Cannot export " + string);
            return null;
        }
        jmolRendererInterface.renderBackground(jmolRendererInterface);
        if (this.renderers == null) {
            this.renderers = new ShapeRenderer[36];
        }
        String string3 = null;
        for (int i = 0; i < 36; ++i) {
            Shape shape = this.shapeManager.getShape(i);
            if (shape == null) continue;
            if (bl2) {
                string3 = "rendering " + JC.getShapeClassName(i, false);
                Logger.startTimer(string3);
            }
            this.getRenderer(i).renderShape(jmolRendererInterface, modelSet, shape);
            if (!bl2) continue;
            Logger.checkTimer(string3, false);
        }
        jmolRendererInterface.renderAllStrings(jmolRendererInterface);
        return jmolRendererInterface.finalizeOutput();
    }
}

