/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Map;
import org.jmol.modelset.Atom;
import org.jmol.util.Escape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class APBridge {
    protected Atom a;
    protected Atom b;
    protected int[][] ladder;
    protected boolean isAntiparallel;

    protected APBridge(Atom atom, Atom atom2, Map<int[][], Boolean> map) {
        this.a = atom;
        this.b = atom2;
        this.ladder = new int[2][2];
        int n = Math.min(atom.index, atom2.index);
        this.ladder[0][1] = n;
        this.ladder[0][0] = n;
        int n2 = Math.max(atom.index, atom2.index);
        this.ladder[1][1] = n2;
        this.ladder[1][0] = n2;
        this.addLadder(map);
    }

    private void addLadder(Map<int[][], Boolean> map) {
        map.put(this.ladder, this.isAntiparallel ? Boolean.TRUE : Boolean.FALSE);
    }

    public String toString() {
        return (this.isAntiparallel ? "a " : "p ") + this.a + " - " + this.b + "\t" + Escape.e(this.ladder);
    }

    protected boolean addBridge(APBridge aPBridge, Map<int[][], Boolean> map) {
        if (aPBridge == null || aPBridge.isAntiparallel != this.isAntiparallel || !this.canAdd(aPBridge) || !aPBridge.canAdd(this)) {
            return false;
        }
        this.extendLadder(aPBridge.ladder[0][0], aPBridge.ladder[1][0]);
        this.extendLadder(aPBridge.ladder[0][1], aPBridge.ladder[1][1]);
        aPBridge.ladder = this.ladder;
        if (aPBridge.ladder != this.ladder) {
            map.remove(aPBridge.ladder);
            this.addLadder(map);
        }
        return true;
    }

    private boolean canAdd(APBridge aPBridge) {
        int n = aPBridge.a.index;
        int n2 = aPBridge.b.index;
        return this.isAntiparallel ? n >= this.ladder[0][1] && n2 <= this.ladder[1][0] || n <= this.ladder[0][0] && n2 >= this.ladder[1][1] : n <= this.ladder[0][0] && n2 <= this.ladder[1][0] || n >= this.ladder[0][1] && n2 >= this.ladder[1][1];
    }

    private void extendLadder(int n, int n2) {
        if (this.ladder[0][0] > n) {
            this.ladder[0][0] = n;
        }
        if (this.ladder[0][1] < n) {
            this.ladder[0][1] = n;
        }
        if (this.ladder[1][0] > n2) {
            this.ladder[1][0] = n2;
        }
        if (this.ladder[1][1] < n2) {
            this.ladder[1][1] = n2;
        }
    }
}

