/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io2;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.jmol.api.JmolDocument;
import org.jmol.util.Logger;
import org.jmol.util.SB;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryDocument
implements JmolDocument {
    protected DataInputStream stream;
    protected boolean isRandom = false;
    protected boolean isBigEndian = true;
    byte[] t8 = new byte[8];
    private static float[] fracIEEE;
    long nBytes;
    OutputStream os;

    @Override
    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.os != null) {
            try {
                this.os.flush();
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setStream(BufferedInputStream bufferedInputStream, boolean bl) {
        if (bufferedInputStream != null) {
            this.stream = new DataInputStream(bufferedInputStream);
        }
        this.isBigEndian = bl;
    }

    @Override
    public void setStreamData(DataInputStream dataInputStream, boolean bl) {
        if (dataInputStream != null) {
            this.stream = dataInputStream;
        }
        this.isBigEndian = bl;
    }

    public void setRandom(boolean bl) {
        this.isRandom = bl;
    }

    @Override
    public byte readByte() throws Exception {
        ++this.nBytes;
        return this.ioReadByte();
    }

    private byte ioReadByte() throws Exception {
        byte by = this.stream.readByte();
        if (this.os != null) {
            this.os.write(by);
        }
        return by;
    }

    @Override
    public int readByteArray(byte[] byArray, int n, int n2) throws Exception {
        int n3 = this.ioRead(byArray, n, n2);
        if (n3 > 0) {
            this.nBytes += (long)n3;
        }
        int n4 = n3;
        if (n3 > 0 && n3 < n2) {
            while (n4 < n2 && n3 > 0) {
                n3 = this.ioRead(byArray, n4, n2 - n4);
                if (n3 <= 0) continue;
                this.nBytes += (long)n3;
                n4 += n3;
            }
        }
        return n4;
    }

    private int ioRead(byte[] byArray, int n, int n2) throws Exception {
        int n3 = this.stream.read(byArray, n, n2);
        if (n3 > 0 && this.os != null) {
            this.writeBytes(byArray, n, n3);
        }
        return n3;
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws Exception {
        this.os.write(byArray, n, n2);
    }

    @Override
    public String readString(int n) throws Exception {
        byte[] byArray = new byte[n];
        int n2 = this.readByteArray(byArray, 0, n);
        return new String(byArray, 0, n2, "UTF-8");
    }

    @Override
    public short readShort() throws Exception {
        this.nBytes += 2L;
        return this.isBigEndian ? this.ioReadShort() : (short)(this.ioReadByte() & 0xFF | (this.ioReadByte() & 0xFF) << 8);
    }

    private short ioReadShort() throws Exception {
        short s = this.stream.readShort();
        if (this.os != null) {
            this.writeShort(s);
        }
        return s;
    }

    public void writeShort(short s) throws Exception {
        this.os.write(s >> 8);
        this.os.write(s);
    }

    @Override
    public int readIntLE() throws Exception {
        this.nBytes += 4L;
        return this.readLEInt();
    }

    @Override
    public int readInt() throws Exception {
        this.nBytes += 4L;
        return this.isBigEndian ? this.ioReadInt() : this.readLEInt();
    }

    private int ioReadInt() throws Exception {
        int n = this.stream.readInt();
        if (this.os != null) {
            this.writeInt(n);
        }
        return n;
    }

    public void writeInt(int n) throws Exception {
        this.os.write(n >> 24);
        this.os.write(n >> 16);
        this.os.write(n >> 8);
        this.os.write(n);
    }

    @Override
    public int swapBytesI(int n) {
        return n >> 24 & 0xFF | (n >> 16 & 0xFF) << 8 | (n >> 8 & 0xFF) << 16 | (n & 0xFF) << 24;
    }

    @Override
    public short swapBytesS(short s) {
        return (short)(s >> 8 & 0xFF | (s & 0xFF) << 8);
    }

    @Override
    public int readUnsignedShort() throws Exception {
        this.nBytes += 2L;
        int n = this.ioReadByte() & 0xFF;
        int n2 = this.ioReadByte() & 0xFF;
        return this.isBigEndian ? (n << 8) + n2 : (n2 << 8) + n;
    }

    @Override
    public long readLong() throws Exception {
        this.nBytes += 8L;
        return this.isBigEndian ? this.ioReadLong() : (long)this.ioReadByte() & 0xFFL | ((long)this.ioReadByte() & 0xFFL) << 8 | ((long)this.ioReadByte() & 0xFFL) << 16 | ((long)this.ioReadByte() & 0xFFL) << 24 | ((long)this.ioReadByte() & 0xFFL) << 32 | ((long)this.ioReadByte() & 0xFFL) << 40 | ((long)this.ioReadByte() & 0xFFL) << 48 | ((long)this.ioReadByte() & 0xFFL) << 54;
    }

    private long ioReadLong() throws Exception {
        long l = this.stream.readLong();
        if (this.os != null) {
            this.writeLong(l);
        }
        return l;
    }

    public void writeLong(long l) throws Exception {
        this.writeInt((int)(l >> 32 & 0xFFFFFFFFL));
        this.writeInt((int)(l & 0xFFFFFFFFL));
    }

    @Override
    public float readFloat() throws Exception {
        int n = this.readInt();
        return Float.intBitsToFloat(n);
    }

    private int readLEInt() throws Exception {
        return this.ioReadByte() & 0xFF | (this.ioReadByte() & 0xFF) << 8 | (this.ioReadByte() & 0xFF) << 16 | (this.ioReadByte() & 0xFF) << 24;
    }

    @Override
    public double readDouble() throws Exception {
        this.nBytes += 8L;
        return this.isBigEndian ? this.ioReadDouble() : Double.longBitsToDouble(this.readLELong());
    }

    public static float bytesToDoubleToFloat(byte[] byArray, int n, boolean bl) {
        if (fracIEEE == null) {
            BinaryDocument.setFracIEEE();
        }
        double d = bl ? Double.longBitsToDouble(((long)byArray[n] & 0xFFL) << 56 | ((long)byArray[n + 1] & 0xFFL) << 48 | ((long)byArray[n + 2] & 0xFFL) << 40 | ((long)byArray[n + 3] & 0xFFL) << 32 | ((long)byArray[n + 4] & 0xFFL) << 24 | ((long)byArray[n + 5] & 0xFFL) << 16 | ((long)byArray[n + 6] & 0xFFL) << 8 | (long)byArray[7] & 0xFFL) : Double.longBitsToDouble(((long)byArray[n + 7] & 0xFFL) << 56 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 1] & 0xFFL) << 8 | (long)byArray[n] & 0xFFL);
        return (float)d;
    }

    static void setFracIEEE() {
        fracIEEE = new float[270];
        for (int i = 0; i < 270; ++i) {
            BinaryDocument.fracIEEE[i] = (float)Math.pow(2.0, i - 141);
        }
    }

    static double shiftIEEE(double d, int n) {
        if (d == 0.0 || n < -140) {
            return 0.0;
        }
        if (n > 128) {
            return 3.4028234663852886E38;
        }
        return d * (double)fracIEEE[n + 140];
    }

    private double ioReadDouble() throws Exception {
        double d = this.stream.readDouble();
        if (this.os != null) {
            this.writeLong(Double.doubleToRawLongBits(d));
        }
        return d;
    }

    private long readLELong() throws Exception {
        return (long)this.ioReadByte() & 0xFFL | ((long)this.ioReadByte() & 0xFFL) << 8 | ((long)this.ioReadByte() & 0xFFL) << 16 | ((long)this.ioReadByte() & 0xFFL) << 24 | ((long)this.ioReadByte() & 0xFFL) << 32 | ((long)this.ioReadByte() & 0xFFL) << 40 | ((long)this.ioReadByte() & 0xFFL) << 48 | ((long)this.ioReadByte() & 0xFFL) << 56;
    }

    @Override
    public void seek(long l) {
        try {
            if (l == this.nBytes) {
                return;
            }
            if (l < this.nBytes) {
                this.stream.reset();
                this.nBytes = 0L;
            } else {
                l -= this.nBytes;
            }
            this.stream.skipBytes((int)l);
            this.nBytes += l;
        }
        catch (Exception exception) {
            Logger.errorEx(null, exception);
        }
    }

    @Override
    public long getPosition() {
        return this.nBytes;
    }

    @Override
    public void setOutputStream(OutputStream outputStream, Viewer viewer, double d) {
        if (viewer.checkPrivateKey(d)) {
            this.os = outputStream;
        }
    }

    @Override
    public SB getAllDataFiles(String string, String string2) {
        return null;
    }

    @Override
    public void getAllDataMapped(String string, String string2, Map<String, String> map) {
    }
}

