/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export.image;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class ImageSelection
implements Transferable {
    private Image image;
    private String text;

    public static void setClipboard(Image image) {
        ImageSelection imageSelection = new ImageSelection(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imageSelection, null);
    }

    public static void setClipboard(String string) {
        ImageSelection imageSelection = new ImageSelection(string);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imageSelection, null);
    }

    public ImageSelection(Image image) {
        this.image = image;
    }

    public ImageSelection(String string) {
        this.text = string;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray;
        if (this.text == null) {
            DataFlavor[] dataFlavorArray2 = new DataFlavor[1];
            dataFlavorArray = dataFlavorArray2;
            dataFlavorArray2[0] = DataFlavor.imageFlavor;
        } else {
            DataFlavor[] dataFlavorArray3 = new DataFlavor[1];
            dataFlavorArray = dataFlavorArray3;
            dataFlavorArray3[0] = DataFlavor.stringFlavor;
        }
        return dataFlavorArray;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return DataFlavor.imageFlavor.equals(dataFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (DataFlavor.imageFlavor.equals(dataFlavor)) {
            return this.image;
        }
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            return this.text;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public static String getClipboardText() {
        String string = null;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        if (transferable == null) {
            return null;
        }
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            } else if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                Object object = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                List list = (List)object;
                int n = list.size();
                if (n == 0) {
                    return null;
                }
                if (n == 1) {
                    string = "LoAd " + Escape.eS(((File)list.get(0)).getAbsolutePath().replace('\\', '/'));
                    if (string.endsWith(".pse\"")) {
                        string = string + " filter 'DORESIZE'";
                    }
                } else {
                    string = "LoAd files ";
                    for (int i = 0; i < n; ++i) {
                        string = string + " " + Escape.eS(((File)list.get(i)).getAbsolutePath().replace('\\', '/'));
                    }
                }
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Logger.errorEx("Clipboard problem", unsupportedFlavorException);
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            Logger.errorEx("Clipboard problem", iOException);
            iOException.printStackTrace();
        }
        return string;
    }
}

