/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.awt;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import org.jmol.api.JmolFileAdapterInterface;
import org.jmol.api.JmolFileInterface;
import org.jmol.awt.JmolFile;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class JmolFileAdapter
implements JmolFileAdapterInterface {
    private Viewer viewer;

    public JmolFileAdapter(Viewer viewer) {
        this.viewer = viewer;
    }

    public Object getBufferedURLInputStream(URL uRL, byte[] byArray, String string) {
        try {
            URLConnection uRLConnection = uRL.openConnection();
            String string2 = null;
            if (byArray != null) {
                string2 = "application/octet-stream;";
            } else if (string != null) {
                string2 = "application/x-www-form-urlencoded";
            }
            if (string2 != null) {
                uRLConnection.setRequestProperty("Content-Type", string2);
                uRLConnection.setDoOutput(true);
                if (byArray == null) {
                    this.outputString(uRLConnection, string);
                } else {
                    this.outputBytes(uRLConnection, byArray);
                }
            }
            return new BufferedInputStream(uRLConnection.getInputStream());
        }
        catch (IOException iOException) {
            return iOException.getMessage();
        }
    }

    private void outputBytes(URLConnection uRLConnection, byte[] byArray) throws IOException {
        uRLConnection.getOutputStream().write(byArray);
        uRLConnection.getOutputStream().flush();
    }

    private void outputString(URLConnection uRLConnection, String string) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream());
        outputStreamWriter.write(string);
        outputStreamWriter.flush();
    }

    public Object getBufferedFileInputStream(String string) {
        File file = new File(string);
        try {
            return new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            return iOException.toString();
        }
    }

    public static JmolFileInterface newFile(String string) {
        return new JmolFile(string);
    }

    public Object openOutputChannel(double d, FileManager fileManager, String string, boolean bl) throws IOException {
        if (!this.viewer.checkPrivateKey(d)) {
            return null;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        return bl ? new BufferedWriter(new OutputStreamWriter(fileOutputStream)) : fileOutputStream;
    }

    public InputStream openFileInputStream(double d, String string) throws IOException {
        return this.viewer.checkPrivateKey(d) ? new FileInputStream(string) : null;
    }

    public String getAbsolutePath(double d, String string) {
        return this.viewer.isApplet() || !this.viewer.checkPrivateKey(d) ? string : new File(string).getAbsolutePath();
    }

    public long getFileLength(double d, String string) {
        return new File(string).length();
    }

    public Object openLogFile(double d, String string, boolean bl) throws IOException {
        return this.viewer.checkPrivateKey(d) && string.indexOf("JmolLog_") >= 0 ? new BufferedWriter(new FileWriter(string, bl)) : null;
    }
}

