/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jmol.adapter.readers.xml.JmolXmlHandler;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Resolver;
import org.jmol.api.Interface;
import org.jmol.util.Logger;
import org.xml.sax.XMLReader;

public class XmlReader
extends AtomSetCollectionReader {
    protected Atom atom;
    protected String[] domAttributes;
    protected XmlReader parent;
    public Map<String, String> atts;
    protected boolean keepChars;
    protected String chars;
    private Object[] domObj = new Object[1];
    private Object[] attribs;
    private Object[] attArgs;
    private Object[] nullObj = new Object[0];

    public void initializeReader() throws Exception {
        this.atts = new Hashtable<String, String>();
        this.setMyError(this.parseXML());
        this.continuing = false;
    }

    private void setMyError(String string) {
        if (string != null && (this.atomSetCollection == null || this.atomSetCollection.errorMessage == null)) {
            this.atomSetCollection = new AtomSetCollection("xml", this, null, null);
            this.atomSetCollection.errorMessage = string;
        }
    }

    private String parseXML() {
        XMLReader xMLReader;
        block4: {
            xMLReader = null;
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setNamespaceAware(true);
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                xMLReader = sAXParser.getXMLReader();
                if (Logger.debugging) {
                    Logger.debug("Using JAXP/SAX XML parser.");
                }
            }
            catch (Exception exception) {
                if (!Logger.debugging) break block4;
                Logger.debug("Could not instantiate JAXP/SAX XML reader: " + ((this.parent == null ? this : this.parent).viewer.isJS ? exception : exception.getMessage()));
            }
        }
        if (xMLReader == null) {
            return "No XML reader found";
        }
        return this.selectReaderAndGo(xMLReader);
    }

    private String selectReaderAndGo(Object object) {
        this.atomSetCollection = new AtomSetCollection(this.readerName, this, null, null);
        String string = null;
        XmlReader xmlReader = null;
        try {
            int n = this.readerName.indexOf("(");
            String string2 = n < 0 ? this.readerName : this.readerName.substring(0, n);
            string = Resolver.getReaderClassBase(string2);
            Class<?> clazz = Class.forName(string);
            xmlReader = (XmlReader)clazz.newInstance();
        }
        catch (Exception exception) {
            return "File reader was not found: " + string;
        }
        try {
            xmlReader.processXml(this, object);
        }
        catch (Exception exception) {
            return "Error reading XML: " + (this.parent.viewer.isJS ? exception : exception.getMessage());
        }
        return null;
    }

    protected void processXml(XmlReader xmlReader, Object object) throws Exception {
        this.PX(xmlReader, object);
    }

    protected void PX(XmlReader xmlReader, Object object) throws Exception {
        this.parent = xmlReader;
        this.atomSetCollection = xmlReader.atomSetCollection;
        this.reader = xmlReader.reader;
        this.atts = xmlReader.atts;
        if (object == null) {
            this.domAttributes = this.getDOMAttributes();
            this.attribs = new Object[1];
            this.attArgs = new Object[1];
            this.domObj = new Object[1];
            this.walkDOMTree();
        } else {
            JmolXmlHandler jmolXmlHandler = (JmolXmlHandler)Interface.getOptionInterface("adapter.readers.xml.XmlHandler");
            jmolXmlHandler.parseXML(this, object, this.reader);
        }
    }

    public void applySymmetryAndSetTrajectory() {
        try {
            if (this.parent == null) {
                this.applySymTrajASCR();
            } else {
                this.parent.applySymmetryAndSetTrajectory();
            }
        }
        catch (Exception exception) {
            System.out.println((this.parent == null ? this : this.parent).viewer.isJS ? exception : exception.getMessage());
            Logger.error("applySymmetry failed: " + exception);
        }
    }

    protected void processDOM(Object object) {
        this.domObj = new Object[]{object};
        this.setMyError(this.selectReaderAndGo(null));
    }

    protected String[] getDOMAttributes() {
        return new String[]{"id"};
    }

    protected void processStartElement(String string) {
    }

    protected void setKeepChars(boolean bl) {
        this.keepChars = bl;
        this.chars = null;
    }

    void processEndElement(String string) {
    }

    private void walkDOMTree() {
        String string = ((String)this.jsObjectGetMember(this.domObj, "localName")).toLowerCase();
        if (string == null) {
            return;
        }
        if (string.equals("#text")) {
            if (this.keepChars) {
                this.chars = (String)this.jsObjectGetMember(this.domObj, "data");
            }
            return;
        }
        this.attribs[0] = this.jsObjectGetMember(this.domObj, "attributes");
        this.getDOMAttributesA(this.attribs);
        this.processStartElement(string);
        boolean bl = (Boolean)this.jsObjectCall(this.domObj, "hasChildNodes", null);
        if (bl) {
            Object object = this.jsObjectGetMember(this.domObj, "firstChild");
            while (object != null) {
                this.domObj[0] = object;
                this.walkDOMTree();
                this.domObj[0] = object;
                object = this.jsObjectGetMember(this.domObj, "nextSibling");
            }
        }
        this.processEndElement(string);
    }

    private void getDOMAttributesA(Object[] objectArray) {
        this.atts.clear();
        if (objectArray == null) {
            return;
        }
        Object object = (Number)this.jsObjectGetMember(objectArray, "length");
        if (object == null || Integer.parseInt(object.toString()) == 0) {
            return;
        }
        int n = this.domAttributes.length;
        while (--n >= 0) {
            this.attArgs[0] = object = this.domAttributes[n];
            Object object2 = this.jsObjectCall(objectArray, "getNamedItem", this.attArgs);
            if (object2 == null) continue;
            this.attArgs[0] = object2;
            String string = (String)this.jsObjectGetMember(this.attArgs, "value");
            if (string == null) continue;
            this.atts.put((String)object, string);
        }
    }

    private Object jsObjectCall(Object[] objectArray, String string, Object[] objectArray2) {
        return this.parent.viewer.getJsObjectInfo(objectArray, string, objectArray2 == null ? this.nullObj : objectArray2);
    }

    private Object jsObjectGetMember(Object[] objectArray, String string) {
        return this.parent.viewer.getJsObjectInfo(objectArray, string, null);
    }
}

