/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cifpdb;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Map;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolLineReader;
import org.jmol.constant.EnumStructure;
import org.jmol.io.CifDataReader;
import org.jmol.util.BS;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.Matrix4f;
import org.jmol.util.P3;
import org.jmol.util.TextFormat;

public class CifReader
extends AtomSetCollectionReader
implements JmolLineReader {
    protected boolean isPDBX;
    private CifDataReader tokenizer = new CifDataReader(this);
    private String thisDataSetName = "";
    private String chemicalName = "";
    private String thisStructuralFormula = "";
    private String thisFormula = "";
    private boolean iHaveDesiredModel;
    private boolean isPDB = false;
    private Map<String, String> htHetero;
    private boolean isMolecular;
    private String molecularType = "GEOM_BOND default";
    private char lastAltLoc = '\u0000';
    private int configurationPtr = Integer.MIN_VALUE;
    private int conformationIndex;
    private boolean filterAssembly;
    private boolean haveAromatic;
    private JmolList<Matrix4f> vBiomts;
    private JmolList<Map<String, Object>> vBiomolecules;
    private Map<String, Matrix4f> htBiomts;
    private Map<String, BS> assemblyIdAtoms;
    private String appendedData;
    private boolean skipping;
    private boolean haveChainsLC;
    private int nAtoms;
    private int nMolecular = 0;
    private boolean incommensurate;
    private static final String[] TransformFields = new String[]{"x[1][1]", "x[1][2]", "x[1][3]", "r[1]", "x[2][1]", "x[2][2]", "x[2][3]", "r[2]", "x[3][1]", "x[3][2]", "x[3][3]", "r[3]"};
    private String key;
    private String data;
    private Map<String, Float> atomTypes;
    private JmolList<Object[]> bondTypes = new JmolList();
    private String disorderAssembly = ".";
    private String lastDisorderAssembly;
    private static final byte ATOM_TYPE_SYMBOL = 0;
    private static final byte ATOM_TYPE_OXIDATION_NUMBER = 1;
    private static final String[] atomTypeFields = new String[]{"_atom_type_symbol", "_atom_type_oxidation_number"};
    private static final byte NONE = -1;
    private static final byte TYPE_SYMBOL = 0;
    private static final byte LABEL = 1;
    private static final byte AUTH_ATOM = 2;
    private static final byte FRACT_X = 3;
    private static final byte FRACT_Y = 4;
    private static final byte FRACT_Z = 5;
    private static final byte CARTN_X = 6;
    private static final byte CARTN_Y = 7;
    private static final byte CARTN_Z = 8;
    private static final byte OCCUPANCY = 9;
    private static final byte B_ISO = 10;
    private static final byte COMP_ID = 11;
    private static final byte AUTH_ASYM_ID = 12;
    private static final byte SEQ_ID = 13;
    private static final byte INS_CODE = 14;
    private static final byte ALT_ID = 15;
    private static final byte GROUP_PDB = 16;
    private static final byte MODEL_NO = 17;
    private static final byte DUMMY_ATOM = 18;
    private static final byte DISORDER_GROUP = 19;
    private static final byte ANISO_LABEL = 20;
    private static final byte ANISO_MMCIF_ID = 21;
    private static final byte ANISO_U11 = 22;
    private static final byte ANISO_U22 = 23;
    private static final byte ANISO_U33 = 24;
    private static final byte ANISO_U12 = 25;
    private static final byte ANISO_U13 = 26;
    private static final byte ANISO_U23 = 27;
    private static final byte ANISO_MMCIF_U11 = 28;
    private static final byte ANISO_MMCIF_U22 = 29;
    private static final byte ANISO_MMCIF_U33 = 30;
    private static final byte ANISO_MMCIF_U12 = 31;
    private static final byte ANISO_MMCIF_U13 = 32;
    private static final byte ANISO_MMCIF_U23 = 33;
    private static final byte U_ISO_OR_EQUIV = 34;
    private static final byte ANISO_B11 = 35;
    private static final byte ANISO_B22 = 36;
    private static final byte ANISO_B33 = 37;
    private static final byte ANISO_B12 = 38;
    private static final byte ANISO_B13 = 39;
    private static final byte ANISO_B23 = 40;
    private static final byte ANISO_Beta_11 = 41;
    private static final byte ANISO_Beta_22 = 42;
    private static final byte ANISO_Beta_33 = 43;
    private static final byte ANISO_Beta_12 = 44;
    private static final byte ANISO_Beta_13 = 45;
    private static final byte ANISO_Beta_23 = 46;
    private static final byte ADP_TYPE = 47;
    private static final byte CHEM_COMP_AC_ID = 48;
    private static final byte CHEM_COMP_AC_NAME = 49;
    private static final byte CHEM_COMP_AC_SYM = 50;
    private static final byte CHEM_COMP_AC_CHARGE = 51;
    private static final byte CHEM_COMP_AC_X = 52;
    private static final byte CHEM_COMP_AC_Y = 53;
    private static final byte CHEM_COMP_AC_Z = 54;
    private static final byte CHEM_COMP_AC_X_IDEAL = 55;
    private static final byte CHEM_COMP_AC_Y_IDEAL = 56;
    private static final byte CHEM_COMP_AC_Z_IDEAL = 57;
    private static final byte DISORDER_ASSEMBLY = 58;
    private static final byte ASYM_ID = 59;
    private static final String[] atomFields = new String[]{"_atom_site_type_symbol", "_atom_site_label", "_atom_site_auth_atom_id", "_atom_site_fract_x", "_atom_site_fract_y", "_atom_site_fract_z", "_atom_site_Cartn_x", "_atom_site_Cartn_y", "_atom_site_Cartn_z", "_atom_site_occupancy", "_atom_site_b_iso_or_equiv", "_atom_site_auth_comp_id", "_atom_site_auth_asym_id", "_atom_site_auth_seq_id", "_atom_site_pdbx_PDB_ins_code", "_atom_site_label_alt_id", "_atom_site_group_PDB", "_atom_site_pdbx_PDB_model_num", "_atom_site_calc_flag", "_atom_site_disorder_group", "_atom_site_aniso_label", "_atom_site_anisotrop_id", "_atom_site_aniso_U_11", "_atom_site_aniso_U_22", "_atom_site_aniso_U_33", "_atom_site_aniso_U_12", "_atom_site_aniso_U_13", "_atom_site_aniso_U_23", "_atom_site_anisotrop_U[1][1]", "_atom_site_anisotrop_U[2][2]", "_atom_site_anisotrop_U[3][3]", "_atom_site_anisotrop_U[1][2]", "_atom_site_anisotrop_U[1][3]", "_atom_site_anisotrop_U[2][3]", "_atom_site_U_iso_or_equiv", "_atom_site_aniso_B_11", "_atom_site_aniso_B_22", "_atom_site_aniso_B_33", "_atom_site_aniso_B_12", "_atom_site_aniso_B_13", "_atom_site_aniso_B_23", "_atom_site_aniso_Beta_11", "_atom_site_aniso_Beta_22", "_atom_site_aniso_Beta_33", "_atom_site_aniso_Beta_12", "_atom_site_aniso_Beta_13", "_atom_site_aniso_Beta_23", "_atom_site_adp_type", "_chem_comp_atom_comp_id", "_chem_comp_atom_atom_id", "_chem_comp_atom_type_symbol", "_chem_comp_atom_charge", "_chem_comp_atom_model_Cartn_x", "_chem_comp_atom_model_Cartn_y", "_chem_comp_atom_model_Cartn_z", "_chem_comp_atom_pdbx_model_Cartn_x_ideal", "_chem_comp_atom_pdbx_model_Cartn_y_ideal", "_chem_comp_atom_pdbx_model_Cartn_z_ideal", "_atom_site_disorder_assembly", "_atom_site_label_asym_id"};
    private static final byte OPER_ID = 12;
    private static final byte OPER_XYZ = 13;
    private static final String[] operFields = new String[]{"_pdbx_struct_oper_list_matrix[1][1]", "_pdbx_struct_oper_list_matrix[1][2]", "_pdbx_struct_oper_list_matrix[1][3]", "_pdbx_struct_oper_list_vector[1]", "_pdbx_struct_oper_list_matrix[2][1]", "_pdbx_struct_oper_list_matrix[2][2]", "_pdbx_struct_oper_list_matrix[2][3]", "_pdbx_struct_oper_list_vector[2]", "_pdbx_struct_oper_list_matrix[3][1]", "_pdbx_struct_oper_list_matrix[3][2]", "_pdbx_struct_oper_list_matrix[3][3]", "_pdbx_struct_oper_list_vector[3]", "_pdbx_struct_oper_list_id", "_pdbx_struct_oper_list_symmetry_operation"};
    private static final byte ASSEM_ID = 0;
    private static final byte ASSEM_OPERS = 1;
    private static final byte ASSEM_LIST = 2;
    private static final String[] assemblyFields = new String[]{"_pdbx_struct_assembly_gen_assembly_id", "_pdbx_struct_assembly_gen_oper_expression", "_pdbx_struct_assembly_gen_asym_id_list"};
    private String[] assem = null;
    private static final byte CHEM_COMP_BOND_ATOM_ID_1 = 0;
    private static final byte CHEM_COMP_BOND_ATOM_ID_2 = 1;
    private static final byte CHEM_COMP_BOND_VALUE_ORDER = 2;
    private static final byte CHEM_COMP_BOND_AROMATIC_FLAG = 3;
    private static final String[] chemCompBondFields = new String[]{"_chem_comp_bond_atom_id_1", "_chem_comp_bond_atom_id_2", "_chem_comp_bond_value_order", "_chem_comp_bond_pdbx_aromatic_flag"};
    private static final byte GEOM_BOND_ATOM_SITE_LABEL_1 = 0;
    private static final byte GEOM_BOND_ATOM_SITE_LABEL_2 = 1;
    private static final byte GEOM_BOND_DISTANCE = 2;
    private static final byte CCDC_GEOM_BOND_TYPE = 3;
    private static final String[] geomBondFields = new String[]{"_geom_bond_atom_site_label_1", "_geom_bond_atom_site_label_2", "_geom_bond_distance", "_ccdc_geom_bond_type"};
    private static final byte NONPOLY_ENTITY_ID = 0;
    private static final byte NONPOLY_NAME = 1;
    private static final byte NONPOLY_COMP_ID = 2;
    private static final String[] nonpolyFields = new String[]{"_pdbx_entity_nonpoly_entity_id", "_pdbx_entity_nonpoly_name", "_pdbx_entity_nonpoly_comp_id"};
    private String[] hetatmData;
    private static final byte CHEM_COMP_ID = 0;
    private static final byte CHEM_COMP_NAME = 1;
    private static final String[] chemCompFields = new String[]{"_chem_comp_id", "_chem_comp_name"};
    private static final byte CONF_TYPE_ID = 0;
    private static final byte BEG_ASYM_ID = 1;
    private static final byte BEG_SEQ_ID = 2;
    private static final byte BEG_INS_CODE = 3;
    private static final byte END_ASYM_ID = 4;
    private static final byte END_SEQ_ID = 5;
    private static final byte END_INS_CODE = 6;
    private static final byte STRUCT_ID = 7;
    private static final byte SERIAL_NO = 8;
    private static final byte HELIX_CLASS = 9;
    private static final String[] structConfFields = new String[]{"_struct_conf_conf_type_id", "_struct_conf_beg_auth_asym_id", "_struct_conf_beg_auth_seq_id", "_struct_conf_pdbx_beg_PDB_ins_code", "_struct_conf_end_auth_asym_id", "_struct_conf_end_auth_seq_id", "_struct_conf_pdbx_end_PDB_ins_code", "_struct_conf_id", "_struct_conf_pdbx_PDB_helix_id", "_struct_conf_pdbx_PDB_helix_class"};
    private static final byte SHEET_ID = 0;
    private static final byte STRAND_ID = 7;
    private static final String[] structSheetRangeFields = new String[]{"_struct_sheet_range_sheet_id", "_struct_sheet_range_beg_auth_asym_id", "_struct_sheet_range_beg_auth_seq_id", "_struct_sheet_range_pdbx_beg_PDB_ins_code", "_struct_sheet_range_end_auth_asym_id", "_struct_sheet_range_end_auth_seq_id", "_struct_sheet_range_pdbx_end_PDB_ins_code", "_struct_sheet_range_id"};
    private static final byte SITE_ID = 0;
    private static final byte SITE_COMP_ID = 1;
    private static final byte SITE_ASYM_ID = 2;
    private static final byte SITE_SEQ_ID = 3;
    private static final byte SITE_INS_CODE = 4;
    private static final String[] structSiteRangeFields = new String[]{"_struct_site_gen_site_id", "_struct_site_gen_auth_comp_id", "_struct_site_gen_auth_asym_id", "_struct_site_gen_auth_seq_id", "_struct_site_gen_label_alt_id"};
    private Map<String, Map<String, Object>> htSites;
    private static final byte SYMOP_XYZ = 0;
    private static final byte SYM_EQUIV_XYZ = 1;
    private static final byte SYM_SSG_XYZ = 2;
    private static final byte SYM_SSG_OP = 3;
    private static final String[] symmetryOperationsFields = new String[]{"_space_group_symop_operation_xyz", "_symmetry_equiv_pos_as_xyz", "_symmetry_ssg_equiv_pos_as_xyz", "_space_group_symop_ssg_operation_algebraic"};
    String field;
    private char firstChar = '\u0000';
    private int[] propertyOf = new int[100];
    private byte[] fieldOf = new byte[atomFields.length];
    private int propertyCount;
    private float[] atomRadius;
    private BS[] bsConnected;
    private BS[] bsSets;
    private final P3 ptOffset = new P3();
    private BS bsMolecule;
    private BS bsExclude;
    private int firstAtom;
    private int atomCount;
    private Atom[] atoms;

    public void initializeReader() throws Exception {
        this.initializeReaderCif();
    }

    protected void initializeReaderCif() throws Exception {
        if (this.checkFilterKey("CONF ")) {
            this.configurationPtr = this.parseIntAt(this.filter, this.filter.indexOf("CONF ") + 5);
        }
        this.appendedData = (String)this.htParams.get("appendedData");
        this.isMolecular = this.filter != null && this.filter.indexOf("MOLECUL") >= 0;
        boolean bl = this.filterAssembly = this.filter != null && this.filter.indexOf("$") >= 0;
        if (this.isMolecular) {
            if (!this.doApplySymmetry) {
                this.doApplySymmetry = true;
                this.latticeCells[0] = 1;
                this.latticeCells[1] = 1;
                this.latticeCells[2] = 1;
            }
            this.molecularType = "filter \"MOLECULAR\"";
        }
        this.nAtoms = 0;
        this.line = "";
        this.skipping = false;
        while ((this.key = this.tokenizer.peekToken()) != null && this.readAllData()) {
        }
        if (this.appendedData != null) {
            this.tokenizer = new CifDataReader(new BufferedReader(new StringReader(this.appendedData)));
            while ((this.key = this.tokenizer.peekToken()) != null && this.readAllData()) {
            }
        }
        if (this.atomSetCollection.getAtomCount() == this.nAtoms) {
            this.atomSetCollection.removeCurrentAtomSet();
        } else {
            this.applySymmetryAndSetTrajectory();
        }
        if (this.htSites != null) {
            this.addSites(this.htSites);
        }
        this.atomSetCollection.setCollectionName("<collection of " + this.atomSetCollection.getAtomSetCount() + " models>");
        this.continuing = false;
    }

    public String readNextLine() throws Exception {
        if (this.readLine() != null && this.line.indexOf("#jmolscript:") >= 0) {
            this.checkCurrentLineForScript();
        }
        return this.line;
    }

    private boolean readAllData() throws Exception {
        if (this.key.startsWith("data_")) {
            if (this.isPDBX) {
                this.tokenizer.getTokenPeeked();
                return true;
            }
            if (this.iHaveDesiredModel) {
                return false;
            }
            this.newModel(++this.modelNumber);
            if (!this.skipping) {
                this.processDataParameter();
            }
            this.nAtoms = this.atomSetCollection.getAtomCount();
            return true;
        }
        if (this.key.startsWith("loop_")) {
            if (this.skipping) {
                this.tokenizer.getTokenPeeked();
                this.skipLoop();
            } else {
                this.processLoopBlock();
            }
            return true;
        }
        if (this.key.indexOf("_") != 0) {
            Logger.warn("CIF ERROR ? should be an underscore: " + this.key);
            this.tokenizer.getTokenPeeked();
        } else if (!this.getData()) {
            return true;
        }
        if (!this.skipping) {
            this.key = this.key.replace('.', '_');
            if (this.key.startsWith("_chemical_name") || this.key.equals("_chem_comp_name")) {
                this.processChemicalInfo("name");
            } else if (this.key.startsWith("_chemical_formula_structural")) {
                this.processChemicalInfo("structuralFormula");
            } else if (this.key.startsWith("_chemical_formula_sum") || this.key.equals("_chem_comp_formula")) {
                this.processChemicalInfo("formula");
            } else if (this.key.startsWith("_cell_")) {
                this.processCellParameter();
            } else if (this.key.startsWith("_symmetry_space_group_name_h-m") || this.key.startsWith("_symmetry_space_group_name_hall") || this.key.startsWith("_space_group_ssg_name")) {
                this.processSymmetrySpaceGroupName();
            } else if (this.key.startsWith("_atom_sites_fract_tran")) {
                this.processUnitCellTransformMatrix();
            } else if (this.key.startsWith("_pdbx_entity_nonpoly")) {
                this.processNonpolyData();
            } else if (this.key.startsWith("_pdbx_struct_assembly_gen")) {
                this.processAssemblyGen();
            }
        }
        return true;
    }

    protected void newModel(int n) throws Exception {
        if (this.isPDB) {
            this.setIsPDB();
        }
        boolean bl = this.skipping = !this.doGetModel(this.modelNumber = n, null);
        if (this.skipping) {
            this.tokenizer.getTokenPeeked();
        } else {
            this.chemicalName = "";
            this.thisStructuralFormula = "";
            this.thisFormula = "";
            if (this.nAtoms == this.atomSetCollection.getAtomCount()) {
                this.atomSetCollection.removeCurrentAtomSet();
            } else {
                this.applySymmetryAndSetTrajectory();
            }
            this.iHaveDesiredModel = this.isLastModel(this.modelNumber);
        }
    }

    protected void finalizeReader() throws Exception {
        if (this.vBiomolecules != null && this.vBiomolecules.size() == 1 && this.atomSetCollection.getAtomCount() > 0) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("biomolecules", this.vBiomolecules);
            this.setBiomolecules();
            if (this.vBiomts != null && this.vBiomts.size() > 1) {
                this.atomSetCollection.applySymmetryBio(this.vBiomts, this.notionalUnitCell, this.applySymmetryToBonds, this.filter);
            }
        }
        this.finalizeReaderASCR();
        String string = this.tokenizer.getFileHeader();
        if (string.length() > 0) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("fileHeader", string);
        }
        if (this.haveAromatic) {
            this.addJmolScript("calculate aromatic");
        }
    }

    private void setBiomolecules() {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setIdentity();
        if (this.assemblyIdAtoms == null) {
            return;
        }
        int n = this.vBiomolecules.size();
        while (--n >= 0) {
            Map map = (Map)this.vBiomolecules.get(n);
            String[] stringArray = TextFormat.split((String)map.get("operators"), ',');
            String string = (String)map.get("assemblies");
            this.vBiomts = new JmolList();
            map.put("biomts", this.vBiomts);
            this.vBiomts.addLast(matrix4f);
            for (int i = 0; i < stringArray.length; ++i) {
                Matrix4f matrix4f2 = this.htBiomts.get(stringArray[i]);
                if (matrix4f2 == null || matrix4f2.equals(matrix4f)) continue;
                this.vBiomts.addLast(matrix4f2);
            }
            if (this.vBiomts.size() < 2) {
                return;
            }
            BS bS = new BS();
            int n2 = string.length() - 1;
            while (--n2 >= 0) {
                BS bS2;
                if (string.charAt(n2) != '$' || (bS2 = this.assemblyIdAtoms.get("" + string.charAt(n2 + 1))) == null) continue;
                bS.or(bS2);
            }
            n2 = bS.cardinality();
            if (n2 < this.atomSetCollection.getAtomCount()) {
                this.atomSetCollection.bsAtoms = bS;
            }
            map.put("atomCount", n2 * stringArray.length);
        }
    }

    public void applySymmetryAndSetTrajectory() throws Exception {
        this.atomSetCollection.setCheckSpecial(!this.isPDB);
        boolean bl = this.doCheckUnitCell && !this.isPDB;
        this.applySymTrajASCR();
        if (bl && (this.bondTypes.size() > 0 || this.isMolecular)) {
            this.setBondingAndMolecules();
        }
    }

    private void processDataParameter() {
        this.bondTypes.clear();
        this.tokenizer.getTokenPeeked();
        String string = this.thisDataSetName = this.key.length() < 6 ? "" : this.key.substring(5);
        if (this.thisDataSetName.length() > 0) {
            this.nextAtomSet();
        }
        if (Logger.debugging) {
            Logger.debug(this.key);
        }
    }

    private void nextAtomSet() {
        this.atomSetCollection.setAtomSetAuxiliaryInfo("isCIF", Boolean.TRUE);
        if (this.atomSetCollection.getCurrentAtomSetIndex() >= 0) {
            this.atomSetCollection.newAtomSet();
        } else {
            this.atomSetCollection.setCollectionName(this.thisDataSetName);
        }
    }

    private String processChemicalInfo(String string) throws Exception {
        if (string.equals("name")) {
            this.chemicalName = this.data = this.tokenizer.fullTrim(this.data);
            if (!this.data.equals("?")) {
                this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("modelLoadNote", this.data);
            }
        } else if (string.equals("structuralFormula")) {
            this.thisStructuralFormula = this.data = this.tokenizer.fullTrim(this.data);
        } else if (string.equals("formula")) {
            this.thisFormula = this.data = this.tokenizer.fullTrim(this.data);
        }
        if (Logger.debugging) {
            Logger.debug(string + " = " + this.data);
        }
        return this.data;
    }

    private void processSymmetrySpaceGroupName() throws Exception {
        this.incommensurate = this.key.indexOf("_ssg_") >= 0;
        this.setSpaceGroupName((this.key.indexOf("h-m") > 0 ? "HM:" : (this.incommensurate ? "SSG:" : "Hall:")) + this.data);
    }

    private void processCellParameter() throws Exception {
        int n = JmolAdapter.cellParamNames.length;
        while (--n >= 0) {
            if (!CifReader.isMatch(this.key, JmolAdapter.cellParamNames[n])) continue;
            this.setUnitCellItem(n, this.parseFloatStr(this.data));
            return;
        }
    }

    private void processUnitCellTransformMatrix() throws Exception {
        float f = this.parseFloatStr(this.data);
        if (Float.isNaN(f)) {
            return;
        }
        for (int i = 0; i < TransformFields.length; ++i) {
            if (this.key.indexOf(TransformFields[i]) < 0) continue;
            this.setUnitCellItem(6 + i, f);
            return;
        }
    }

    private boolean getData() throws Exception {
        this.key = this.tokenizer.getTokenPeeked();
        this.data = this.tokenizer.getNextToken();
        if (Logger.debugging) {
            Logger.debug(this.key + " " + this.data);
        }
        if (this.data == null) {
            Logger.warn("CIF ERROR ? end of file; data missing: " + this.key);
            return false;
        }
        return this.data.length() == 0 || this.data.charAt(0) != '\u0000';
    }

    private void processLoopBlock() throws Exception {
        this.tokenizer.getTokenPeeked();
        String string = this.tokenizer.peekToken();
        if (string == null) {
            return;
        }
        boolean bl = false;
        if (string.startsWith("_atom_site_") || string.startsWith("_atom_site.") || (bl = string.equals("_chem_comp_atom.comp_id"))) {
            if (!this.processAtomSiteLoopBlock(bl)) {
                return;
            }
            this.atomSetCollection.setAtomSetName(this.thisDataSetName);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("chemicalName", this.chemicalName);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("structuralFormula", this.thisStructuralFormula);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("formula", this.thisFormula);
            return;
        }
        if (string.startsWith("_atom_type")) {
            this.processAtomTypeLoopBlock();
            return;
        }
        if (string.startsWith("_chem_comp_bond")) {
            this.processLigandBondLoopBlock();
            return;
        }
        if (string.startsWith("_geom_bond")) {
            if (!this.doApplySymmetry) {
                this.isMolecular = true;
                this.doApplySymmetry = true;
                this.latticeCells[0] = 1;
                this.latticeCells[1] = 1;
                this.latticeCells[2] = 1;
            }
            if (this.isMolecular) {
                this.processGeomBondLoopBlock();
            } else {
                this.skipLoop();
            }
            return;
        }
        if (string.startsWith("_pdbx_entity_nonpoly")) {
            this.processNonpolyLoopBlock();
            return;
        }
        if (string.startsWith("_chem_comp")) {
            this.processChemCompLoopBlock();
            return;
        }
        if (string.startsWith("_struct_conf") && !string.startsWith("_struct_conf_type")) {
            this.processStructConfLoopBlock();
            return;
        }
        if (string.startsWith("_struct_sheet_range")) {
            this.processStructSheetRangeLoopBlock();
            return;
        }
        if (string.startsWith("_symmetry_equiv_pos") || string.startsWith("_space_group_symop") || string.startsWith("_symmetry_ssg_equiv")) {
            if (this.ignoreFileSymmetryOperators) {
                Logger.warn("ignoring file-based symmetry operators");
                this.skipLoop();
            } else {
                this.processSymmetryOperationsLoopBlock();
            }
            return;
        }
        if (string.startsWith("_struct_site")) {
            this.processStructSiteBlock();
            return;
        }
        if (string.startsWith("_pdbx_struct_oper_list")) {
            this.processStructOperListBlock();
            return;
        }
        if (string.startsWith("_pdbx_struct_assembly_gen")) {
            this.processAssemblyGenBlock();
            return;
        }
        this.skipLoop();
    }

    private void processAtomTypeLoopBlock() throws Exception {
        this.parseLoopParameters(atomTypeFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            String string = null;
            float f = Float.NaN;
            block7: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block7;
                    }
                    case 0: {
                        string = this.field;
                        continue block7;
                    }
                    case 1: {
                        f = this.parseFloatStr(this.field);
                    }
                }
            }
            if (string == null || Float.isNaN(f)) continue;
            if (this.atomTypes == null) {
                this.atomTypes = new Hashtable<String, Float>();
            }
            this.atomTypes.put(string, Float.valueOf(f));
        }
    }

    boolean processAtomSiteLoopBlock(boolean bl) throws Exception {
        int n = -1;
        boolean bl2 = false;
        char c = '\u0000';
        this.parseLoopParameters(atomFields);
        if (this.fieldOf[55] != -1) {
            this.isPDB = false;
            this.setFractionalCoordinates(false);
        } else if (this.fieldOf[6] != -1 || this.fieldOf[52] != -1) {
            this.setFractionalCoordinates(false);
            this.disableField(3);
            this.disableField(4);
            this.disableField(5);
        } else if (this.fieldOf[3] != -1) {
            this.setFractionalCoordinates(true);
            this.disableField(6);
            this.disableField(7);
            this.disableField(8);
        } else if (this.fieldOf[20] != -1) {
            bl2 = true;
        } else if (this.fieldOf[21] != -1) {
            bl2 = true;
        } else {
            this.skipLoop();
            return false;
        }
        int n2 = -1;
        int n3 = -1;
        while (this.tokenizer.getData()) {
            int n4;
            Atom atom = new Atom();
            c = '\u0000';
            if (this.isPDBX) {
                if (n3 == -1) {
                    for (n4 = 0; n4 < this.tokenizer.fieldCount; ++n4) {
                        if (this.fieldProperty(n4) != 17) continue;
                        n3 = n4;
                        break;
                    }
                    if (n3 == -1) {
                        n3 = -2;
                    }
                }
                if (n3 >= 0) {
                    this.fieldProperty(n3);
                    n4 = this.parseIntStr(this.field);
                    if (n4 != n) {
                        if (this.iHaveDesiredModel) {
                            this.skipLoop();
                            this.skipping = false;
                            this.continuing = true;
                            break;
                        }
                        n = n4;
                        this.newModel(n4);
                        if (!this.skipping) {
                            this.nextAtomSet();
                        }
                    }
                    if (this.skipping) continue;
                }
            }
            block32: for (n4 = 0; n4 < this.tokenizer.fieldCount; ++n4) {
                switch (this.fieldProperty(n4)) {
                    case -1: 
                    case 17: {
                        continue block32;
                    }
                    case 0: 
                    case 50: {
                        char c2;
                        String string = this.field.length() < 2 ? this.field : (Atom.isValidElementSymbol2(this.firstChar, c2 = Character.toLowerCase(this.field.charAt(1))) ? "" + this.firstChar + c2 : "" + this.firstChar);
                        atom.elementSymbol = string;
                        if (this.atomTypes == null || !this.atomTypes.containsKey(this.field)) continue block32;
                        float f = this.atomTypes.get(this.field).floatValue();
                        atom.formalCharge = Math.round(f);
                        if (!((double)Math.abs((float)atom.formalCharge - f) > 0.1) || !Logger.debugging) continue block32;
                        Logger.debug("CIF charge on " + this.field + " was " + f + "; rounded to " + atom.formalCharge);
                        continue block32;
                    }
                    case 1: 
                    case 2: 
                    case 49: {
                        atom.atomName = this.field;
                        continue block32;
                    }
                    case 55: {
                        float f = this.parseFloatStr(this.field);
                        if (Float.isNaN(f)) continue block32;
                        atom.x = f;
                        continue block32;
                    }
                    case 56: {
                        float f = this.parseFloatStr(this.field);
                        if (Float.isNaN(f)) continue block32;
                        atom.y = f;
                        continue block32;
                    }
                    case 57: {
                        float f = this.parseFloatStr(this.field);
                        if (Float.isNaN(f)) continue block32;
                        atom.z = f;
                        continue block32;
                    }
                    case 3: 
                    case 6: 
                    case 52: {
                        atom.x = this.parseFloatStr(this.field);
                        continue block32;
                    }
                    case 4: 
                    case 7: 
                    case 53: {
                        atom.y = this.parseFloatStr(this.field);
                        continue block32;
                    }
                    case 5: 
                    case 8: 
                    case 54: {
                        atom.z = this.parseFloatStr(this.field);
                        continue block32;
                    }
                    case 51: {
                        atom.formalCharge = this.parseIntStr(this.field);
                        continue block32;
                    }
                    case 9: {
                        float f = this.parseFloatStr(this.field);
                        if (Float.isNaN(f)) continue block32;
                        atom.occupancy = (int)(f * 100.0f);
                        continue block32;
                    }
                    case 10: {
                        atom.bfactor = this.parseFloatStr(this.field) * (this.isPDB ? 1.0f : 100.0f);
                        continue block32;
                    }
                    case 11: 
                    case 48: {
                        atom.group3 = this.field;
                        continue block32;
                    }
                    case 59: {
                        c = this.firstChar;
                        continue block32;
                    }
                    case 12: {
                        if (!this.haveChainsLC && !this.field.toUpperCase().equals(this.field)) {
                            this.haveChainsLC = this.viewer.getChainID("lc") != 0;
                        }
                        atom.chainID = this.viewer.getChainID(this.field);
                        continue block32;
                    }
                    case 13: {
                        atom.sequenceNumber = this.parseIntStr(this.field);
                        continue block32;
                    }
                    case 14: {
                        atom.insertionCode = this.firstChar;
                        continue block32;
                    }
                    case 15: {
                        atom.alternateLocationID = this.firstChar;
                        continue block32;
                    }
                    case 58: {
                        this.disorderAssembly = this.field;
                        continue block32;
                    }
                    case 19: {
                        if (this.firstChar == '-' && this.field.length() > 1) {
                            atom.alternateLocationID = this.field.charAt(1);
                            atom.ignoreSymmetry = true;
                            continue block32;
                        }
                        atom.alternateLocationID = this.firstChar;
                        continue block32;
                    }
                    case 16: {
                        this.isPDB = true;
                        if (!"HETATM".equals(this.field)) continue block32;
                        atom.isHetero = true;
                        continue block32;
                    }
                    case 18: {
                        if (!"dum".equals(this.field)) continue block32;
                        atom.x = Float.NaN;
                        continue block32;
                    }
                    case 47: {
                        int n5;
                        if (!this.field.equalsIgnoreCase("Uiso") || (n5 = this.fieldOf[34]) == -1) continue block32;
                        float[] fArray = this.atomSetCollection.getAnisoBorU(atom);
                        if (fArray == null) {
                            fArray = new float[8];
                            this.atomSetCollection.setAnisoBorU(atom, fArray, 8);
                        }
                        fArray[7] = this.parseFloatStr(this.tokenizer.loopData[n5]);
                        continue block32;
                    }
                    case 20: {
                        n2 = this.atomSetCollection.getAtomIndexFromName(this.field);
                        if (n2 < 0) continue block32;
                        atom = this.atomSetCollection.getAtom(n2);
                        continue block32;
                    }
                    case 21: {
                        atom = this.atomSetCollection.getAtom(++n2);
                        continue block32;
                    }
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: {
                        float[] fArray = this.atomSetCollection.getAnisoBorU(atom);
                        if (fArray == null) {
                            fArray = new float[8];
                            this.atomSetCollection.setAnisoBorU(atom, fArray, 8);
                        }
                        int n5 = (this.propertyOf[n4] - 22) % 6;
                        fArray[n5] = this.parseFloatStr(this.field);
                        continue block32;
                    }
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        float[] fArray = this.atomSetCollection.getAnisoBorU(atom);
                        if (fArray == null) {
                            fArray = new float[8];
                            this.atomSetCollection.setAnisoBorU(atom, fArray, 4);
                        }
                        int n6 = (this.propertyOf[n4] - 35) % 6;
                        fArray[n6] = this.parseFloatStr(this.field);
                        continue block32;
                    }
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: {
                        float[] fArray = this.atomSetCollection.getAnisoBorU(atom);
                        if (fArray == null) {
                            fArray = new float[8];
                            this.atomSetCollection.setAnisoBorU(atom, fArray, 0);
                        }
                        int n7 = (this.propertyOf[n4] - 41) % 6;
                        fArray[n7] = this.parseFloatStr(this.field);
                    }
                }
            }
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn("atom " + atom.atomName + " has invalid/unknown coordinates");
                continue;
            }
            if (bl2 || !this.filterCIFAtom(atom, n2, c)) continue;
            this.setAtomCoord(atom);
            if (atom.elementSymbol == null && atom.atomName != null) {
                int n8;
                String string = atom.atomName;
                for (n8 = 0; n8 < string.length() && Character.isLetter(string.charAt(n8)); ++n8) {
                }
                atom.elementSymbol = n8 == 0 || n8 > 2 ? "Xx" : string.substring(0, n8);
            }
            this.atomSetCollection.addAtomWithMappedName(atom);
            if (c != '\u0000') {
                BS bS;
                if (this.assemblyIdAtoms == null) {
                    this.assemblyIdAtoms = new Hashtable<String, BS>();
                }
                if ((bS = this.assemblyIdAtoms.get("" + c)) == null) {
                    bS = new BS();
                    this.assemblyIdAtoms.put("" + c, bS);
                }
                bS.set(atom.index);
            }
            if (!atom.isHetero || this.htHetero == null) continue;
            this.atomSetCollection.setAtomSetAuxiliaryInfo("hetNames", this.htHetero);
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("hetNames", this.htHetero);
            this.htHetero = null;
        }
        if (this.isPDB) {
            this.setIsPDB();
        }
        this.atomSetCollection.setAtomSetAuxiliaryInfo("isCIF", Boolean.TRUE);
        if (this.isPDBX && this.skipping) {
            this.skipping = false;
        }
        return true;
    }

    protected boolean filterCIFAtom(Atom atom, int n, char c) {
        if (!this.filterAtom(atom, n)) {
            return false;
        }
        if (this.filterAssembly && this.filterReject(this.filter, "$", "" + c)) {
            return false;
        }
        if (this.configurationPtr > 0) {
            if (!this.disorderAssembly.equals(this.lastDisorderAssembly)) {
                this.lastDisorderAssembly = this.disorderAssembly;
                this.lastAltLoc = '\u0000';
                this.conformationIndex = this.configurationPtr;
            }
            if (atom.alternateLocationID != '\u0000') {
                if (this.conformationIndex >= 0 && atom.alternateLocationID != this.lastAltLoc) {
                    this.lastAltLoc = atom.alternateLocationID;
                    --this.conformationIndex;
                }
                if (this.conformationIndex != 0) {
                    Logger.info("ignoring " + atom.atomName);
                    return false;
                }
            }
        }
        return true;
    }

    private void processAssemblyGen() throws Exception {
        if (this.assem == null) {
            this.assem = new String[3];
        }
        if (this.key.indexOf("assembly_id") >= 0) {
            this.assem[0] = this.data = this.tokenizer.fullTrim(this.data);
        } else if (this.key.indexOf("oper_expression") >= 0) {
            this.assem[1] = this.data = this.tokenizer.fullTrim(this.data);
        } else if (this.key.indexOf("asym_id_list") >= 0) {
            this.assem[2] = this.data = this.tokenizer.fullTrim(this.data);
        }
        if (this.assem[0] != null && this.assem[1] != null && this.assem[2] != null) {
            this.addAssembly();
        }
    }

    private void processAssemblyGenBlock() throws Exception {
        this.parseLoopParameters(assemblyFields);
        this.assem = new String[3];
        while (this.tokenizer.getData()) {
            int n = 0;
            for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                int n2 = this.fieldProperty(i);
                switch (n2) {
                    case 0: 
                    case 1: 
                    case 2: {
                        ++n;
                        this.assem[n2] = this.field;
                    }
                }
            }
            if (n != 3) continue;
            this.addAssembly();
        }
        this.assem = null;
    }

    private void addAssembly() throws Exception {
        int n = this.parseIntStr(this.assem[0]);
        if (!this.checkFilterKey("ASSEMBLY " + n + ";")) {
            return;
        }
        if (this.vBiomolecules == null) {
            this.vBiomolecules = new JmolList();
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("molecule", n);
        hashtable.put("assemblies", "$" + this.assem[2].replace(',', '$'));
        hashtable.put("operators", this.assem[1]);
        hashtable.put("biomts", new JmolList());
        Logger.info("assembly " + n + " operators " + this.assem[1] + " ASYM_IDs " + this.assem[2]);
        this.vBiomolecules.addLast((Map<String, Object>)hashtable);
        this.assem = null;
    }

    private void processStructOperListBlock() throws Exception {
        this.parseLoopParameters(operFields);
        float[] fArray = new float[16];
        fArray[15] = 1.0f;
        while (this.tokenizer.getData()) {
            int n = 0;
            String string = null;
            String string2 = null;
            block6: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                int n2 = this.fieldProperty(i);
                switch (n2) {
                    case -1: {
                        continue block6;
                    }
                    case 12: {
                        string = this.field;
                        continue block6;
                    }
                    case 13: {
                        string2 = this.field;
                        continue block6;
                    }
                    default: {
                        fArray[n2] = this.parseFloatStr(this.field);
                        ++n;
                    }
                }
            }
            if (string == null || n != 12 && (string2 == null || this.symmetry == null)) continue;
            Logger.info("assembly operator " + string + " " + string2);
            Matrix4f matrix4f = new Matrix4f();
            if (n != 12) {
                this.symmetry.getMatrixFromString(string2, fArray, false);
                fArray[3] = fArray[3] * (this.symmetry.getUnitCellInfoType(0) / 12.0f);
                fArray[7] = fArray[7] * (this.symmetry.getUnitCellInfoType(1) / 12.0f);
                fArray[11] = fArray[11] * (this.symmetry.getUnitCellInfoType(2) / 12.0f);
            }
            matrix4f.setA(fArray);
            if (this.htBiomts == null) {
                this.htBiomts = new Hashtable<String, Matrix4f>();
            }
            this.htBiomts.put(string, matrix4f);
        }
    }

    private void processLigandBondLoopBlock() throws Exception {
        this.parseLoopParameters(chemCompBondFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            Logger.warn("?que? missing _chem_comp_bond property:" + n);
            this.skipLoop();
            return;
        }
        n = 0;
        boolean bl = false;
        while (this.tokenizer.getData()) {
            int n2 = -1;
            int n3 = -1;
            n = 0;
            bl = false;
            block12: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case 0: {
                        n2 = this.atomSetCollection.getAtomIndexFromName(this.field);
                        continue block12;
                    }
                    case 1: {
                        n3 = this.atomSetCollection.getAtomIndexFromName(this.field);
                        continue block12;
                    }
                    case 3: {
                        bl = this.field.charAt(0) == 'Y';
                        continue block12;
                    }
                    case 2: {
                        n = this.getBondOrder(this.field);
                    }
                }
            }
            if (n2 < 0 || n3 < 0) continue;
            if (bl) {
                switch (n) {
                    case 1: {
                        n = 513;
                        break;
                    }
                    case 2: {
                        n = 514;
                    }
                }
            }
            this.atomSetCollection.addNewBondWithOrder(n2, n3, n);
        }
    }

    private int getBondOrder(String string) {
        switch (string.charAt(0)) {
            default: {
                Logger.warn("unknown CIF bond order: " + string);
            }
            case 'S': {
                return 1;
            }
            case 'D': {
                return 2;
            }
            case 'T': {
                return 3;
            }
            case 'A': 
        }
        this.haveAromatic = true;
        return 515;
    }

    private void processGeomBondLoopBlock() throws Exception {
        this.parseLoopParameters(geomBondFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.propertyOf[n] == 3 || this.fieldOf[n] != -1) continue;
            Logger.warn("?que? missing _geom_bond property:" + n);
            this.skipLoop();
            return;
        }
        String string = null;
        String string2 = null;
        Integer n2 = 1;
        while (this.tokenizer.getData()) {
            int n3 = -1;
            int n4 = -1;
            float f = 0.0f;
            float f2 = 0.0f;
            block9: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block9;
                    }
                    case 0: {
                        string = this.field;
                        n3 = this.atomSetCollection.getAtomIndexFromName(string);
                        continue block9;
                    }
                    case 1: {
                        string2 = this.field;
                        n4 = this.atomSetCollection.getAtomIndexFromName(string2);
                        continue block9;
                    }
                    case 2: {
                        f = this.parseFloatStr(this.field);
                        int n5 = this.field.indexOf(40);
                        if (n5 >= 0) {
                            char[] cArray = this.field.toCharArray();
                            String string3 = this.field.substring(n5 + 1, this.field.length() - 1);
                            int n6 = string3.length();
                            int n7 = n5;
                            while (--n7 >= 0) {
                                if (cArray[n7] == '.') {
                                    --n7;
                                }
                                cArray[n7] = --n6 < 0 ? 48 : (int)string3.charAt(n6);
                            }
                            f2 = this.parseFloatStr(String.valueOf(cArray));
                            if (!Float.isNaN(f2)) continue block9;
                            Logger.info("error reading uncertainty for " + this.line);
                            f2 = 0.015f;
                            continue block9;
                        }
                        f2 = 0.015f;
                        continue block9;
                    }
                    case 3: {
                        n2 = this.getBondOrder(this.field);
                    }
                }
            }
            if (n3 < 0 || n4 < 0 || !(f > 0.0f)) continue;
            this.bondTypes.addLast(new Object[]{string, string2, Float.valueOf(f), Float.valueOf(f2), n2});
        }
    }

    private void processNonpolyData() {
        if (this.hetatmData == null) {
            this.hetatmData = new String[3];
        }
        int n = nonpolyFields.length;
        while (--n >= 0) {
            if (!CifReader.isMatch(this.key, nonpolyFields[n])) continue;
            this.hetatmData[n] = this.data;
            break;
        }
        if (this.hetatmData[1] == null || this.hetatmData[2] == null) {
            return;
        }
        this.addHetero(this.hetatmData[2], this.hetatmData[1]);
        this.hetatmData = null;
    }

    private void processChemCompLoopBlock() throws Exception {
        this.parseLoopParameters(chemCompFields);
        while (this.tokenizer.getData()) {
            String string = null;
            String string2 = null;
            block6: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block6;
                    }
                    case 0: {
                        string = this.field;
                        continue block6;
                    }
                    case 1: {
                        string2 = this.field;
                    }
                }
            }
            if (string == null || string2 == null) continue;
            this.addHetero(string, string2);
        }
    }

    private void processNonpolyLoopBlock() throws Exception {
        this.parseLoopParameters(nonpolyFields);
        while (this.tokenizer.getData()) {
            String string = null;
            String string2 = null;
            block6: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: 
                    case 0: {
                        continue block6;
                    }
                    case 2: {
                        string = this.field;
                        continue block6;
                    }
                    case 1: {
                        string2 = this.field;
                    }
                }
            }
            if (string == null || string2 == null) {
                return;
            }
            this.addHetero(string, string2);
        }
    }

    private void addHetero(String string, String string2) {
        if (!JmolAdapter.isHetero(string)) {
            return;
        }
        if (this.htHetero == null) {
            this.htHetero = new Hashtable<String, String>();
        }
        this.htHetero.put(string, string2);
        if (Logger.debugging) {
            Logger.debug("hetero: " + string + " = " + string2);
        }
    }

    private void processStructConfLoopBlock() throws Exception {
        this.parseLoopParameters(structConfFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            Logger.warn("?que? missing _struct_conf property:" + n);
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            Structure structure = new Structure(-1, EnumStructure.HELIX, EnumStructure.HELIX, null, 0, 0);
            block15: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block15;
                    }
                    case 0: {
                        if (this.field.startsWith("TURN")) {
                            structure.structureType = structure.substructureType = EnumStructure.TURN;
                            continue block15;
                        }
                        if (this.field.startsWith("HELX")) continue block15;
                        structure.structureType = structure.substructureType = EnumStructure.NONE;
                        continue block15;
                    }
                    case 1: {
                        structure.startChainStr = this.field;
                        structure.startChainID = this.viewer.getChainID(this.field);
                        continue block15;
                    }
                    case 2: {
                        structure.startSequenceNumber = this.parseIntStr(this.field);
                        continue block15;
                    }
                    case 3: {
                        structure.startInsertionCode = this.firstChar;
                        continue block15;
                    }
                    case 4: {
                        structure.endChainStr = this.field;
                        structure.endChainID = this.viewer.getChainID(this.field);
                        continue block15;
                    }
                    case 5: {
                        structure.endSequenceNumber = this.parseIntStr(this.field);
                        continue block15;
                    }
                    case 9: {
                        structure.substructureType = Structure.getHelixType(this.parseIntStr(this.field));
                        continue block15;
                    }
                    case 6: {
                        structure.endInsertionCode = this.firstChar;
                        continue block15;
                    }
                    case 7: {
                        structure.structureID = this.field;
                        continue block15;
                    }
                    case 8: {
                        structure.serialID = this.parseIntStr(this.field);
                    }
                }
            }
            this.atomSetCollection.addStructure(structure);
        }
    }

    private void processStructSheetRangeLoopBlock() throws Exception {
        this.parseLoopParameters(structSheetRangeFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            Logger.warn("?que? missing _struct_conf property:" + n);
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            Structure structure = new Structure(-1, EnumStructure.SHEET, EnumStructure.SHEET, null, 0, 0);
            block12: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case 1: {
                        structure.startChainID = this.viewer.getChainID(this.field);
                        continue block12;
                    }
                    case 2: {
                        structure.startSequenceNumber = this.parseIntStr(this.field);
                        continue block12;
                    }
                    case 3: {
                        structure.startInsertionCode = this.firstChar;
                        continue block12;
                    }
                    case 4: {
                        structure.endChainID = this.viewer.getChainID(this.field);
                        continue block12;
                    }
                    case 5: {
                        structure.endSequenceNumber = this.parseIntStr(this.field);
                        continue block12;
                    }
                    case 6: {
                        structure.endInsertionCode = this.firstChar;
                        continue block12;
                    }
                    case 0: {
                        structure.strandCount = 1;
                        structure.structureID = this.field;
                        continue block12;
                    }
                    case 7: {
                        structure.serialID = this.parseIntStr(this.field);
                    }
                }
            }
            this.atomSetCollection.addStructure(structure);
        }
    }

    private void processStructSiteBlock() throws Exception {
        this.parseLoopParameters(structSiteRangeFields);
        int n = 3;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            Logger.warn("?que? missing _struct_site property:" + n);
            this.skipLoop();
            return;
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        Map<String, Object> map = null;
        this.htSites = new Hashtable<String, Map<String, Object>>();
        while (this.tokenizer.getData()) {
            for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case 0: {
                        if (string6 != "") {
                            String string7 = (String)map.get("groups");
                            string7 = string7 + (string7.length() == 0 ? "" : ",") + string6;
                            string6 = "";
                            map.put("groups", string7);
                        }
                        if ((map = this.htSites.get(string = this.field)) == null) {
                            map = new Hashtable<String, Object>();
                            map.put("groups", "");
                            this.htSites.put(string, map);
                        }
                        string2 = "";
                        string3 = "";
                        string4 = "";
                        string5 = "";
                        break;
                    }
                    case 1: {
                        string5 = this.field;
                        break;
                    }
                    case 2: {
                        string4 = this.field;
                        break;
                    }
                    case 3: {
                        string2 = this.field;
                        break;
                    }
                    case 4: {
                        string3 = this.field;
                    }
                }
                if (string2 == "" || string5 == "") continue;
                string6 = "[" + string5 + "]" + string2 + (string3.length() > 0 ? "^" + string3 : "") + (string4.length() > 0 ? ":" + string4 : "");
            }
        }
        if (string6 != "") {
            String string8 = (String)map.get("groups");
            string8 = string8 + (string8.length() == 0 ? "" : ",") + string6;
            string6 = "";
            map.put("groups", string8);
        }
    }

    private void processSymmetryOperationsLoopBlock() throws Exception {
        this.parseLoopParameters(symmetryOperationsFields);
        int n = 0;
        int n2 = this.propertyCount;
        while (--n2 >= 0) {
            if (this.fieldOf[n2] == -1) continue;
            ++n;
        }
        if (n != 1) {
            Logger.warn("?que? _symmetry_equiv or _space_group_symop property not found");
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            for (n2 = 0; n2 < this.tokenizer.fieldCount; ++n2) {
                switch (this.fieldProperty(n2)) {
                    case 2: {
                        if (this.field.indexOf(126) >= 0) {
                            this.field = TextFormat.simpleReplace(this.field, "~", "");
                        }
                    }
                    case 0: 
                    case 1: 
                    case 3: {
                        this.setSymmetryOperator(this.field);
                    }
                }
            }
        }
    }

    private int fieldProperty(int n) {
        this.field = this.tokenizer.loopData[n];
        return this.field.length() > 0 && (this.firstChar = this.field.charAt(0)) != '\u0000' ? this.propertyOf[n] : -1;
    }

    private void parseLoopParameters(String[] stringArray) throws Exception {
        this.tokenizer.fieldCount = 0;
        int n = stringArray.length;
        while (--n >= 0) {
            this.fieldOf[n] = -1;
        }
        this.propertyCount = stringArray.length;
        while (true) {
            String string;
            if ((string = this.tokenizer.peekToken()) == null) {
                this.tokenizer.fieldCount = 0;
                break;
            }
            if (string.charAt(0) != '_') break;
            this.tokenizer.getTokenPeeked();
            this.propertyOf[this.tokenizer.fieldCount] = -1;
            int n2 = stringArray.length;
            while (--n2 >= 0) {
                if (!CifReader.isMatch(string, stringArray[n2])) continue;
                this.propertyOf[this.tokenizer.fieldCount] = n2;
                this.fieldOf[n2] = (byte)this.tokenizer.fieldCount;
                break;
            }
            ++this.tokenizer.fieldCount;
        }
        if (this.tokenizer.fieldCount > 0) {
            this.tokenizer.loopData = new String[this.tokenizer.fieldCount];
        }
    }

    private void disableField(int n) {
        byte by = this.fieldOf[n];
        if (by != -1) {
            this.propertyOf[by] = -1;
        }
    }

    private void skipLoop() throws Exception {
        String string;
        while ((string = this.tokenizer.peekToken()) != null && string.charAt(0) == '_') {
            string = this.tokenizer.getTokenPeeked();
        }
        while (this.tokenizer.getNextDataToken() != null) {
        }
    }

    private static boolean isMatch(String string, String string2) {
        int n = string.length();
        if (string2.length() != n) {
            return false;
        }
        int n2 = n;
        while (--n2 >= 0) {
            char c;
            char c2 = string.charAt(n2);
            if (c2 == (c = string2.charAt(n2)) || (c2 == '_' || c2 == '.') && (c == '_' || c == '.')) continue;
            if (c2 <= 'Z' && c2 >= 'A') {
                c2 = (char)(c2 + 32);
            } else if (c <= 'Z' && c >= 'A') {
                c = (char)(c + 32);
            }
            if (c2 == c) continue;
            return false;
        }
        return true;
    }

    private void setBondingAndMolecules() {
        int n;
        int n2;
        Logger.info("CIF creating molecule " + (this.bondTypes.size() > 0 ? " using GEOM_BOND records" : ""));
        this.atoms = this.atomSetCollection.getAtoms();
        this.firstAtom = this.atomSetCollection.getLastAtomSetAtomIndex();
        int n3 = this.atomSetCollection.getLastAtomSetAtomCount();
        this.atomCount = this.firstAtom + n3;
        this.bsSets = new BS[n3];
        this.symmetry = this.atomSetCollection.getSymmetry();
        for (n2 = this.firstAtom; n2 < this.atomCount; ++n2) {
            n = this.atomSetCollection.getAtomIndexFromName(this.atoms[n2].atomName) - this.firstAtom;
            if (this.bsSets[n] == null) {
                this.bsSets[n] = new BS();
            }
            this.bsSets[n].set(n2 - this.firstAtom);
        }
        if (this.isMolecular) {
            this.atomRadius = new float[this.atomCount];
            for (n2 = this.firstAtom; n2 < this.atomCount; ++n2) {
                int n4;
                n = JmolAdapter.getElementNumber(this.atoms[n2].getElementSymbol());
                this.atoms[n2].elementNumber = (short)n;
                int n5 = n4 = this.atoms[n2].formalCharge == Integer.MIN_VALUE ? 0 : this.atoms[n2].formalCharge;
                if (n <= 0) continue;
                this.atomRadius[n2] = JmolAdapter.getBondingRadiusFloat(n, n4);
            }
            this.bsConnected = new BS[this.atomCount];
            for (n2 = this.firstAtom; n2 < this.atomCount; ++n2) {
                this.bsConnected[n2] = new BS();
            }
            this.bsMolecule = new BS();
            this.bsExclude = new BS();
        }
        n2 = 1;
        while (this.createBonds(n2 != 0)) {
            n2 = 0;
        }
        if (this.isMolecular) {
            if (this.atomSetCollection.bsAtoms == null) {
                this.atomSetCollection.bsAtoms = new BS();
            }
            this.atomSetCollection.bsAtoms.clearBits(this.firstAtom, this.atomCount);
            this.atomSetCollection.bsAtoms.or(this.bsMolecule);
            this.atomSetCollection.bsAtoms.andNot(this.bsExclude);
            for (n = this.firstAtom; n < this.atomCount; ++n) {
                if (this.atomSetCollection.bsAtoms.get(n)) {
                    this.symmetry.toCartesian(this.atoms[n], true);
                    continue;
                }
                if (!Logger.debugging) continue;
                Logger.debug(this.molecularType + " removing " + n + " " + this.atoms[n].atomName + " " + this.atoms[n]);
            }
            this.atomSetCollection.setAtomSetAuxiliaryInfo("notionalUnitcell", null);
            if (this.nMolecular++ == this.atomSetCollection.getCurrentAtomSetIndex()) {
                this.atomSetCollection.clearGlobalBoolean(0);
                this.atomSetCollection.clearGlobalBoolean(1);
                this.atomSetCollection.clearGlobalBoolean(2);
            }
        }
        if (this.bondTypes.size() > 0) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("hasBonds", Boolean.TRUE);
        }
        this.atomSetCollection.setAtomSetAuxiliaryInfo("fileHasUnitCell", Boolean.TRUE);
        this.bondTypes.clear();
        this.atomRadius = null;
        this.bsSets = null;
        this.bsConnected = null;
        this.bsMolecule = null;
        this.bsExclude = null;
    }

    private boolean createBonds(boolean bl) {
        int n;
        BS bS;
        int n2;
        int n3;
        int n4;
        int n5 = this.bondTypes.size();
        while (--n5 >= 0) {
            Object[] objectArray = (Object[])this.bondTypes.get(n5);
            float f = ((Float)objectArray[2]).floatValue();
            float f2 = ((Float)objectArray[3]).floatValue();
            n4 = (Integer)objectArray[4];
            n3 = this.atomSetCollection.getAtomIndexFromName((String)objectArray[0]);
            n2 = this.atomSetCollection.getAtomIndexFromName((String)objectArray[1]);
            BS bS2 = this.bsSets[n3 - this.firstAtom];
            bS = this.bsSets[n2 - this.firstAtom];
            if (bS2 == null || bS == null) continue;
            n = bS2.nextSetBit(0);
            while (n >= 0) {
                int n6 = bS.nextSetBit(0);
                while (n6 >= 0) {
                    if (!(this.isMolecular && this.bsConnected[n + this.firstAtom].get(n6) || !this.symmetry.checkDistance(this.atoms[n + this.firstAtom], this.atoms[n6 + this.firstAtom], f, f2, 0, 0, 0, this.ptOffset))) {
                        this.addNewBond(n + this.firstAtom, n6 + this.firstAtom, n4);
                    }
                    n6 = bS.nextSetBit(n6 + 1);
                }
                n = bS2.nextSetBit(n + 1);
            }
        }
        if (this.bondTypes.size() > 0) {
            for (n5 = this.firstAtom; n5 < this.atomCount; ++n5) {
                if (this.atoms[n5].elementNumber != 1) continue;
                boolean bl2 = this.atoms[n5].alternateLocationID != '\u0000';
                for (int i = this.firstAtom; i < this.atomCount; ++i) {
                    if (i == n5 || this.atoms[i].elementNumber == 1 || bl2 && this.atoms[i].alternateLocationID != '\u0000' && this.atoms[i].alternateLocationID != this.atoms[n5].alternateLocationID || this.bsConnected[n5].get(i) || !this.symmetry.checkDistance(this.atoms[n5], this.atoms[i], 1.1f, 0.0f, 0, 0, 0, this.ptOffset)) continue;
                    this.addNewBond(n5, i, 1);
                }
            }
        }
        if (!this.isMolecular) {
            return false;
        }
        if (bl) {
            for (n5 = this.firstAtom; n5 < this.atomCount; ++n5) {
                if (this.atoms[n5].atomSite + this.firstAtom != n5 || this.bsMolecule.get(n5)) continue;
                this.setBs(this.atoms, n5, this.bsConnected, this.bsMolecule);
            }
        }
        float f = this.viewer.getFloat(0x22000004);
        BS bS3 = new BS();
        P3 p3 = new P3();
        P3 p32 = new P3();
        n4 = 2;
        for (n3 = this.firstAtom; n3 < this.atomCount; ++n3) {
            if (this.bsMolecule.get(n3) || this.bsExclude.get(n3)) continue;
            n2 = this.bsMolecule.nextSetBit(0);
            while (n2 >= 0) {
                if (this.symmetry.checkDistance(this.atoms[n2], this.atoms[n3], this.atomRadius[n3] + this.atomRadius[n2] + f, 0.0f, n4, n4, n4, this.ptOffset)) {
                    this.setBs(this.atoms, n3, this.bsConnected, bS3);
                    int n7 = bS3.nextSetBit(0);
                    while (n7 >= 0) {
                        this.atoms[n7].add(this.ptOffset);
                        p3.setT(this.atoms[n7]);
                        this.symmetry.toCartesian(p3, true);
                        bS = this.bsSets[this.atomSetCollection.getAtomIndexFromName(this.atoms[n7].atomName) - this.firstAtom];
                        if (bS != null) {
                            n = bS.nextSetBit(0);
                            while (n >= 0) {
                                if (n + this.firstAtom != n7) {
                                    p32.setT(this.atoms[n + this.firstAtom]);
                                    this.symmetry.toCartesian(p32, true);
                                    if (p32.distance(p3) < 0.1f) {
                                        this.bsExclude.set(n7);
                                        break;
                                    }
                                }
                                n = bS.nextSetBit(n + 1);
                            }
                        }
                        this.bsMolecule.set(n7);
                        n7 = bS3.nextSetBit(n7 + 1);
                    }
                    return true;
                }
                n2 = this.bsMolecule.nextSetBit(n2 + 1);
            }
        }
        return false;
    }

    private void addNewBond(int n, int n2, int n3) {
        this.atomSetCollection.addNewBondWithOrder(n, n2, n3);
        if (!this.isMolecular) {
            return;
        }
        this.bsConnected[n].set(n2);
        this.bsConnected[n2].set(n);
    }

    private void setBs(Atom[] atomArray, int n, BS[] bSArray, BS bS) {
        BS bS2 = bSArray[n];
        bS.set(n);
        int n2 = bS2.nextSetBit(0);
        while (n2 >= 0) {
            if (!bS.get(n2)) {
                this.setBs(atomArray, n2, bSArray, bS);
            }
            n2 = bS2.nextSetBit(n2 + 1);
        }
    }
}

