/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Map;
import org.jmol.script.SV;
import org.jmol.util.AxisAngle4f;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.JmolList;
import org.jmol.util.Matrix3f;
import org.jmol.util.Matrix4f;
import org.jmol.util.P3;
import org.jmol.util.P4;
import org.jmol.util.Parser;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.util.Tuple3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Escape {
    private static final String escapable = "\\\\\tt\rr\nn\"\"";

    public static String escapeColor(int n) {
        return n == 0 ? null : "[x" + Escape.getHexColorFromRGB(n) + "]";
    }

    public static String getHexColorFromRGB(int n) {
        if (n == 0) {
            return null;
        }
        String string = "00" + Integer.toHexString(n >> 16 & 0xFF);
        string = string.substring(string.length() - 2);
        String string2 = "00" + Integer.toHexString(n >> 8 & 0xFF);
        string2 = string2.substring(string2.length() - 2);
        String string3 = "00" + Integer.toHexString(n & 0xFF);
        string3 = string3.substring(string3.length() - 2);
        return string + string2 + string3;
    }

    public static String eP(Tuple3f tuple3f) {
        if (tuple3f == null) {
            return "null";
        }
        return "{" + tuple3f.x + " " + tuple3f.y + " " + tuple3f.z + "}";
    }

    public static String matrixToScript(Object object) {
        return TextFormat.replaceAllCharacters(object.toString(), "\n\r ", "").replace('\t', ' ');
    }

    public static String eP4(P4 p4) {
        return "{" + p4.x + " " + p4.y + " " + p4.z + " " + p4.w + "}";
    }

    public static String e(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return Escape.eS((String)object);
        }
        if (object instanceof JmolList) {
            return Escape.eV((JmolList)object);
        }
        if (object instanceof BS) {
            return Escape.eBS((BS)object);
        }
        if (object instanceof Tuple3f) {
            return Escape.eP((Tuple3f)object);
        }
        if (object instanceof P4) {
            return Escape.eP4((P4)object);
        }
        if (Escape.isAS(object)) {
            return Escape.eAS((String[])object, true);
        }
        if (Escape.isAI(object)) {
            return Escape.eAI((int[])object);
        }
        if (Escape.isAF(object)) {
            return Escape.eAF((float[])object);
        }
        if (Escape.isAD(object)) {
            return Escape.eAD((double[])object);
        }
        if (Escape.isAP(object)) {
            return Escape.eAP((P3[])object);
        }
        if (object instanceof Matrix3f) {
            return TextFormat.simpleReplace(((Matrix3f)object).toString(), "\t", ",\t");
        }
        if (object instanceof Matrix4f) {
            return TextFormat.simpleReplace(((Matrix4f)object).toString(), "\t", ",\t");
        }
        if (object instanceof AxisAngle4f) {
            AxisAngle4f axisAngle4f = (AxisAngle4f)object;
            return "{" + axisAngle4f.x + " " + axisAngle4f.y + " " + axisAngle4f.z + " " + (float)((double)axisAngle4f.angle * 180.0 / Math.PI) + "}";
        }
        if (object instanceof Map) {
            return Escape.escapeMap((Map)object);
        }
        if (Escape.isAII(object) || Escape.isAFF(object) || Escape.isAFFF(object)) {
            return Escape.toJSON(null, object);
        }
        return object.toString();
    }

    public static boolean isAS(Object object) {
        return object instanceof String[];
    }

    public static boolean isASS(Object object) {
        return object instanceof String[][];
    }

    public static boolean isAP(Object object) {
        return object instanceof P3[];
    }

    public static boolean isAF(Object object) {
        return object instanceof float[];
    }

    public static boolean isAFloat(Object object) {
        return object instanceof Float[];
    }

    public static boolean isAV(Object object) {
        return object instanceof SV[];
    }

    public static boolean isAD(Object object) {
        return object instanceof double[];
    }

    public static boolean isAB(Object object) {
        return object instanceof byte[];
    }

    public static boolean isAI(Object object) {
        return object instanceof int[];
    }

    public static boolean isAII(Object object) {
        return object instanceof int[][];
    }

    public static boolean isAFF(Object object) {
        return object instanceof float[][];
    }

    public static boolean isAFFF(Object object) {
        return object instanceof float[][][];
    }

    public static String eS(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        boolean bl = false;
        for (n = 0; n < escapable.length(); n += 2) {
            if (string.indexOf(escapable.charAt(n)) < 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            while (n < escapable.length()) {
                int n2 = -1;
                char c = escapable.charAt(n++);
                char c2 = escapable.charAt(n++);
                SB sB = new SB();
                int n3 = 0;
                while ((n2 = string.indexOf(c, n2 + 1)) >= 0) {
                    sB.append(string.substring(n3, n2)).appendC('\\').appendC(c2);
                    n3 = n2 + 1;
                }
                sB.append(string.substring(n3, string.length()));
                string = sB.toString();
            }
        }
        n = string.length();
        while (--n >= 0) {
            if (string.charAt(n) <= '\u007f') continue;
            string = string.substring(0, n) + Escape.unicode(string.charAt(n)) + string.substring(n + 1);
        }
        return "\"" + string + "\"";
    }

    private static String unicode(char c) {
        String string = "0000" + Integer.toHexString(c);
        return "\\u" + string.substring(string.length() - 4);
    }

    public static String eV(JmolList<SV> jmolList) {
        if (jmolList == null) {
            return Escape.eS("");
        }
        SB sB = new SB();
        sB.append("[");
        for (int i = 0; i < jmolList.size(); ++i) {
            if (i > 0) {
                sB.append(", ");
            }
            sB.append(Escape.escapeNice(((SV)jmolList.get(i)).asString()));
        }
        sB.append("]");
        return sB.toString();
    }

    public static String escapeMap(Map<String, Object> map) {
        SB sB = new SB();
        sB.append("{ ");
        String string = "";
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string2 = entry.getKey();
            sB.append(string).append(Escape.eS(string2)).appendC(':');
            Object object = entry.getValue();
            if (!(object instanceof SV)) {
                object = SV.getVariable(object);
            }
            sB.append(((SV)object).escape());
            string = ",";
        }
        sB.append(" }");
        return sB.toString();
    }

    public static String escapeFloatA(float[] fArray, boolean bl) {
        if (bl) {
            return Escape.toJSON(null, fArray);
        }
        SB sB = new SB();
        for (int i = 0; i < fArray.length; ++i) {
            if (i > 0) {
                sB.appendC('\n');
            }
            sB.appendF(fArray[i]);
        }
        return sB.toString();
    }

    public static String escapeFloatAA(float[][] fArray, boolean bl) {
        SB sB = new SB();
        String string = bl ? ";\n" : "\n";
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] == null) continue;
            if (i > 0) {
                sB.append(string);
            }
            for (int j = 0; j < fArray[i].length; ++j) {
                sB.appendF(fArray[i][j]).appendC('\t');
            }
        }
        return sB.toString();
    }

    public static String escapeFloatAAA(float[][][] fArray, boolean bl) {
        String string;
        SB sB = new SB();
        String string2 = string = bl ? ";\n" : "\n";
        if (fArray[0] == null || fArray[0][0] == null) {
            return "0 0 0" + string;
        }
        sB.appendI(fArray.length).append(" ").appendI(fArray[0].length).append(" ").appendI(fArray[0][0].length);
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] == null) continue;
            sB.append(string);
            for (int j = 0; j < fArray[i].length; ++j) {
                if (fArray[i][j] == null) continue;
                sB.append(string);
                for (int k = 0; k < fArray[i][j].length; ++k) {
                    sB.appendF(fArray[i][j][k]).appendC('\t');
                }
            }
        }
        return sB.toString();
    }

    public static String eAS(String[] stringArray, boolean bl) {
        if (stringArray == null) {
            return Escape.eS("");
        }
        SB sB = new SB();
        sB.append("[");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                sB.append(", ");
            }
            sB.append(bl ? Escape.escapeNice(stringArray[i]) : Escape.eS(stringArray[i]));
        }
        sB.append("]");
        return sB.toString();
    }

    public static String eAI(int[] nArray) {
        if (nArray == null) {
            return Escape.eS("");
        }
        SB sB = new SB();
        sB.append("[");
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                sB.append(", ");
            }
            sB.appendI(nArray[i]);
        }
        return sB.append("]").toString();
    }

    public static String eAD(double[] dArray) {
        if (dArray == null) {
            return Escape.eS("");
        }
        SB sB = new SB();
        sB.append("[");
        for (int i = 0; i < dArray.length; ++i) {
            if (i > 0) {
                sB.append(", ");
            }
            sB.appendD(dArray[i]);
        }
        return sB.append("]").toString();
    }

    public static String eAF(float[] fArray) {
        if (fArray == null) {
            return Escape.eS("");
        }
        SB sB = new SB();
        sB.append("[");
        for (int i = 0; i < fArray.length; ++i) {
            if (i > 0) {
                sB.append(", ");
            }
            sB.appendF(fArray[i]);
        }
        return sB.append("]").toString();
    }

    public static String eAP(P3[] p3Array) {
        if (p3Array == null) {
            return Escape.eS("");
        }
        SB sB = new SB();
        sB.append("[");
        for (int i = 0; i < p3Array.length; ++i) {
            if (i > 0) {
                sB.append(", ");
            }
            sB.append(Escape.eP(p3Array[i]));
        }
        return sB.append("]").toString();
    }

    private static String escapeNice(String string) {
        if (string == null) {
            return "null";
        }
        float f = Parser.parseFloatStrict(string);
        return Float.isNaN(f) ? Escape.eS(string) : string;
    }

    public static Object unescapePointOrBitsetOrMatrixOrArray(String string) {
        if (string.charAt(0) == '{') {
            return Escape.uP(string);
        }
        if ((Escape.isStringArray(string) || string.startsWith("[{") && string.indexOf("[{") == string.lastIndexOf("[{")) && string.indexOf(44) < 0 && string.indexOf(46) < 0 && string.indexOf(45) < 0) {
            return Escape.uB(string);
        }
        if (string.startsWith("[[")) {
            return Escape.unescapeMatrix(string);
        }
        return string;
    }

    public static boolean isStringArray(String string) {
        return string.startsWith("({") && string.lastIndexOf("({") == 0 && string.indexOf("})") == string.length() - 2;
    }

    public static Object uP(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = string.replace('\n', ' ').trim();
        if (string2.charAt(0) != '{' || string2.charAt(string2.length() - 1) != '}') {
            return string;
        }
        float[] fArray = new float[5];
        string2 = string2.substring(1, string2.length() - 1);
        int[] nArray = new int[1];
        for (n = 0; n < 5; ++n) {
            fArray[n] = Parser.parseFloatNext(string2, nArray);
            if (!Float.isNaN(fArray[n])) continue;
            if (nArray[0] >= string2.length() || string2.charAt(nArray[0]) != ',') break;
            nArray[0] = nArray[0] + 1;
            --n;
        }
        if (n == 3) {
            return P3.new3(fArray[0], fArray[1], fArray[2]);
        }
        if (n == 4) {
            return P4.new4(fArray[0], fArray[1], fArray[2], fArray[3]);
        }
        return string;
    }

    public static BS uB(String string) {
        char c;
        int n;
        if (string == null || (n = (string = string.trim()).length()) < 4 || string.equalsIgnoreCase("({null})") || (c = string.charAt(0)) != '(' && c != '[' || string.charAt(n - 1) != (c == '(' ? (char)')' : ']') || string.charAt(1) != '{' || string.indexOf(125) != n - 2) {
            return null;
        }
        int n2 = n -= 2;
        while (--n2 >= 2) {
            c = string.charAt(n2);
            if (Character.isDigit(c) || c == ' ' || c == '\t' || c == ':') continue;
            return null;
        }
        n2 = n;
        while (Character.isDigit(string.charAt(--n2))) {
        }
        if (++n2 == n) {
            n2 = 0;
        } else {
            try {
                n2 = Integer.parseInt(string.substring(n2, n));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        BS bS = BSUtil.newBitSet(n2);
        n2 = -1;
        int n3 = -1;
        int n4 = -2;
        block8: for (int i = 2; i <= n; ++i) {
            c = string.charAt(i);
            switch (c) {
                case '\t': 
                case ' ': 
                case '}': {
                    if (n4 < 0) continue block8;
                    if (n4 < n2) {
                        return null;
                    }
                    n2 = n4;
                    if (n3 < 0) {
                        n3 = n4;
                    }
                    bS.setBits(n3, n4 + 1);
                    n3 = -1;
                    n4 = -2;
                    continue block8;
                }
                case ':': {
                    n3 = n2 = n4;
                    n4 = -2;
                    continue block8;
                }
                default: {
                    if (!Character.isDigit(c)) continue block8;
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    n4 = n4 * 10 + (c - 48);
                }
            }
        }
        return n3 >= 0 ? null : bS;
    }

    public static Object unescapeMatrix(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = string.replace('\n', ' ').trim();
        if (string2.lastIndexOf("[[") != 0 || string2.indexOf("]]") != string2.length() - 2) {
            return string;
        }
        float[] fArray = new float[16];
        string2 = string2.substring(2, string2.length() - 2).replace('[', ' ').replace(']', ' ').replace(',', ' ');
        int[] nArray = new int[1];
        for (n = 0; n < 16; ++n) {
            fArray[n] = Parser.parseFloatNext(string2, nArray);
            if (Float.isNaN(fArray[n])) break;
        }
        if (!Float.isNaN(Parser.parseFloatNext(string2, nArray))) {
            return string;
        }
        if (n == 9) {
            return Matrix3f.newA(fArray);
        }
        if (n == 16) {
            return Matrix4f.newA(fArray);
        }
        return string;
    }

    public static String eBS(BS bS) {
        return Escape.eB(bS, '(', ')');
    }

    public static String eBond(BS bS) {
        return Escape.eB(bS, '[', ']');
    }

    private static String eB(BS bS, char c, char c2) {
        if (bS == null) {
            return c + "{}" + c2;
        }
        SB sB = new SB();
        sB.append(c + "{");
        int n = bS.length();
        int n2 = -1;
        int n3 = -2;
        int n4 = -1;
        while (++n4 <= n) {
            boolean bl = bS.get(n4);
            if (n4 == n || n2 >= 0 && !bl) {
                if (n2 >= 0 && n3 != n2) {
                    sB.append((n3 == n2 - 1 ? " " : ":") + n2);
                }
                if (n4 == n) break;
                n2 = -1;
            }
            if (!bS.get(n4)) continue;
            if (n2 < 0) {
                sB.append((n3 == -2 ? "" : " ") + n4);
                n3 = n4;
            }
            n2 = n4;
        }
        sB.append("}").appendC(c2);
        return sB.toString();
    }

    private static String packageJSONSb(String string, SB sB) {
        return Escape.packageJSON(string, sB.toString());
    }

    private static String packageJSON(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return "\"" + string + "\": " + string2;
    }

    private static String fixString(String string) {
        if (string == null || string.indexOf("{\"") == 0) {
            return string;
        }
        string = TextFormat.simpleReplace(string, "\"", "''");
        string = TextFormat.simpleReplace(string, "\n", " | ");
        return "\"" + string + "\"";
    }

    public static String toJSON(String string, Object object) {
        SB sB = new SB();
        String string2 = "";
        if (object == null) {
            return Escape.packageJSON(string, null);
        }
        if (object instanceof Integer || object instanceof Float || object instanceof Double) {
            return Escape.packageJSON(string, object.toString());
        }
        if (object instanceof String) {
            return Escape.packageJSON(string, Escape.fixString((String)object));
        }
        if (Escape.isAS(object)) {
            sB.append("[");
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).append(Escape.fixString(((String[])object)[i]));
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageJSONSb(string, sB);
        }
        if (Escape.isAI(object)) {
            sB.append("[");
            int n = ((int[])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).appendI(((int[])object)[i]);
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageJSONSb(string, sB);
        }
        if (Escape.isAF(object)) {
            sB.append("[");
            int n = ((float[])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).appendF(((float[])object)[i]);
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageJSONSb(string, sB);
        }
        if (Escape.isAD(object)) {
            sB.append("[");
            int n = ((double[])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).appendD(((double[])object)[i]);
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageJSONSb(string, sB);
        }
        if (Escape.isAP(object)) {
            sB.append("[");
            int n = ((P3[])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2);
                Escape.addJsonTuple(sB, ((P3[])object)[i]);
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageJSONSb(string, sB);
        }
        if (Escape.isASS(object)) {
            sB.append("[");
            int n = ((String[][])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).append(Escape.toJSON(null, ((String[][])object)[i]));
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageJSONSb(string, sB);
        }
        if (Escape.isAII(object)) {
            sB.append("[");
            int n = ((int[][])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).append(Escape.toJSON(null, ((int[][])object)[i]));
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageJSONSb(string, sB);
        }
        if (Escape.isAFF(object)) {
            sB.append("[");
            int n = ((float[][])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).append(Escape.toJSON(null, ((float[][])object)[i]));
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageJSONSb(string, sB);
        }
        if (Escape.isAFFF(object)) {
            sB.append("[");
            int n = ((float[][][])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).append(Escape.toJSON(null, ((float[][][])object)[i]));
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageJSONSb(string, sB);
        }
        if (object instanceof JmolList) {
            sB.append("[ ");
            int n = ((JmolList)object).size();
            for (int i = 0; i < n; ++i) {
                sB.append(string2).append(Escape.toJSON(null, ((JmolList)object).get(i)));
                string2 = ",";
            }
            sB.append(" ]");
            return Escape.packageJSONSb(string, sB);
        }
        if (object instanceof Matrix4f) {
            float[] fArray = new float[4];
            Matrix4f matrix4f = (Matrix4f)object;
            sB.appendC('[');
            for (int i = 0; i < 4; ++i) {
                if (i > 0) {
                    sB.appendC(',');
                }
                matrix4f.getRow(i, fArray);
                sB.append(Escape.toJSON(null, fArray));
            }
            sB.appendC(']');
            return Escape.packageJSONSb(string, sB);
        }
        if (object instanceof Matrix3f) {
            float[] fArray = new float[3];
            Matrix3f matrix3f = (Matrix3f)object;
            sB.appendC('[');
            for (int i = 0; i < 3; ++i) {
                if (i > 0) {
                    sB.appendC(',');
                }
                matrix3f.getRow(i, fArray);
                sB.append(Escape.toJSON(null, fArray));
            }
            sB.appendC(']');
            return Escape.packageJSONSb(string, sB);
        }
        if (object instanceof Tuple3f) {
            Escape.addJsonTuple(sB, (Tuple3f)object);
            return Escape.packageJSONSb(string, sB);
        }
        if (object instanceof AxisAngle4f) {
            sB.append("[").appendF(((AxisAngle4f)object).x).append(",").appendF(((AxisAngle4f)object).y).append(",").appendF(((AxisAngle4f)object).z).append(",").appendF((float)((double)((AxisAngle4f)object).angle * 180.0 / Math.PI)).append("]");
            return Escape.packageJSONSb(string, sB);
        }
        if (object instanceof P4) {
            sB.append("[").appendF(((P4)object).x).append(",").appendF(((P4)object).y).append(",").appendF(((P4)object).z).append(",").appendF(((P4)object).w).append("]");
            return Escape.packageJSONSb(string, sB);
        }
        if (object instanceof Map) {
            sB.append("{ ");
            for (String string3 : ((Map)object).keySet()) {
                sB.append(string2).append(Escape.packageJSON(string3, Escape.toJSON(null, ((Map)object).get(string3))));
                string2 = ",";
            }
            sB.append(" }");
            return Escape.packageJSONSb(string, sB);
        }
        return Escape.packageJSON(string, Escape.fixString(object.toString()));
    }

    private static void addJsonTuple(SB sB, Tuple3f tuple3f) {
        sB.append("[").appendF(tuple3f.x).append(",").appendF(tuple3f.y).append(",").appendF(tuple3f.z).append("]");
    }

    public static String toReadable(String string, Object object) {
        SB sB = new SB();
        String string2 = "";
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return Escape.packageReadable(string, null, Escape.eS((String)object));
        }
        if (Escape.isAS(object)) {
            sB.append("[");
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).append(Escape.eS(((String[])object)[i]));
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "String[" + n + "]", sB);
        }
        if (Escape.isAI(object)) {
            sB.append("[");
            int n = ((int[])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).appendI(((int[])object)[i]);
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "int[" + n + "]", sB);
        }
        if (Escape.isAF(object)) {
            sB.append("[");
            int n = ((float[])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).appendF(((float[])object)[i]);
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "float[" + n + "]", sB);
        }
        if (Escape.isAD(object)) {
            sB.append("[");
            int n = ((double[])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).appendD(((double[])object)[i]);
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "double[" + n + "]", sB);
        }
        if (Escape.isAP(object)) {
            sB.append("[");
            int n = ((P3[])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).append(Escape.eP(((P3[])object)[i]));
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "point3f[" + n + "]", sB);
        }
        if (Escape.isASS(object)) {
            sB.append("[");
            int n = ((String[][])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).append(Escape.toReadable(null, ((String[][])object)[i]));
                string2 = ",\n";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "String[" + n + "][]", sB);
        }
        if (Escape.isAII(object)) {
            sB.append("[");
            int n = ((int[][])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).append(Escape.toReadable(null, ((int[][])object)[i]));
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "int[" + n + "][]", sB);
        }
        if (Escape.isAFF(object)) {
            sB.append("[\n");
            int n = ((float[][])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).append(Escape.toReadable(null, ((float[][])object)[i]));
                string2 = ",\n";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "float[][]", sB);
        }
        if (object instanceof JmolList) {
            int n = ((JmolList)object).size();
            for (int i = 0; i < n; ++i) {
                sB.append(Escape.toReadable(string + "[" + (i + 1) + "]", ((JmolList)object).get(i)));
            }
            return Escape.packageReadableSb(string, "List[" + n + "]", sB);
        }
        if (object instanceof Matrix3f || object instanceof Tuple3f || object instanceof P4 || object instanceof AxisAngle4f) {
            sB.append(Escape.e(object));
            return Escape.packageReadableSb(string, null, sB);
        }
        if (object instanceof Map) {
            for (String string3 : ((Map)object).keySet()) {
                sB.append(Escape.toReadable((string == null ? "" : string + ".") + string3, ((Map)object).get(string3)));
            }
            return sB.toString();
        }
        return Escape.packageReadable(string, null, object.toString());
    }

    private static String packageReadableSb(String string, String string2, SB sB) {
        return Escape.packageReadable(string, string2, sB.toString());
    }

    private static String packageReadable(String string, String string2, String string3) {
        String string4;
        String string5 = string4 = string2 == null ? "" : string2 + "\t";
        if (string == null) {
            return string4 + string3;
        }
        return "\n" + string + "\t" + (string2 == null ? "" : "*" + string2 + "\t") + string3;
    }

    public static String escapeModelFileNumber(int n) {
        return "" + n / 1000000 + "." + n % 1000000;
    }

    public static String encapsulateData(String string, Object object, int n) {
        return "  DATA \"" + string + "\"\n" + (n == 2 ? Escape.escapeFloatAA((float[][])object, true) + ";\n" : (n == 3 ? Escape.escapeFloatAAA((float[][][])object, true) + ";\n" : object)) + "    END \"" + string + "\";\n";
    }

    public static String unescapeUnicode(String string) {
        int n = string.length();
        SB sB = SB.newN(n);
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = string.charAt(n2++)) == '\\' && n2 < n) {
                c = string.charAt(n2++);
                switch (c) {
                    case 'u': {
                        char c2;
                        int n3;
                        if (n2 >= n) break;
                        int n4 = 0;
                        int n5 = 4;
                        while (--n5 >= 0 && n2 < n && (n3 = Escape.getHexitValue(c2 = string.charAt(n2))) >= 0) {
                            n4 <<= 4;
                            n4 += n3;
                            ++n2;
                        }
                        c = (char)n4;
                    }
                }
            }
            sB.appendC(c);
        }
        return sB.toString();
    }

    public static int getHexitValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + c - 97;
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + c - 65;
        }
        return -1;
    }

    public static String[] unescapeStringArray(String string) {
        if (string == null || !string.startsWith("[") || !string.endsWith("]")) {
            return null;
        }
        JmolList<String> jmolList = new JmolList<String>();
        int[] nArray = new int[]{1};
        while (nArray[0] < string.length()) {
            String string2 = Parser.getQuotedStringNext(string, nArray);
            if (string2 == null) {
                return null;
            }
            jmolList.addLast(TextFormat.simpleReplace(string2, "\\\"", "\""));
            while (nArray[0] < string.length() && string.charAt(nArray[0]) != '\"') {
                nArray[0] = nArray[0] + 1;
            }
        }
        return jmolList.toArray(new String[jmolList.size()]);
    }

    public static String escapeUrl(String string) {
        string = TextFormat.simpleReplace(string, "\n", "");
        string = TextFormat.simpleReplace(string, "%", "%25");
        string = TextFormat.simpleReplace(string, "[", "%5B");
        string = TextFormat.simpleReplace(string, "]", "%5D");
        string = TextFormat.simpleReplace(string, " ", "%20");
        return string;
    }
}

