/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import org.jmol.api.Interface;
import org.jmol.api.JmolScriptEvaluator;
import org.jmol.api.JmolScriptManager;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptQueueThread;
import org.jmol.thread.JmolThread;
import org.jmol.util.BS;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptManager
implements JmolScriptManager {
    private Viewer viewer;
    private JmolScriptEvaluator eval;
    private JmolScriptEvaluator evalTemp;
    private Thread[] queueThreads = new Thread[2];
    private boolean[] scriptQueueRunning = new boolean[2];
    private JmolThread commandWatcherThread;
    public JmolList<JmolList<Object>> scriptQueue = new JmolList();
    private boolean useCommandWatcherThread = false;
    private int scriptIndex;
    private boolean isScriptQueued = true;

    @Override
    public JmolScriptEvaluator getEval() {
        return this.eval;
    }

    @Override
    public JmolList<JmolList<Object>> getScriptQueue() {
        return this.scriptQueue;
    }

    @Override
    public boolean isScriptQueued() {
        return this.isScriptQueued;
    }

    @Override
    public void setViewer(Viewer viewer) {
        this.viewer = viewer;
        this.eval = this.newScriptEvaluator();
        this.eval.setCompiler();
    }

    private JmolScriptEvaluator newScriptEvaluator() {
        return ((JmolScriptEvaluator)Interface.getOptionInterface("script.ScriptEvaluator")).setViewer(this.viewer);
    }

    @Override
    public void clear(boolean bl) {
        if (!bl) {
            this.evalTemp = null;
            return;
        }
        this.startCommandWatcher(false);
        this.interruptQueueThreads();
    }

    @Override
    public String addScript(String string, boolean bl, boolean bl2) {
        return (String)this.addScr("String", string, "", bl, bl2);
    }

    private Object addScr(String string, String string2, String string3, boolean bl, boolean bl2) {
        if (!this.viewer.global.useScriptQueue) {
            this.clearQueue();
            this.viewer.haltScriptExecution();
        }
        if (this.commandWatcherThread == null && this.useCommandWatcherThread) {
            this.startCommandWatcher(true);
        }
        if (this.commandWatcherThread != null && string2.indexOf("/*SPLIT*/") >= 0) {
            String[] stringArray = TextFormat.splitChars(string2, "/*SPLIT*/");
            for (int i = 0; i < stringArray.length; ++i) {
                this.addScr(string, stringArray[i], string3, bl, bl2);
            }
            return "split into " + stringArray.length + " sections for processing";
        }
        boolean bl3 = this.commandWatcherThread != null && (string2.indexOf("javascript") < 0 || string2.indexOf("#javascript ") >= 0);
        JmolList<Object> jmolList = new JmolList<Object>();
        jmolList.addLast(string2);
        jmolList.addLast(string3);
        jmolList.addLast(string);
        jmolList.addLast(bl ? Boolean.TRUE : Boolean.FALSE);
        jmolList.addLast(bl2 ? Boolean.TRUE : Boolean.FALSE);
        jmolList.addLast(Integer.valueOf(bl3 ? -1 : 1));
        this.scriptQueue.addLast(jmolList);
        this.startScriptQueue(false);
        return "pending";
    }

    @Override
    public void clearQueue() {
        this.scriptQueue.clear();
    }

    @Override
    public void waitForQueue() {
        if (this.viewer.isSingleThreaded) {
            return;
        }
        int n = 0;
        while (this.isQueueProcessing()) {
            try {
                Thread.sleep(100L);
                if (n++ % 10 != 0 || !Logger.debugging) continue;
                Logger.debug("...scriptManager waiting for queue: " + this.scriptQueue.size() + " thread=" + Thread.currentThread().getName());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public boolean isQueueProcessing() {
        return this.queueThreads[0] != null || this.queueThreads[1] != null;
    }

    private synchronized void flushQueue(String string) {
        int n = this.scriptQueue.size();
        while (--n >= 0) {
            String string2 = (String)((JmolList)this.scriptQueue.get(n)).get(0);
            if (string2.indexOf(string) != 0) continue;
            this.scriptQueue.remove(n);
            if (!Logger.debugging) continue;
            Logger.debug(this.scriptQueue.size() + " scripts; removed: " + string2);
        }
    }

    private void startScriptQueue(boolean bl) {
        int n;
        int n2 = n = bl ? 1 : 0;
        if (this.scriptQueueRunning[n]) {
            return;
        }
        this.scriptQueueRunning[n] = true;
        this.queueThreads[n] = new ScriptQueueThread(this, this.viewer, bl, n);
        this.queueThreads[n].start();
    }

    @Override
    public JmolList<Object> getScriptItem(boolean bl, boolean bl2) {
        if (this.viewer.isSingleThreaded && this.viewer.queueOnHold) {
            return null;
        }
        JmolList jmolList = (JmolList)this.scriptQueue.get(0);
        int n = (Integer)jmolList.get(5);
        boolean bl3 = bl ? n < 0 : (bl2 ? n == 0 : n == 1);
        return bl3 ? jmolList : null;
    }

    @Override
    public synchronized void startCommandWatcher(boolean bl) {
        this.useCommandWatcherThread = bl;
        if (bl) {
            if (this.commandWatcherThread != null) {
                return;
            }
            this.commandWatcherThread = (JmolThread)Interface.getOptionInterface("script.CommandWatcherThread");
            this.commandWatcherThread.setManager(this, this.viewer, null);
            this.commandWatcherThread.start();
        } else {
            if (this.commandWatcherThread == null) {
                return;
            }
            this.clearCommandWatcherThread();
        }
        if (Logger.debugging) {
            Logger.debug("command watcher " + (bl ? "started" : "stopped") + this.commandWatcherThread);
        }
    }

    void interruptQueueThreads() {
        for (int i = 0; i < this.queueThreads.length; ++i) {
            if (this.queueThreads[i] == null) continue;
            this.queueThreads[i].interrupt();
        }
    }

    public void clearCommandWatcherThread() {
        if (this.commandWatcherThread == null) {
            return;
        }
        this.commandWatcherThread.interrupt();
        this.commandWatcherThread = null;
    }

    @Override
    public void queueThreadFinished(int n) {
        this.queueThreads[n].interrupt();
        this.scriptQueueRunning[n] = false;
        this.queueThreads[n] = null;
        this.viewer.setSyncDriver(4);
    }

    public void runScriptNow() {
        JmolList<Object> jmolList;
        if (this.scriptQueue.size() > 0 && (jmolList = this.getScriptItem(true, true)) != null) {
            jmolList.set(5, 0);
            this.startScriptQueue(true);
        }
    }

    @Override
    public Object evalStringWaitStatusQueued(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        if (string2 == null) {
            return null;
        }
        String string4 = this.checkScriptExecution(string2, false);
        if (string4 != null) {
            return string4;
        }
        SB sB = string3 == null || string3.equals("output") ? new SB() : null;
        String string5 = this.viewer.statusManager.getStatusList();
        this.viewer.getStatusChanged(string3);
        if (this.viewer.isSyntaxCheck) {
            Logger.info("--checking script:\n" + this.eval.getScript() + "\n----\n");
        }
        boolean bl5 = bl4 = string2.indexOf(")") == 0;
        if (bl4) {
            string2 = string2.substring(1);
        }
        bl4 = bl4 || !bl3;
        this.viewer.setErrorMessage(null, null);
        boolean bl6 = bl ? this.eval.compileScriptFile(string2, bl2) : this.eval.compileScriptString(string2, bl2);
        String string6 = this.eval.getErrorMessage();
        String string7 = this.eval.getErrorMessageUntranslated();
        this.viewer.setErrorMessage(string6, string7);
        this.viewer.refresh(7, "script complete");
        if (bl6) {
            this.isScriptQueued = bl3;
            if (!bl2) {
                this.viewer.setScriptStatus(null, string2, -2 - ++this.scriptIndex, null);
            }
            this.eval.evaluateCompiledScript(this.viewer.isSyntaxCheck, this.viewer.isSyntaxAndFileCheck, bl4, this.viewer.listCommands, sB, bl3 || !this.viewer.isSingleThreaded);
        } else {
            this.viewer.scriptStatus(string6);
            this.viewer.setScriptStatus("Jmol script terminated", string6, 1, string7);
            this.viewer.setStateScriptVersion(null);
        }
        if (string6 != null && this.viewer.autoExit) {
            this.viewer.exitJmol();
        }
        if (this.viewer.isSyntaxCheck) {
            if (string6 == null) {
                Logger.info("--script check ok");
            } else {
                Logger.error("--script check error\n" + string7);
            }
            Logger.info("(use 'exit' to stop checking)");
        }
        this.isScriptQueued = true;
        if (string.equalsIgnoreCase("String")) {
            return string7;
        }
        if (sB != null) {
            return string7 == null ? sB.toString() : string7;
        }
        JmolList<JmolList<JmolList<Object>>> jmolList = this.viewer.getStatusChanged(string3);
        this.viewer.getStatusChanged(string5);
        return jmolList;
    }

    private String checkScriptExecution(String string, boolean bl) {
        String string2 = string;
        if (string2.indexOf("\u0001##") >= 0) {
            string2 = string2.substring(0, string2.indexOf("\u0001##"));
        }
        if (this.checkResume(string2)) {
            return "script processing resumed";
        }
        if (this.checkStepping(string2)) {
            return "script processing stepped";
        }
        if (this.checkHalt(string2, bl)) {
            return "script execution halted";
        }
        return null;
    }

    private boolean checkResume(String string) {
        if (string.equalsIgnoreCase("resume")) {
            this.viewer.setScriptStatus("", "execution resumed", 0, null);
            this.eval.resumePausedExecution();
            return true;
        }
        return false;
    }

    private boolean checkStepping(String string) {
        if (string.equalsIgnoreCase("step")) {
            this.eval.stepPausedExecution();
            return true;
        }
        if (string.equalsIgnoreCase("?")) {
            this.viewer.scriptStatus(this.eval.getNextStatement());
            return true;
        }
        return false;
    }

    @Override
    public String evalStringQuietSync(String string, boolean bl, boolean bl2) {
        String string2;
        boolean bl3;
        if (bl2 && this.viewer.statusManager.syncingScripts && string.indexOf("#NOSYNC;") < 0) {
            this.viewer.syncScript(string + " #NOSYNC;", null, 0);
        }
        if (this.eval.isPaused() && string.charAt(0) != '!') {
            string = '!' + TextFormat.trim(string, "\n\r\t ");
        }
        boolean bl4 = bl3 = string.length() > 0 && string.charAt(0) == '!';
        if (bl3) {
            string = string.substring(1);
        }
        if ((string2 = this.checkScriptExecution(string, bl3)) != null) {
            return string2;
        }
        if (this.viewer.isScriptExecuting() && (bl3 || this.eval.isPaused())) {
            this.viewer.setInsertedCommand(string);
            if (string.indexOf("moveto ") == 0) {
                this.flushQueue("moveto ");
            }
            return "!" + string;
        }
        this.viewer.setInsertedCommand("");
        if (bl) {
            string = string + "\u0001## EDITOR_IGNORE ##";
        }
        return this.addScript(string, false, bl && !this.viewer.getBoolean(603979880));
    }

    @Override
    public boolean checkHalt(String string, boolean bl) {
        if (string.equalsIgnoreCase("pause")) {
            this.viewer.pauseScriptExecution();
            if (this.viewer.scriptEditorVisible) {
                this.viewer.setScriptStatus("", "paused -- type RESUME to continue", 0, null);
            }
            return true;
        }
        if (string.equalsIgnoreCase("menu")) {
            this.viewer.getProperty("DATA_API", "getPopupMenu", "\u0000");
            return true;
        }
        string = string.toLowerCase();
        boolean bl2 = false;
        String string2 = null;
        if (string.startsWith("exit")) {
            this.viewer.haltScriptExecution();
            this.viewer.clearScriptQueue();
            this.viewer.clearTimeouts();
            string2 = "exit";
            bl2 = string.equals("exit");
        } else if (string.startsWith("quit")) {
            this.viewer.haltScriptExecution();
            string2 = "quit";
            bl2 = string.equals("quit");
        }
        if (string2 == null) {
            return false;
        }
        if (bl) {
            this.viewer.clearThreads();
            this.viewer.queueOnHold = false;
        }
        if (bl || this.viewer.global.waitForMoveTo) {
            this.viewer.stopMotion();
        }
        Logger.info(this.viewer.isSyntaxCheck ? string2 + " -- stops script checking" : (bl ? "!" : "") + string2 + " received");
        this.viewer.isSyntaxCheck = false;
        return bl2;
    }

    @Override
    public BS getAtomBitSetEval(JmolScriptEvaluator jmolScriptEvaluator, Object object) {
        if (jmolScriptEvaluator == null && (jmolScriptEvaluator = this.evalTemp) == null) {
            jmolScriptEvaluator = this.evalTemp = this.newScriptEvaluator();
        }
        return jmolScriptEvaluator.getAtomBitSet(object);
    }

    @Override
    public Object scriptCheckRet(String string, boolean bl) {
        if (string.indexOf(")") == 0 || string.indexOf("!") == 0) {
            string = string.substring(1);
        }
        ScriptContext scriptContext = this.newScriptEvaluator().checkScriptSilent(string);
        if (bl || scriptContext.errorMessage == null) {
            return scriptContext;
        }
        return scriptContext.errorMessage;
    }
}

