/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import org.jmol.constant.EnumStructure;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.PhosphorusMonomer;
import org.jmol.util.JmolList;
import org.jmol.util.P3;
import org.jmol.util.Quaternion;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;
import org.jmol.viewer.JC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NucleicMonomer
extends PhosphorusMonomer {
    static final byte C6 = 1;
    private static final byte O2Pr = 2;
    private static final byte C5 = 3;
    private static final byte N1 = 4;
    private static final byte C2 = 5;
    private static final byte N3 = 6;
    private static final byte C4 = 7;
    private static final byte O2 = 8;
    private static final byte N7 = 9;
    private static final byte C8 = 10;
    private static final byte N9 = 11;
    private static final byte O4 = 12;
    private static final byte O6 = 13;
    private static final byte N4 = 14;
    private static final byte NP = 15;
    private static final byte N6 = 16;
    private static final byte N2 = 17;
    private static final byte H5T = 18;
    private static final byte O5Pr = 19;
    private static final byte H3T = 20;
    private static final byte O3Pr = 21;
    private static final byte C3Pr = 22;
    private static final byte O1P = 23;
    private static final byte O2P = 24;
    private static final byte C1P = 25;
    private static final byte C4P = 26;
    static final byte[] interestingNucleicAtomIDs = new byte[]{-14, 37, -80, 36, 32, 33, 34, 35, -39, -40, -41, -42, -48, -47, -43, -14, -45, -44, -73, -7, -89, 10, 9, -75, -77, -13, -9};
    private boolean hasRnaO2Prime;
    private static final byte[] ring6OffsetIndexes = new byte[]{3, 1, 4, 5, 6, 7};
    private static final byte[] ring5OffsetIndexes = new byte[]{3, 9, 10, 11, 7};
    private static final byte[] heavyAtomIndexes = new byte[]{3, 1, 4, 5, 6, 7, 11, 10, 9, 16, 14, 8, 12, 17, 13};
    P3 baseCenter;
    public static final int CARTOON_VISIBILITY_FLAG = JC.getShapeVisibilityFlag(11);

    private NucleicMonomer() {
    }

    public static Monomer validateAndAllocate(Chain chain, String string, int n, int n2, int n3, int[] nArray) {
        byte[] byArray = NucleicMonomer.scanForOffsets(n2, nArray, interestingNucleicAtomIDs);
        if (byArray == null) {
            return null;
        }
        if (!NucleicMonomer.checkOptional(byArray, (byte)19, n2, nArray[73])) {
            return null;
        }
        NucleicMonomer.checkOptional(byArray, (byte)20, n2, nArray[89]);
        NucleicMonomer.checkOptional(byArray, (byte)18, n2, nArray[90]);
        NucleicMonomer.checkOptional(byArray, (byte)23, n2, nArray[75]);
        NucleicMonomer.checkOptional(byArray, (byte)24, n2, nArray[77]);
        return new NucleicMonomer().set4(chain, string, n, n2, n3, byArray);
    }

    private NucleicMonomer set4(Chain chain, String string, int n, int n2, int n3, byte[] byArray) {
        this.set3(chain, string, n, n2, n3, byArray);
        if (!NucleicMonomer.have(byArray, (byte)15)) {
            byArray[0] = byArray[19];
            int n4 = byArray[0] & 0xFF;
            if (n4 != 255) {
                this.leadAtomIndex = n2 + n4;
            }
        }
        this.hasRnaO2Prime = NucleicMonomer.have(byArray, (byte)2);
        this.isPyrimidine = NucleicMonomer.have(byArray, (byte)8);
        this.isPurine = NucleicMonomer.have(byArray, (byte)9) && NucleicMonomer.have(byArray, (byte)10) && NucleicMonomer.have(byArray, (byte)11);
        return this;
    }

    public boolean isNucleicMonomer() {
        return true;
    }

    @Override
    public boolean isDna() {
        return !this.hasRnaO2Prime;
    }

    @Override
    public boolean isRna() {
        return this.hasRnaO2Prime;
    }

    @Override
    public boolean isPurine() {
        return this.isPurine;
    }

    @Override
    public boolean isPyrimidine() {
        return this.isPyrimidine;
    }

    public boolean isGuanine() {
        return NucleicMonomer.have(this.offsets, (byte)17);
    }

    @Override
    public EnumStructure getProteinStructureType() {
        return this.hasRnaO2Prime ? EnumStructure.RNA : EnumStructure.DNA;
    }

    Atom getC1P() {
        return this.getAtomFromOffsetIndex(25);
    }

    Atom getC2() {
        return this.getAtomFromOffsetIndex(5);
    }

    Atom getC4P() {
        return this.getAtomFromOffsetIndex(26);
    }

    Atom getN1() {
        return this.getAtomFromOffsetIndex(4);
    }

    Atom getN3() {
        return this.getAtomFromOffsetIndex(6);
    }

    Atom getN2() {
        return this.getAtomFromOffsetIndex(17);
    }

    Atom getN4() {
        return this.getAtomFromOffsetIndex(14);
    }

    Atom getN6() {
        return this.getAtomFromOffsetIndex(16);
    }

    Atom getO2() {
        return this.getAtomFromOffsetIndex(8);
    }

    Atom getO4() {
        return this.getAtomFromOffsetIndex(12);
    }

    Atom getO6() {
        return this.getAtomFromOffsetIndex(13);
    }

    @Override
    Atom getTerminatorAtom() {
        return this.getAtomFromOffsetIndex(NucleicMonomer.have(this.offsets, (byte)20) ? 20 : 21);
    }

    public void getBaseRing6Points(P3[] p3Array) {
        int n = 6;
        while (--n >= 0) {
            p3Array[n] = this.getAtomFromOffsetIndex(ring6OffsetIndexes[n]);
        }
    }

    public boolean maybeGetBaseRing5Points(P3[] p3Array) {
        if (this.isPurine) {
            int n = 5;
            while (--n >= 0) {
                p3Array[n] = this.getAtomFromOffsetIndex(ring5OffsetIndexes[n]);
            }
        }
        return this.isPurine;
    }

    @Override
    boolean isConnectedAfter(Monomer monomer) {
        if (monomer == null) {
            return true;
        }
        Atom atom = this.getAtomFromOffsetIndex(15);
        if (atom == null) {
            return false;
        }
        return ((NucleicMonomer)monomer).getAtomFromOffsetIndex(21).isBonded(atom) || this.isCA2(monomer);
    }

    @Override
    public void findNearestAtomIndex(int n, int n2, Atom[] atomArray, short s, short s2) {
        int n3;
        Atom atom = atomArray[0];
        Atom atom2 = this.getLeadAtom();
        Atom atom3 = this.getAtomFromOffsetIndex(19);
        Atom atom4 = this.getAtomFromOffsetIndex(22);
        int n4 = s / 2;
        if (n4 < 1900) {
            n4 = 1900;
        }
        if ((n3 = (int)this.scaleToScreen(atom2.screenZ, n4)) < 4) {
            n3 = 4;
        }
        if (this.isCursorOnTopOf(atom2, n, n2, n3, atom) || this.isCursorOnTopOf(atom3, n, n2, n3, atom) || this.isCursorOnTopOf(atom4, n, n2, n3, atom)) {
            atomArray[0] = atom2;
        }
    }

    public void setModelClickability() {
        Atom atom;
        if (this.isAtomHidden(this.leadAtomIndex)) {
            return;
        }
        int n = 6;
        while (--n >= 0) {
            atom = this.getAtomFromOffsetIndex(ring6OffsetIndexes[n]);
            atom.setClickable(CARTOON_VISIBILITY_FLAG);
        }
        if (this.isPurine) {
            n = 4;
            while (--n >= 1) {
                atom = this.getAtomFromOffsetIndex(ring5OffsetIndexes[n]);
                atom.setClickable(CARTOON_VISIBILITY_FLAG);
            }
        }
    }

    Atom getN0() {
        return this.getAtomFromOffsetIndex(this.isPurine ? 11 : 4);
    }

    @Override
    public Object getHelixData(int n, char c, int n2) {
        return this.getHelixData2(n, c, n2);
    }

    @Override
    P3 getQuaternionFrameCenter(char c) {
        switch (c) {
            case 'a': 
            case 'b': 
            case 'p': 
            case 'x': {
                return this.getP();
            }
            case 'c': {
                if (this.baseCenter == null) {
                    int n = 0;
                    this.baseCenter = new P3();
                    for (int i = 0; i < heavyAtomIndexes.length; ++i) {
                        Atom atom = this.getAtomFromOffsetIndex(heavyAtomIndexes[i]);
                        if (atom == null) continue;
                        this.baseCenter.add(atom);
                        ++n;
                    }
                    this.baseCenter.scale(1.0f / (float)n);
                }
                return this.baseCenter;
            }
        }
        return this.getN0();
    }

    @Override
    public Quaternion getQuaternion(char c) {
        Tuple3f tuple3f;
        Tuple3f tuple3f2;
        Atom atom;
        Atom atom2 = null;
        Atom atom3 = null;
        boolean bl = false;
        boolean bl2 = false;
        switch (c) {
            case 'a': {
                atom = this.getP();
                if (this.monomerIndex == 0 || atom == null) {
                    return null;
                }
                bl = true;
                atom2 = ((NucleicMonomer)this.bioPolymer.monomers[this.monomerIndex - 1]).getC4P();
                atom3 = this.getC4P();
                break;
            }
            case 'x': {
                atom = this.getP();
                if (this.monomerIndex == this.bioPolymer.monomerCount - 1 || atom == null) {
                    return null;
                }
                atom2 = ((NucleicMonomer)this.bioPolymer.monomers[this.monomerIndex + 1]).getP();
                atom3 = this.getC4P();
                break;
            }
            case 'b': {
                return this.getQuaternionP();
            }
            case 'c': 
            case 'n': {
                atom = this.getN0();
                if (atom == null) {
                    return null;
                }
                bl = true;
                bl2 = true;
                atom2 = this.getAtomFromOffsetIndex(5);
                atom3 = this.getAtomFromOffsetIndex(25);
                break;
            }
            case 'p': {
                atom = this.getP();
                if (atom == null) {
                    return null;
                }
                tuple3f2 = this.getAtomFromOffsetIndex(23);
                tuple3f = this.getAtomFromOffsetIndex(24);
                Bond[] bondArray = atom.getBonds();
                if (bondArray == null) {
                    return null;
                }
                Group group = atom.getGroup();
                for (int i = 0; i < bondArray.length; ++i) {
                    Atom atom4 = bondArray[i].getOtherAtom(atom);
                    if (tuple3f2 != null && atom4.index == tuple3f2.index || tuple3f != null && atom4.index == ((Atom)tuple3f).index) continue;
                    if (atom4.getGroup() == group) {
                        atom3 = atom4;
                        continue;
                    }
                    atom2 = atom4;
                }
                break;
            }
            case 'q': {
                return null;
            }
            default: {
                atom = this.getN0();
                if (atom == null) {
                    return null;
                }
                if (this.isPurine) {
                    atom2 = this.getAtomFromOffsetIndex(5);
                    atom3 = this.getAtomFromOffsetIndex(9);
                    break;
                }
                atom2 = this.getAtomFromOffsetIndex(6);
                atom3 = this.getAtomFromOffsetIndex(1);
            }
        }
        if (atom2 == null || atom3 == null) {
            return null;
        }
        tuple3f2 = V3.newVsub(atom2, atom);
        tuple3f = V3.newVsub(atom3, atom);
        if (bl2) {
            tuple3f.scale(-1.0f);
        }
        return Quaternion.getQuaternionFrameV((V3)tuple3f2, (V3)tuple3f, null, bl);
    }

    @Override
    public boolean isCrossLinked(Group group) {
        if (!(group instanceof NucleicMonomer) || this.isPurine == group.isPurine()) {
            return false;
        }
        NucleicMonomer nucleicMonomer = this.isPurine ? (NucleicMonomer)group : this;
        NucleicMonomer nucleicMonomer2 = this.isPurine ? this : (NucleicMonomer)group;
        Atom atom = nucleicMonomer2.getN1();
        Atom atom2 = nucleicMonomer.getN3();
        return atom.isBonded(atom2);
    }

    @Override
    public boolean getCrossLinkLead(JmolList<Integer> jmolList) {
        Atom atom = this.isPurine ? this.getN1() : this.getN3();
        Bond[] bondArray = atom.getBonds();
        if (bondArray == null) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < bondArray.length; ++i) {
            Atom atom2;
            Group group;
            if (!bondArray[i].isHydrogen() || !((group = (atom2 = bondArray[i].getOtherAtom(atom)).getGroup()) instanceof NucleicMonomer)) continue;
            NucleicMonomer nucleicMonomer = (NucleicMonomer)group;
            if ((this.isPurine ? nucleicMonomer.getN3() : nucleicMonomer.getN1()) != atom2) continue;
            if (jmolList == null) {
                return true;
            }
            jmolList.addLast(nucleicMonomer.leadAtomIndex);
            bl = true;
        }
        return bl;
    }

    public boolean getEdgePoints(P3[] p3Array) {
        p3Array[0] = this.getLeadAtom();
        p3Array[1] = this.getC4P();
        p3Array[2] = p3Array[5] = this.getC1P();
        switch (this.getGroup1()) {
            case 'C': {
                p3Array[3] = this.getO2();
                p3Array[4] = this.getN4();
                return true;
            }
            case 'A': {
                p3Array[3] = this.getC2();
                p3Array[4] = this.getN6();
                return true;
            }
            case 'G': 
            case 'I': {
                p3Array[3] = this.getC2();
                p3Array[4] = this.getO6();
                return true;
            }
            case 'T': 
            case 'U': {
                p3Array[3] = this.getO2();
                p3Array[4] = this.getO4();
                return true;
            }
        }
        return false;
    }
}

