/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jmol.io.JmolBinary;
import org.jmol.minimize.MinAngle;
import org.jmol.minimize.MinAtom;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.MinPosition;
import org.jmol.minimize.MinTorsion;
import org.jmol.minimize.Minimizer;
import org.jmol.minimize.Util;
import org.jmol.minimize.forcefield.Calculations;
import org.jmol.util.BS;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;

public abstract class ForceField {
    static final int ENERGY = 1;
    static final int EBOND = 2;
    static final int EANGLE = 4;
    static final int ESTRBND = 8;
    static final int ETORSION = 16;
    static final int EOOP = 32;
    static final int EVDW = 64;
    static final int EELECTROSTATIC = 128;
    public static final int ABI_IJ = 3;
    public static final int ABI_JK = 4;
    public static final int TBI_AB = 4;
    public static final int TBI_BC = 5;
    public static final int TBI_CD = 6;
    public static final int R3 = 0;
    public static final int R4 = 1;
    public static final int R5 = 2;
    public static final int R56 = 3;
    public String name;
    Calculations calc;
    private double criterion;
    private double e0;
    private double dE;
    int currentStep;
    private int stepMax;
    private double[][] coordSaved;
    int minAtomCount;
    int minBondCount;
    MinAtom[] minAtoms;
    MinBond[] minBonds;
    MinAngle[] minAngles;
    MinTorsion[] minTorsions;
    MinPosition[] minPositions;
    BS bsFixed;
    Minimizer minimizer;
    String base;

    public abstract void clear();

    public abstract boolean setModel(BS var1, int var2);

    protected void setModelFields() {
        this.minAtoms = this.minimizer.minAtoms;
        this.minBonds = this.minimizer.minBonds;
        this.minAngles = this.minimizer.minAngles;
        this.minTorsions = this.minimizer.minTorsions;
        this.bsFixed = this.minimizer.bsMinFixed;
        this.minAtomCount = this.minAtoms.length;
        this.minBondCount = this.minBonds.length;
    }

    public void setConstraints(Minimizer minimizer) {
        this.bsFixed = minimizer.bsMinFixed;
        this.calc.setConstraints(minimizer.constraints);
        this.coordSaved = null;
    }

    public void steepestDescentInitialize(int n, double d) {
        this.stepMax = n;
        this.criterion = d / (double)this.toUserUnits(1.0);
        this.currentStep = 0;
        this.clearForces();
        this.calc.setLoggingEnabled(true);
        this.calc.setLoggingEnabled(n == 0 || Logger.isActiveLevel(6));
        String string = this.name + " " + this.calc.getDebugHeader(-1) + "Jmol Minimization Version " + Viewer.getJmolVersion() + "\n";
        this.calc.appendLogData(string);
        Logger.info(string);
        this.calc.getConstraintList();
        if (this.calc.loggingEnabled) {
            this.calc.appendLogData(this.calc.getAtomList("S T E E P E S T   D E S C E N T"));
        }
        this.dE = 0.0;
        this.calc.setPreliminary(n > 0);
        this.e0 = this.energyFull(false, false);
        string = TextFormat.sprintf(" Initial " + this.name + " E = %10.3f " + this.minimizer.units + " criterion = %8.6f max steps = " + n, "ff", new Object[]{Float.valueOf(this.toUserUnits(this.e0)), Float.valueOf(this.toUserUnits(d))});
        this.minimizer.report(string, false);
        this.calc.appendLogData(string);
    }

    private void clearForces() {
        for (int i = 0; i < this.minAtomCount; ++i) {
            this.minAtoms[i].force[2] = 0.0;
            this.minAtoms[i].force[1] = 0.0;
            this.minAtoms[i].force[0] = 0.0;
        }
    }

    public boolean steepestDescentTakeNSteps(int n) {
        if (this.stepMax == 0) {
            return false;
        }
        boolean bl = true;
        for (int i = 1; i <= n; ++i) {
            String string;
            ++this.currentStep;
            this.calc.setSilent(true);
            for (int j = 0; j < this.minAtomCount; ++j) {
                if (this.bsFixed != null && this.bsFixed.get(j)) continue;
                this.setForcesUsingNumericalDerivative(this.minAtoms[j], 1);
            }
            this.linearSearch();
            this.calc.setSilent(false);
            if (this.calc.loggingEnabled) {
                this.calc.appendLogData(this.calc.getAtomList("S T E P    " + this.currentStep));
            }
            double d = this.energyFull(false, false);
            this.dE = d - this.e0;
            boolean bl2 = Util.isNear3(d, this.e0, this.criterion);
            if (bl2 || this.currentStep % 10 == 0 || this.stepMax <= this.currentStep) {
                string = TextFormat.sprintf(this.name + " Step %-4d E = %10.6f    dE = %8.6f ", "Fi", new Object[]{new float[]{(float)d, (float)this.dE, (float)this.criterion}, this.currentStep});
                this.minimizer.report(string, false);
                this.calc.appendLogData(string);
            }
            this.e0 = d;
            if (bl2 || this.stepMax <= this.currentStep) {
                if (this.calc.loggingEnabled) {
                    this.calc.appendLogData(this.calc.getAtomList("F I N A L  G E O M E T R Y"));
                }
                if (bl2) {
                    string = TextFormat.formatStringF("\n    " + this.name + " STEEPEST DESCENT HAS CONVERGED: E = %8.5f " + this.minimizer.units + " after " + this.currentStep + " steps", "f", this.toUserUnits(d));
                    this.calc.appendLogData(string);
                    this.minimizer.report(string, true);
                    Logger.info(string);
                }
                return false;
            }
            if (!bl || !(this.getNormalizedDE() >= 2.0)) continue;
            bl = false;
            this.calc.setPreliminary(false);
            this.e0 = this.energyFull(false, false);
        }
        return true;
    }

    private double getEnergies(int n, boolean bl) {
        if ((n & 1) != 0) {
            return this.energyFull(bl, true);
        }
        double d = 0.0;
        if ((n & 2) != 0) {
            d += this.energyBond(bl);
        }
        if ((n & 4) != 0) {
            d += this.energyAngle(bl);
        }
        if ((n & 8) != 0) {
            d += this.energyStretchBend(bl);
        }
        if ((n & 0x20) != 0) {
            d += this.energyOOP(bl);
        }
        if ((n & 0x10) != 0) {
            d += this.energyTorsion(bl);
        }
        if ((n & 0x40) != 0) {
            d += this.energyVDW(bl);
        }
        if ((n & 0x80) != 0) {
            d += this.energyES(bl);
        }
        return d;
    }

    private void setForcesUsingNumericalDerivative(MinAtom minAtom, int n) {
        double d = 1.0E-5;
        minAtom.force[0] = -this.getDE(minAtom, n, 0, d);
        minAtom.force[1] = -this.getDE(minAtom, n, 1, d);
        minAtom.force[2] = -this.getDE(minAtom, n, 2, d);
    }

    private double getDE(MinAtom minAtom, int n, int n2, double d) {
        int n3 = n2;
        minAtom.coord[n3] = minAtom.coord[n3] + d;
        double d2 = this.getEnergies(n, false);
        int n4 = n2;
        minAtom.coord[n4] = minAtom.coord[n4] - d;
        return (d2 - this.e0) / d;
    }

    public double energyFull(boolean bl, boolean bl2) {
        if (bl) {
            this.clearForces();
        }
        double d = this.energyBond(bl) + this.energyAngle(bl) + this.energyTorsion(bl) + this.energyStretchBend(bl) + this.energyOOP(bl) + this.energyVDW(bl) + this.energyES(bl);
        if (!bl2 && this.calc.loggingEnabled) {
            this.calc.appendLogData(TextFormat.sprintf("\nTOTAL %s ENERGY = %8.3f %s/mol\n", "sfs", new Object[]{this.name, Float.valueOf(this.toUserUnits(d)), this.minimizer.units}));
        }
        return d;
    }

    double energyStretchBend(boolean bl) {
        return this.calc.energyStretchBend(bl);
    }

    double energyBond(boolean bl) {
        return this.calc.energyBond(bl);
    }

    double energyAngle(boolean bl) {
        return this.calc.energyAngle(bl);
    }

    double energyTorsion(boolean bl) {
        return this.calc.energyTorsion(bl);
    }

    double energyOOP(boolean bl) {
        return this.calc.energyOOP(bl);
    }

    double energyVDW(boolean bl) {
        return this.calc.energyVDW(bl);
    }

    double energyES(boolean bl) {
        return this.calc.energyES(bl);
    }

    private void linearSearch() {
        double d = 0.0;
        double d2 = 0.23;
        double d3 = 0.3;
        double d4 = d3 * d3;
        double d5 = this.energyFull(false, true);
        for (int i = 0; i < 10; ++i) {
            this.saveCoordinates();
            for (int j = 0; j < this.minAtomCount; ++j) {
                if (this.bsFixed != null && this.bsFixed.get(j)) continue;
                double[] dArray = this.minAtoms[j].force;
                double[] dArray2 = this.minAtoms[j].coord;
                double d6 = dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2];
                if (d6 > d4 / d2 / d2) {
                    d6 = d3 / Math.sqrt(d6) / d2;
                    dArray[0] = dArray[0] * d6;
                    dArray[1] = dArray[1] * d6;
                    dArray[2] = dArray[2] * d6;
                }
                for (int k = 0; k < 3; ++k) {
                    if (!Util.isFinite(dArray[k])) continue;
                    double d7 = dArray[k] * d2;
                    if (d7 > d3) {
                        int n = k;
                        dArray2[n] = dArray2[n] + d3;
                        continue;
                    }
                    if (d7 < -d3) {
                        int n = k;
                        dArray2[n] = dArray2[n] - d3;
                        continue;
                    }
                    int n = k;
                    dArray2[n] = dArray2[n] + d7;
                }
            }
            double d8 = this.energyFull(false, true);
            if (Util.isNear3(d8, d5, 0.001)) break;
            if (d8 > d5) {
                d2 *= 0.1;
                this.restoreCoordinates();
                continue;
            }
            if (!(d8 < d5)) continue;
            d5 = d8;
            d += d2;
            if (!((d2 *= 2.15) > 1.0)) continue;
            d2 = 1.0;
        }
    }

    private void saveCoordinates() {
        if (this.coordSaved == null) {
            this.coordSaved = new double[this.minAtomCount][3];
        }
        for (int i = 0; i < this.minAtomCount; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.coordSaved[i][j] = this.minAtoms[i].coord[j];
            }
        }
    }

    private void restoreCoordinates() {
        for (int i = 0; i < this.minAtomCount; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.minAtoms[i].coord[j] = this.coordSaved[i][j];
            }
        }
    }

    public boolean detectExplosion() {
        Object object;
        int n;
        for (n = 0; n < this.minAtomCount; ++n) {
            object = this.minAtoms[n];
            for (int i = 0; i < 3; ++i) {
                if (Util.isFinite(((MinAtom)object).coord[i])) continue;
                return true;
            }
        }
        for (n = 0; n < this.minBondCount; ++n) {
            object = this.minBonds[n];
            if (!(Util.distance2(this.minAtoms[((MinBond)object).data[0]].coord, this.minAtoms[((MinBond)object).data[1]].coord) > 900.0)) continue;
            return true;
        }
        return false;
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public double getEnergy() {
        return this.e0;
    }

    public String getAtomList(String string) {
        return this.calc.getAtomList(string);
    }

    public double getEnergyDiff() {
        return this.dE;
    }

    public String getLogData() {
        return this.calc.getLogData();
    }

    double getNormalizedDE() {
        return Math.abs(this.dE / this.criterion);
    }

    public float toUserUnits(double d) {
        return this.toUnits(d, this.calc.getUnits());
    }

    private float toUnits(double d, String string) {
        return (float)(string.equalsIgnoreCase(this.minimizer.units) ? d : d * (this.minimizer.units.equals("kJ") ? 4.1868 : 0.23884589662749595));
    }

    public void log(String string) {
        this.calc.appendLogData(string);
    }

    protected BufferedReader getBufferedReader(String string) throws IOException {
        URL uRL = null;
        uRL = this.getResourceUrl(string);
        if (uRL == null) {
            System.err.println("Couldn't find file: " + string);
            throw new NullPointerException();
        }
        return this.getResource(uRL);
    }

    private URL getResourceUrl(String string) {
        string = "data/" + string;
        return this.getClass().getResource(string);
    }

    protected BufferedReader getResource(URL uRL) throws IOException {
        return JmolBinary.getBufferedReader(new BufferedInputStream((InputStream)uRL.getContent()), null);
    }
}

