/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.atomdata;

import org.jmol.constant.EnumVdw;
import org.jmol.util.SB;

public class RadiusData {
    public String info;
    public EnumType factorType = EnumType.ABSOLUTE;
    public EnumVdw vdwType = EnumVdw.AUTO;
    public float value = Float.NaN;
    public float valueExtended = 0.0f;
    public float[] values;

    public RadiusData(float[] fArray, float f, EnumType enumType, EnumVdw enumVdw) {
        if (fArray != null) {
            this.values = fArray;
            this.value = 2.1474836E9f;
            return;
        }
        if (enumType == null) {
            return;
        }
        this.factorType = enumType;
        this.value = f;
        if (enumVdw != null) {
            this.vdwType = enumVdw;
        }
    }

    public String toString() {
        if (Float.isNaN(this.value)) {
            return "";
        }
        SB sB = new SB();
        switch (this.factorType) {
            case ABSOLUTE: {
                sB.appendF(this.value);
                break;
            }
            case OFFSET: {
                sB.append(this.value > 0.0f ? "+" : "").appendF(this.value);
                break;
            }
            case FACTOR: {
                sB.appendI((int)(this.value * 100.0f)).append("%");
                if (this.vdwType == EnumVdw.AUTO) break;
                sB.append(this.vdwType.getVdwLabel());
                break;
            }
            case SCREEN: {
                sB.appendI((int)this.value);
            }
        }
        return sB.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumType {
        ABSOLUTE,
        OFFSET,
        FACTOR,
        SCREEN;

    }
}

