/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAdapterAtomIterator;
import org.jmol.util.BS;
import org.jmol.util.JmolList;
import org.jmol.util.P3;
import org.jmol.util.Tensor;
import org.jmol.util.V3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AtomIterator
implements JmolAdapterAtomIterator {
    private int iatom;
    private Atom atom;
    private int atomCount;
    private Atom[] atoms;
    private BS bsAtoms;

    AtomIterator(AtomSetCollection atomSetCollection) {
        this.atomCount = atomSetCollection.getAtomCount();
        this.atoms = atomSetCollection.getAtoms();
        this.bsAtoms = atomSetCollection.bsAtoms;
        this.iatom = 0;
    }

    @Override
    public boolean hasNext() {
        if (this.iatom == this.atomCount) {
            return false;
        }
        while ((this.atom = this.atoms[this.iatom++]) == null || this.bsAtoms != null && !this.bsAtoms.get(this.atom.index)) {
            if (this.iatom != this.atomCount) continue;
            return false;
        }
        this.atoms[this.iatom - 1] = null;
        return true;
    }

    @Override
    public int getAtomSetIndex() {
        return this.atom.atomSetIndex;
    }

    @Override
    public BS getAtomSymmetry() {
        return this.atom.bsSymmetry;
    }

    @Override
    public int getAtomSite() {
        return this.atom.atomSite + 1;
    }

    @Override
    public Object getUniqueID() {
        return this.atom.index;
    }

    @Override
    public int getElementNumber() {
        return this.atom.elementNumber > 0 ? this.atom.elementNumber : JmolAdapter.getElementNumber(this.atom.getElementSymbol());
    }

    @Override
    public String getAtomName() {
        return this.atom.atomName;
    }

    @Override
    public int getFormalCharge() {
        return this.atom.formalCharge;
    }

    @Override
    public float getPartialCharge() {
        return this.atom.partialCharge;
    }

    @Override
    public JmolList<Tensor> getTensors() {
        return this.atom.tensors;
    }

    @Override
    public float getRadius() {
        return this.atom.radius;
    }

    @Override
    public V3 getVib() {
        return this.atom.vib == null || Float.isNaN(this.atom.vib.z) ? null : this.atom.vib;
    }

    @Override
    public float getBfactor() {
        return Float.isNaN(this.atom.bfactor) && this.atom.anisoBorU != null ? this.atom.anisoBorU[7] * 100.0f : this.atom.bfactor;
    }

    @Override
    public int getOccupancy() {
        return (int)(this.atom.foccupancy * 100.0f);
    }

    @Override
    public boolean getIsHetero() {
        return this.atom.isHetero;
    }

    @Override
    public int getAtomSerial() {
        return this.atom.atomSerial;
    }

    @Override
    public int getChainID() {
        return this.atom.chainID;
    }

    @Override
    public char getAlternateLocationID() {
        return JmolAdapter.canonizeAlternateLocationID(this.atom.alternateLocationID);
    }

    @Override
    public String getGroup3() {
        return this.atom.group3;
    }

    @Override
    public int getSequenceNumber() {
        return this.atom.sequenceNumber;
    }

    @Override
    public char getInsertionCode() {
        return JmolAdapter.canonizeInsertionCode(this.atom.insertionCode);
    }

    @Override
    public P3 getXYZ() {
        return this.atom;
    }
}

