/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import org.jmol.symmetry.HallInfo;
import org.jmol.symmetry.HallRotation;
import org.jmol.symmetry.HallTranslation;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.Logger;
import org.jmol.util.Matrix4f;
import org.jmol.util.P3i;
import org.jmol.util.SB;
import org.jmol.util.Tuple3i;

class HallRotationTerm {
    String inputCode;
    String primitiveCode;
    String lookupCode;
    String translationString;
    HallRotation rotation;
    HallTranslation translation;
    Matrix4f seitzMatrix12ths = new Matrix4f();
    boolean isImproper;
    int order;
    char axisType = '\u0000';
    char diagonalReferenceAxis = '\u0000';
    boolean allPositive = true;

    HallRotationTerm(HallInfo hallInfo, String string, int n, char c) {
        HallTranslation hallTranslation;
        this.inputCode = string;
        string = string + "   ";
        if (string.charAt(0) == '-') {
            this.isImproper = true;
            string = string.substring(1);
        }
        this.primitiveCode = "";
        this.order = string.charAt(0) - 48;
        this.diagonalReferenceAxis = '\u0000';
        this.axisType = '\u0000';
        int n2 = 2;
        char c2 = string.charAt(1);
        block0 : switch (c2) {
            case 'x': 
            case 'y': 
            case 'z': {
                switch (string.charAt(2)) {
                    case '\"': 
                    case '\'': {
                        this.diagonalReferenceAxis = c2;
                        c2 = string.charAt(2);
                        ++n2;
                    }
                }
            }
            case '*': {
                this.axisType = c2;
                break;
            }
            case '\"': 
            case '\'': {
                this.axisType = c2;
                switch (string.charAt(2)) {
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        this.diagonalReferenceAxis = string.charAt(2);
                        ++n2;
                        break block0;
                    }
                }
                this.diagonalReferenceAxis = c;
                break;
            }
            default: {
                this.axisType = (char)(this.order == 1 ? 95 : (hallInfo.nRotations == 0 ? 122 : (hallInfo.nRotations == 2 ? 42 : (n == 2 || n == 4 ? 120 : 39))));
                string = string.substring(0, 1) + this.axisType + string.substring(1);
            }
        }
        this.primitiveCode = this.primitiveCode + (this.axisType == '_' ? "1" : string.substring(0, 2));
        if (this.diagonalReferenceAxis != '\u0000') {
            string = string.substring(0, 1) + this.diagonalReferenceAxis + this.axisType + string.substring(n2);
            this.primitiveCode = this.primitiveCode + this.diagonalReferenceAxis;
            n2 = 3;
        }
        this.lookupCode = string.substring(0, n2);
        this.rotation = HallRotation.lookup(this.lookupCode);
        if (this.rotation == null) {
            Logger.error((String)("Rotation lookup could not find " + this.inputCode + " ? " + this.lookupCode));
            return;
        }
        this.translation = new HallTranslation('\u0000', null);
        this.translationString = "";
        int n3 = string.length();
        for (int i = n2; i < n3; ++i) {
            char c3 = string.charAt(i);
            hallTranslation = HallTranslation.getHallTranslation(c3, this.order);
            if (hallTranslation == null) continue;
            this.translationString = this.translationString + "" + hallTranslation.translationCode;
            this.translation.rotationShift12ths += hallTranslation.rotationShift12ths;
            this.translation.vectorShift12ths.add((Tuple3i)hallTranslation.vectorShift12ths);
        }
        this.primitiveCode = (this.isImproper ? "-" : "") + this.primitiveCode + this.translationString;
        if (this.isImproper) {
            this.seitzMatrix12ths.setM(this.rotation.seitzMatrixInv);
        } else {
            this.seitzMatrix12ths.setM(this.rotation.seitzMatrix);
        }
        this.seitzMatrix12ths.m03 = this.translation.vectorShift12ths.x;
        this.seitzMatrix12ths.m13 = this.translation.vectorShift12ths.y;
        this.seitzMatrix12ths.m23 = this.translation.vectorShift12ths.z;
        switch (this.axisType) {
            case 'x': {
                this.seitzMatrix12ths.m03 += (float)this.translation.rotationShift12ths;
                break;
            }
            case 'y': {
                this.seitzMatrix12ths.m13 += (float)this.translation.rotationShift12ths;
                break;
            }
            case 'z': {
                this.seitzMatrix12ths.m23 += (float)this.translation.rotationShift12ths;
            }
        }
        if (hallInfo.vectorCode.length() > 0) {
            Matrix4f matrix4f = new Matrix4f();
            Matrix4f matrix4f2 = new Matrix4f();
            matrix4f.setIdentity();
            matrix4f2.setIdentity();
            hallTranslation = hallInfo.vector12ths;
            matrix4f.m03 = ((P3i)hallTranslation).x;
            matrix4f.m13 = ((P3i)hallTranslation).y;
            matrix4f.m23 = ((P3i)hallTranslation).z;
            matrix4f2.m03 = -((P3i)hallTranslation).x;
            matrix4f2.m13 = -((P3i)hallTranslation).y;
            matrix4f2.m23 = -((P3i)hallTranslation).z;
            this.seitzMatrix12ths.mul2(matrix4f, this.seitzMatrix12ths);
            this.seitzMatrix12ths.mulM4(matrix4f2);
        }
        if (Logger.debugging) {
            Logger.debug((String)("code = " + string + "; primitive code =" + this.primitiveCode + "\n Seitz Matrix(12ths):" + this.seitzMatrix12ths));
        }
    }

    String dumpInfo(String string) {
        SB sB = new SB();
        sB.append("\ninput code: ").append(this.inputCode).append("; primitive code: ").append(this.primitiveCode).append("\norder: ").appendI(this.order).append(this.isImproper ? " (improper axis)" : "");
        if (this.axisType != '_') {
            sB.append("; axisType: ").appendC(this.axisType);
            if (this.diagonalReferenceAxis != '\u0000') {
                sB.appendC(this.diagonalReferenceAxis);
            }
        }
        if (this.translationString.length() > 0) {
            sB.append("; translation: ").append(this.translationString);
        }
        if (string.length() > 0) {
            sB.append("; vector offset: ").append(string);
        }
        if (this.rotation != null) {
            sB.append("\noperator: ").append(this.getXYZ(this.allPositive)).append("\nSeitz matrix:\n").append(SymmetryOperation.dumpSeitz(this.seitzMatrix12ths));
        }
        return sB.toString();
    }

    String getXYZ(boolean bl) {
        return SymmetryOperation.getXYZFromMatrix(this.seitzMatrix12ths, true, bl, true);
    }
}

