/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import org.jmol.api.SymmetryInterface;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Escape;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.Matrix3f;
import org.jmol.util.Matrix4f;
import org.jmol.util.Measure;
import org.jmol.util.P3;
import org.jmol.util.P4;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.util.TriangleData;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;

class SymmetryOperation
extends Matrix4f {
    String xyzOriginal;
    String xyz;
    private boolean doNormalize = true;
    boolean isFinalized;
    private int opId;
    private P3 atomTest;
    private P3 temp3;
    private String[] myLabels;
    int modDim;
    float[] rotTransMatrix;
    Matrix4f gammaIS;
    static final String[] labelsXYZ = new String[]{"x", "y", "z"};
    static final String[] labelsX1_6 = new String[]{"x1", "x2", "x3", "x4", "x5", "x6"};
    private static final String[] twelfths = new String[]{"0", "1/12", "1/6", "1/4", "1/3", "5/12", "1/2", "7/12", "2/3", "3/4", "5/6", "11/12"};

    SymmetryOperation(SymmetryOperation symmetryOperation, P3[] p3Array, int n, int n2, boolean bl) {
        this.doNormalize = bl;
        if (symmetryOperation == null) {
            this.opId = n2;
            return;
        }
        this.xyzOriginal = symmetryOperation.xyzOriginal;
        this.xyz = symmetryOperation.xyz;
        this.opId = symmetryOperation.opId;
        this.modDim = symmetryOperation.modDim;
        this.myLabels = symmetryOperation.myLabels;
        this.rotTransMatrix = symmetryOperation.rotTransMatrix;
        this.setM(symmetryOperation);
        if (symmetryOperation.rotTransMatrix.length == 32) {
            this.setMod456();
        }
        this.doFinalize();
        if (bl) {
            this.setOffset(p3Array, n, n2);
        }
    }

    private void setMod456() {
        this.gammaIS = new Matrix4f();
        this.gammaIS.setA(this.rotTransMatrix, 16);
    }

    void doFinalize() {
        this.m03 /= 12.0f;
        this.m13 /= 12.0f;
        this.m23 /= 12.0f;
        if (this.modDim > 0) {
            this.gammaIS.m03 /= 12.0f;
            this.gammaIS.m13 /= 12.0f;
            this.gammaIS.m23 /= 12.0f;
        }
        this.isFinalized = true;
    }

    String getXyz(boolean bl) {
        return bl && this.modDim == 0 || this.xyzOriginal == null ? this.xyz : this.xyzOriginal;
    }

    void newPoint(P3 p3, P3 p32, int n, int n2, int n3) {
        if (this.temp3 == null) {
            this.temp3 = new P3();
        }
        this.temp3.setT((Tuple3f)p3);
        this.transform2((Tuple3f)this.temp3, (Tuple3f)this.temp3);
        p32.set(this.temp3.x + (float)n, this.temp3.y + (float)n2, this.temp3.z + (float)n3);
    }

    String dumpInfo() {
        return "\n" + this.xyz + "\ninternal matrix representation:\n" + this.toString();
    }

    static final String dumpSeitz(Matrix4f matrix4f) {
        return new SB().append("{\t").appendI((int)matrix4f.m00).append("\t").appendI((int)matrix4f.m01).append("\t").appendI((int)matrix4f.m02).append("\t").append(SymmetryOperation.twelfthsOf(matrix4f.m03)).append("\t}\n").append("{\t").appendI((int)matrix4f.m10).append("\t").appendI((int)matrix4f.m11).append("\t").appendI((int)matrix4f.m12).append("\t").append(SymmetryOperation.twelfthsOf(matrix4f.m13)).append("\t}\n").append("{\t").appendI((int)matrix4f.m20).append("\t").appendI((int)matrix4f.m21).append("\t").appendI((int)matrix4f.m22).append("\t").append(SymmetryOperation.twelfthsOf(matrix4f.m23)).append("\t}\n").append("{\t0\t0\t0\t1\t}\n").toString();
    }

    static final String dumpCanonicalSeitz(Matrix4f matrix4f) {
        return new SB().append("{\t").appendI((int)matrix4f.m00).append("\t").appendI((int)matrix4f.m01).append("\t").appendI((int)matrix4f.m02).append("\t").append(SymmetryOperation.twelfthsOf((matrix4f.m03 + 12.0f) % 12.0f)).append("\t}\n").append("{\t").appendI((int)matrix4f.m10).append("\t").appendI((int)matrix4f.m11).append("\t").appendI((int)matrix4f.m12).append("\t").append(SymmetryOperation.twelfthsOf((matrix4f.m13 + 12.0f) % 12.0f)).append("\t}\n").append("{\t").appendI((int)matrix4f.m20).append("\t").appendI((int)matrix4f.m21).append("\t").appendI((int)matrix4f.m22).append("\t").append(SymmetryOperation.twelfthsOf((matrix4f.m23 + 12.0f) % 12.0f)).append("\t}\n").append("{\t0\t0\t0\t1\t}\n").toString();
    }

    boolean setMatrixFromXYZ(String string, int n) {
        if (string == null) {
            return false;
        }
        this.xyzOriginal = string;
        string = string.toLowerCase();
        int n2 = 16;
        this.modDim = n;
        if (n > 0) {
            n2 = 32;
            this.myLabels = labelsX1_6;
        }
        this.rotTransMatrix = new float[n2];
        boolean bl = string.startsWith("!");
        if (bl) {
            string = string.substring(1);
        }
        if (string.indexOf("xyz matrix:") == 0) {
            this.xyz = string;
            Parser.parseStringInfestedFloatArray((String)string, null, (float[])this.rotTransMatrix);
            return this.setFromMatrix(null, bl);
        }
        if (string.indexOf("[[") == 0) {
            string = string.replace('[', ' ').replace(']', ' ').replace(',', ' ');
            Parser.parseStringInfestedFloatArray((String)string, null, (float[])this.rotTransMatrix);
            for (int i = 0; i < n2; ++i) {
                float f = this.rotTransMatrix[i];
                if (!Float.isNaN(f)) continue;
                return false;
            }
            this.setA(this.rotTransMatrix, 0);
            if (n2 == 32) {
                this.setMod456();
            }
            this.isFinalized = true;
            if (bl) {
                this.invertM(this);
            }
            this.xyz = SymmetryOperation.getXYZFromMatrix(this, false, false, false);
            return true;
        }
        String string2 = SymmetryOperation.getMatrixFromString(this, string, this.rotTransMatrix, false);
        if (string2 == null) {
            return false;
        }
        this.setA(this.rotTransMatrix, 0);
        if (n2 == 32) {
            this.setMod456();
        }
        if (bl) {
            this.invertM(this);
            this.xyz = SymmetryOperation.getXYZFromMatrix(this, true, false, false);
        } else {
            this.xyz = string2;
        }
        if (Logger.debugging) {
            Logger.debug((String)("" + (Object)((Object)this)));
        }
        return true;
    }

    boolean setFromMatrix(float[] fArray, boolean bl) {
        float f = 0.0f;
        int n = 0;
        this.myLabels = this.modDim == 0 ? labelsXYZ : labelsX1_6;
        for (int i = 0; i < this.rotTransMatrix.length; ++i) {
            if (Float.isNaN(this.rotTransMatrix[i])) {
                return false;
            }
            f = this.rotTransMatrix[i];
            if (Math.abs(f) < 1.0E-5f) {
                f = 0.0f;
            }
            if (i % 4 == 3) {
                if (fArray != null) {
                    f /= 12.0f;
                    if (n < fArray.length) {
                        f += fArray[n++];
                    }
                }
                f = SymmetryOperation.normalizeTwelfths((float)((f < 0.0f ? -1 : 1) * Math.round(Math.abs(f * 12.0f))) / 12.0f, this.doNormalize);
            }
            this.rotTransMatrix[i] = f;
            if (i != 11 && i != 27) continue;
            i += 4;
        }
        this.rotTransMatrix[15] = 1.0f;
        this.setA(this.rotTransMatrix, 0);
        if (this.rotTransMatrix.length == 32) {
            this.rotTransMatrix[31] = 1.0f;
            this.gammaIS = new Matrix4f();
            this.gammaIS.setA(this.rotTransMatrix, 16);
        }
        this.isFinalized = true;
        if (bl) {
            this.invertM(this);
        }
        this.xyz = SymmetryOperation.getXYZFromMatrix(this, true, false, false);
        return true;
    }

    static String getMatrixFromString(SymmetryOperation symmetryOperation, String string, float[] fArray, boolean bl) {
        String[] stringArray;
        char c;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = symmetryOperation != null && symmetryOperation.modDim > 0;
        int n = bl5 ? 4 + symmetryOperation.modDim : 4;
        boolean bl6 = symmetryOperation != null && symmetryOperation.doNormalize;
        fArray[15] = 1.0f;
        if (bl5) {
            int n2 = n;
            c = n * 5 - 4;
            while (n2 < 7) {
                fArray[c] = 1.0f;
                ++n2;
                c += 5;
            }
            fArray[31] = 1.0f;
        }
        String[] stringArray2 = stringArray = symmetryOperation == null || !bl5 ? null : symmetryOperation.myLabels;
        if (stringArray == null) {
            stringArray = labelsXYZ;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        float f = 0.0f;
        String string2 = "";
        int n6 = -1;
        float f2 = 1.0f;
        string = string + ",";
        if (bl5) {
            string = TextFormat.simpleReplace((String)string, (String)"x1", (String)"x");
            string = TextFormat.simpleReplace((String)string, (String)"x2", (String)"y");
            string = TextFormat.simpleReplace((String)string, (String)"x3", (String)"z");
            string = TextFormat.simpleReplace((String)string, (String)"x4", (String)"x");
            string = TextFormat.simpleReplace((String)string, (String)"x5", (String)"y");
            string = TextFormat.simpleReplace((String)string, (String)"x6", (String)"z");
        }
        block13: for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            switch (c) {
                case ' ': 
                case '!': 
                case '\'': 
                case '{': 
                case '}': {
                    continue block13;
                }
                case '-': {
                    bl4 = true;
                    continue block13;
                }
                case '+': {
                    bl4 = false;
                    continue block13;
                }
                case '/': {
                    bl2 = true;
                    continue block13;
                }
                case 'X': 
                case 'x': {
                    int n7;
                    int n8 = n7 = bl4 ? -1 : 1;
                    if (bl && f != 0.0f) {
                        n7 = (int)((float)n7 * f);
                        f = 0.0f;
                    }
                    n3 = n7;
                    break;
                }
                case 'Y': 
                case 'y': {
                    int n9 = n4 = bl4 ? -1 : 1;
                    if (!bl || f == 0.0f) break;
                    n4 = (int)((float)n4 * f);
                    f = 0.0f;
                    break;
                }
                case 'Z': 
                case 'z': {
                    int n10 = n5 = bl4 ? -1 : 1;
                    if (!bl || f == 0.0f) break;
                    n5 = (int)((float)n5 * f);
                    f = 0.0f;
                    break;
                }
                case ',': {
                    if (++n6 > 2 && !bl5) {
                        Logger.warn((String)("Symmetry Operation? " + string));
                        return null;
                    }
                    f = SymmetryOperation.normalizeTwelfths(f, bl6);
                    int n11 = n6 * 4 + (n6 > 2 ? 4 : 0);
                    fArray[n11++] = n3;
                    fArray[n11++] = n4;
                    fArray[n11++] = n5;
                    fArray[n11] = f;
                    String string3 = "";
                    int n12 = n6 < 3 ? 0 : 3;
                    string3 = string3 + SymmetryOperation.plusMinus(string3, n3, stringArray[n12++]);
                    string3 = string3 + SymmetryOperation.plusMinus(string3, n4, stringArray[n12++]);
                    string3 = string3 + SymmetryOperation.plusMinus(string3, n5, stringArray[n12++]);
                    string3 = string3 + SymmetryOperation.xyzFraction(f, false, true);
                    string2 = string2 + (string2 == "" ? "" : ",") + string3;
                    if (n6 == n - 2) {
                        return string2;
                    }
                    n5 = 0;
                    n4 = 0;
                    n3 = 0;
                    f = 0.0f;
                    break;
                }
                case '.': {
                    bl3 = true;
                    f2 = 1.0f;
                    continue block13;
                }
                case '0': {
                    if (!bl3 && (bl2 || !bl)) continue block13;
                }
                default: {
                    int n13 = c - 48;
                    if (bl3 && n13 >= 0 && n13 <= 9) {
                        f2 /= 10.0f;
                        if (f < 0.0f) {
                            bl4 = true;
                        }
                        f += f2 * (float)n13 * (float)(bl4 ? -1 : 1);
                        continue block13;
                    }
                    if (n13 >= 0 && n13 <= 9) {
                        if (bl2) {
                            f /= (float)n13;
                            break;
                        }
                        f = f * 10.0f + (float)((bl4 ? -1 : 1) * n13);
                        bl4 = false;
                        break;
                    }
                    Logger.warn((String)("symmetry character?" + c));
                }
            }
            bl4 = false;
            bl2 = false;
            bl3 = false;
        }
        return null;
    }

    private static String plusMinus(String string, float f, String string2) {
        return f == 0.0f ? "" : (f < 0.0f ? "-" : (string.length() == 0 ? "" : "+")) + string2;
    }

    private static float normalizeTwelfths(float f, boolean bl) {
        f *= 12.0f;
        if (bl) {
            while (f > 6.0f) {
                f -= 12.0f;
            }
            while (f <= -6.0f) {
                f += 12.0f;
            }
        }
        return f;
    }

    static final String getXYZFromMatrix(Matrix4f matrix4f, boolean bl, boolean bl2, boolean bl3) {
        String[] stringArray;
        String string = "";
        SymmetryOperation symmetryOperation = matrix4f instanceof SymmetryOperation ? (SymmetryOperation)matrix4f : null;
        String[] stringArray2 = stringArray = symmetryOperation == null ? null : symmetryOperation.myLabels;
        if (stringArray == null) {
            stringArray = labelsXYZ;
        }
        float[] fArray = new float[4];
        int n = symmetryOperation == null ? 3 : symmetryOperation.modDim + 3;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4 = n3 = i < 3 ? 0 : 3;
            if (i < 3) {
                matrix4f.getRow(i, fArray);
            } else {
                int n5 = 0;
                n2 = i * 4 + 4;
                while (n5 < 4) {
                    fArray[n5] = symmetryOperation.rotTransMatrix[n2];
                    ++n5;
                    ++n2;
                }
            }
            String string2 = "";
            for (n2 = 0; n2 < 3; ++n2) {
                if (fArray[n2] == 0.0f) continue;
                string2 = string2 + SymmetryOperation.plusMinus(string2, fArray[n2], stringArray[n2 + n3]);
            }
            string2 = string2 + SymmetryOperation.xyzFraction(bl ? fArray[3] : fArray[3] * 12.0f, bl2, bl3);
            string = string + "," + string2;
        }
        return string.substring(1);
    }

    private static final String twelfthsOf(float f) {
        int n;
        String string = "";
        int n2 = Math.round(f);
        if (n2 == 12) {
            return "1";
        }
        if (n2 == -12) {
            return "-1";
        }
        if (n2 < 0 && (n2 = -n2) % 12 != 0) {
            string = "-";
        }
        if ((n = n2 / 12) < 1) {
            return string + twelfths[n2 % 12];
        }
        int n3 = 0;
        switch (n2 % 12) {
            case 0: {
                return string + n;
            }
            case 1: 
            case 5: 
            case 7: 
            case 11: {
                n3 = 12;
                break;
            }
            case 2: 
            case 10: {
                n3 = 6;
                break;
            }
            case 3: 
            case 9: {
                n3 = 4;
                break;
            }
            case 4: 
            case 8: {
                n3 = 3;
                break;
            }
            case 6: {
                n3 = 2;
            }
        }
        return string + n2 * n3 / 12 + "/" + n3;
    }

    private static final String xyzFraction(float f, boolean bl, boolean bl2) {
        String string;
        if (bl) {
            for (f = (float)Math.round(f); f < 0.0f; f += 12.0f) {
            }
        } else if (bl2 && f > 6.0f) {
            f -= 12.0f;
        }
        return (string = SymmetryOperation.twelfthsOf(f)).charAt(0) == '0' ? "" : (f > 0.0f ? "+" + string : string);
    }

    private void setOffset(P3[] p3Array, int n, int n2) {
        int n3 = n;
        int n4 = n3 + n2;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.atomTest == null) {
            this.atomTest = new P3();
        }
        for (int i = n3; i < n4; ++i) {
            this.newPoint(p3Array[i], this.atomTest, 0, 0, 0);
            f += this.atomTest.x;
            f2 += this.atomTest.y;
            f3 += this.atomTest.z;
        }
        while ((double)f < -0.001 || (double)f >= (double)n2 + 0.001) {
            this.m03 += (float)(f < 0.0f ? 1 : -1);
            f += (float)(f < 0.0f ? n2 : -n2);
        }
        while ((double)f2 < -0.001 || (double)f2 >= (double)n2 + 0.001) {
            this.m13 += (float)(f2 < 0.0f ? 1 : -1);
            f2 += (float)(f2 < 0.0f ? n2 : -n2);
        }
        while ((double)f3 < -0.001 || (double)f3 >= (double)n2 + 0.001) {
            this.m23 += (float)(f3 < 0.0f ? 1 : -1);
            f3 += (float)(f3 < 0.0f ? n2 : -n2);
        }
    }

    V3[] rotateAxes(V3[] v3Array, UnitCell unitCell, P3 p3, Matrix3f matrix3f) {
        V3[] v3Array2 = new V3[3];
        this.getRotationScale(matrix3f);
        int n = v3Array.length;
        while (--n >= 0) {
            p3.setT((Tuple3f)v3Array[n]);
            unitCell.toFractional((Tuple3f)p3, true);
            matrix3f.transform((Tuple3f)p3);
            unitCell.toCartesian((Tuple3f)p3, true);
            v3Array2[n] = V3.newV((Tuple3f)p3);
        }
        return v3Array2;
    }

    public Object[] getDescription(SymmetryInterface symmetryInterface, P3 p3, P3 p32, String string) {
        if (!this.isFinalized) {
            this.doFinalize();
        }
        return SymmetryOperation.getDescription(this, this.xyzOriginal, symmetryInterface, p3, p32, string);
    }

    private static Object[] getDescription(SymmetryOperation symmetryOperation, String string, SymmetryInterface symmetryInterface, P3 p3, P3 p32, String string2) {
        float f;
        float f2;
        String string3;
        V3 v3;
        boolean bl;
        boolean bl2;
        V3 v32 = new V3();
        P3 p33 = new P3();
        P3 p34 = new P3();
        P3 p35 = new P3();
        P3 p36 = new P3();
        V3 v33 = new V3();
        V3 v34 = new V3();
        String string4 = SymmetryOperation.getXYZFromMatrix(symmetryOperation, false, false, false);
        boolean bl3 = bl2 = string2 == null;
        if (p3 == null || Float.isNaN(p3.x)) {
            p3 = new P3();
        }
        if (p32 != null) {
            p34.setT((Tuple3f)p3);
            p35.setT((Tuple3f)p32);
            symmetryInterface.toUnitCell(p34, p33);
            symmetryInterface.toUnitCell(p35, p33);
            symmetryInterface.toFractional((Tuple3f)p34, false);
            symmetryOperation.transform((Tuple3f)p34);
            symmetryInterface.toCartesian((Tuple3f)p34, false);
            symmetryInterface.toUnitCell(p34, p33);
            if (p34.distance((Tuple3f)p35) > 0.1f) {
                return null;
            }
            p34.setT((Tuple3f)p3);
            p35.setT((Tuple3f)p32);
            symmetryInterface.toFractional((Tuple3f)p34, false);
            symmetryInterface.toFractional((Tuple3f)p35, false);
            symmetryOperation.transform((Tuple3f)p34);
            v34.sub2((Tuple3f)p35, (Tuple3f)p34);
            p34.set(0.0f, 0.0f, 0.0f);
            p35.set(0.0f, 0.0f, 0.0f);
        }
        p36.z = 1.0f;
        p35.y = 1.0f;
        p34.x = 1.0f;
        p34.add((Tuple3f)p3);
        p35.add((Tuple3f)p3);
        p36.add((Tuple3f)p3);
        P3 p37 = P3.newP((Tuple3f)p3);
        P3 p38 = P3.newP((Tuple3f)p34);
        P3 p39 = P3.newP((Tuple3f)p35);
        P3 p310 = P3.newP((Tuple3f)p36);
        symmetryInterface.toFractional((Tuple3f)p37, false);
        symmetryInterface.toFractional((Tuple3f)p38, false);
        symmetryInterface.toFractional((Tuple3f)p39, false);
        symmetryInterface.toFractional((Tuple3f)p310, false);
        symmetryOperation.transform2((Tuple3f)p37, (Tuple3f)p37);
        symmetryOperation.transform2((Tuple3f)p38, (Tuple3f)p38);
        symmetryOperation.transform2((Tuple3f)p39, (Tuple3f)p39);
        symmetryOperation.transform2((Tuple3f)p310, (Tuple3f)p310);
        p37.add((Tuple3f)v34);
        p38.add((Tuple3f)v34);
        p39.add((Tuple3f)v34);
        p310.add((Tuple3f)v34);
        SymmetryOperation.approx((Tuple3f)v34);
        symmetryInterface.toCartesian((Tuple3f)p37, false);
        symmetryInterface.toCartesian((Tuple3f)p38, false);
        symmetryInterface.toCartesian((Tuple3f)p39, false);
        symmetryInterface.toCartesian((Tuple3f)p310, false);
        V3 v35 = new V3();
        v35.sub2((Tuple3f)p38, (Tuple3f)p37);
        V3 v36 = new V3();
        v36.sub2((Tuple3f)p39, (Tuple3f)p37);
        V3 v37 = new V3();
        v37.sub2((Tuple3f)p310, (Tuple3f)p37);
        v32.cross(v35, v36);
        boolean bl4 = bl = v32.dot((Tuple3f)v37) < 0.0f;
        if (bl) {
            p38.scaleAdd2(-2.0f, (Tuple3f)v35, (Tuple3f)p38);
            p39.scaleAdd2(-2.0f, (Tuple3f)v36, (Tuple3f)p39);
            p310.scaleAdd2(-2.0f, (Tuple3f)v37, (Tuple3f)p310);
        }
        Object[] objectArray = (Object[])Measure.computeHelicalAxis(null, (int)135266306, (P3)p3, (P3)p37, (Quaternion)Quaternion.getQuaternionFrame((P3)p37, (Tuple3f)p38, (Tuple3f)p39).div(Quaternion.getQuaternionFrame((P3)p3, (Tuple3f)p34, (Tuple3f)p35)));
        P3 p311 = (P3)objectArray[0];
        V3 v38 = (V3)objectArray[1];
        int n = (int)Math.abs(Parser.approx((float)((P3)objectArray[3]).x, (float)1.0f));
        float f3 = SymmetryOperation.approxF(((P3)objectArray[3]).y);
        if (bl) {
            p38.scaleAdd2(2.0f, (Tuple3f)v35, (Tuple3f)p38);
            p39.scaleAdd2(2.0f, (Tuple3f)v36, (Tuple3f)p39);
            p310.scaleAdd2(2.0f, (Tuple3f)v37, (Tuple3f)p310);
        }
        if ((v3 = V3.newVsub((Tuple3f)p37, (Tuple3f)p3)).length() < 0.1f) {
            v3 = null;
        }
        P3 p312 = null;
        P3 p313 = null;
        P3 p314 = null;
        boolean bl5 = n == 0;
        boolean bl6 = !bl5;
        boolean bl7 = false;
        boolean bl8 = false;
        if (bl6 || bl) {
            v3 = null;
        }
        if (bl && bl5) {
            p313 = P3.newP((Tuple3f)p3);
            p313.add((Tuple3f)p37);
            p313.scale(0.5f);
            p312 = p37;
            bl7 = true;
        } else if (bl) {
            V3 v39 = f3 == 0.0f ? new V3() : v38;
            float f4 = 0.0f;
            switch (n) {
                case 60: {
                    f4 = 0.6666667f;
                    break;
                }
                case 120: {
                    f4 = 2.0f;
                    break;
                }
                case 90: {
                    f4 = 1.0f;
                    break;
                }
                case 180: {
                    p314 = new P3();
                    p314.setT((Tuple3f)p3);
                    p314.add((Tuple3f)v39);
                    p311.scaleAdd2(0.5f, (Tuple3f)v39, (Tuple3f)p3);
                    if (p314.distance((Tuple3f)p37) > 0.1f) {
                        v3 = V3.newVsub((Tuple3f)p37, (Tuple3f)p314);
                        p33.setT((Tuple3f)v3);
                        symmetryInterface.toFractional((Tuple3f)p33, false);
                        v33.setT((Tuple3f)p33);
                    } else {
                        v3 = null;
                    }
                    bl6 = false;
                    bl = false;
                    bl8 = true;
                }
            }
            if (f4 != 0.0f) {
                v32.setT((Tuple3f)p3);
                v32.sub((Tuple3f)p311);
                v32.add((Tuple3f)p37);
                v32.sub((Tuple3f)p311);
                v32.sub((Tuple3f)v39);
                v32.scale(f4);
                p311.add((Tuple3f)v32);
                p313 = new P3();
                p313.scaleAdd2(0.5f, (Tuple3f)v39, (Tuple3f)p311);
                p312 = new P3();
                p312.scaleAdd2(-2.0f, (Tuple3f)p313, (Tuple3f)p3);
                p312.scale(-1.0f);
            }
        } else if (v3 != null) {
            p33.setT((Tuple3f)v3);
            symmetryInterface.toFractional((Tuple3f)p33, false);
            if (SymmetryOperation.approxF(p33.x) == 1.0f) {
                p33.x = 0.0f;
            }
            if (SymmetryOperation.approxF(p33.y) == 1.0f) {
                p33.y = 0.0f;
            }
            if (SymmetryOperation.approxF(p33.z) == 1.0f) {
                p33.z = 0.0f;
            }
            v33.setT((Tuple3f)p33);
            symmetryInterface.toCartesian((Tuple3f)p33, false);
            v3.setT((Tuple3f)p33);
        }
        int n2 = n;
        SymmetryOperation.approx0((Tuple3f)v38);
        if (bl6) {
            P3 p315 = new P3();
            v32.setT((Tuple3f)v38);
            int n3 = n;
            if (bl) {
                p315.setT((Tuple3f)p311);
                p315.add((Tuple3f)v32);
                n3 = Math.round(Measure.computeTorsion((Tuple3f)p312, (Tuple3f)p311, (Tuple3f)p315, (Tuple3f)p37, (boolean)true));
            } else if (f3 == 0.0f) {
                p315.setT((Tuple3f)p311);
                p33.scaleAdd2(1.0f, (Tuple3f)p315, (Tuple3f)v32);
                n3 = Math.round(Measure.computeTorsion((Tuple3f)p3, (Tuple3f)p311, (Tuple3f)p33, (Tuple3f)p37, (boolean)true));
            } else {
                p33.setT((Tuple3f)p311);
                p33.add((Tuple3f)v32);
                p315.scaleAdd2(0.5f, (Tuple3f)v32, (Tuple3f)p311);
                n3 = Math.round(Measure.computeTorsion((Tuple3f)p3, (Tuple3f)p311, (Tuple3f)p33, (Tuple3f)p37, (boolean)true));
            }
            if (n3 != 0) {
                n = n3;
            }
        }
        if (bl6 && !bl && f3 == 0.0f && (v38.z < 0.0f || v38.z == 0.0f && (v38.y < 0.0f || v38.y == 0.0f && v38.x < 0.0f))) {
            v38.scale(-1.0f);
            n = -n;
        }
        String string5 = "identity";
        SB sB = new SB();
        if (bl7) {
            p33.setT((Tuple3f)p313);
            symmetryInterface.toFractional((Tuple3f)p33, false);
            string5 = "inversion center|" + SymmetryOperation.fcoord((Tuple3f)p33);
        } else if (bl6) {
            if (bl) {
                string5 = "" + 360 / n2 + "-bar axis";
            } else if (f3 != 0.0f) {
                string5 = "" + 360 / n2 + "-fold screw axis";
                p33.setT((Tuple3f)v38);
                symmetryInterface.toFractional((Tuple3f)p33, false);
                string5 = string5 + "|translation: " + SymmetryOperation.fcoord((Tuple3f)p33);
            } else {
                string5 = "C" + 360 / n2 + " axis";
            }
        } else if (v3 != null) {
            string3 = " " + SymmetryOperation.fcoord((Tuple3f)v33);
            if (bl5) {
                string5 = "translation:" + string3;
            } else if (bl8) {
                float f5 = SymmetryOperation.approxF(v33.x);
                f2 = SymmetryOperation.approxF(v33.y);
                f = SymmetryOperation.approxF(v33.z);
                string3 = " " + SymmetryOperation.fcoord((Tuple3f)v33);
                string5 = f5 != 0.0f && f2 != 0.0f && f != 0.0f ? "d-" : (f5 != 0.0f && f2 != 0.0f || f2 != 0.0f && f != 0.0f || f != 0.0f && f5 != 0.0f ? "n-" : (f5 != 0.0f ? "a-" : (f2 != 0.0f ? "b-" : "c-")));
                string5 = string5 + "glide plane |translation:" + string3;
            }
        } else if (bl8) {
            string5 = "mirror plane";
        }
        if (bl && !bl7) {
            p33.setT((Tuple3f)p313);
            symmetryInterface.toFractional((Tuple3f)p33, false);
            string5 = string5 + "|inversion center at " + SymmetryOperation.fcoord((Tuple3f)p33);
        }
        string3 = null;
        if (!bl2) {
            String string6 = "\ndraw ID " + string2 + "_";
            sB = new SB();
            sB.append("// " + string + "|" + string4 + "|" + string5 + "\n");
            sB.append(string6).append("* delete");
            SymmetryOperation.drawLine(sB, string6 + "frame1X", 0.15f, p3, p34, "red");
            SymmetryOperation.drawLine(sB, string6 + "frame1Y", 0.15f, p3, p35, "green");
            SymmetryOperation.drawLine(sB, string6 + "frame1Z", 0.15f, p3, p36, "blue");
            p33.setT((Tuple3f)p38);
            p33.sub((Tuple3f)p37);
            p33.scaleAdd2(0.9f, (Tuple3f)p33, (Tuple3f)p37);
            SymmetryOperation.drawLine(sB, string6 + "frame2X", 0.2f, p37, p33, "red");
            p33.setT((Tuple3f)p39);
            p33.sub((Tuple3f)p37);
            p33.scaleAdd2(0.9f, (Tuple3f)p33, (Tuple3f)p37);
            SymmetryOperation.drawLine(sB, string6 + "frame2Y", 0.2f, p37, p33, "green");
            p33.setT((Tuple3f)p310);
            p33.sub((Tuple3f)p37);
            p33.scaleAdd2(0.9f, (Tuple3f)p33, (Tuple3f)p37);
            SymmetryOperation.drawLine(sB, string6 + "frame2Z", 0.2f, p37, p33, "purple");
            if (bl6) {
                P3 p316 = new P3();
                String string7 = "red";
                n2 = n;
                f = 1.0f;
                v32.setT((Tuple3f)v38);
                if (bl) {
                    p316.setT((Tuple3f)p311);
                    p316.add((Tuple3f)v32);
                    if (f3 == 0.0f) {
                        p316.setT((Tuple3f)p313);
                        v32.scale(3.0f);
                        p33.scaleAdd2(-1.0f, (Tuple3f)v32, (Tuple3f)p311);
                        sB.append(string6).append("rotVector2 diameter 0.1 ").append(Escape.eP((Tuple3f)p311)).append(Escape.eP((Tuple3f)p33)).append(" color red");
                    }
                    f = p37.distance((Tuple3f)p316);
                    sB.append(string6).append("rotLine1 ").append(Escape.eP((Tuple3f)p316)).append(Escape.eP((Tuple3f)p312)).append(" color red");
                    sB.append(string6).append("rotLine2 ").append(Escape.eP((Tuple3f)p316)).append(Escape.eP((Tuple3f)p37)).append(" color red");
                } else if (f3 == 0.0f) {
                    boolean bl9;
                    boolean bl10 = bl9 = p3.distance((Tuple3f)p37) < 0.2f;
                    if (!bl9) {
                        sB.append(string6).append("rotLine1 ").append(Escape.eP((Tuple3f)p3)).append(Escape.eP((Tuple3f)p311)).append(" color red");
                        sB.append(string6).append("rotLine2 ").append(Escape.eP((Tuple3f)p37)).append(Escape.eP((Tuple3f)p311)).append(" color red");
                    }
                    v32.scale(3.0f);
                    p33.scaleAdd2(-1.0f, (Tuple3f)v32, (Tuple3f)p311);
                    sB.append(string6).append("rotVector2 diameter 0.1 ").append(Escape.eP((Tuple3f)p311)).append(Escape.eP((Tuple3f)p33)).append(" color red");
                    p316.setT((Tuple3f)p311);
                    if (f3 == 0.0f && (double)p3.distance((Tuple3f)p37) < 0.2) {
                        p316.scaleAdd2(0.5f, (Tuple3f)p316, (Tuple3f)v32);
                    }
                } else {
                    string7 = "orange";
                    sB.append(string6).append("rotLine1 ").append(Escape.eP((Tuple3f)p3)).append(Escape.eP((Tuple3f)p311)).append(" color red");
                    p33.setT((Tuple3f)p311);
                    p33.add((Tuple3f)v32);
                    sB.append(string6).append("rotLine2 ").append(Escape.eP((Tuple3f)p37)).append(Escape.eP((Tuple3f)p33)).append(" color red");
                    p316.scaleAdd2(0.5f, (Tuple3f)v32, (Tuple3f)p311);
                }
                p33.setT((Tuple3f)p316);
                p33.add((Tuple3f)v32);
                if (bl && f3 != 0.0f) {
                    sB.append(string6).append("rotRotLine1").append(Escape.eP((Tuple3f)p316)).append(Escape.eP((Tuple3f)p312)).append(" color red");
                    sB.append(string6).append("rotRotLine2").append(Escape.eP((Tuple3f)p316)).append(Escape.eP((Tuple3f)p37)).append(" color red");
                }
                sB.append(string6).append("rotRotArrow arrow width 0.10 scale " + f + " arc ").append(Escape.eP((Tuple3f)p316)).append(Escape.eP((Tuple3f)p33));
                if (bl) {
                    p33.setT((Tuple3f)p312);
                } else {
                    p33.setT((Tuple3f)p3);
                }
                if (p33.distance((Tuple3f)p37) < 0.1f) {
                    p33.set((float)Math.random(), (float)Math.random(), (float)Math.random());
                }
                sB.append(Escape.eP((Tuple3f)p33));
                p33.set(0.0f, (float)n2, 0.0f);
                sB.append(Escape.eP((Tuple3f)p33)).append(" color red");
                sB.append(string6).append("rotVector1 vector diameter 0.1 ").append(Escape.eP((Tuple3f)p311)).append(Escape.eP((Tuple3f)v32)).append("color ").append(string7);
            }
            if (bl8) {
                if ((double)p3.distance((Tuple3f)p314) > 0.2) {
                    sB.append(string6).append("planeVector arrow ").append(Escape.eP((Tuple3f)p3)).append(Escape.eP((Tuple3f)p314)).append(" color indigo");
                }
                if (v3 != null) {
                    p33.scaleAdd2(-1.0f, (Tuple3f)p37, (Tuple3f)p38);
                    p33.add((Tuple3f)p314);
                    SymmetryOperation.drawLine(sB, string6 + "planeFrameX", 0.15f, p314, p33, "translucent red");
                    p33.scaleAdd2(-1.0f, (Tuple3f)p37, (Tuple3f)p39);
                    p33.add((Tuple3f)p314);
                    SymmetryOperation.drawLine(sB, string6 + "planeFrameY", 0.15f, p314, p33, "translucent green");
                    p33.scaleAdd2(-1.0f, (Tuple3f)p37, (Tuple3f)p310);
                    p33.add((Tuple3f)p314);
                    SymmetryOperation.drawLine(sB, string6 + "planeFrameZ", 0.15f, p314, p33, "translucent blue");
                }
                String string8 = v3 == null ? "green" : "blue";
                v32.setT((Tuple3f)v38);
                v32.normalize();
                f2 = -v32.x * p311.x - v32.y * p311.y - v32.z * p311.z;
                P4 p4 = P4.new4((float)v32.x, (float)v32.y, (float)v32.z, (float)f2);
                JmolList jmolList = new JmolList();
                jmolList.addLast((Object)symmetryInterface.getCanonicalCopy(1.05f));
                TriangleData.intersectPlane((P4)p4, (JmolList)jmolList, (int)3);
                int n4 = jmolList.size();
                while (--n4 >= 0) {
                    P3[] p3Array = (P3[])jmolList.get(n4);
                    sB.append(string6).append("planep").appendI(n4).append(" ").append(Escape.eP((Tuple3f)p3Array[0])).append(Escape.eP((Tuple3f)p3Array[1]));
                    if (p3Array.length == 3) {
                        sB.append(Escape.eP((Tuple3f)p3Array[2]));
                    }
                    sB.append(" color translucent ").append(string8);
                }
                if (jmolList.size() == 0) {
                    p33.setT((Tuple3f)p311);
                    p33.add((Tuple3f)v38);
                    sB.append(string6).append("planeCircle scale 2.0 circle ").append(Escape.eP((Tuple3f)p311)).append(Escape.eP((Tuple3f)p33)).append(" color translucent ").append(string8).append(" mesh fill");
                }
            }
            if (bl) {
                sB.append(string6).append("invPoint diameter 0.4 ").append(Escape.eP((Tuple3f)p313));
                sB.append(string6).append("invArrow arrow ").append(Escape.eP((Tuple3f)p3)).append(Escape.eP((Tuple3f)p312)).append(" color indigo");
                if (!bl7) {
                    p33.setT((Tuple3f)p312);
                    p33.add((Tuple3f)p3);
                    p33.sub((Tuple3f)p34);
                    SymmetryOperation.drawLine(sB, string6 + "invFrameX", 0.15f, p312, p33, "translucent red");
                    p33.setT((Tuple3f)p312);
                    p33.add((Tuple3f)p3);
                    p33.sub((Tuple3f)p35);
                    SymmetryOperation.drawLine(sB, string6 + "invFrameY", 0.15f, p312, p33, "translucent green");
                    p33.setT((Tuple3f)p312);
                    p33.add((Tuple3f)p3);
                    p33.sub((Tuple3f)p36);
                    SymmetryOperation.drawLine(sB, string6 + "invFrameZ", 0.15f, p312, p33, "translucent blue");
                }
            }
            if (v3 != null) {
                if (p314 == null) {
                    p314 = P3.newP((Tuple3f)p3);
                }
                sB.append(string6).append("transVector vector ").append(Escape.eP((Tuple3f)p314)).append(Escape.eP((Tuple3f)v3));
            }
            sB.append("\nvar pt00 = " + Escape.eP((Tuple3f)p3));
            sB.append("\nvar p0 = " + Escape.eP((Tuple3f)p37));
            sB.append("\nif (within(0.2,p0).length == 0) {");
            sB.append("\nvar set2 = within(0.2,p0.uxyz.xyz)");
            sB.append("\nif (set2) {");
            sB.append(string6).append("cellOffsetVector arrow @p0 @set2 color grey");
            sB.append(string6).append("offsetFrameX diameter 0.20 @{set2.xyz} @{set2.xyz + ").append(Escape.eP((Tuple3f)v35)).append("*0.9} color red");
            sB.append(string6).append("offsetFrameY diameter 0.20 @{set2.xyz} @{set2.xyz + ").append(Escape.eP((Tuple3f)v36)).append("*0.9} color green");
            sB.append(string6).append("offsetFrameZ diameter 0.20 @{set2.xyz} @{set2.xyz + ").append(Escape.eP((Tuple3f)v37)).append("*0.9} color purple");
            sB.append("\n}}\n");
            string3 = sB.toString();
            sB = null;
            string6 = null;
        }
        if (v3 == null) {
            v33 = null;
        }
        if (bl6) {
            if (!bl && f3 != 0.0f) {
                v3 = V3.newV((Tuple3f)v38);
                p33.setT((Tuple3f)v3);
                symmetryInterface.toFractional((Tuple3f)p33, false);
                v33 = V3.newV((Tuple3f)p33);
            }
            if (!bl || f3 != 0.0f) {
                // empty if block
            }
        }
        if (bl8) {
            if (v3 != null) {
                // empty if block
            }
            n = 0;
        }
        if (bl) {
            if (bl7) {
                p311 = null;
                v38 = null;
                v3 = null;
                v33 = null;
            }
        } else if (bl5) {
            p311 = null;
            v38 = null;
        }
        if (v38 != null) {
            v38.normalize();
        }
        Matrix4f matrix4f = null;
        matrix4f = Matrix4f.newM((Matrix4f)symmetryOperation);
        if (v34.length() != 0.0f) {
            matrix4f.m03 += v34.x;
            matrix4f.m13 += v34.y;
            matrix4f.m23 += v34.z;
        }
        string4 = SymmetryOperation.getXYZFromMatrix(matrix4f, false, false, false);
        return new Object[]{string4, string, string5, string3, SymmetryOperation.approx0((Tuple3f)v33), SymmetryOperation.approx0((Tuple3f)v3), SymmetryOperation.approx0((Tuple3f)p313), SymmetryOperation.approx0((Tuple3f)p311), SymmetryOperation.approx0((Tuple3f)v38), n, matrix4f, v34};
    }

    private static void drawLine(SB sB, String string, float f, P3 p3, P3 p32, String string2) {
        sB.append(string).append(" diameter ").appendF(f).append(Escape.eP((Tuple3f)p3)).append(Escape.eP((Tuple3f)p32)).append(" color ").append(string2);
    }

    static String fcoord(Tuple3f tuple3f) {
        return SymmetryOperation.fc(tuple3f.x) + " " + SymmetryOperation.fc(tuple3f.y) + " " + SymmetryOperation.fc(tuple3f.z);
    }

    private static String fc(float f) {
        String string;
        float f2 = Math.abs(f);
        int n = (int)SymmetryOperation.approxF(f2 * 24.0f);
        String string2 = string = f < 0.0f ? "-" : "";
        if (n % 8 != 0) {
            return string + SymmetryOperation.twelfthsOf(n >> 1);
        }
        return n == 0 ? "0" : (n == 24 ? string + "1" : string + n / 8 + "/3");
    }

    private static Tuple3f approx0(Tuple3f tuple3f) {
        if (tuple3f != null) {
            if (Math.abs(tuple3f.x) < 1.0E-4f) {
                tuple3f.x = 0.0f;
            }
            if (Math.abs(tuple3f.y) < 1.0E-4f) {
                tuple3f.y = 0.0f;
            }
            if (Math.abs(tuple3f.z) < 1.0E-4f) {
                tuple3f.z = 0.0f;
            }
        }
        return tuple3f;
    }

    private static Tuple3f approx(Tuple3f tuple3f) {
        if (tuple3f != null) {
            tuple3f.x = SymmetryOperation.approxF(tuple3f.x);
            tuple3f.y = SymmetryOperation.approxF(tuple3f.y);
            tuple3f.z = SymmetryOperation.approxF(tuple3f.z);
        }
        return tuple3f;
    }

    private static float approxF(float f) {
        return Parser.approx((float)f, (float)100.0f);
    }

    public static void normalizeTranslation(Matrix4f matrix4f) {
        matrix4f.m03 = ((int)matrix4f.m03 + 12) % 12;
        matrix4f.m13 = ((int)matrix4f.m13 + 12) % 12;
        matrix4f.m23 = ((int)matrix4f.m23 + 12) % 12;
    }
}

