/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Parser;
import org.jmol.util.SB;

class ApbsReader
extends VolumeFileReader {
    ApbsReader() {
    }

    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2VFR(surfaceGenerator, bufferedReader);
        if (this.params.thePlane == null) {
            this.params.insideOut = !this.params.insideOut;
        }
        this.isAngstroms = true;
        this.nSurfaces = 1;
    }

    protected void readParameters() throws Exception {
        this.jvxlFileHeaderBuffer = SB.newS((String)this.skipComments(false));
        while (this.line != null && this.line.length() == 0) {
            this.readLine();
        }
        this.jvxlFileHeaderBuffer.append("APBS OpenDx DATA ").append(this.line).append("\n");
        this.jvxlFileHeaderBuffer.append("see http://apbs.sourceforge.net\n");
        String string = this.readLine();
        String[] stringArray = Parser.getTokens((String)string);
        if (stringArray.length >= 4) {
            this.volumetricOrigin.set(this.parseFloatStr(stringArray[1]), this.parseFloatStr(stringArray[2]), this.parseFloatStr(stringArray[3]));
        }
        VolumeFileReader.checkAtomLine(this.isXLowToHigh, this.isAngstroms, stringArray[0], string, this.jvxlFileHeaderBuffer);
        this.readVoxelVector(0);
        this.readVoxelVector(1);
        this.readVoxelVector(2);
        this.readLine();
        stringArray = this.getTokens();
        for (int i = 0; i < 3; ++i) {
            this.voxelCounts[i] = this.parseIntStr(stringArray[i + 5]);
        }
        this.readLine();
    }
}

