/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import org.jmol.adapter.readers.more.ForceFieldReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;

public class Mol2Reader
extends ForceFieldReader {
    private int nAtoms = 0;
    private int atomCount = 0;
    private boolean isPDB = false;
    private int lastSequenceNumber = Integer.MAX_VALUE;
    private int chainID = 64;

    protected void initializeReader() throws Exception {
        this.setUserAtomTypes();
    }

    public boolean checkLine() throws Exception {
        if (this.line.equals("@<TRIPOS>MOLECULE")) {
            if (!this.processMolecule()) {
                return true;
            }
            this.continuing = !this.isLastModel(this.modelNumber);
            return false;
        }
        if (this.line.length() != 0 && this.line.charAt(0) == '#') {
            this.checkCurrentLineForScript();
        }
        return true;
    }

    private boolean processMolecule() throws Exception {
        this.isPDB = false;
        String string = this.readLine().trim();
        if (!this.doGetModel(++this.modelNumber, string)) {
            return false;
        }
        this.lastSequenceNumber = Integer.MAX_VALUE;
        this.chainID = 64;
        this.readLine();
        this.line = this.line + " 0 0 0 0 0 0";
        this.atomCount = this.parseIntStr(this.line);
        int n = this.parseInt();
        int n2 = this.parseInt();
        this.readLine();
        this.readLine();
        if (this.readLine() != null && (this.line.length() == 0 || this.line.charAt(0) != '@') && this.readLine() != null && this.line.length() != 0 && this.line.charAt(0) != '@') {
            if (this.line.indexOf("jmolscript:") >= 0) {
                this.checkCurrentLineForScript();
                if (this.line.equals("#")) {
                    this.line = "";
                }
            }
            if (this.line.length() != 0) {
                string = string + ": " + this.line.trim();
            }
        }
        this.newAtomSet(string);
        while (this.line != null && !this.line.equals("@<TRIPOS>MOLECULE")) {
            if (this.line.equals("@<TRIPOS>ATOM")) {
                this.readAtoms(this.atomCount);
                this.atomSetCollection.setAtomSetName(string);
            } else if (this.line.equals("@<TRIPOS>BOND")) {
                this.readBonds(n);
            } else if (this.line.equals("@<TRIPOS>SUBSTRUCTURE")) {
                this.readResInfo(n2);
            } else if (this.line.equals("@<TRIPOS>CRYSIN")) {
                this.readCrystalInfo();
            }
            this.readLine();
        }
        this.nAtoms += this.atomCount;
        if (this.isPDB) {
            this.setIsPDB();
        }
        this.applySymmetryAndSetTrajectory();
        return true;
    }

    private void readAtoms(int n) throws Exception {
        Object object;
        if (n == 0) {
            return;
        }
        int n2 = this.atomSetCollection.getAtomCount();
        for (int i = 0; i < n; ++i) {
            object = this.atomSetCollection.addNewAtom();
            String[] stringArray = Mol2Reader.getTokensStr((String)this.readLine());
            String string = stringArray[5];
            ((Atom)object).atomName = stringArray[1] + '\u0000' + string;
            int n3 = string.indexOf(".");
            ((Atom)object).elementSymbol = n3 == 0 ? ((Atom)object).atomName : (n3 > 0 ? string.substring(0, n3) : string);
            object.set(this.parseFloatStr(stringArray[2]), this.parseFloatStr(stringArray[3]), this.parseFloatStr(stringArray[4]));
            if (stringArray.length > 6) {
                ((Atom)object).sequenceNumber = this.parseIntStr(stringArray[6]);
                if (((Atom)object).sequenceNumber < this.lastSequenceNumber) {
                    if (this.chainID == 90) {
                        this.chainID = 96;
                    }
                    ++this.chainID;
                }
                this.lastSequenceNumber = ((Atom)object).sequenceNumber;
                this.setChainID((Atom)object, (char)this.chainID);
            }
            if (stringArray.length > 7) {
                ((Atom)object).group3 = stringArray[7];
            }
            if (stringArray.length <= 8) continue;
            ((Atom)object).partialCharge = this.parseFloatStr(stringArray[8]);
            if (((Atom)object).partialCharge != (float)((int)((Atom)object).partialCharge)) continue;
            ((Atom)object).formalCharge = (int)((Atom)object).partialCharge;
        }
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        object = atomArray[n2].group3;
        if (object == null) {
            return;
        }
        boolean bl = false;
        int n4 = this.atomSetCollection.getAtomCount();
        while (--n4 >= n2) {
            if (((String)object).equals(atomArray[this.atomSetCollection.getAtomCount() - 1].group3)) continue;
            bl = true;
            break;
        }
        if (bl) {
            bl = false;
            n4 = this.atomSetCollection.getAtomCount();
            while (--n4 >= n2) {
                Atom atom = atomArray[n4];
                if (atom.group3.length() > 3 || JmolAdapter.lookupGroupID((String)atom.group3) < 0) continue;
                this.isPDB = true;
                bl = true;
                break;
            }
        }
        n4 = this.atomSetCollection.getAtomCount();
        while (--n4 >= n2) {
            if (bl) {
                atomArray[n4].isHetero = JmolAdapter.isHetero((String)atomArray[n4].group3);
                continue;
            }
            atomArray[n4].group3 = null;
        }
    }

    private void readBonds(int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            String[] stringArray = Mol2Reader.getTokensStr((String)this.readLine());
            int n2 = this.parseIntStr(stringArray[1]);
            int n3 = this.parseIntStr(stringArray[2]);
            int n4 = this.parseIntStr(stringArray[3]);
            if (n4 == Integer.MIN_VALUE) {
                n4 = stringArray[3].equals("ar") ? 515 : (stringArray[3].equals("am") ? 1 : 17);
            }
            this.atomSetCollection.addBond(new Bond(this.nAtoms + n2 - 1, this.nAtoms + n3 - 1, n4));
        }
    }

    private void readResInfo(int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            this.readLine();
        }
    }

    private void readCrystalInfo() throws Exception {
        int n;
        this.readLine();
        String[] stringArray = this.getTokens();
        if (stringArray.length < 6) {
            return;
        }
        String string = "";
        for (n = 6; n < stringArray.length; ++n) {
            string = string + " " + stringArray[n];
        }
        string = string == "" ? " P1" : string + " *";
        string = string.substring(1);
        this.setSpaceGroupName(string);
        if (this.ignoreFileUnitCell) {
            return;
        }
        for (n = 0; n < 6; ++n) {
            this.setUnitCellItem(n, this.parseFloatStr(stringArray[n]));
        }
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        for (int i = 0; i < this.atomCount; ++i) {
            this.setAtomCoord(atomArray[this.nAtoms + i]);
        }
    }
}

