/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.TextFormat;

public class AbinitReader
extends AtomSetCollectionReader {
    private float[] cellLattice;

    protected void initializeReader() {
        this.setSpaceGroupName("P1");
        this.doApplySymmetry = true;
    }

    protected boolean checkLine() throws Exception {
        if (this.line.contains("Real(R)+Recip(G)")) {
            this.readIntiallattice();
        }
        return true;
    }

    private void readIntiallattice() throws Exception {
        this.cellLattice = new float[9];
        String string = "";
        int n = 0;
        while (this.readLine() != null && this.line.indexOf("Unit cell volume") < 0) {
            string = string + this.line;
            string = TextFormat.simpleReplace((String)string, (String)"=", (String)"= ");
            String[] stringArray = AbinitReader.getTokensStr((String)string);
            this.cellLattice[n++] = this.parseFloatStr(stringArray[1]) * 0.5291772f;
            this.cellLattice[n++] = this.parseFloatStr(stringArray[2]) * 0.5291772f;
            this.cellLattice[n++] = this.parseFloatStr(stringArray[3]) * 0.5291772f;
            ++n;
        }
        this.setSymmetry();
    }

    private void setSymmetry() throws Exception {
        this.applySymmetryAndSetTrajectory();
        this.setSpaceGroupName("P1");
        this.setFractionalCoordinates(false);
    }
}

