/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.Map;
import java.util.Random;
import org.jmol.api.Interface;
import org.jmol.api.MOCalculationInterface;
import org.jmol.api.QuantumPlaneCalculationInterface;
import org.jmol.api.VolumeDataInterface;
import org.jmol.constant.EnumQuantumShell;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.ArrayUtil;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.P3;
import org.jmol.util.P4;
import org.jmol.util.TextFormat;
import org.jmol.util.V3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IsoMOReader
extends AtomDataReader {
    private Random random;
    private final float[] vDist = new float[3];
    private P3[] points;
    private V3 vTemp;
    MOCalculationInterface q;
    JmolList<Map<String, Object>> mos;
    boolean isNci;
    float[] coef;
    int[][] dfCoefMaps;
    float[] linearCombination;
    float[][] coefs;
    private boolean isElectronDensityCalc;
    private boolean qSetupDone;

    IsoMOReader() {
    }

    @Override
    void init(SurfaceGenerator surfaceGenerator) {
        this.initADR(surfaceGenerator);
        boolean bl = this.isNci = this.params.qmOrbitalType == 3;
        if (this.isNci) {
            this.hasColorData = true;
            this.isXLowToHigh = true;
            this.precalculateVoxelData = false;
            this.params.insideOut = !this.params.insideOut;
        }
    }

    @Override
    protected void setup(boolean bl) {
        String string;
        this.mos = (JmolList)this.params.moData.get("mos");
        this.linearCombination = this.params.qm_moLinearCombination;
        Map map = this.mos != null && this.linearCombination == null ? (Map)this.mos.get(this.params.qm_moNumber - 1) : null;
        boolean bl2 = this.params.moData.containsKey("haveVolumeData");
        if (bl2 && map != null) {
            this.params.volumeData = (VolumeData)map.get("volumeData");
        }
        this.setup2();
        this.doAddHydrogens = false;
        this.getAtoms(this.params.bsSelected, this.doAddHydrogens, !this.isNci, this.isNci, this.isNci, false, false, this.params.qm_marginAngstroms);
        if (this.isNci) {
            this.setHeader("NCI (promolecular)", "see NCIPLOT: A Program for Plotting Noncovalent Interaction Regions, Julia Contreras-Garcia, et al., J. of Chemical Theory and Computation, 2011, 7, 625-632");
        } else {
            this.setHeader("MO", "calculation type: " + this.params.moData.get("calculationType"));
        }
        this.setRanges(this.params.qm_ptsPerAngstrom, this.params.qm_gridMax, 0.0f);
        String string2 = string = this.isNci ? "quantum.NciCalculation" : "quantum.MOCalculation";
        if (bl2) {
            int n = this.params.title.length;
            while (--n >= 0) {
                this.fixTitleLine2(n, map);
            }
        } else {
            this.q = (MOCalculationInterface)Interface.getOptionInterface((String)string);
            if (this.isNci) {
                this.qpc = (QuantumPlaneCalculationInterface)this.q;
            } else if (this.linearCombination == null) {
                int n = this.params.title.length;
                while (--n >= 0) {
                    this.fixTitleLine2(n, map);
                }
                this.coef = (float[])map.get("coefficients");
                this.dfCoefMaps = (int[][])map.get("dfCoefMaps");
            } else {
                int n;
                this.coefs = ArrayUtil.newFloat2((int)this.mos.size());
                for (n = 1; n < this.linearCombination.length; n += 2) {
                    int n2 = (int)this.linearCombination[n];
                    if (n2 > this.mos.size() || n2 < 1) {
                        return;
                    }
                    this.coefs[n2 - 1] = (float[])((Map)this.mos.get(n2 - 1)).get("coefficients");
                }
                n = this.params.title.length;
                while (--n >= 0) {
                    this.fixTitleLine2(n, null);
                }
            }
            this.isElectronDensityCalc = this.coef == null && this.linearCombination == null && !this.isNci;
        }
        this.volumeData.sr = null;
        if (bl && !this.isElectronDensityCalc && !bl2) {
            this.volumeData.doIterate = false;
            this.voxelData = new float[1][1][1];
            this.volumeData.setVoxelDataAsArray(this.voxelData);
            this.volumeData.sr = this;
            this.points = new P3[1];
            this.points[0] = new P3();
            if (!this.setupCalculation()) {
                this.q = null;
            }
        } else if (this.params.psi_monteCarloCount > 0) {
            this.vertexDataOnly = true;
            this.random = new Random(this.params.randomSeed);
        }
    }

    @Override
    protected boolean readVolumeParameters(boolean bl) {
        this.setup(bl);
        if (this.volumeData.sr == null) {
            this.initializeVolumetricData();
        }
        return true;
    }

    private void fixTitleLine2(int n, Map<String, Object> map) {
        int n2;
        if (!this.fixTitleLine(n)) {
            return;
        }
        String string = this.params.title[n];
        int n3 = string.indexOf("%");
        if (string.length() == 0 || n3 < 0) {
            return;
        }
        int n4 = 0;
        if (string.indexOf("%F") >= 0) {
            string = TextFormat.formatStringS((String)string, (String)"F", (String)this.params.fileName);
        }
        if (string.indexOf("%I") >= 0) {
            string = TextFormat.formatStringS((String)string, (String)"I", (String)(this.params.qm_moLinearCombination == null ? "" + this.params.qm_moNumber : EnumQuantumShell.getMOString((float[])this.params.qm_moLinearCombination)));
        }
        if (string.indexOf("%N") >= 0) {
            string = TextFormat.formatStringS((String)string, (String)"N", (String)("" + this.params.qmOrbitalCount));
        }
        Float f = null;
        if (map == null) {
            for (n2 = 0; n2 < this.linearCombination.length; n2 += 2) {
                if (this.linearCombination[n2] == 0.0f) continue;
                map = (Map)this.mos.get((int)this.linearCombination[n2 + 1] - 1);
                Float f2 = (Float)map.get("energy");
                if (f == null) {
                    if (f2 != null) {
                        f = f2;
                        continue;
                    }
                } else {
                    if (f.equals(f2)) continue;
                    f = null;
                }
                break;
            }
        } else if (map.containsKey("energy")) {
            f = (Float)map.get("energy");
        }
        if (string.indexOf("%E") >= 0) {
            string = TextFormat.formatStringS((String)string, (String)"E", (String)(f != null && ++n4 != 0 ? "" + f : ""));
        }
        if (string.indexOf("%U") >= 0) {
            string = TextFormat.formatStringS((String)string, (String)"U", (String)(f != null && this.params.moData.containsKey("energyUnits") && ++n4 != 0 ? (String)this.params.moData.get("energyUnits") : ""));
        }
        if (string.indexOf("%S") >= 0) {
            string = TextFormat.formatStringS((String)string, (String)"S", (String)(map != null && map.containsKey("symmetry") && ++n4 != 0 ? "" + map.get("symmetry") : ""));
        }
        if (string.indexOf("%O") >= 0) {
            string = TextFormat.formatStringS((String)string, (String)"O", (String)(map != null && map.containsKey("occupancy") && ++n4 != 0 ? "" + map.get("occupancy") : ""));
        }
        if (string.indexOf("%T") >= 0) {
            string = TextFormat.formatStringS((String)string, (String)"T", (String)(map != null && map.containsKey("type") && ++n4 != 0 ? "" + map.get("type") : ""));
        }
        if (string.equals("string")) {
            this.params.title[n] = "";
            return;
        }
        n2 = string.indexOf("?") == 0 ? 1 : 0;
        this.params.title[n] = n2 == 0 ? string : (n4 > 0 && !string.trim().endsWith("=") ? string.substring(1) : "");
    }

    @Override
    protected void readSurfaceData(boolean bl) throws Exception {
        int n;
        int n2;
        if (this.volumeData.sr != null) {
            return;
        }
        if (this.params.psi_monteCarloCount <= 0) {
            this.readSurfaceDataVDR(bl);
            return;
        }
        if (this.points != null) {
            return;
        }
        this.points = new P3[1000];
        for (n2 = 0; n2 < 1000; ++n2) {
            this.points[n2] = new P3();
        }
        if (this.params.thePlane != null) {
            this.vTemp = new V3();
        }
        for (n2 = 0; n2 < 3; ++n2) {
            this.vDist[n2] = this.volumeData.volumetricVectorLengths[n2] * (float)this.volumeData.voxelCounts[n2];
        }
        this.voxelData = new float[1000][1][1];
        this.volumeData.setVoxelDataAsArray(this.voxelData);
        this.getValues();
        float f = 0.0f;
        for (n = 0; n < 1000; ++n) {
            float f2;
            float f3 = Math.abs(this.voxelData[n][0][0]);
            if (!(f2 > f)) continue;
            f = f3;
        }
        if (f < 1.0E-4f) {
            return;
        }
        n = 0;
        block3: while (n < this.params.psi_monteCarloCount) {
            this.getValues();
            for (int i = 0; i < 1000; ++i) {
                float f4 = this.voxelData[i][0][0];
                float f5 = Math.abs(f4);
                if (f5 <= this.getRnd(f)) continue;
                this.addVC(this.points[i], f4, 0);
                if (++n == this.params.psi_monteCarloCount) continue block3;
            }
        }
    }

    @Override
    protected void postProcessVertices() {
    }

    private void getValues() {
        for (int i = 0; i < 1000; ++i) {
            this.voxelData[i][0][0] = 0.0f;
            this.points[i].set(this.volumeData.volumetricOrigin.x + this.getRnd(this.vDist[0]), this.volumeData.volumetricOrigin.y + this.getRnd(this.vDist[1]), this.volumeData.volumetricOrigin.z + this.getRnd(this.vDist[2]));
            if (this.params.thePlane == null) continue;
            Measure.getPlaneProjection((P3)this.points[i], (P4)this.params.thePlane, (P3)this.points[i], (V3)this.vTemp);
        }
        this.createOrbital();
    }

    @Override
    public float getValueAtPoint(P3 p3, boolean bl) {
        return this.q == null ? 0.0f : this.q.processPt(p3);
    }

    private float getRnd(float f) {
        return this.random.nextFloat() * f;
    }

    @Override
    protected void generateCube() {
        if (this.params.volumeData != null) {
            return;
        }
        this.newVoxelDataCube();
        this.createOrbital();
    }

    protected void createOrbital() {
        boolean bl;
        boolean bl2 = bl = this.params.psi_monteCarloCount > 0;
        if (this.isElectronDensityCalc) {
            if (this.mos == null || bl) {
                return;
            }
            int n = this.params.qm_moNumber;
            while (--n >= 0) {
                Logger.info((String)(" generating isosurface data for MO " + (n + 1)));
                Map map = (Map)this.mos.get(n);
                this.coef = (float[])map.get("coefficients");
                this.dfCoefMaps = (int[][])map.get("dfCoefMaps");
                if (!this.setupCalculation()) {
                    return;
                }
                this.q.createCube();
            }
        } else {
            if (!bl) {
                Logger.info((String)("generating isosurface data for MO using cutoff " + this.params.cutoff));
            }
            if (!this.setupCalculation()) {
                return;
            }
            this.q.createCube();
        }
    }

    @Override
    public float[] getPlane(int n) {
        if (!this.qSetupDone) {
            this.setupCalculation();
        }
        return this.getPlane2(n);
    }

    private boolean setupCalculation() {
        this.qSetupDone = true;
        switch (this.params.qmOrbitalType) {
            case 5: {
                break;
            }
            case 1: {
                return this.q.setupCalculation((VolumeDataInterface)this.volumeData, this.bsMySelected, null, null, (String)this.params.moData.get("calculationType"), this.atomData.atomXyz, this.atomData.firstAtomIndex, (JmolList)this.params.moData.get("shells"), (float[][])this.params.moData.get("gaussians"), this.dfCoefMaps, null, this.coef, this.linearCombination, this.params.isSquaredLinear, this.coefs, null, this.params.moData.get("isNormalized") == null, this.points, this.params.parameters, this.params.testFlags);
            }
            case 2: {
                return this.q.setupCalculation((VolumeDataInterface)this.volumeData, this.bsMySelected, null, null, (String)this.params.moData.get("calculationType"), this.atomData.atomXyz, this.atomData.firstAtomIndex, null, (float[][])null, (int[][])null, this.params.moData.get("slaters"), this.coef, this.linearCombination, this.params.isSquaredLinear, this.coefs, null, true, this.points, this.params.parameters, this.params.testFlags);
            }
            case 3: {
                return this.q.setupCalculation((VolumeDataInterface)this.volumeData, this.bsMySelected, this.params.bsSolvent, this.atomData.bsMolecules, null, this.atomData.atomXyz, this.atomData.firstAtomIndex, null, (float[][])null, (int[][])null, null, null, null, this.params.isSquaredLinear, (float[][])null, null, true, this.points, this.params.parameters, this.params.testFlags);
            }
        }
        return false;
    }

    @Override
    protected float getSurfacePointAndFraction(float f, boolean bl, float f2, float f3, P3 p3, V3 v3, int n, int n2, int n3, int n4, int n5, float[] fArray, P3 p32) {
        float f4 = this.getSPF(f, bl, f2, f3, p3, v3, n, n2, n3, n4, n5, fArray, p32);
        if (this.q != null && !Float.isNaN(f4)) {
            f4 = this.q.processPt(p32);
            if (this.params.isSquared) {
                f4 *= f4;
            }
        }
        return f4;
    }
}

