/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.parallel;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jmol.api.JmolParallelProcessor;
import org.jmol.parallel.ScriptProcess;
import org.jmol.parallel.ScriptProcessRunnable;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptFunction;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptParallelProcessor
extends ScriptFunction
implements JmolParallelProcessor {
    Viewer viewer;
    public volatile int counter = 0;
    public volatile Error error = null;
    Object lock = new Object();
    private JmolList<ScriptProcess> processes = new JmolList();

    public Object getExecutor() {
        return Executors.newCachedThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAllProcesses(Viewer viewer) {
        if (this.processes.size() == 0) {
            return;
        }
        this.viewer = viewer;
        boolean bl = !viewer.isParallel() && viewer.setParallel(true);
        JmolList jmolList = new JmolList();
        this.error = null;
        this.counter = 0;
        if (Logger.debugging) {
            Logger.debug((String)("running " + this.processes.size() + " processes on " + Viewer.nProcessors + " processesors inParallel=" + bl));
        }
        this.counter = this.processes.size();
        int n = this.processes.size();
        while (--n >= 0) {
            ShapeManager shapeManager = null;
            if (bl) {
                shapeManager = new ShapeManager(viewer, viewer.getModelSet());
                jmolList.addLast((Object)shapeManager);
            }
            this.runProcess((ScriptProcess)this.processes.remove(0), shapeManager);
        }
        Object object = this.lock;
        synchronized (object) {
            while (this.counter > 0) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.error == null) continue;
                throw this.error;
            }
        }
        this.mergeResults((JmolList<ShapeManager>)jmolList);
        viewer.setParallel(false);
    }

    void mergeResults(JmolList<ShapeManager> jmolList) {
        try {
            for (int i = 0; i < jmolList.size(); ++i) {
                this.viewer.mergeShapes(((ShapeManager)jmolList.get(i)).getShapes());
            }
        }
        catch (Error error) {
            throw error;
        }
        finally {
            this.counter = -1;
            jmolList = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearShapeManager(Error error) {
        ScriptParallelProcessor scriptParallelProcessor = this;
        synchronized (scriptParallelProcessor) {
            this.error = error;
            ((Object)((Object)this)).notifyAll();
        }
    }

    public void addProcess(String string, ScriptContext scriptContext) {
        this.processes.addLast((Object)new ScriptProcess(string, scriptContext));
    }

    private void runProcess(ScriptProcess scriptProcess, ShapeManager shapeManager) {
        Executor executor;
        ScriptProcessRunnable scriptProcessRunnable = new ScriptProcessRunnable(this, scriptProcess, this.lock, shapeManager);
        Executor executor2 = executor = shapeManager == null ? null : (Executor)this.viewer.getExecutor();
        if (executor != null) {
            executor.execute(scriptProcessRunnable);
        } else {
            scriptProcessRunnable.run();
        }
    }

    void eval(ScriptContext scriptContext, ShapeManager shapeManager) {
        this.viewer.evalParallel(scriptContext, shapeManager);
    }
}

