/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import org.jmol.atomdata.RadiusData;
import org.jmol.constant.EnumPalette;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelsetbio.BioModel;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.shape.AtomShape;
import org.jmol.shape.Shape;
import org.jmol.shapebio.BioShape;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.C;

public abstract class BioShapeCollection
extends Shape {
    Atom[] atoms;
    short madOn = (short)-2;
    short madHelixSheet = (short)3000;
    short madTurnRandom = (short)800;
    short madDnaRna = (short)5000;
    boolean isActive = false;
    public BioShape[] bioShapes;

    public final void initModelSet() {
        this.isBioShape = true;
        this.atoms = this.modelSet.atoms;
        this.initialize();
    }

    public int getSizeG(Group group) {
        Monomer monomer = (Monomer)group;
        int n = monomer.getGroupIndex();
        int n2 = monomer.getLeadAtom().getIndex();
        int n3 = this.bioShapes.length;
        while (--n3 >= 0) {
            BioShape bioShape = this.bioShapes[n3];
            for (int i = 0; i < bioShape.monomerCount; ++i) {
                if (bioShape.monomers[i].getGroupIndex() != n || bioShape.monomers[i].getLeadAtom().getIndex() != n2) continue;
                return bioShape.mads[i];
            }
        }
        return 0;
    }

    public void setShapeSizeRD(int n, RadiusData radiusData, BS bS) {
        short s = (short)n;
        this.initialize();
        int n2 = this.bioShapes.length;
        while (--n2 >= 0) {
            BioShape bioShape = this.bioShapes[n2];
            if (bioShape.monomerCount <= 0) continue;
            bioShape.setMad(s, bS, radiusData == null ? null : radiusData.values);
        }
    }

    public void setProperty(String string, Object object, BS bS) {
        this.setPropBSC(string, object, bS);
    }

    protected void setPropBSC(String string, Object object, BS bS) {
        if (string == "refreshTrajectories") {
            int n = (Integer)((Object[])object)[0];
            int n2 = this.bioShapes.length;
            while (--n2 >= 0) {
                BioShape bioShape = this.bioShapes[n2];
                if (bioShape.modelIndex != n) continue;
                bioShape.falsifyMesh();
            }
            return;
        }
        if (string == "deleteModelAtoms") {
            this.atoms = (Atom[])((Object[])object)[1];
            int n = ((int[])((Object[])object)[2])[0];
            int n3 = this.bioShapes.length;
            while (--n3 >= 0) {
                BioShape bioShape = this.bioShapes[n3];
                if (bioShape.modelIndex > n) {
                    --bioShape.modelIndex;
                    bioShape.leadAtomIndices = bioShape.bioPolymer.getLeadAtomIndices();
                    continue;
                }
                if (bioShape.modelIndex != n) continue;
                this.bioShapes = (BioShape[])ArrayUtil.deleteElements((Object)this.bioShapes, (int)n3, (int)1);
            }
            return;
        }
        this.initialize();
        if ("color" == string) {
            byte by = EnumPalette.pidOf((Object)object);
            short s = C.getColixO((Object)object);
            int n = this.bioShapes.length;
            while (--n >= 0) {
                BioShape bioShape = this.bioShapes[n];
                if (bioShape.monomerCount <= 0) continue;
                bioShape.setColixBS(s, by, bS);
            }
            return;
        }
        if ("params" == string) {
            int n = bS.length();
            int[] nArray = new int[n];
            int n4 = 0;
            int n5 = bS.nextSetBit(0);
            while (n5 >= 0) {
                nArray[n5] = n4++;
                n5 = bS.nextSetBit(n5 + 1);
            }
            n4 = this.bioShapes.length;
            while (--n4 >= 0) {
                this.bioShapes[n4].setParams((Object[])object, nArray, bS);
            }
            return;
        }
        if ("colorPhase" == string) {
            Object[] objectArray = (Object[])object;
            short s = C.getColixO((Object)objectArray[0]);
            short s2 = C.getColixO((Object)objectArray[1]);
            int n = this.bioShapes.length;
            while (--n >= 0) {
                BioShape bioShape = this.bioShapes[n];
                if (bioShape.monomerCount <= 0) continue;
                bioShape.setColixBS(s2, (byte)0, bS);
                bioShape.setColixBack(s, bS);
            }
            return;
        }
        if ("translucency" == string) {
            boolean bl = "translucent".equals(object);
            int n = this.bioShapes.length;
            while (--n >= 0) {
                BioShape bioShape = this.bioShapes[n];
                if (bioShape.monomerCount <= 0) continue;
                bioShape.setTranslucent(bl, bS, this.translucentLevel);
            }
            return;
        }
        this.setPropS(string, object, bS);
    }

    public String getShapeState() {
        return this.viewer.getAtomShapeSetState((Shape)this, (AtomShape[])this.bioShapes);
    }

    void initialize() {
        int n = this.modelSet.modelCount;
        Model[] modelArray = this.modelSet.models;
        int n2 = this.modelSet.getBioPolymerCount();
        BioShape[] bioShapeArray = new BioShape[n2--];
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = this.modelSet.getBioPolymerCountInModel(n3);
            while (--n4 >= 0) {
                BioPolymer bioPolymer = ((BioModel)modelArray[n3]).getBioPolymer(n4);
                bioShapeArray[n2] = this.bioShapes == null || this.bioShapes.length <= n2 || this.bioShapes[n2] == null || this.bioShapes[n2].bioPolymer != bioPolymer ? new BioShape(this, n3, bioPolymer) : this.bioShapes[n2];
                --n2;
            }
        }
        this.bioShapes = bioShapeArray;
    }

    public void findNearestAtomIndex(int n, int n2, Atom[] atomArray, BS bS) {
        int n3 = this.bioShapes.length;
        while (--n3 >= 0) {
            this.bioShapes[n3].findNearestAtomIndex(n, n2, atomArray, bS);
        }
    }

    public void setVisibilityFlags(BS bS) {
        if (this.bioShapes == null) {
            return;
        }
        bS = BSUtil.copy((BS)bS);
        int n = this.modelSet.modelCount;
        while (--n >= 0) {
            if (!bS.get(n) || !this.modelSet.isTrajectory(n)) continue;
            bS.set(this.modelSet.getTrajectoryIndex(n));
        }
        n = this.bioShapes.length;
        while (--n >= 0) {
            BioShape bioShape = this.bioShapes[n];
            bioShape.modelVisibilityFlags = bS.get(bioShape.modelIndex) ? this.myVisibilityFlag : 0;
        }
    }

    public void setModelClickability() {
        if (this.bioShapes == null) {
            return;
        }
        int n = this.bioShapes.length;
        while (--n >= 0) {
            this.bioShapes[n].setModelClickability();
        }
    }

    int getMpsShapeCount() {
        return this.bioShapes.length;
    }

    public BioShape getBioShape(int n) {
        return this.bioShapes[n];
    }
}

