/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import org.jmol.constant.EnumStructure;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.Helix;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.modelsetbio.Sheet;
import org.jmol.modelsetbio.Turn;
import org.jmol.util.P3;
import org.jmol.util.Quaternion;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;

public class AlphaMonomer
extends Monomer {
    static final byte[] alphaOffsets = new byte[]{0};
    protected ProteinStructure proteinStructure;
    protected P3 nitrogenHydrogenPoint;

    public boolean isProtein() {
        return true;
    }

    static Monomer validateAndAllocateA(Chain chain, String string, int n, int n2, int n3, int[] nArray) {
        return n2 != n3 || nArray[2] != n2 ? null : new AlphaMonomer().set2(chain, string, n, n2, n3, alphaOffsets);
    }

    protected AlphaMonomer() {
    }

    boolean isAlphaMonomer() {
        return true;
    }

    public ProteinStructure getProteinStructure() {
        return this.proteinStructure;
    }

    public Object getStructure() {
        return this.getProteinStructure();
    }

    void setStructure(ProteinStructure proteinStructure) {
        this.proteinStructure = proteinStructure;
        if (proteinStructure == null) {
            this.nitrogenHydrogenPoint = null;
        }
    }

    public void setStrucNo(int n) {
        if (this.proteinStructure != null) {
            this.proteinStructure.strucNo = n;
        }
    }

    public EnumStructure getProteinStructureType() {
        return this.proteinStructure == null ? EnumStructure.NONE : this.proteinStructure.type;
    }

    public EnumStructure getProteinStructureSubType() {
        return this.proteinStructure == null ? EnumStructure.NONE : this.proteinStructure.subtype;
    }

    public int getStrucNo() {
        return this.proteinStructure != null ? this.proteinStructure.strucNo : 0;
    }

    public boolean isHelix() {
        return this.proteinStructure != null && this.proteinStructure.type == EnumStructure.HELIX;
    }

    public boolean isSheet() {
        return this.proteinStructure != null && this.proteinStructure.type == EnumStructure.SHEET;
    }

    public int setProteinStructureType(EnumStructure enumStructure, int n) {
        if (n < 0 || n > 0 && this.monomerIndex == 0) {
            int n2;
            if (this.proteinStructure != null && (n2 = this.proteinStructure.removeMonomer(this.monomerIndex)) > 0) {
                this.getBioPolymer().removeProteinStructure(this.monomerIndex + 1, n2);
            }
            switch (enumStructure) {
                case HELIX: 
                case HELIXALPHA: 
                case HELIX310: 
                case HELIXPI: {
                    this.setStructure(new Helix((AlphaPolymer)this.bioPolymer, this.monomerIndex, 1, enumStructure));
                    break;
                }
                case SHEET: {
                    this.setStructure(new Sheet((AlphaPolymer)this.bioPolymer, this.monomerIndex, 1, enumStructure));
                    break;
                }
                case TURN: {
                    this.setStructure(new Turn((AlphaPolymer)this.bioPolymer, this.monomerIndex, 1));
                    break;
                }
                case NONE: {
                    this.setStructure(null);
                }
            }
        } else {
            this.setStructure(this.getBioPolymer().getProteinStructure(n));
            if (this.proteinStructure != null) {
                this.proteinStructure.addMonomer(this.monomerIndex);
            }
        }
        return this.monomerIndex;
    }

    public final Atom getAtom(byte by) {
        return by == 2 ? this.getLeadAtom() : null;
    }

    public final P3 getAtomPoint(byte by) {
        return by == 2 ? this.getLeadAtom() : null;
    }

    boolean isConnectedAfter(Monomer monomer) {
        Atom atom;
        if (monomer == null) {
            return true;
        }
        Atom atom2 = this.getLeadAtom();
        return atom2.isBonded(atom = monomer.getLeadAtom()) || atom2.distance((Tuple3f)atom) <= 4.2f;
    }

    P3 getQuaternionFrameCenter(char c) {
        return this.getQuaternionFrameCenterAlpha(c);
    }

    protected P3 getQuaternionFrameCenterAlpha(char c) {
        switch (c) {
            case 'C': 
            case 'b': 
            case 'c': 
            case 'x': {
                return this.getLeadAtom();
            }
        }
        return null;
    }

    public Object getHelixData(int n, char c, int n2) {
        return this.getHelixData2(n, c, n2);
    }

    public Quaternion getQuaternion(char c) {
        return this.getQuaternionAlpha(c);
    }

    protected Quaternion getQuaternionAlpha(char c) {
        V3 v3 = new V3();
        V3 v32 = new V3();
        V3 v33 = null;
        switch (c) {
            default: {
                return null;
            }
            case 'b': 
            case 'c': 
            case 'x': 
        }
        if (this.monomerIndex == 0 || this.monomerIndex == this.bioPolymer.monomerCount - 1) {
            return null;
        }
        Atom atom = this.getLeadAtom();
        P3 p3 = this.bioPolymer.getLeadPoint(this.monomerIndex + 1);
        P3 p32 = this.bioPolymer.getLeadPoint(this.monomerIndex - 1);
        v3.sub2((Tuple3f)p3, (Tuple3f)atom);
        v32.sub2((Tuple3f)p32, (Tuple3f)atom);
        return Quaternion.getQuaternionFrameV((V3)v3, (V3)v32, v33, (boolean)false);
    }
}

