/*
 * Decompiled with CFR 0.152.
 */
package jspecview.util;

import jspecview.util.JSVDefaultLogger;
import jspecview.util.JSVLoggerInterface;

public final class JSVLogger {
    private static JSVLoggerInterface _logger = new JSVDefaultLogger();
    public static final int LEVEL_FATAL = 1;
    public static final int LEVEL_ERROR = 2;
    public static final int LEVEL_WARN = 3;
    public static final int LEVEL_INFO = 4;
    public static final int LEVEL_DEBUG = 5;
    public static final int LEVEL_DEBUGHIGH = 6;
    public static final int LEVEL_MAX = 7;
    private static final boolean[] _activeLevels = new boolean[7];
    private static boolean _logLevel = false;
    public static boolean debugging;
    static String strError;
    static long startTime;

    static {
        JSVLogger._activeLevels[6] = JSVLogger.getProperty("debugHigh", false);
        JSVLogger._activeLevels[5] = JSVLogger.getProperty("debug", false);
        JSVLogger._activeLevels[4] = JSVLogger.getProperty("info", true);
        JSVLogger._activeLevels[3] = JSVLogger.getProperty("warn", true);
        JSVLogger._activeLevels[2] = JSVLogger.getProperty("error", true);
        JSVLogger._activeLevels[1] = JSVLogger.getProperty("fatal", true);
        _logLevel = JSVLogger.getProperty("logLevel", false);
        debugging = _logger != null && (_activeLevels[5] || _activeLevels[6]);
    }

    private static boolean getProperty(String level, boolean defaultValue) {
        try {
            String property = System.getProperty("jmol.logger." + level);
            if (property != null) {
                return Boolean.TRUE.equals(Boolean.valueOf(property));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static void setLogger(JSVLoggerInterface logger) {
        _logger = logger;
        debugging = JSVLogger.isActiveLevel(5) || JSVLogger.isActiveLevel(6);
    }

    public static boolean isActiveLevel(int level) {
        return _logger != null && level >= 0 && level < 7 && _activeLevels[level];
    }

    public static void setActiveLevel(int level, boolean active) {
        if (level < 0) {
            level = 0;
        }
        if (level >= 7) {
            level = 6;
        }
        JSVLogger._activeLevels[level] = active;
        debugging = JSVLogger.isActiveLevel(5) || JSVLogger.isActiveLevel(6);
    }

    public static void setLogLevel(int level) {
        int i = 7;
        while (--i >= 0) {
            JSVLogger.setActiveLevel(i, i <= level);
        }
    }

    public static String getLevel(int level) {
        switch (level) {
            case 6: {
                return "DEBUGHIGH";
            }
            case 5: {
                return "DEBUG";
            }
            case 4: {
                return "INFO";
            }
            case 3: {
                return "WARN";
            }
            case 2: {
                return "ERROR";
            }
            case 1: {
                return "FATAL";
            }
        }
        return "????";
    }

    public static boolean logLevel() {
        return _logLevel;
    }

    public static void logLevel(boolean log) {
        _logLevel = log;
    }

    public static void debug(String txt) {
        if (!debugging) {
            return;
        }
        try {
            _logger.debug(txt);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void info(String txt) {
        try {
            if (JSVLogger.isActiveLevel(4)) {
                _logger.info(txt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void warn(String txt) {
        try {
            if (JSVLogger.isActiveLevel(3)) {
                _logger.warn(txt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void warn(String txt, Throwable e) {
        try {
            if (JSVLogger.isActiveLevel(3)) {
                _logger.warn(txt, e);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String checkForError() {
        if (strError == null) {
            return null;
        }
        String err = strError;
        strError = null;
        return err;
    }

    public static void error(String txt) {
        try {
            strError = txt;
            if (JSVLogger.isActiveLevel(2)) {
                _logger.error(txt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void error(String txt, Throwable e) {
        try {
            if (JSVLogger.isActiveLevel(2)) {
                _logger.error(txt, e);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void fatal(String txt) {
        try {
            if (JSVLogger.isActiveLevel(1)) {
                _logger.fatal(txt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void fatal(String txt, Throwable e) {
        try {
            if (JSVLogger.isActiveLevel(1)) {
                _logger.fatal(txt, e);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void startTimer() {
        startTime = System.currentTimeMillis();
    }

    public static long checkTimer(String msg) {
        long time = System.currentTimeMillis() - startTime;
        if (msg != null) {
            JSVLogger.info(String.valueOf(msg) + ": " + time + " ms");
        }
        return time;
    }

    public static void checkMemory() {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long bTotal = runtime.totalMemory();
        long bFree = runtime.freeMemory();
        long bMax = 0L;
        try {
            bMax = runtime.maxMemory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        JSVLogger.info("Memory: Total-Free=" + (bTotal - bFree) + "; Total=" + bTotal + "; Free=" + bFree + "; Max=" + bMax);
    }
}

