/*
 * Decompiled with CFR 0.152.
 */
package jspecview.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import jspecview.common.JSVersion;
import jspecview.util.JSVEscape;
import jspecview.util.JSVLogger;
import jspecview.util.JSVMonitorInputStream;
import jspecview.util.JSVParser;
import jspecview.util.JSVTextFormat;
import jspecview.util.JSVZipFileSequentialReader;
import jspecview.util.JSVZipUtil;

public class JSVFileManager {
    public static String SIMULATION_PROTOCOL = "http://SIMULATION/";
    private static final String[] urlPrefixes = new String[]{"http:", "https:", "ftp:", SIMULATION_PROTOCOL, "file:"};
    private static String nciResolver = "http://cactus.nci.nih.gov/chemical/structure/%FILE/file?format=sdf&get3d=True";
    private static String nmrdbServer = "http://www.nmrdb.org/tools/jmol/predict.php?POST?molfile=";
    private static Map<String, String> htSimulate;
    private static int stringCount;

    public static String getFileAsString(String name, URL appletDocumentBase) {
        if (name == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(8192);
        try {
            String line;
            BufferedReader br = JSVFileManager.getBufferedReaderFromName(name, appletDocumentBase, null);
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
            br.close();
        }
        catch (Exception e) {
            return null;
        }
        return sb.toString();
    }

    public static BufferedReader getBufferedReaderForInputStream(InputStream in) throws IOException {
        return new BufferedReader(new InputStreamReader(in));
    }

    public static BufferedReader getBufferedReaderForString(String data) {
        return data == null ? null : new BufferedReader(new StringReader(data));
    }

    public static BufferedReader getBufferedReaderFromName(String name, URL appletDocumentBase, String startCode) throws MalformedURLException, IOException {
        if (name == null) {
            throw new IOException("Cannot find " + name);
        }
        String path = JSVFileManager.classifyName(name, appletDocumentBase);
        return JSVFileManager.getUnzippedBufferedReaderFromName(path, appletDocumentBase, startCode);
    }

    public static String classifyName(String name, URL appletDocumentBase) throws MalformedURLException {
        if (appletDocumentBase != null) {
            if (name.indexOf(":\\") == 1 || name.indexOf(":/") == 1) {
                name = "file:///" + name;
            }
            URL url = new URL(appletDocumentBase, name);
            return url.toString();
        }
        if (JSVFileManager.isURL(name)) {
            URL url = new URL(name);
            return url.toString();
        }
        File file = new File(name);
        return file.getAbsolutePath();
    }

    public static boolean isURL(String name) {
        int i = urlPrefixes.length;
        while (--i >= 0) {
            if (!name.startsWith(urlPrefixes[i])) continue;
            return true;
        }
        return false;
    }

    private static BufferedReader getUnzippedBufferedReaderFromName(String name, URL appletDocumentBase, String startCode) throws IOException {
        String[] subFileList = null;
        if (name.indexOf("|") >= 0 && (subFileList = JSVTextFormat.split(name, "|")) != null && subFileList.length > 0) {
            name = subFileList[0];
        }
        if (name.startsWith(SIMULATION_PROTOCOL)) {
            return JSVFileManager.getBufferedReaderForString(JSVFileManager.getSimulationJCampDX(name.substring(SIMULATION_PROTOCOL.length())));
        }
        InputStream in = JSVFileManager.getInputStream(name, true, appletDocumentBase);
        BufferedInputStream bis = new BufferedInputStream(in, 8192);
        if (JSVFileManager.isGzip(bis)) {
            return new BufferedReader(new InputStreamReader(new GZIPInputStream(bis)));
        }
        if (JSVZipUtil.isZipFile(bis)) {
            return new JSVZipFileSequentialReader(bis, subFileList, startCode);
        }
        return new BufferedReader(new InputStreamReader(bis));
    }

    private static boolean isGzip(InputStream is) throws IOException {
        byte[] abMagic = new byte[4];
        is.mark(5);
        int countRead = is.read(abMagic, 0, 4);
        is.reset();
        return countRead == 4 && abMagic[0] == 31 && abMagic[1] == -117;
    }

    public static InputStream getInputStream(String name, boolean showMsg, URL appletDocumentBase) throws IOException, MalformedURLException {
        InputStream in;
        int length;
        int iurl;
        boolean isURL = JSVFileManager.isURL(name);
        boolean isApplet = appletDocumentBase != null;
        String post = null;
        if (isURL && (iurl = name.indexOf("?POST?")) >= 0) {
            post = name.substring(iurl + 6);
            name = name.substring(0, iurl);
        }
        if (isApplet || isURL) {
            URL url = isApplet ? new URL(appletDocumentBase, name) : new URL(name);
            name = url.toString();
            if (showMsg) {
                JSVLogger.info("JSVFileManager opening URL " + url.toString());
            }
            URLConnection conn = url.openConnection();
            if (post != null) {
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setDoOutput(true);
                OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
                wr.write(post);
                wr.flush();
            }
            length = conn.getContentLength();
            in = conn.getInputStream();
        } else {
            if (showMsg) {
                JSVLogger.info("JSVFileManager opening file " + name);
            }
            File file = new File(name);
            length = (int)file.length();
            in = new FileInputStream(file);
        }
        return new JSVMonitorInputStream(in, length);
    }

    private static String getSimulationJCampDX(String name) {
        String key;
        String jcamp;
        if (htSimulate == null) {
            htSimulate = new Hashtable<String, String>();
        }
        if ((jcamp = htSimulate.get(key = "" + name.substring(name.indexOf("V2000") + 1).hashCode())) == null) {
            System.out.println("creating " + name);
            boolean isInline = name.startsWith("MOL=");
            String molFile = isInline ? JSVTextFormat.simpleReplace(name.substring(4), "\\n", "\n") : JSVFileManager.getFileAsString(JSVTextFormat.simpleReplace(nciResolver, "%FILE", JSVEscape.escapeUrl(name.substring(1))), null);
            int pt = molFile.indexOf("\n");
            molFile = "/JSpecView " + JSVersion.VERSION + molFile.substring(pt);
            molFile = JSVTextFormat.replaceAllCharacters(molFile, "?", '_');
            String json = JSVFileManager.getFileAsString(String.valueOf(nmrdbServer) + molFile, null);
            System.out.println(json);
            json = JSVTextFormat.simpleReplace(json, "\\r\\n", "\n");
            json = JSVTextFormat.simpleReplace(json, "\\t", "\t");
            json = JSVTextFormat.simpleReplace(json, "\\n", "\n");
            molFile = JSVParser.getQuotedJSONAttribute(json, "molfile", null);
            String xml = JSVParser.getQuotedJSONAttribute(json, "xml", null);
            xml = JSVTextFormat.simpleReplace(xml, "</", "\n</");
            xml = JSVTextFormat.simpleReplace(xml, "><", ">\n<");
            xml = JSVTextFormat.simpleReplace(xml, "\\\"", "\"");
            jcamp = JSVParser.getQuotedJSONAttribute(json, "jcamp", null);
            jcamp = "##TITLE=" + (isInline ? "JMOL SIMULATION" : name) + "\n" + jcamp.substring(jcamp.indexOf("\n##") + 1);
            JSVLogger.info(String.valueOf(jcamp.substring(0, jcamp.indexOf("##XYDATA") + 40)) + "...");
            pt = 0;
            pt = jcamp.indexOf("##.");
            String id = name;
            int pt1 = id.indexOf("id='");
            if (isInline && pt1 > 0) {
                id = id.substring(pt1 + 4, (String.valueOf(id) + "'").indexOf("'", pt1 + 4));
            }
            jcamp = String.valueOf(jcamp.substring(0, pt)) + "##$MODELS=\n<Models>\n" + "<ModelData id=" + JSVEscape.escape(id) + "\n type=\"MOL\">\n" + molFile + "</ModelData>\n</Models>\n" + "##$SIGNALS=\n" + xml + "\n" + jcamp.substring(pt);
            htSimulate.put(key, jcamp);
        }
        return jcamp;
    }

    private static URL getResource(Object object, String fileName, String[] error) {
        URL url = null;
        try {
            url = object.getClass().getResource("resources/" + fileName);
            if (url == null) {
                error[0] = "Couldn't find file: " + fileName;
            }
        }
        catch (Exception e) {
            error[0] = "Exception " + e.getMessage() + " in getResource " + fileName;
        }
        return url;
    }

    public static String getResourceString(Object object, String name, String[] error) {
        URL url = JSVFileManager.getResource(object, name, error);
        if (url == null) {
            error[0] = "Error loading resource " + name;
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)url.getContent()));
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            br.close();
        }
        catch (Exception e) {
            error[0] = e.getMessage();
        }
        String str = sb.toString();
        return str;
    }

    public static String getJmolFilePath(String filePath, URL appletDocumentBase) {
        try {
            filePath = JSVFileManager.classifyName(filePath, appletDocumentBase);
        }
        catch (MalformedURLException e) {
            return null;
        }
        return appletDocumentBase == null ? filePath.replace('\\', '/') : filePath;
    }

    public static String getName(String file) {
        if (file == null) {
            return "String" + ++stringCount;
        }
        try {
            if (JSVFileManager.isURL(file)) {
                if (file.startsWith(SIMULATION_PROTOCOL) && file.length() > 100) {
                    return String.valueOf(file.substring(0, Math.min(file.length(), 30))) + "...";
                }
                String name = new URL(file).getFile();
                return name.substring(name.lastIndexOf(47) + 1);
            }
            return new File(file).getName();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static void fileCopy(String name, File file) {
        try {
            BufferedReader br = JSVFileManager.getBufferedReaderFromName(name, null, null);
            FileWriter writer = new FileWriter(file.getAbsolutePath());
            String line = null;
            while ((line = br.readLine()) != null) {
                writer.write(line);
                writer.write(JSVTextFormat.newLine);
            }
            writer.close();
        }
        catch (Exception e) {
            JSVLogger.error(e.getMessage());
        }
    }
}

