/*
 * Decompiled with CFR 0.152.
 */
package jspecview.util;

import java.util.BitSet;
import java.util.List;
import java.util.Map;
import jspecview.util.JSVTextFormat;

public class JSVEscape {
    private static final String escapable = "\\\\\tt\rr\nn\"\"";

    public static String escape(String str) {
        if (str == null) {
            return "\"\"";
        }
        boolean haveEscape = false;
        int i = 0;
        while (i < escapable.length()) {
            if (str.indexOf(escapable.charAt(i)) >= 0) {
                haveEscape = true;
                break;
            }
            i += 2;
        }
        if (haveEscape) {
            while (i < escapable.length()) {
                int pt = -1;
                char ch = escapable.charAt(i++);
                char ch2 = escapable.charAt(i++);
                StringBuffer sb = new StringBuffer();
                int pt0 = 0;
                while ((pt = str.indexOf(ch, pt + 1)) >= 0) {
                    sb.append(str.substring(pt0, pt)).append('\\').append(ch2);
                    pt0 = pt + 1;
                }
                sb.append(str.substring(pt0, str.length()));
                str = sb.toString();
            }
        }
        i = str.length();
        while (--i >= 0) {
            if (str.charAt(i) <= '\u007f') continue;
            str = String.valueOf(str.substring(0, i)) + JSVEscape.unicode(str.charAt(i)) + str.substring(i + 1);
        }
        return "\"" + str + "\"";
    }

    private static String unicode(char c) {
        String s = "0000" + Integer.toHexString(c);
        return "\\u" + s.substring(s.length() - 4);
    }

    public static String toJSON(String infoType, Object info, boolean addCR) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        if (info == null) {
            return JSVEscape.packageJSON(infoType, null, addCR);
        }
        if (info instanceof Integer || info instanceof Float || info instanceof Double) {
            return JSVEscape.packageJSON(infoType, info.toString(), addCR);
        }
        if (info instanceof String) {
            return JSVEscape.packageJSON(infoType, JSVEscape.fixString((String)info), addCR);
        }
        if (info instanceof String[]) {
            sb.append("[");
            int imax = ((String[])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(JSVEscape.fixString(((String[])info)[i]));
                sep = ",";
                ++i;
            }
            sb.append("]");
            return JSVEscape.packageJSON(infoType, sb, addCR);
        }
        if (info instanceof int[]) {
            sb.append("[");
            int imax = ((int[])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(((int[])info)[i]);
                sep = ",";
                ++i;
            }
            sb.append("]");
            return JSVEscape.packageJSON(infoType, sb, addCR);
        }
        if (info instanceof float[]) {
            sb.append("[");
            int imax = ((float[])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(((float[])info)[i]);
                sep = ",";
                ++i;
            }
            sb.append("]");
            return JSVEscape.packageJSON(infoType, sb, addCR);
        }
        if (info instanceof double[]) {
            sb.append("[");
            int imax = ((double[])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(((double[])info)[i]);
                sep = ",";
                ++i;
            }
            sb.append("]");
            return JSVEscape.packageJSON(infoType, sb, addCR);
        }
        if (info instanceof String[][]) {
            sb.append("[");
            if (addCR) {
                sb.append('\n');
            }
            int imax = ((String[][])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(JSVEscape.toJSON(null, ((String[][])info)[i], addCR));
                if (addCR) {
                    sb.append('\n');
                }
                sep = ",";
                ++i;
            }
            sb.append("]");
            return JSVEscape.packageJSON(infoType, sb, addCR);
        }
        if (info instanceof int[][]) {
            sb.append("[");
            int imax = ((int[][])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(JSVEscape.toJSON(null, ((int[][])info)[i], addCR));
                sep = ",";
                ++i;
            }
            sb.append("]");
            return JSVEscape.packageJSON(infoType, sb, addCR);
        }
        if (info instanceof float[][]) {
            sb.append("[");
            int imax = ((float[][])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(JSVEscape.toJSON(null, ((float[][])info)[i], addCR));
                sep = ",";
                ++i;
            }
            sb.append("]");
            return JSVEscape.packageJSON(infoType, sb, addCR);
        }
        if (info instanceof double[][]) {
            sb.append("[");
            int imax = ((double[][])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(JSVEscape.toJSON(null, ((double[][])info)[i], addCR));
                sep = ",";
                ++i;
            }
            sb.append("]");
            return JSVEscape.packageJSON(infoType, sb, addCR);
        }
        if (info instanceof float[][][]) {
            sb.append("[");
            int imax = ((float[][][])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(JSVEscape.toJSON(null, ((float[][][])info)[i], addCR));
                sep = ",";
                ++i;
            }
            sb.append("]");
            return JSVEscape.packageJSON(infoType, sb, addCR);
        }
        if (info instanceof Object[]) {
            sb.append("[");
            int imax = ((Object[])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(JSVEscape.toJSON(null, ((Object[])info)[i], addCR));
                sep = ",";
                ++i;
            }
            sb.append("]");
            return JSVEscape.packageJSON(infoType, sb, addCR);
        }
        if (info instanceof List) {
            sb.append("[ ");
            int imax = ((List)info).size();
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(JSVEscape.toJSON(null, ((List)info).get(i), addCR));
                sep = ",";
                ++i;
            }
            sb.append(" ]");
            return JSVEscape.packageJSON(infoType, sb, addCR);
        }
        if (info instanceof Map) {
            sb.append("{ ");
            for (String key : ((Map)info).keySet()) {
                sb.append(sep).append(JSVEscape.packageJSON(key, JSVEscape.toJSON(null, ((Map)info).get(key), addCR), addCR));
                sep = ",";
            }
            sb.append(" }");
            return JSVEscape.packageJSON(infoType, sb, addCR);
        }
        return JSVEscape.packageJSON(infoType, JSVEscape.fixString(info.toString()), addCR);
    }

    private static String fixString(String s) {
        if (s == null || s.indexOf("{\"") == 0) {
            return s;
        }
        s = JSVTextFormat.simpleReplace(s, "\"", "''");
        s = JSVTextFormat.simpleReplace(s, "\n", " | ");
        return "\"" + s + "\"";
    }

    private static String packageJSON(String infoType, StringBuilder sb, boolean addCR) {
        return JSVEscape.packageJSON(infoType, sb.toString(), addCR);
    }

    private static String packageJSON(String infoType, String info, boolean addCR) {
        if (infoType == null) {
            return info;
        }
        return "\"" + infoType + "\": " + info + (addCR ? "\n" : "");
    }

    public static String escapeUrl(String url) {
        url = JSVTextFormat.simpleReplace(url, "\n", "");
        url = JSVTextFormat.simpleReplace(url, "%", "%25");
        url = JSVTextFormat.simpleReplace(url, "[", "%5B");
        url = JSVTextFormat.simpleReplace(url, "]", "%5D");
        url = JSVTextFormat.simpleReplace(url, " ", "%20");
        url = JSVTextFormat.simpleReplace(url, "?", "%3F");
        return url;
    }

    public static BitSet unescapeBitSet(String str) {
        char ch;
        int len;
        if (str == null || (len = (str = str.trim()).length()) < 4 || str.equalsIgnoreCase("({null})") || (ch = str.charAt(0)) != '(' && ch != '[' || str.charAt(len - 1) != (ch == '(' ? (char)')' : ']') || str.charAt(1) != '{' || str.indexOf(125) != len - 2) {
            return null;
        }
        int i = len -= 2;
        while (--i >= 2) {
            ch = str.charAt(i);
            if (Character.isDigit(ch) || ch == ' ' || ch == '\t' || ch == ':') continue;
            return null;
        }
        int lastN = len;
        while (Character.isDigit(str.charAt(--lastN))) {
        }
        if (++lastN == len) {
            lastN = 0;
        } else {
            try {
                lastN = Integer.parseInt(str.substring(lastN, len));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        BitSet bs = new BitSet(lastN);
        lastN = -1;
        int iPrev = -1;
        int iThis = -2;
        int i2 = 2;
        while (i2 <= len) {
            ch = str.charAt(i2);
            switch (ch) {
                case '\t': 
                case ' ': 
                case '}': {
                    if (iThis < 0) break;
                    if (iThis < lastN) {
                        return null;
                    }
                    lastN = iThis;
                    if (iPrev < 0) {
                        iPrev = iThis;
                    }
                    bs.set(iPrev, iThis + 1);
                    iPrev = -1;
                    iThis = -2;
                    break;
                }
                case ':': {
                    iPrev = lastN = iThis;
                    iThis = -2;
                    break;
                }
                default: {
                    if (!Character.isDigit(ch)) break;
                    if (iThis < 0) {
                        iThis = 0;
                    }
                    iThis = iThis * 10 + (ch - 48);
                }
            }
            ++i2;
        }
        return iPrev >= 0 ? null : bs;
    }
}

