/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.io.IOException;
import jspecview.util.JSVLogger;

public class JDXSourceStreamTokenizer {
    private BufferedReader br;
    private String label;
    private String value;
    private int labelLineNo = 0;
    private String line;
    private int lineNo;

    JDXSourceStreamTokenizer(BufferedReader br) {
        this.br = br;
    }

    String peakLabel() {
        return this.nextLabel(false);
    }

    String getLabel() {
        return this.nextLabel(true);
    }

    private String nextLabel(boolean isGet) {
        this.label = null;
        this.value = null;
        while (this.line == null) {
            block10: {
                try {
                    this.readLine();
                    if (this.line != null) break block10;
                    this.line = "";
                    return null;
                }
                catch (IOException e) {
                    this.line = "";
                    return null;
                }
            }
            this.line = this.line.trim();
            if (this.line.startsWith("##")) break;
            this.line = null;
        }
        int pt = this.line.indexOf("=");
        if (pt < 0) {
            if (isGet) {
                JSVLogger.info("BAD JDX LINE -- no '=' (line " + this.lineNo + "): " + this.line);
            }
            this.label = this.line;
            if (!isGet) {
                this.line = "";
            }
        } else {
            this.label = this.line.substring(0, pt).trim();
            if (isGet) {
                this.line = this.line.substring(pt + 1);
            }
        }
        this.labelLineNo = this.lineNo;
        if (JSVLogger.debugging) {
            JSVLogger.info(this.label);
        }
        return JDXSourceStreamTokenizer.cleanLabel(this.label);
    }

    public static String cleanLabel(String label) {
        if (label == null) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < label.length()) {
            switch (label.charAt(i)) {
                case ' ': 
                case '-': 
                case '/': 
                case '\\': 
                case '_': {
                    break;
                }
                default: {
                    str.append(label.charAt(i));
                }
            }
            ++i;
        }
        return str.toString().toUpperCase();
    }

    String getRawLabel() {
        return this.label;
    }

    int getLabelLineNo() {
        return this.labelLineNo;
    }

    public String getValue() {
        if (this.value != null) {
            return this.value;
        }
        StringBuffer sb = new StringBuffer(this.line);
        if (sb.length() > 0) {
            sb.append('\n');
        }
        try {
            while (this.readLine() != null) {
                if (this.line.indexOf("##") < 0 || !this.line.trim().startsWith("##")) {
                    sb.append(this.line).append('\n');
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.value = JDXSourceStreamTokenizer.trimLines(sb);
        if (JSVLogger.debugging) {
            JSVLogger.info(this.value);
        }
        return this.value;
    }

    public String readLineTrimmed() throws IOException {
        this.readLine();
        if (this.line == null) {
            return null;
        }
        if (this.line.indexOf("$$") < 0) {
            return this.line.trim();
        }
        StringBuffer sb = new StringBuffer(this.line);
        return JDXSourceStreamTokenizer.trimLines(sb);
    }

    String flushLine() {
        StringBuffer sb = new StringBuffer(this.line);
        this.line = null;
        return JDXSourceStreamTokenizer.trimLines(sb);
    }

    private String readLine() throws IOException {
        this.line = this.br.readLine();
        ++this.lineNo;
        return this.line;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String trimLines(StringBuffer v) {
        int n = v.length();
        int ilast = n - 1;
        int vpt = JDXSourceStreamTokenizer.ptNonWhite(v, 0, n);
        if (vpt >= n) {
            return "";
        }
        if (v.charAt(vpt) == '<') {
            n = v.lastIndexOf(">") + 1;
            if (n == 0) {
                n = v.length();
            }
            return v.substring(vpt, n);
        }
        char[] buffer = new char[n - vpt];
        int pt = 0;
        while (vpt < n) {
            block14: {
                int ch = v.charAt(vpt);
                switch (ch) {
                    case 13: {
                        if (vpt >= ilast || v.charAt(vpt + 1) != '\n') {
                            ch = 10;
                            break;
                        }
                        break block14;
                    }
                    case 10: {
                        if (pt > 0 && buffer[pt - 1] != '\n') {
                            pt -= vpt - JDXSourceStreamTokenizer.ptNonSpaceRev(v, vpt) - 1;
                        }
                        ++vpt;
                        vpt = JDXSourceStreamTokenizer.ptNonSpace(v, vpt, n) - 1;
                        break;
                    }
                    case 36: {
                        if (vpt >= ilast || v.charAt(vpt + 1) != '$') break;
                        ++vpt;
                        while (++vpt < n && "\n\r".indexOf(v.charAt(vpt)) < 0) {
                        }
                        break block14;
                    }
                }
                if (ch != 10 || pt <= 0 || buffer[pt - 1] != '\n') {
                    buffer[pt++] = ch;
                }
            }
            ++vpt;
        }
        if (pt > 0 && buffer[pt - 1] == '\n') {
            --pt;
        }
        return new String(buffer).substring(0, pt).trim();
    }

    private static int ptNonWhite(StringBuffer v, int pt, int n) {
        while (pt < n && Character.isWhitespace(v.charAt(pt))) {
            ++pt;
        }
        return pt;
    }

    private static int ptNonSpace(StringBuffer v, int pt, int n) {
        while (pt < n && (v.charAt(pt) == ' ' || v.charAt(pt) == '\t')) {
            ++pt;
        }
        return pt;
    }

    private static int ptNonSpaceRev(StringBuffer v, int pt) {
        while (--pt >= 0 && (v.charAt(pt) == ' ' || v.charAt(pt) == '\t')) {
        }
        return pt;
    }
}

