/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import jspecview.common.Coordinate;
import jspecview.common.JDXSpectrum;
import jspecview.export.Exporter;
import jspecview.export.JDXCompressor;
import jspecview.source.FileReader;
import jspecview.util.JSVTextFormat;

public class JDXExporter {
    private static final double FACTOR_DIVISOR = 1000000.0;

    static String export(Exporter.ExportType type, String path, JDXSpectrum spectrum, int startIndex, int endIndex) throws IOException {
        String data = JDXExporter.toStringAux(type, spectrum, startIndex, endIndex);
        if (path == null) {
            return data;
        }
        FileWriter writer = new FileWriter(path);
        writer.write(data);
        writer.close();
        return " (" + data.length() + " bytes)";
    }

    private static String toStringAux(Exporter.ExportType type, JDXSpectrum spectrum, int startIndex, int endIndex) {
        StringBuffer buffer = new StringBuffer();
        Coordinate[] newXYCoords = spectrum.getXYCoords();
        String tabDataSet = "";
        String tmpDataClass = "XYDATA";
        if (spectrum.isHZtoPPM()) {
            Coordinate[] xyCoords = newXYCoords;
            newXYCoords = new Coordinate[xyCoords.length];
            int i = 0;
            while (i < xyCoords.length) {
                newXYCoords[i] = xyCoords[i].copy();
                ++i;
            }
            Coordinate.applyScale(newXYCoords, spectrum.getObservedFreq(), 1.0);
        }
        double xCompFactor = spectrum.getXFactor();
        boolean isIntegerX = JDXExporter.areIntegers(newXYCoords, startIndex, endIndex, 1.0, true);
        if (!isIntegerX && !JDXExporter.areIntegers(newXYCoords, startIndex, endIndex, xCompFactor, true)) {
            xCompFactor = 1.0;
        }
        double minY = Coordinate.getMinY(newXYCoords, startIndex, endIndex);
        double maxY = Coordinate.getMaxY(newXYCoords, startIndex, endIndex);
        double yCompFactor = spectrum.getYFactor();
        switch (type) {
            case XY: {
                yCompFactor = 1.0;
                tmpDataClass = spectrum.isContinuous() ? "XYDATA" : "XYPOINTS";
                break;
            }
            case PAC: {
                yCompFactor = 1.0;
                break;
            }
            default: {
                boolean isIntegerY = JDXExporter.areIntegers(newXYCoords, startIndex, endIndex, 1.0, false);
                if (isIntegerY || JDXExporter.areIntegers(newXYCoords, startIndex, endIndex, yCompFactor, false)) break;
                yCompFactor = (maxY - minY) / 1000000.0;
            }
        }
        int step = 1;
        if (spectrum.isExportXAxisLeftToRight() != spectrum.getFirstX() < spectrum.getLastX()) {
            int t = startIndex;
            startIndex = endIndex;
            endIndex = t;
            step = -1;
        }
        switch (type) {
            case DIF: 
            case DIFDUP: {
                tabDataSet = JDXCompressor.compressDIF(newXYCoords, startIndex, endIndex, step, xCompFactor, yCompFactor, type == Exporter.ExportType.DIFDUP);
                break;
            }
            case FIX: {
                tabDataSet = JDXCompressor.compressFIX(newXYCoords, startIndex, endIndex, step, xCompFactor, yCompFactor);
                break;
            }
            case PAC: {
                tabDataSet = JDXCompressor.compressPAC(newXYCoords, startIndex, endIndex, step, xCompFactor, yCompFactor);
                break;
            }
            case SQZ: {
                tabDataSet = JDXCompressor.compressSQZ(newXYCoords, startIndex, endIndex, step, xCompFactor, yCompFactor);
                break;
            }
            case XY: {
                tabDataSet = JDXCompressor.getXYList(newXYCoords, startIndex, endIndex, step);
                break;
            }
        }
        int index = Arrays.binarySearch(FileReader.VAR_LIST_TABLE[0], tmpDataClass);
        String varList = FileReader.VAR_LIST_TABLE[1][index];
        buffer.append(JDXExporter.getHeaderString(spectrum, tmpDataClass, minY, maxY, xCompFactor, yCompFactor, startIndex, endIndex));
        buffer.append("##" + tmpDataClass + "= " + varList + JSVTextFormat.newLine);
        buffer.append(tabDataSet);
        buffer.append("##END=");
        return buffer.toString();
    }

    private static String getHeaderString(JDXSpectrum spec, String tmpDataClass, double minY, double maxY, double tmpXFactor, double tmpYFactor, int startIndex, int endIndex) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("##TITLE= ").append(spec.getTitle()).append(JSVTextFormat.newLine);
        buffer.append("##JCAMP-DX= 5.01").append(JSVTextFormat.newLine);
        buffer.append("##DATA TYPE= ").append(spec.getDataType()).append(JSVTextFormat.newLine);
        buffer.append("##DATA CLASS= ").append(tmpDataClass).append(JSVTextFormat.newLine);
        buffer.append("##ORIGIN= ").append(spec.getOrigin()).append(JSVTextFormat.newLine);
        buffer.append("##OWNER= ").append(spec.getOwner()).append(JSVTextFormat.newLine);
        String d = spec.getDate();
        String longdate = "";
        String currentTime = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSSS ZZZZ").format(Calendar.getInstance().getTime());
        longdate = spec.getLongDate().equals("") || d.length() != 8 ? String.valueOf(currentTime) + " $$ export date from JSpecView" : (d.length() == 8 ? String.valueOf(d.charAt(0) < '5' ? "20" : "19") + d + " " + spec.getTime() : spec.getLongDate());
        buffer.append("##LONGDATE= ").append(longdate).append(JSVTextFormat.newLine);
        List<String[]> headerTable = spec.getHeaderTable();
        int i = 0;
        while (i < headerTable.size()) {
            String[] entry = headerTable.get(i);
            String label = entry[0];
            String dataSet = entry[1];
            String nl = dataSet.startsWith("<") && dataSet.contains("</") ? JSVTextFormat.newLine : "";
            buffer.append(label).append("= ").append(nl).append(dataSet).append(JSVTextFormat.newLine);
            ++i;
        }
        double observedFreq = spec.getObservedFreq();
        if (!spec.is1D()) {
            buffer.append("##NUM DIM= ").append(spec.numDim).append(JSVTextFormat.newLine);
        }
        if (observedFreq != Double.MAX_VALUE) {
            buffer.append("##.OBSERVE FREQUENCY= ").append(observedFreq).append(JSVTextFormat.newLine);
        }
        if (spec.observedNucl != "") {
            buffer.append("##.OBSERVE NUCLEUS= ").append(spec.observedNucl).append(JSVTextFormat.newLine);
        }
        buffer.append("##XUNITS= ").append(spec.isHZtoPPM() ? "HZ" : spec.getXUnits()).append(JSVTextFormat.newLine);
        buffer.append("##YUNITS= ").append(spec.getYUnits()).append(JSVTextFormat.newLine);
        buffer.append("##XFACTOR= ").append(JSVTextFormat.fixExponentInt(tmpXFactor)).append(JSVTextFormat.newLine);
        buffer.append("##YFACTOR= ").append(JSVTextFormat.fixExponentInt(tmpYFactor)).append(JSVTextFormat.newLine);
        double f = spec.isHZtoPPM() ? observedFreq : 1.0;
        Coordinate[] xyCoords = spec.getXYCoords();
        buffer.append("##FIRSTX= ").append(JSVTextFormat.fixExponentInt(xyCoords[startIndex].getXVal() * f)).append(JSVTextFormat.newLine);
        buffer.append("##FIRSTY= ").append(JSVTextFormat.fixExponentInt(xyCoords[startIndex].getYVal())).append(JSVTextFormat.newLine);
        buffer.append("##LASTX= ").append(JSVTextFormat.fixExponentInt(xyCoords[endIndex].getXVal() * f)).append(JSVTextFormat.newLine);
        buffer.append("##NPOINTS= ").append(Math.abs(endIndex - startIndex) + 1).append(JSVTextFormat.newLine);
        buffer.append("##MINY= ").append(JSVTextFormat.fixExponentInt(minY)).append(JSVTextFormat.newLine);
        buffer.append("##MAXY= ").append(JSVTextFormat.fixExponentInt(maxY)).append(JSVTextFormat.newLine);
        return buffer.toString();
    }

    private static boolean areIntegers(Coordinate[] xyCoords, int startIndex, int endIndex, double factor, boolean isX) {
        int i = startIndex;
        while (i <= endIndex) {
            double x = (isX ? xyCoords[i].getXVal() : xyCoords[i].getYVal()) / factor;
            if (JSVTextFormat.isAlmostInteger(x)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

