/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jspecview.common.DialogHelper;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVPanel;
import jspecview.common.PanelData;
import jspecview.common.ScriptInterface;
import jspecview.common.ScriptToken;
import jspecview.export.AMLExporter;
import jspecview.export.CMLExporter;
import jspecview.export.JDXExporter;
import jspecview.export.SVGExporter;
import jspecview.util.JSVFileManager;
import jspecview.util.JSVTextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Exporter {
    public static final String sourceLabel = "Original...";

    public static String exportTheSpectrum(ExportType mode, String path, JDXSpectrum spec, int startIndex, int endIndex) throws IOException {
        switch (mode) {
            case DIF: 
            case FIX: 
            case SQZ: 
            case PAC: 
            case XY: 
            case DIFDUP: {
                return JDXExporter.export(mode, path, spec, startIndex, endIndex);
            }
            case SVG: 
            case SVGI: {
                return new SVGExporter().exportAsSVG(path, spec, startIndex, endIndex, mode == ExportType.SVGI);
            }
            case CML: {
                return new CMLExporter().exportAsCML(path, spec, startIndex, endIndex);
            }
            case AML: {
                return new AMLExporter().exportAsAnIML(path, spec, startIndex, endIndex);
            }
        }
        return null;
    }

    public static String exportSpectrum(ScriptInterface si, JFrame frame, DialogHelper dialogHelper, String type) {
        JSVPanel jsvp = si.getSelectedPanel();
        boolean isView = si.getCurrentSource().isView;
        int nSpectra = jsvp.getPanelData().getNumberOfSpectraInCurrentSet();
        if (nSpectra == 1 || !isView && type.equals(sourceLabel) || jsvp.getPanelData().getCurrentSpectrumIndex() >= 0) {
            return Exporter.exportSpectrum(si, type, -1, dialogHelper);
        }
        String[] items = new String[nSpectra];
        int i = 0;
        while (i < nSpectra) {
            items[i] = jsvp.getPanelData().getSpectrumAt(i).getTitle();
            ++i;
        }
        final JDialog dialog = new JDialog(frame, "Export", true);
        dialog.setResizable(false);
        dialog.setSize(200, 100);
        Component panel = (Component)((Object)jsvp);
        dialog.setLocation((panel.getLocation().x + panel.getSize().width) / 2, (panel.getLocation().y + panel.getSize().height) / 2);
        final JComboBox<String> cb = new JComboBox<String>(items);
        Dimension d = new Dimension(120, 25);
        cb.setPreferredSize(d);
        cb.setMaximumSize(d);
        cb.setMinimumSize(d);
        JPanel p = new JPanel(new FlowLayout());
        JButton button = new JButton("OK");
        p.add(cb);
        p.add(button);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)new JLabel("Choose Spectrum to export", 0), "North");
        dialog.getContentPane().add(p);
        final int[] ret = new int[]{-1};
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ret[0] = cb.getSelectedIndex();
                dialog.dispose();
            }
        });
        dialog.setVisible(true);
        dialog.dispose();
        if (ret[0] < 0) {
            return null;
        }
        return Exporter.exportSpectrum(si, type, ret[0], dialogHelper);
    }

    public static String exportCmd(JSVPanel jsvp, List<String> tokens, boolean forInkscape) {
        String ext;
        String mode = "XY";
        String fileName = null;
        switch (tokens.size()) {
            default: {
                return "EXPORT what?";
            }
            case 1: {
                fileName = JSVTextFormat.trimQuotes(tokens.get(0));
                int pt = fileName.indexOf(".");
                if (pt >= 0) break;
                return "EXPORT mode?";
            }
            case 2: {
                mode = tokens.get(0).toUpperCase();
                fileName = JSVTextFormat.trimQuotes(tokens.get(1));
            }
        }
        if ((ext = fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase()).equals("JDX")) {
            if (mode == null) {
                mode = "XY";
            }
        } else if (ExportType.isExportMode(ext)) {
            mode = ext;
        } else if (ExportType.isExportMode(mode)) {
            fileName = String.valueOf(fileName) + "." + mode;
        }
        ExportType type = ExportType.getType(mode);
        if (forInkscape && type == ExportType.SVG) {
            type = ExportType.SVGI;
        }
        return Exporter.exportSpectrumOrImage(jsvp, type, -1, fileName);
    }

    private static String exportSpectrum(ScriptInterface si, String mode, int index, DialogHelper dialogHelper) {
        JSVPanel jsvp = si.getSelectedPanel();
        ExportType imode = ExportType.getType(mode);
        String name = dialogHelper.getSuggestedFileName(imode);
        File file = dialogHelper.getFile(name, (Component)((Object)jsvp), true);
        if (file == null) {
            return null;
        }
        String msg = "OK";
        if (imode == ExportType.SOURCE) {
            JSVFileManager.fileCopy(jsvp.getPanelData().getSpectrum().getFilePath(), file);
        } else {
            msg = Exporter.exportSpectrumOrImage(jsvp, imode, index, file.getAbsolutePath());
        }
        boolean isOK = msg.startsWith("OK");
        if (isOK) {
            si.updateRecentMenus(file.getAbsolutePath());
        }
        return msg;
    }

    private static String exportSpectrumOrImage(JSVPanel jsvp, ExportType imode, int index, String path) {
        PanelData pd = jsvp.getPanelData();
        if (index < 0 && (index = pd.getCurrentSpectrumIndex()) < 0) {
            return "Error exporting spectrum: No spectrum selected";
        }
        JDXSpectrum spec = pd.getSpectrumAt(index);
        int startIndex = pd.getStartingPointIndex(index);
        int endIndex = pd.getEndingPointIndex(index);
        try {
            String msg;
            switch (imode) {
                case SVG: 
                case SVGI: {
                    msg = new SVGExporter().exportAsSVG(path, spec.getXYCoords(), spec.getTitle(), startIndex, endIndex, spec.getXUnits(), spec.getYUnits(), spec.isContinuous(), spec.isXIncreasing(), spec.isInverted(), (Color)jsvp.getColor(ScriptToken.PLOTAREACOLOR), ((Component)((Object)jsvp)).getBackground(), (Color)jsvp.getPlotColor(0), (Color)jsvp.getColor(ScriptToken.GRIDCOLOR), (Color)jsvp.getColor(ScriptToken.TITLECOLOR), (Color)jsvp.getColor(ScriptToken.SCALECOLOR), (Color)jsvp.getColor(ScriptToken.UNITSCOLOR), imode == ExportType.SVGI);
                    break;
                }
                default: {
                    msg = Exporter.exportTheSpectrum(imode, path, spec, startIndex, endIndex);
                }
            }
            return "OK - Exported " + imode.name() + ": " + path + msg;
        }
        catch (IOException ioe) {
            return "Error exporting " + path + ": " + ioe.getMessage();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExportType {
        UNK,
        SOURCE,
        DIF,
        FIX,
        SQZ,
        PAC,
        XY,
        DIFDUP,
        PNG,
        JPG,
        SVG,
        SVGI,
        CML,
        AML,
        PDF;


        public static ExportType getType(String type) {
            if ((type = type.toUpperCase()).equalsIgnoreCase(Exporter.sourceLabel)) {
                return SOURCE;
            }
            if (type.startsWith("XML")) {
                return AML;
            }
            ExportType[] exportTypeArray = ExportType.values();
            int n = exportTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExportType mode = exportTypeArray[n2];
                if (mode.name().equals(type)) {
                    return mode;
                }
                ++n2;
            }
            return UNK;
        }

        public static boolean isExportMode(String ext) {
            return ExportType.getType(ext) != UNK;
        }
    }
}

