/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Hashtable;
import java.util.Map;
import jspecview.common.JSVPanel;
import jspecview.common.ScriptToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameters {
    protected String name;
    protected String titleFont;
    protected String displayFont;
    protected Map<ScriptToken, Object> elementColors = new Hashtable<ScriptToken, Object>();
    protected boolean isDefault = false;
    protected Object plotColors;
    public double integralMinY = 0.1;
    public double integralRange = 50.0;
    public double integralOffset = 30.0;
    public boolean integralDrawAll = false;
    public double peakListThreshold = Double.NaN;
    public String peakListInterpolation = "parabolic";
    public String numberFormat = "0.00";
    private Map<ScriptToken, Boolean> htBooleans = new Hashtable<ScriptToken, Boolean>();

    public Map<ScriptToken, Object> getColors() {
        return this.elementColors;
    }

    public Parameters(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(String fontName) {
        this.titleFont = fontName;
    }

    public String getDisplayFont() {
        return this.displayFont;
    }

    public void setDisplayFont(String fontName) {
        this.displayFont = fontName;
    }

    public void setDefault(boolean val) {
        this.isDefault = val;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public Object getColor(ScriptToken st) {
        return this.elementColors.get((Object)st);
    }

    public Object setColor(ScriptToken st, Object color) {
        if (color != null) {
            this.elementColors.put(st, color);
        }
        return color;
    }

    public Parameters copy(String newName) {
        Parameters ds = new Parameters(newName);
        ds.setDisplayFont(this.getDisplayFont());
        for (Map.Entry<ScriptToken, Object> entry : this.elementColors.entrySet()) {
            ds.setColor(entry.getKey(), entry.getValue());
        }
        return ds;
    }

    public Parameters copy() {
        return this.copy(this.getName());
    }

    protected void setDefaultColors(Object[] colors) {
        this.setColor(ScriptToken.TITLECOLOR, colors[0]);
        this.setColor(ScriptToken.UNITSCOLOR, colors[1]);
        this.setColor(ScriptToken.SCALECOLOR, colors[2]);
        this.setColor(ScriptToken.COORDINATESCOLOR, colors[3]);
        this.setColor(ScriptToken.GRIDCOLOR, colors[4]);
        this.setColor(ScriptToken.PLOTCOLOR, colors[5]);
        this.setColor(ScriptToken.PLOTAREACOLOR, colors[6]);
        this.setColor(ScriptToken.BACKGROUNDCOLOR, colors[7]);
        this.setColor(ScriptToken.INTEGRALPLOTCOLOR, colors[8]);
        this.setColor(ScriptToken.PEAKTABCOLOR, colors[9]);
        this.setColor(ScriptToken.HIGHLIGHTCOLOR, colors[10]);
    }

    protected void setParamDefaults() {
        this.setBoolean(ScriptToken.TITLEON, true);
        this.setBoolean(ScriptToken.ENABLEZOOM, true);
        this.setBoolean(ScriptToken.DISPLAY2D, true);
        this.setBoolean(ScriptToken.COORDINATESON, true);
        this.setBoolean(ScriptToken.GRIDON, true);
        this.setBoolean(ScriptToken.XSCALEON, true);
        this.setBoolean(ScriptToken.YSCALEON, true);
        this.setBoolean(ScriptToken.XUNITSON, true);
        this.setBoolean(ScriptToken.YUNITSON, true);
    }

    public static boolean isTrue(String value) {
        return value.length() == 0 || Boolean.parseBoolean(value);
    }

    public static Boolean getTFToggle(String value) {
        return value.equalsIgnoreCase("TOGGLE") ? null : (Parameters.isTrue(value) ? Boolean.TRUE : Boolean.FALSE);
    }

    public Map<ScriptToken, Boolean> getBooleans() {
        return this.htBooleans;
    }

    public boolean setBoolean(ScriptToken st, boolean val) {
        this.htBooleans.put(st, val);
        return val;
    }

    public boolean getBoolean(ScriptToken t) {
        return Boolean.TRUE == this.htBooleans.get((Object)t);
    }

    public void setFor(JSVPanel jsvp, Parameters ds, boolean includeMeasures) {
        if (ds == null) {
            ds = this;
        }
        if (includeMeasures) {
            jsvp.getPanelData().setBoolean(this, null);
        }
        if (jsvp.getPlotColor(1) != null) {
            jsvp.setPlotColors(this.plotColors);
        }
        jsvp.setColorOrFont(ds, null);
    }

    public void set(JSVPanel jsvp, ScriptToken st, String value) {
        Object param = null;
        switch (st) {
            default: {
                return;
            }
            case PLOTCOLORS: {
                if (jsvp == null) {
                    this.getPlotColors(value);
                } else {
                    jsvp.setPlotColors(this.getPlotColors(value));
                }
                return;
            }
            case COORDINATESON: 
            case DISPLAY1D: 
            case DISPLAY2D: 
            case ENABLEZOOM: 
            case GRIDON: 
            case REVERSEPLOT: 
            case TITLEON: 
            case TITLEBOLDON: 
            case XSCALEON: 
            case XUNITSON: 
            case YSCALEON: 
            case YUNITSON: {
                Boolean tfToggle = Parameters.getTFToggle(value);
                if (tfToggle != null) {
                    this.setBoolean(st, tfToggle);
                    break;
                }
                if (jsvp == null) {
                    return;
                }
                boolean b = !jsvp.getPanelData().getBoolean(st);
                switch (st) {
                    case XSCALEON: {
                        this.setBoolean(ScriptToken.XUNITSON, b);
                        jsvp.getPanelData().setBoolean(ScriptToken.XUNITSON, b);
                        break;
                    }
                    case YSCALEON: {
                        this.setBoolean(ScriptToken.YUNITSON, b);
                        jsvp.getPanelData().setBoolean(ScriptToken.YUNITSON, b);
                    }
                }
                this.setBoolean(st, b);
                break;
            }
            case BACKGROUNDCOLOR: 
            case COORDINATESCOLOR: 
            case GRIDCOLOR: 
            case HIGHLIGHTCOLOR: 
            case INTEGRALPLOTCOLOR: 
            case PEAKTABCOLOR: 
            case PLOTAREACOLOR: 
            case PLOTCOLOR: 
            case SCALECOLOR: 
            case TITLECOLOR: 
            case UNITSCOLOR: {
                param = this.setColorFromString(st, value);
                break;
            }
            case DISPLAYFONTNAME: 
            case TITLEFONTNAME: {
                param = this.getFontName(st, value);
            }
        }
        if (jsvp == null) {
            return;
        }
        if (param != null) {
            jsvp.setColorOrFont(this, st);
        } else {
            jsvp.getPanelData().setBoolean(this, st);
        }
    }

    protected Object getPlotColors(String value) {
        return null;
    }

    protected Object setColorFromString(ScriptToken st, String value) {
        return null;
    }

    protected Object getFontName(ScriptToken st, String value) {
        return null;
    }

    static boolean isMatch(String match, String key) {
        return match == null || key.equalsIgnoreCase(match);
    }

    public static void putInfo(String match, Map<String, Object> info, String key, Object value) {
        if (value != null && Parameters.isMatch(match, key)) {
            info.put(match == null ? key : match, value);
        }
    }
}

