/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import jspecview.common.Annotation;
import jspecview.common.Coordinate;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVDialog;
import jspecview.common.JSVPanel;
import jspecview.common.JSVPanelNode;
import jspecview.common.PanelData;
import jspecview.common.Parameters;
import jspecview.common.PeakInfo;
import jspecview.common.PeakPickEvent;
import jspecview.common.ScriptInterface;
import jspecview.common.ScriptToken;
import jspecview.common.ScriptTokenizer;
import jspecview.source.JDXSource;
import jspecview.util.JSVEscape;
import jspecview.util.JSVLogger;
import jspecview.util.JSVParser;
import jspecview.util.JSVTextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSViewer {
    private static final int NLEVEL_MAX = 100;
    private static String testScript = "<PeakData  index=\"1\" title=\"\" model=\"~1.1\" type=\"1HNMR\" xMin=\"3.2915\" xMax=\"3.2965\" atoms=\"15,16,17,18,19,20\" multiplicity=\"\" integral=\"1\"> src=\"JPECVIEW\" file=\"http://SIMULATION/$caffeine\"";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean runScriptNow(ScriptInterface si, String script) {
        si.incrementViewCount(1);
        if (script == null) {
            script = "";
        }
        String msg = null;
        script = script.trim();
        if (JSVLogger.debugging) {
            JSVLogger.info("RUNSCRIPT " + script);
        }
        JSVPanel jsvp = si.getSelectedPanel();
        boolean isOK = true;
        int nErrorsLeft = 10;
        ScriptTokenizer commandTokens = new ScriptTokenizer(script, true);
        block44: while (commandTokens.hasMoreTokens() && nErrorsLeft > 0) {
            String token = commandTokens.nextToken();
            ScriptTokenizer eachParam = new ScriptTokenizer(token, false);
            String key = ScriptToken.getKey(eachParam);
            if (key == null) continue;
            ScriptToken st = ScriptToken.getScriptToken(key);
            String value = ScriptToken.getValue(st, eachParam, token);
            JSVLogger.info("KEY-> " + key + " VALUE-> " + value + " : " + (Object)((Object)st));
            try {
                switch (st) {
                    case UNKNOWN: {
                        JSVLogger.info("Unrecognized parameter: " + key);
                        --nErrorsLeft;
                        break;
                    }
                    default: {
                        si.getParameters().set(jsvp, st, value);
                        si.updateBoolean(st, Parameters.isTrue(value));
                        break;
                    }
                    case COORDCALLBACKFUNCTIONNAME: 
                    case LOADFILECALLBACKFUNCTIONNAME: 
                    case PEAKCALLBACKFUNCTIONNAME: 
                    case SYNCCALLBACKFUNCTIONNAME: {
                        si.execSetCallback(st, value);
                        break;
                    }
                    case AUTOINTEGRATE: {
                        si.execSetAutoIntegrate(Parameters.isTrue(value));
                        break;
                    }
                    case CLOSE: {
                        si.execClose(value, true);
                        jsvp = si.getSelectedPanel();
                        break;
                    }
                    case DEBUG: {
                        JSVLogger.setLogLevel(value.toLowerCase().equals("high") ? 6 : (Parameters.isTrue(value) ? 5 : 4));
                        break;
                    }
                    case EXPORT: {
                        msg = si.execExport(jsvp, value);
                        return false;
                    }
                    case FINDX: {
                        if (jsvp == null) continue block44;
                        jsvp.getPanelData().findX(null, Double.parseDouble(value));
                        break;
                    }
                    case GETPROPERTY: {
                        Map<String, Object> info;
                        Map<String, Object> map = info = jsvp == null ? null : JSViewer.getPropertyAsJavaObject(si, value);
                        if (info == null) continue block44;
                        jsvp.showMessage(JSVEscape.toJSON(null, info, true), value);
                        break;
                    }
                    case GETSOLUTIONCOLOR: {
                        if (jsvp == null) continue block44;
                        JSViewer.showColorMessage(si);
                        break;
                    }
                    case HIDDEN: {
                        si.execHidden(Parameters.isTrue(value));
                        break;
                    }
                    case INTEGRALOFFSET: 
                    case INTEGRALRANGE: {
                        JSViewer.execSetIntegralParameter(si, st, Double.parseDouble(value));
                        break;
                    }
                    case INTEGRATE: 
                    case INTEGRATION: {
                        if (jsvp == null) continue block44;
                        JSViewer.execIntegrate(si, value);
                        break;
                    }
                    case INTEGRATIONRATIOS: {
                        si.setIntegrationRatios(value);
                        if (jsvp == null) continue block44;
                        JSViewer.execIntegrate(si, null);
                        break;
                    }
                    case INTERFACE: {
                        si.execSetInterface(value);
                        break;
                    }
                    case IRMODE: {
                        if (jsvp == null) continue block44;
                        JSViewer.execIRMode(si, value);
                        break;
                    }
                    case JMOL: {
                        si.syncToJmol(value);
                        break;
                    }
                    case JSV: {
                        JSViewer.syncScript(si, JSVTextFormat.trimQuotes(value));
                        break;
                    }
                    case LABEL: {
                        if (jsvp == null) continue block44;
                        jsvp.getPanelData().addAnnotation(ScriptToken.getTokens(value));
                        break;
                    }
                    case LINK: {
                        if (jsvp == null) continue block44;
                        jsvp.getPanelData().linkSpectra(PanelData.LinkMode.getMode(value));
                        break;
                    }
                    case LOAD: {
                        msg = si.execLoad(value);
                        jsvp = si.getSelectedPanel();
                        break;
                    }
                    case LOADIMAGINARY: {
                        si.setLoadImaginary(Parameters.isTrue(value));
                        break;
                    }
                    case OVERLAYSTACKED: {
                        if (jsvp == null) continue block44;
                        jsvp.getPanelData().splitStack(!Parameters.isTrue(value));
                        break;
                    }
                    case PEAK: {
                        JSViewer.execPeak(si, value);
                        break;
                    }
                    case PEAKLIST: {
                        JSViewer.execPeakList(si, value);
                        break;
                    }
                    case PRINT: {
                        if (jsvp == null) continue block44;
                        si.print(value);
                        break;
                    }
                    case SCALEBY: {
                        JSViewer.scaleSelectedBy(si.getPanelNodes(), value);
                        break;
                    }
                    case SCRIPT: {
                        String s = si.getFileAsString(value);
                        if (s == null || si.incrementScriptLevelCount(0) >= 100) continue block44;
                        JSViewer.runScriptNow(si, s);
                        break;
                    }
                    case SELECT: {
                        JSViewer.execSelect(si, value);
                        break;
                    }
                    case SETPEAK: {
                        if (jsvp == null) continue block44;
                        jsvp.getPanelData().shiftSpectrum(Double.NaN, value.equalsIgnoreCase("NONE") ? Double.MAX_VALUE : (value.equalsIgnoreCase("?") ? Double.MIN_VALUE : Double.parseDouble(value)));
                        break;
                    }
                    case SETX: {
                        if (jsvp == null) continue block44;
                        jsvp.getPanelData().shiftSpectrum(Double.MIN_VALUE, Double.parseDouble(value));
                        break;
                    }
                    case SHIFTX: {
                        if (jsvp == null) continue block44;
                        jsvp.getPanelData().shiftSpectrum(value.equalsIgnoreCase("NONE") ? Double.MAX_VALUE : Double.parseDouble(value), Double.NaN);
                        break;
                    }
                    case SHOWMEASUREMENTS: {
                        if (jsvp == null) continue block44;
                        jsvp.getPanelData().showAnnotation(Annotation.AType.Measurements, Parameters.getTFToggle(value));
                        break;
                    }
                    case SHOWPEAKLIST: {
                        if (jsvp == null) continue block44;
                        jsvp.getPanelData().showAnnotation(Annotation.AType.PeakList, Parameters.getTFToggle(value));
                        break;
                    }
                    case SHOWINTEGRATION: {
                        if (jsvp == null) continue block44;
                        jsvp.getPanelData().showAnnotation(Annotation.AType.Integration, Parameters.getTFToggle(value));
                        break;
                    }
                    case SPECTRUM: 
                    case SPECTRUMNUMBER: {
                        jsvp = si.setSpectrum(value);
                        if (jsvp != null) continue block44;
                        return false;
                    }
                    case STACKOFFSETY: {
                        int offset = JSVParser.parseInt("" + JSVParser.parseFloat(value));
                        if (jsvp == null || offset == Integer.MIN_VALUE) continue block44;
                        jsvp.getPanelData().setYStackOffsetPercent(offset);
                        break;
                    }
                    case TEST: {
                        si.execTest(value);
                        break;
                    }
                    case OVERLAY: 
                    case VIEW: {
                        JSViewer.execView(si, value, true);
                        jsvp = si.getSelectedPanel();
                        break;
                    }
                    case YSCALE: {
                        if (jsvp == null) continue block44;
                        JSViewer.setYScale(si, value, jsvp);
                        break;
                    }
                    case ZOOM: {
                        if (jsvp == null) continue block44;
                        isOK = JSViewer.execZoom(value, jsvp);
                        break;
                    }
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                JSVLogger.error(e.getMessage());
                if (JSVLogger.debugging) {
                    e.printStackTrace();
                }
                isOK = false;
                --nErrorsLeft;
            }
        }
        si.incrementViewCount(-1);
        si.execScriptComplete(msg, true);
        return isOK;
    }

    private static void execPeak(ScriptInterface si, String value) {
        try {
            List<String> tokens = ScriptToken.getTokens(value);
            value = " type=\"" + tokens.get(0).toUpperCase() + "\" _match=\"" + JSVTextFormat.trimQuotes(tokens.get(1).toUpperCase()) + "\"";
            if (tokens.size() > 2 && tokens.get(2).equalsIgnoreCase("all")) {
                value = String.valueOf(value) + " title=\"ALL\"";
            }
            JSViewer.processPeakPickEvent(si, new PeakInfo(value), false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void execPeakList(ScriptInterface si, String value) {
        JSVPanel jsvp = si.getSelectedPanel();
        Parameters p = si.getParameters();
        Boolean b = Parameters.getTFToggle(value);
        if (value.indexOf("=") < 0) {
            if (jsvp != null) {
                jsvp.getPanelData().getPeakListing(null, b);
            }
        } else {
            List<String> tokens = ScriptToken.getTokens(value);
            int i = tokens.size();
            while (--i >= 0) {
                String token = tokens.get(i);
                int pt = token.indexOf("=");
                if (pt <= 0) continue;
                String key = token.substring(0, pt);
                value = token.substring(pt + 1);
                try {
                    if (key.startsWith("thr")) {
                        p.peakListThreshold = Double.valueOf(value);
                    } else if (key.startsWith("int")) {
                        String string = p.peakListInterpolation = value.equalsIgnoreCase("none") ? "NONE" : "parabolic";
                    }
                    if (jsvp == null) continue;
                    jsvp.getPanelData().getPeakListing(p, Boolean.TRUE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static boolean execZoom(String value, JSVPanel jsvp) {
        double x1 = 0.0;
        double x2 = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        List<String> tokens = ScriptToken.getTokens(value);
        switch (tokens.size()) {
            default: {
                return false;
            }
            case 1: {
                JSViewer.zoomTo(jsvp, tokens.get(0));
                return true;
            }
            case 2: {
                x1 = Double.parseDouble(tokens.get(0));
                x2 = Double.parseDouble(tokens.get(1));
                break;
            }
            case 4: {
                x1 = Double.parseDouble(tokens.get(0));
                y1 = Double.parseDouble(tokens.get(1));
                x2 = Double.parseDouble(tokens.get(2));
                y2 = Double.parseDouble(tokens.get(3));
            }
        }
        jsvp.getPanelData().setZoom(x1, y1, x2, y2);
        return true;
    }

    private static void scaleSelectedBy(List<JSVPanelNode> nodes, String value) {
        try {
            double f = Double.parseDouble(value);
            int i = nodes.size();
            while (--i >= 0) {
                nodes.get((int)i).jsvp.getPanelData().scaleSelectedBy(f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void execSelect(ScriptInterface si, String value) {
        List<JSVPanelNode> nodes = si.getPanelNodes();
        int i = nodes.size();
        while (--i >= 0) {
            nodes.get((int)i).jsvp.getPanelData().selectFromEntireSet(Integer.MIN_VALUE);
        }
        ArrayList<JDXSpectrum> speclist = new ArrayList<JDXSpectrum>();
        JSViewer.fillSpecList(si, value, speclist, false);
    }

    public static void execView(ScriptInterface si, String value, boolean fromScript) {
        ArrayList<JDXSpectrum> speclist = new ArrayList<JDXSpectrum>();
        String strlist = JSViewer.fillSpecList(si, value, speclist, true);
        if (speclist.size() > 0) {
            si.openDataOrFile(null, strlist, speclist, strlist, -1, -1, false);
        }
        if (!fromScript) {
            si.validateAndRepaint();
        }
    }

    private static void execIRMode(ScriptInterface si, String value) {
        JDXSpectrum.IRMode mode = JDXSpectrum.IRMode.getMode(value);
        PanelData pd = si.getSelectedPanel().getPanelData();
        JDXSpectrum spec = pd.getSpectrum();
        JDXSpectrum spec2 = JDXSpectrum.taConvert(spec, mode);
        if (spec2 == spec) {
            return;
        }
        pd.setSpectrum(spec2);
        si.setIRMode(mode);
    }

    private static void execIntegrate(ScriptInterface si, String value) {
        JSVPanel jsvp = si.getSelectedPanel();
        if (jsvp == null) {
            return;
        }
        jsvp.getPanelData().checkIntegral(si.getParameters(), value);
        String integrationRatios = si.getIntegrationRatios();
        if (integrationRatios != null) {
            jsvp.getPanelData().setIntegrationRatios(integrationRatios);
        }
        si.setIntegrationRatios(null);
        jsvp.doRepaint();
    }

    private static void execSetIntegralParameter(ScriptInterface si, ScriptToken st, double value) {
        Parameters p = si.getParameters();
        switch (st) {
            case INTEGRALRANGE: {
                p.integralRange = value;
                break;
            }
            case INTEGRALOFFSET: {
                p.integralOffset = value;
            }
        }
        JSVPanel jsvp = si.getSelectedPanel();
        if (jsvp == null) {
            return;
        }
        jsvp.getPanelData().checkIntegral(si.getParameters(), "update");
    }

    private static void setYScale(ScriptInterface si, String value, JSVPanel jsvp) {
        List<JSVPanelNode> panelNodes = si.getPanelNodes();
        JDXSource currentSource = si.getCurrentSource();
        List<String> tokens = ScriptToken.getTokens(value);
        int pt = 0;
        boolean isAll = false;
        if (tokens.size() > 1 && tokens.get(0).equalsIgnoreCase("ALL")) {
            isAll = true;
        }
        int n = ++pt;
        double y1 = Double.parseDouble(tokens.get(n));
        double y2 = Double.parseDouble(tokens.get(++pt));
        if (isAll) {
            JDXSpectrum spec = jsvp.getPanelData().getSpectrum();
            int i = panelNodes.size();
            while (--i >= 0) {
                JSVPanelNode node = panelNodes.get(i);
                if (node.source != currentSource || !JDXSpectrum.areXScalesCompatible(spec, node.getSpectrum(), false, false)) continue;
                node.jsvp.getPanelData().setZoom(0.0, y1, 0.0, y2);
            }
        } else {
            jsvp.getPanelData().setZoom(0.0, y1, 0.0, y2);
        }
    }

    public static void setOverlayLegendVisibility(ScriptInterface si, JSVPanel jsvp, boolean showLegend) {
        List<JSVPanelNode> panelNodes = si.getPanelNodes();
        JSVPanelNode node = JSVPanelNode.findNode(jsvp, panelNodes);
        int i = panelNodes.size();
        while (--i >= 0) {
            JSViewer.showOverlayLegend(si, panelNodes.get(i), panelNodes.get(i) == node && showLegend);
        }
    }

    private static void showOverlayLegend(ScriptInterface si, JSVPanelNode node, boolean visible) {
        JSVDialog legend = node.legend;
        if (legend == null && visible) {
            legend = node.setLegend(node.jsvp.getPanelData().getNumberOfSpectraInCurrentSet() > 1 && node.jsvp.getPanelData().getNumberOfGraphSets() == 1 ? si.getOverlayLegend(node.jsvp) : null);
        }
        if (legend != null) {
            legend.setVisible(visible);
        }
    }

    public static void addHighLight(ScriptInterface si, double x1, double x2, int r, int g, int b, int a) {
        JSVPanel jsvp = si.getSelectedPanel();
        if (jsvp != null) {
            jsvp.getPanelData().addHighlight(null, x1, x2, null, r, g, b, a);
            jsvp.doRepaint();
        }
    }

    public static void syncScript(ScriptInterface si, String peakScript) {
        String modelSent;
        if (peakScript.equals("TEST")) {
            peakScript = testScript;
        }
        JSVLogger.info(Thread.currentThread() + "Jmol>JSV " + peakScript);
        if (peakScript.indexOf("<PeakData") < 0) {
            JSViewer.runScriptNow(si, peakScript);
            if (peakScript.indexOf("#SYNC_PEAKS") >= 0) {
                JDXSource source = si.getCurrentSource();
                if (source == null) {
                    return;
                }
                try {
                    String file = "file=" + JSVEscape.escape(source.getFilePath());
                    ArrayList<PeakInfo> peaks = source.getSpectra().get(0).getPeakList();
                    StringBuffer sb = new StringBuffer();
                    sb.append("[");
                    int n = peaks.size();
                    int i = 0;
                    while (i < n) {
                        String s = peaks.get(i).toString();
                        s = String.valueOf(s) + " " + file;
                        sb.append(JSVEscape.escape(s));
                        if (i > 0) {
                            sb.append(",");
                        }
                        ++i;
                    }
                    sb.append("]");
                    si.syncToJmol("Peaks: " + sb);
                }
                catch (Exception file) {
                    // empty catch block
                }
            }
            return;
        }
        peakScript = JSVTextFormat.simpleReplace(peakScript, "\\\"", "");
        String file = JSVParser.getQuotedAttribute(peakScript, "file");
        System.out.println("file2=" + file);
        String index = JSVParser.getQuotedAttribute(peakScript, "index");
        if (file == null || index == null) {
            return;
        }
        String model = JSVParser.getQuotedAttribute(peakScript, "model");
        String jmolSource = JSVParser.getQuotedAttribute(peakScript, "src");
        String string = modelSent = jmolSource != null && jmolSource.startsWith("Jmol") ? null : si.getReturnFromJmolModel();
        if (model != null && modelSent != null && !model.equals(modelSent)) {
            JSVLogger.info("JSV ignoring model " + model + "; should be " + modelSent);
            return;
        }
        si.setReturnFromJmolModel(null);
        if (si.getPanelNodes().size() == 0 || !JSViewer.checkFileAlreadyLoaded(si, file)) {
            JSVLogger.info("file " + file + " not found -- JSViewer closing all and reopening");
            si.syncLoad(file);
        }
        PeakInfo pi = JSViewer.selectPanelByPeak(si, peakScript);
        JSVPanel jsvp = si.getSelectedPanel();
        String type = JSVParser.getQuotedAttribute(peakScript, "type");
        jsvp.getPanelData().selectSpectrum(file, type, model, true);
        si.sendPanelChange(jsvp);
        jsvp.getPanelData().addPeakHighlight(pi);
        jsvp.doRepaint();
        if (jmolSource == null || pi != null && pi.getAtoms() != null) {
            si.syncToJmol(JSViewer.jmolSelect(pi));
        }
    }

    private static boolean checkFileAlreadyLoaded(ScriptInterface si, String fileName) {
        JSVPanel jsvp = si.getSelectedPanel();
        if (jsvp != null && jsvp.getPanelData().hasFileLoaded(fileName)) {
            return true;
        }
        List<JSVPanelNode> panelNodes = si.getPanelNodes();
        int i = panelNodes.size();
        while (--i >= 0) {
            if (!panelNodes.get((int)i).jsvp.getPanelData().hasFileLoaded(fileName)) continue;
            si.setSelectedPanel(panelNodes.get((int)i).jsvp);
            return true;
        }
        return false;
    }

    private static PeakInfo selectPanelByPeak(ScriptInterface si, String peakScript) {
        List<JSVPanelNode> panelNodes = si.getPanelNodes();
        if (panelNodes == null) {
            return null;
        }
        String file = JSVParser.getQuotedAttribute(peakScript, "file");
        String index = JSVParser.getQuotedAttribute(peakScript, "index");
        PeakInfo pi = null;
        int i = panelNodes.size();
        while (--i >= 0) {
            panelNodes.get((int)i).jsvp.getPanelData().addPeakHighlight(null);
        }
        JSVPanel jsvp = si.getSelectedPanel();
        pi = jsvp.getPanelData().selectPeakByFileIndex(file, index);
        System.out.println(Thread.currentThread() + "JSViewer selectPanelByPeak pi = " + pi);
        if (pi != null) {
            si.setNode(JSVPanelNode.findNode(jsvp, panelNodes), false);
        } else {
            int i2 = panelNodes.size();
            while (--i2 >= 0) {
                JSVPanelNode node = panelNodes.get(i2);
                pi = node.jsvp.getPanelData().selectPeakByFileIndex(file, index);
                if (pi == null) continue;
                si.setNode(node, false);
                break;
            }
        }
        return pi;
    }

    public static void processPeakPickEvent(ScriptInterface si, Object eventObj, boolean isApp) {
        PeakInfo pi;
        if (eventObj instanceof PeakInfo) {
            pi = (PeakInfo)eventObj;
            JSVPanel jsvp = si.getSelectedPanel();
            PeakInfo pi2 = jsvp.getPanelData().findMatchingPeakInfo(pi);
            if (pi2 == null) {
                if (!"ALL".equals(pi.getTitle())) {
                    return;
                }
                List<JSVPanelNode> panelNodes = si.getPanelNodes();
                JSVPanelNode node = null;
                int i = 0;
                while (i < panelNodes.size()) {
                    pi2 = panelNodes.get((int)i).jsvp.getPanelData().findMatchingPeakInfo(pi);
                    if (pi2 != null) {
                        node = panelNodes.get(i);
                        break;
                    }
                    ++i;
                }
                if (node == null) {
                    return;
                }
                si.setNode(node, false);
            }
            pi = pi2;
        } else {
            PeakPickEvent e = (PeakPickEvent)eventObj;
            si.setSelectedPanel((JSVPanel)e.getSource());
            pi = e.getPeakInfo();
        }
        si.getSelectedPanel().getPanelData().addPeakHighlight(pi);
        JSViewer.syncToJmol(si, pi);
        if (pi.isClearAll()) {
            si.getSelectedPanel().doRepaint();
        } else {
            si.getSelectedPanel().getPanelData().selectSpectrum(pi.getFilePath(), pi.getType(), pi.getModel(), true);
        }
        si.checkCallbacks(pi.getTitle());
    }

    private static void syncToJmol(ScriptInterface si, PeakInfo pi) {
        si.setReturnFromJmolModel(pi.getModel());
        si.syncToJmol(JSViewer.jmolSelect(pi));
    }

    public static void sendPanelChange(ScriptInterface si, JSVPanel jsvp) {
        PanelData pd = jsvp.getPanelData();
        JDXSpectrum spec = pd.getSpectrum();
        PeakInfo pi = spec.getSelectedPeak();
        if (pi == null) {
            pi = spec.getModelPeakInfoForAutoSelectOnLoad();
        }
        if (pi == null) {
            pi = spec.getBasePeakInfo();
        }
        pd.addPeakHighlight(pi);
        JSVLogger.info(Thread.currentThread() + "JSViewer sendFrameChange " + jsvp);
        JSViewer.syncToJmol(si, pi);
    }

    public static String jmolSelect(PeakInfo pi) {
        String script = null;
        script = "IR".equals(pi.getType()) || "RAMAN".equals(pi.getType()) ? "vibration ON; selectionHalos OFF;" : (pi.getAtoms() != null ? "vibration OFF; selectionhalos ON;" : "vibration OFF; selectionhalos OFF;");
        script = "Select: " + pi + " script=\"" + script;
        System.out.println("JSpecView jmolSelect " + script);
        return script;
    }

    public static void removeAllHighlights(ScriptInterface si) {
        JSVPanel jsvp = si.getSelectedPanel();
        if (jsvp != null) {
            jsvp.getPanelData().removeAllHighlights();
            jsvp.doRepaint();
        }
    }

    public static void removeHighlights(ScriptInterface si, double x1, double x2) {
        JSVPanel jsvp = si.getSelectedPanel();
        if (jsvp != null) {
            jsvp.getPanelData().removeHighlight(x1, x2);
            jsvp.doRepaint();
        }
    }

    public static Map<String, Object> getPropertyAsJavaObject(ScriptInterface si, String key) {
        boolean isAll = false;
        if (key != null && key.toUpperCase().startsWith("ALL ") || "all".equalsIgnoreCase(key)) {
            key = key.substring(3).trim();
            isAll = true;
        }
        if ("".equals(key)) {
            key = null;
        }
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        Map<String, Object> map0 = si.getSelectedPanel().getPanelData().getInfo(true, key);
        if (!isAll && map0 != null) {
            return map0;
        }
        if (map0 != null) {
            map.put("current", map0);
        }
        ArrayList<Map<String, Object>> info = new ArrayList<Map<String, Object>>();
        List<JSVPanelNode> panelNodes = si.getPanelNodes();
        int i = 0;
        while (i < panelNodes.size()) {
            JSVPanel jsvp = panelNodes.get((int)i).jsvp;
            if (jsvp != null) {
                info.add(panelNodes.get(i).getInfo(key));
            }
            ++i;
        }
        map.put("items", info);
        return map;
    }

    public static String getCoordinate(ScriptInterface si) {
        Coordinate coord;
        if (si.getSelectedPanel() != null && (coord = si.getSelectedPanel().getPanelData().getClickedCoordinate()) != null) {
            return String.valueOf(coord.getXVal()) + " " + coord.getYVal();
        }
        return "";
    }

    private static String fillSpecList(ScriptInterface si, String value, List<JDXSpectrum> speclist, boolean isView) {
        JSVPanelNode node;
        List<String> list;
        StringBuffer sb;
        List<JSVPanelNode> panelNodes = si.getPanelNodes();
        JSVPanel selectedPanel = si.getSelectedPanel();
        String prefix = "1.";
        List<String> list0 = null;
        boolean isNone = value.equalsIgnoreCase("NONE");
        if (isNone || value.equalsIgnoreCase("all")) {
            value = "*";
        }
        if (value.indexOf("*") < 0) {
            String[] tokens = value.split(" ");
            sb = new StringBuffer();
            int i = 0;
            while (i < tokens.length) {
                int pt = tokens[i].indexOf(46);
                if (pt != tokens[i].lastIndexOf(46)) {
                    tokens[i] = String.valueOf(tokens[i].substring(0, pt + 1)) + tokens[i].substring(pt + 1).replace('.', '_');
                }
                sb.append(tokens[i]).append(" ");
                ++i;
            }
            value = sb.toString().trim();
        }
        if (value.equals("*")) {
            list = ScriptToken.getTokens(JSVPanelNode.getSpectrumListAsString(panelNodes));
        } else if (value.startsWith("\"")) {
            list = ScriptToken.getTokens(value);
        } else {
            value = JSVTextFormat.simpleReplace(value, "_", " _ ");
            value = JSVTextFormat.simpleReplace(value, "-", " - ");
            list = ScriptToken.getTokens(value);
            list0 = ScriptToken.getTokens(JSVPanelNode.getSpectrumListAsString(panelNodes));
            if (list0.size() == 0) {
                return null;
            }
        }
        String id0 = selectedPanel == null ? prefix : JSVPanelNode.findNode((JSVPanel)selectedPanel, panelNodes).id;
        id0 = id0.substring(0, id0.indexOf(".") + 1);
        sb = new StringBuffer();
        int n = list.size();
        String idLast = null;
        int i = 0;
        while (i < n) {
            String id = list.get(i);
            double userYFactor = Double.NaN;
            int isubspec = -1;
            if (i + 1 < n && list.get(i + 1).equals("*")) {
                userYFactor = Double.parseDouble(list.get(i += 2));
            } else if (i + 1 < n && list.get(i + 1).equals("_")) {
                isubspec = Integer.parseInt(list.get(i += 2));
            }
            if (id.equals("-")) {
                if (idLast == null) {
                    idLast = list0.get(0);
                }
                String string = id = i + 1 == n ? list0.get(list0.size() - 1) : list.get(++i);
                if (!id.contains(".")) {
                    id = String.valueOf(id0) + id;
                }
                int pt = 0;
                while (pt < list0.size() && !list0.get(pt).equals(idLast)) {
                    ++pt;
                }
                ++pt;
                while (pt < list0.size() && !idLast.equals(id)) {
                    idLast = list0.get(pt++);
                    speclist.add(JSVPanelNode.findNodeById((String)idLast, panelNodes).jsvp.getPanelData().getSpectrumAt(0));
                    sb.append(",").append(idLast);
                }
            } else if (id.startsWith("\"")) {
                id = JSVTextFormat.trim(id, "\"");
                int j = 0;
                while (j < panelNodes.size()) {
                    JSVPanelNode node2 = panelNodes.get(j);
                    if (node2.fileName != null && node2.fileName.startsWith(id) || node2.frameTitle != null && node2.frameTitle.startsWith(id)) {
                        JSViewer.addSpecToList(node2.jsvp.getPanelData(), userYFactor, -1, speclist, isView);
                        sb.append(",").append(node2.id);
                    }
                    ++j;
                }
            } else {
                JSVPanelNode node3;
                if (!id.contains(".")) {
                    id = String.valueOf(id0) + id;
                }
                if ((node3 = JSVPanelNode.findNodeById(id, panelNodes)) != null) {
                    idLast = id;
                    JSViewer.addSpecToList(node3.jsvp.getPanelData(), userYFactor, isubspec, speclist, isView);
                    sb.append(",").append(id);
                    if (isubspec > 0) {
                        sb.append(".").append(isubspec);
                    }
                }
            }
            ++i;
        }
        if (isView && speclist.size() == 1 && (node = JSVPanelNode.findNodeById(idLast, panelNodes)) != null) {
            si.setNode(node, true);
            speclist.clear();
        }
        return isNone ? "NONE" : (sb.length() > 0 ? sb.toString().substring(1) : null);
    }

    private static void addSpecToList(PanelData pd, double userYFactor, int isubspec, List<JDXSpectrum> list, boolean isView) {
        if (isView) {
            JDXSpectrum spec = pd.getSpectrumAt(0);
            spec.setUserYFactor(Double.isNaN(userYFactor) ? 1.0 : userYFactor);
            pd.addToList(isubspec - 1, list);
        } else {
            pd.selectFromEntireSet(isubspec - 1);
        }
    }

    private static void zoomTo(JSVPanel jsvp, String value) {
        PanelData pd = jsvp.getPanelData();
        if (value.equalsIgnoreCase("next")) {
            pd.nextView();
        } else if (value.toLowerCase().startsWith("prev")) {
            pd.previousView();
        } else if (value.equalsIgnoreCase("out")) {
            pd.resetView();
        } else if (value.equalsIgnoreCase("clear")) {
            pd.clearAllView();
        }
    }

    public static void showColorMessage(ScriptInterface si) {
        JSVPanel jsvp = si.getSelectedPanel();
        jsvp.showMessage(jsvp.getPanelData().getSolutionColorHtml(), "Predicted Colour");
    }
}

