/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.List;
import javax.swing.JOptionPane;
import jspecview.common.ScriptInterface;
import jspecview.util.JSVEscape;
import jspecview.util.JSVLogger;

public class JSVDropTargetListener
implements DropTargetListener {
    private ScriptInterface si;
    static int lastSelection = 0;

    public JSVDropTargetListener(ScriptInterface si) {
        this.si = si;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(dtde.getSourceActions());
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dtde) {
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void drop(DropTargetDropEvent dtde) {
        JSVLogger.debug("Drop detected...");
        Transferable t = dtde.getTransferable();
        boolean isAccepted = false;
        boolean doAppend = false;
        if (this.si.getCurrentSource() != null) {
            Object[] options = new Object[]{"Replace", "Append", "Cancel"};
            int ret = JOptionPane.showOptionDialog(null, "Select an option", "JSpecView File Drop", -1, 3, null, options, options[lastSelection]);
            if (ret < 0 || ret == 2) {
                return;
            }
            lastSelection = ret;
            doAppend = ret == 1;
        }
        String prefix = doAppend ? "" : "close ALL;";
        String postfix = doAppend ? "" : "overlay ALL";
        String cmd = "LOAD APPEND ";
        String fileToLoad = null;
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            Object o = null;
            try {
                dtde.acceptDrop(3);
                o = t.getTransferData(DataFlavor.javaFileListFlavor);
                isAccepted = true;
            }
            catch (Exception e) {
                JSVLogger.error("transfer failed");
            }
            if (o instanceof List) {
                List list = (List)o;
                dtde.getDropTargetContext().dropComplete(true);
                dtde = null;
                StringBuffer sb = new StringBuffer(prefix);
                int i = 0;
                while (i < list.size()) {
                    sb.append(String.valueOf(cmd) + JSVEscape.escape(((File)list.get(i)).getAbsolutePath()) + ";");
                    ++i;
                }
                sb.append(postfix);
                cmd = sb.toString();
                JSVLogger.info("Drop command = " + cmd);
                this.si.runScript(cmd);
                return;
            }
        }
        JSVLogger.debug("browsing supported flavours to find something useful...");
        DataFlavor[] df = t.getTransferDataFlavors();
        if (df == null || df.length == 0) {
            return;
        }
        int i = 0;
        while (i < df.length) {
            DataFlavor flavor = df[i];
            Object o = null;
            JSVLogger.info("df " + i + " flavor " + flavor);
            JSVLogger.info("  class: " + flavor.getRepresentationClass().getName());
            JSVLogger.info("  mime : " + flavor.getMimeType());
            if (flavor.getMimeType().startsWith("text/uri-list") && flavor.getRepresentationClass().getName().equals("java.lang.String")) {
                try {
                    if (!isAccepted) {
                        dtde.acceptDrop(3);
                    }
                    isAccepted = true;
                    o = t.getTransferData(flavor);
                }
                catch (Exception e) {
                    JSVLogger.error(null, e);
                }
                if (o instanceof String) {
                    dtde.getDropTargetContext().dropComplete(true);
                    if (JSVLogger.debugging) {
                        JSVLogger.debug("  String: " + o.toString());
                    }
                    fileToLoad = o.toString();
                    break;
                }
            } else if (flavor.getMimeType().equals("application/x-java-serialized-object; class=java.lang.String")) {
                try {
                    if (!isAccepted) {
                        dtde.acceptDrop(3);
                    }
                    isAccepted = true;
                    o = t.getTransferData(df[i]);
                }
                catch (Exception e) {
                    JSVLogger.error(null, e);
                }
                if (o instanceof String) {
                    String content = (String)o;
                    dtde.getDropTargetContext().dropComplete(true);
                    if (JSVLogger.debugging) {
                        JSVLogger.debug("  String: " + content);
                    }
                    if (content.startsWith("file:/")) {
                        fileToLoad = content;
                        break;
                    }
                }
            }
            ++i;
        }
        if (!isAccepted) {
            dtde.rejectDrop();
        }
        if (fileToLoad != null) {
            cmd = String.valueOf(prefix) + cmd + JSVEscape.escape(fileToLoad) + "\";" + postfix;
            JSVLogger.info("Drop command = " + cmd);
            this.si.runScript(cmd);
        }
    }
}

