/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import jspecview.common.Annotation;
import jspecview.common.AnnotationData;
import jspecview.common.AnnotationDialog;
import jspecview.common.Coordinate;
import jspecview.common.ImageView;
import jspecview.common.Integral;
import jspecview.common.IntegralData;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVPanel;
import jspecview.common.Measurement;
import jspecview.common.MeasurementData;
import jspecview.common.PanelData;
import jspecview.common.Parameters;
import jspecview.common.PeakData;
import jspecview.common.PeakInfo;
import jspecview.common.PeakPickEvent;
import jspecview.common.PlotWidget;
import jspecview.common.ScaleData;
import jspecview.common.ScriptToken;
import jspecview.common.ViewData;
import jspecview.common.Visible;
import jspecview.common.XYScaleConverter;
import jspecview.util.JSVLogger;
import jspecview.util.JSVParser;
import jspecview.util.JSVTextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GraphSet
implements XYScaleConverter {
    private GraphSet gs2dLinkedX;
    private GraphSet gs2dLinkedY;
    private boolean cur1D2Locked;
    protected List<Highlight> highlights = new ArrayList<Highlight>();
    protected List<JDXSpectrum> spectra = new ArrayList<JDXSpectrum>(2);
    private boolean isSplittable = true;
    private boolean allowStacking = true;
    private int[] splitPointers = new int[1];
    private List<Annotation> annotations;
    private MeasurementData selectedSpectrumMeasurements;
    private MeasurementData selectedSpectrumIntegrals;
    private Annotation lastAnnotation;
    private Measurement pendingMeasurement;
    private Integral pendingIntegral;
    private List<JDXSpectrum> graphsTemp = new ArrayList<JDXSpectrum>();
    private PlotWidget[] widgets;
    private boolean isLinked;
    static final double RT2 = Math.sqrt(2.0);
    private boolean haveSingleYScale;
    private int iSpectrumMovedTo;
    private int iSpectrumClicked;
    private int iSpectrumSelected = -1;
    private boolean stackSelected = false;
    private BitSet bsSelected = new BitSet();
    ViewData viewData;
    boolean reversePlot;
    int nSplit = 1;
    int yStackOffsetPercent = 0;
    boolean showAllStacked = true;
    protected List<ViewData> viewList;
    protected ImageView imageView;
    protected PanelData pd;
    protected boolean sticky2Dcursor;
    protected int nSpectra;
    private double fracX = 1.0;
    private double fracY = 1.0;
    private double fX0 = 0.0;
    private double fY0 = 0.0;
    private PlotWidget zoomBox1D;
    private PlotWidget zoomBox2D;
    private PlotWidget pin1Dx0;
    private PlotWidget pin1Dx1;
    private PlotWidget pin1Dy0;
    private PlotWidget pin1Dy1;
    private PlotWidget pin1Dx01;
    private PlotWidget pin1Dy01;
    private PlotWidget pin2Dx0;
    private PlotWidget pin2Dx1;
    private PlotWidget pin2Dy0;
    private PlotWidget pin2Dy1;
    private PlotWidget pin2Dx01;
    private PlotWidget pin2Dy01;
    private PlotWidget cur2Dx0;
    private PlotWidget cur2Dx1;
    private PlotWidget cur1D2x1;
    private PlotWidget cur1D2x2;
    private PlotWidget cur2Dy;
    private int xPixel0;
    private int yPixel0;
    private int xPixel1;
    private int yPixel1;
    private int xVArrows;
    private int xHArrows;
    private int yHArrows;
    private int xPixel00;
    private int yPixel00;
    private int xPixel11;
    private int yPixel11;
    private int yPixel000;
    private int xPixels;
    private int yPixels;
    private int xPixel10;
    private int xPixels0;
    private boolean allowStackedYScale = true;
    private boolean drawXAxisLeftToRight;
    private boolean xAxisLeftToRight = true;
    private int iPreviousSpectrumClicked = -1;
    private boolean haveSelectedSpectrum;
    private boolean zoomEnabled;
    private int currentZoomIndex;
    private double lastClickX = Double.NaN;
    private int lastPixelX = Integer.MAX_VALUE;
    private int height;
    private int width;
    private int right;
    private int top;
    private int left;
    private int bottom;
    private PeakInfo piMouseOver;
    private final Coordinate coordTemp = new Coordinate();
    private static final int minNumOfPointsForZoom = 3;
    private final int FONT_PLAIN = 0;
    private final int FONT_BOLD = 1;
    private final int FONT_ITALIC = 2;
    private boolean is2DSpectrum;
    private Measurement selectedMeasurement;
    private Integral selectedIntegral;
    private double lastXMax = Double.NaN;
    private int lastSpecClicked = -1;
    private static final int MIN_DRAG_PIXELS = 5;
    private boolean inPlotMove;
    private int xPixelMovedTo = -1;
    private int xPixelMovedTo2 = -1;
    private double yValueMovedTo;
    private double xValueMovedTo;
    private boolean haveLeftRightArrows;
    private int xPixelPlot1;
    private int xPixelPlot0;
    private int yPixelPlot0;
    private int yPixelPlot1;
    private boolean nextClickForSetPeak;
    Map<Double, String> mapX = new Hashtable<Double, String>();
    private static final int ONLINE_CUTOFF = 2;
    private boolean triggered = true;
    private Map<String, AnnotationData> dialogs;
    private Object[] aIntegrationRatios;

    GraphSet() {
    }

    protected abstract void disposeImage();

    protected abstract void draw2DImage(Object var1);

    protected abstract void drawHandle(Object var1, int var2, int var3, boolean var4);

    protected abstract void drawLine(Object var1, int var2, int var3, int var4, int var5);

    protected abstract void drawRect(Object var1, int var2, int var3, int var4, int var5);

    protected abstract void drawString(Object var1, String var2, int var3, int var4);

    protected abstract void drawTitle(Object var1, int var2, int var3, String var4);

    protected abstract void fillArrow(Object var1, ArrowType var2, int var3, int var4, boolean var5);

    protected abstract void fillBox(Object var1, int var2, int var3, int var4, int var5, ScriptToken var6);

    protected abstract void fillCircle(Object var1, int var2, int var3, boolean var4);

    abstract Annotation getAnnotation(double var1, double var3, String var5, boolean var6, boolean var7, int var8, int var9);

    abstract Annotation getAnnotation(List<String> var1, Annotation var2);

    protected abstract boolean get2DImage();

    protected abstract int getFontHeight(Object var1);

    protected abstract int getStringWidth(Object var1, String var2);

    protected abstract void rotatePlot(Object var1, int var2, int var3, int var4);

    protected abstract void setAnnotationColor(Object var1, Annotation var2, ScriptToken var3);

    protected abstract void setColor(Object var1, ScriptToken var2);

    protected abstract void setCurrentBoxColor(Object var1);

    protected abstract void setPlotColor(Object var1, int var2);

    protected abstract void setColor(Object var1, int var2, int var3, int var4);

    protected abstract void setStrokeBold(Object var1, boolean var2);

    abstract void setPlotColors(Object var1);

    abstract void setPlotColor0(Object var1);

    abstract boolean update2dImage(boolean var1);

    private int setSpectrumMovedTo(int i) {
        this.iSpectrumMovedTo = i;
        return this.iSpectrumMovedTo;
    }

    private void setSpectrumClicked(int i) {
        this.stackSelected = this.showAllStacked;
        if (i < 0 || this.iSpectrumClicked != i) {
            this.lastClickX = Double.NaN;
            this.lastPixelX = Integer.MAX_VALUE;
        }
        this.iSpectrumClicked = this.setSpectrumSelected(this.setSpectrumMovedTo(i));
    }

    int setSpectrumSelected(int i) {
        boolean isNew = i != this.iSpectrumSelected;
        this.iSpectrumSelected = i;
        if (isNew) {
            this.hideAllDialogsExceptCurrent();
            this.getCurrentView();
        }
        return this.iSpectrumSelected;
    }

    void closeDialogsExcept(Annotation.AType type) {
        if (this.dialogs != null) {
            for (Map.Entry<String, AnnotationData> e : this.dialogs.entrySet()) {
                AnnotationData ad = e.getValue();
                if (!(ad instanceof AnnotationDialog) || type != Annotation.AType.NONE && ad.getAType() == type) continue;
                ((AnnotationDialog)ad).setVisible(false);
            }
        }
    }

    void dispose() {
        this.spectra = null;
        this.viewData = null;
        this.viewList = null;
        this.annotations = null;
        this.lastAnnotation = null;
        this.pendingMeasurement = null;
        this.imageView = null;
        this.graphsTemp = null;
        this.widgets = null;
        this.disposeImage();
        if (this.dialogs != null) {
            for (Map.Entry<String, AnnotationData> e : this.dialogs.entrySet()) {
                AnnotationData ad = e.getValue();
                if (!(ad instanceof AnnotationDialog)) continue;
                ((AnnotationDialog)ad).dispose();
            }
        }
        this.dialogs = null;
    }

    private boolean isDrawNoSpectra() {
        return this.iSpectrumSelected == Integer.MIN_VALUE;
    }

    private int getFixedSelectedSpectrumIndex() {
        return Math.max(this.iSpectrumSelected, 0);
    }

    JDXSpectrum getSpectrum() {
        return this.getSpectrumAt(this.getFixedSelectedSpectrumIndex()).getCurrentSubSpectrum();
    }

    JDXSpectrum getSpectrumAt(int index) {
        return this.spectra.get(index);
    }

    private int getSpectrumIndex(JDXSpectrum spec) {
        int i = this.spectra.size();
        while (--i >= 0) {
            if (this.spectra.get(i) != spec) continue;
            return i;
        }
        return -1;
    }

    private void addSpec(JDXSpectrum spec) {
        this.spectra.add(spec);
        ++this.nSpectra;
    }

    void splitStack(List<GraphSet> graphSets, boolean doSplit) {
        if (doSplit && this.isSplittable) {
            this.nSplit = this.nSpectra;
            this.showAllStacked = false;
            this.setSpectrumClicked(0);
        } else {
            this.nSplit = 1;
            this.splitPointers[0] = 0;
            this.showAllStacked = this.allowStacking && !doSplit;
            this.setSpectrumClicked(-1);
        }
        this.stackSelected = false;
        GraphSet.setFractionalPositions(this.pd, graphSets, PanelData.LinkMode.NONE);
    }

    private void setPositionForFrame(int iSplit) {
        int marginalHeight = this.height - 50;
        this.xPixel00 = (int)((double)this.width * this.fX0);
        this.xPixel11 = (int)((double)this.xPixel00 + (double)this.width * this.fracX - 1.0);
        this.xHArrows = this.xPixel00 + 25;
        this.xVArrows = this.xPixel11 - this.right / 2;
        this.xPixel0 = this.xPixel00 + (int)((double)this.left * (1.0 - this.fX0));
        this.xPixel10 = this.xPixel1 = this.xPixel11 - this.right;
        this.xPixels0 = this.xPixels = this.xPixel1 - this.xPixel0 + 1;
        this.yPixel000 = (this.fY0 == 0.0 ? 25 : 0) + (int)((double)this.height * this.fY0);
        this.yPixel00 = this.yPixel000 + (int)((double)marginalHeight * this.fracY * (double)iSplit);
        this.yPixel11 = this.yPixel00 + (int)((double)marginalHeight * this.fracY) - 1;
        this.yHArrows = this.yPixel11 - 12;
        this.yPixel0 = this.yPixel00 + this.top / 2;
        this.yPixel1 = this.yPixel11 - this.bottom / 2;
        this.yPixels = this.yPixel1 - this.yPixel0 + 1;
        if (this.imageView != null && this.is2DSpectrum) {
            this.setImageWindow();
            if (this.pd.display1D) {
                double widthRatio = this.pd.display1D ? 1.0 * (double)(this.xPixels0 - this.imageView.xPixels) / (double)this.xPixels0 : 1.0;
                this.xPixels = (int)Math.floor(widthRatio * (double)this.xPixels0 * 0.8);
                this.xPixel1 = this.xPixel0 + this.xPixels - 1;
            } else {
                this.xPixels = 0;
                this.xPixel1 = this.imageView.xPixel0 - 30;
            }
        }
    }

    private boolean hasPoint(int xPixel, int yPixel) {
        return xPixel >= this.xPixel00 && xPixel <= this.xPixel11 && yPixel >= this.yPixel000 && yPixel <= this.yPixel11 * this.nSplit;
    }

    private boolean isInPlotRegion(int xPixel, int yPixel) {
        return xPixel >= this.xPixel0 && xPixel <= this.xPixel1 && yPixel >= this.yPixel0 && yPixel <= this.yPixel1;
    }

    int getSplitPoint(int yPixel) {
        return Math.min((yPixel - this.yPixel000) / (this.yPixel11 - this.yPixel00), this.nSplit - 1);
    }

    private boolean isSplitWidget(int xPixel, int yPixel) {
        return this.isSplittable && xPixel >= this.xPixel11 - 20 && yPixel >= this.yPixel00 + 1 && xPixel <= this.xPixel11 - 10 && yPixel <= this.yPixel00 + 11;
    }

    void initGraphSet(int startIndex, int endIndex) {
        this.xAxisLeftToRight = this.getSpectrumAt(0).shouldDisplayXAxisIncreasing();
        this.setDrawXAxis();
        int[] startIndices = new int[this.nSpectra];
        int[] endIndices = new int[this.nSpectra];
        this.bsSelected.set(0, this.nSpectra);
        this.allowStackedYScale = true;
        if (endIndex <= 0) {
            endIndex = Integer.MAX_VALUE;
        }
        this.isSplittable = this.nSpectra > 1;
        this.allowStacking = this.spectra.get(0).isStackable();
        this.showAllStacked = this.allowStacking && this.nSpectra > 1;
        int i = 0;
        while (i < this.nSpectra) {
            int iLast = this.spectra.get(i).getXYCoords().length - 1;
            startIndices[i] = Coordinate.intoRange(startIndex, 0, iLast);
            endIndices[i] = Coordinate.intoRange(endIndex, 0, iLast);
            this.allowStackedYScale &= this.spectra.get(i).getYUnits().equals(this.spectra.get(0).getYUnits()) && this.spectra.get(i).getUserYFactor() == this.spectra.get(0).getUserYFactor();
            ++i;
        }
        this.getView(0.0, 0.0, 0.0, 0.0, startIndices, endIndices, null, null);
        this.viewList = new ArrayList<ViewData>();
        this.viewList.add(this.viewData);
    }

    private synchronized void getView(double x1, double x2, double y1, double y2, int[] startIndices, int[] endIndices, ScaleData[] viewScales, ScaleData[] yScales) {
        List<JDXSpectrum> graphs = this.graphsTemp.size() == 0 ? this.spectra : this.graphsTemp;
        List<JDXSpectrum> subspecs = this.getSpectrumAt(0).getSubSpectra();
        boolean dontUseSubspecs = subspecs == null || subspecs.size() == 2 && subspecs.get(1).isImaginary();
        boolean is2D = !this.getSpectrumAt(0).is1D();
        boolean useFirstSubSpecOnly = false;
        if (is2D && useFirstSubSpecOnly || dontUseSubspecs && y1 == y2) {
            graphs = this.spectra;
        } else if (y1 == y2) {
            this.viewData = new ViewData(subspecs, y1, y2, this.getSpectrum().isContinuous());
            graphs = null;
        }
        if (graphs != null) {
            this.viewData = new ViewData(graphs, y1, y2, startIndices, endIndices, this.getSpectrumAt(0).isContinuous(), is2D);
            if (x1 != x2) {
                this.getScale().setXRange(x1, x2);
            }
        }
        if (viewScales != null) {
            ScaleData.copyScaleFactors(viewScales, this.viewData.getScaleData());
            if (yScales != null) {
                ScaleData.copyYScales(yScales, this.viewData.getScaleData());
            }
            this.getCurrentView();
        }
    }

    private boolean isNearby(Coordinate a1, Coordinate a2, XYScaleConverter c, int range) {
        double x = a1.getXVal();
        int xp1 = c.toPixelX(x);
        int yp1 = this.toPixelY(a1.getYVal());
        x = a2.getXVal();
        int xp2 = c.toPixelX(x);
        int yp2 = this.toPixelY(a2.getYVal());
        return Math.abs(xp1 - xp2) + Math.abs(yp1 - yp2) < range;
    }

    void setReversePlot(boolean val) {
        this.reversePlot = val;
        if (this.reversePlot) {
            this.closeDialogsExcept(Annotation.AType.NONE);
        }
        this.setDrawXAxis();
    }

    private void setDrawXAxis() {
        this.drawXAxisLeftToRight = this.xAxisLeftToRight ^ this.reversePlot;
        int i = 0;
        while (i < this.spectra.size()) {
            this.spectra.get(i).setExportXAxisDirection(this.drawXAxisLeftToRight);
            ++i;
        }
    }

    @Override
    public int fixX(int xPixel) {
        return Coordinate.intoRange(xPixel, this.xPixel0, this.xPixel1);
    }

    private boolean isInTopBar(int xPixel, int yPixel) {
        return xPixel == this.fixX(xPixel) && yPixel > this.pin1Dx0.yPixel0 - 2 && yPixel < this.pin1Dx0.yPixel1;
    }

    private boolean isInTopBar2D(int xPixel, int yPixel) {
        return this.imageView != null && xPixel == this.imageView.fixX(xPixel) && yPixel > this.pin2Dx0.yPixel0 - 2 && yPixel < this.pin2Dx0.yPixel1;
    }

    private boolean isInRightBar(int xPixel, int yPixel) {
        return yPixel == this.fixY(yPixel) && xPixel > this.pin1Dy0.xPixel1 && xPixel < this.pin1Dy0.xPixel0 + 2;
    }

    private boolean isInRightBar2D(int xPixel, int yPixel) {
        return this.imageView != null && yPixel == this.fixY(yPixel) && xPixel > this.pin2Dy0.xPixel1 && xPixel < this.pin2Dy0.xPixel0 + 2;
    }

    @Override
    public ScaleData getScale() {
        return this.viewData.getScale();
    }

    @Override
    public int getXPixels() {
        return this.xPixels;
    }

    @Override
    public int getXPixel0() {
        return this.xPixel0;
    }

    @Override
    public int getYPixels() {
        return this.yPixels;
    }

    @Override
    public double toX(int xPixel) {
        if (this.imageView != null && this.imageView.isXWithinRange(xPixel)) {
            return this.imageView.toX(xPixel);
        }
        return this.getScale().toX(this.fixX(xPixel), this.xPixel1, this.drawXAxisLeftToRight);
    }

    private double toX0(int xPixel) {
        return this.viewList.get(0).getScale().toX0(this.fixX(xPixel), this.xPixel0, this.xPixel1, this.drawXAxisLeftToRight);
    }

    @Override
    public int toPixelX(double dx) {
        return this.getScale().toPixelX(dx, this.xPixel0, this.xPixel1, this.drawXAxisLeftToRight);
    }

    private int toPixelX0(double x) {
        return this.viewList.get(0).getScale().toPixelX0(x, this.xPixel0, this.xPixel1, this.drawXAxisLeftToRight);
    }

    @Override
    public double toY(int yPixel) {
        return this.getScale().toY(yPixel, this.yPixel0);
    }

    @Override
    public int toPixelY(double yVal) {
        return this.getScale().toPixelY(yVal, this.yPixel1);
    }

    private double toY0(int yPixel) {
        return this.viewList.get(0).getScale().toY0(this.fixY(yPixel), this.yPixel0, this.yPixel1);
    }

    private int toPixelY0(double y) {
        return this.fixY(this.viewList.get(0).getScale().toPixelY0(y, this.yPixel0, this.yPixel1));
    }

    @Override
    public int fixY(int yPixel) {
        return Coordinate.intoRange(yPixel, this.yPixel0, this.yPixel1);
    }

    private int toPixelYint(double yVal) {
        return this.yPixel1 - (int)(Double.isNaN(yVal) ? -2.147483648E9 : (double)this.yPixels * yVal);
    }

    private Annotation findAnnotation2D(Coordinate xy) {
        int i = this.annotations.size();
        while (--i >= 0) {
            Annotation a = this.annotations.get(i);
            if (!this.isNearby(a, xy, this.imageView, 10)) continue;
            return a;
        }
        return null;
    }

    private void addAnnotation(Annotation annotation, boolean isToggle) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<Annotation>();
        }
        boolean removed = false;
        int i = this.annotations.size();
        while (--i >= 0) {
            if (!(annotation.is2D ? this.isNearby(this.annotations.get(i), annotation, this.imageView, 10) : annotation.equals(this.annotations.get(i)))) continue;
            removed = true;
            this.annotations.remove(i);
        }
        if (!(annotation.getText().length() <= 0 || removed && isToggle)) {
            this.annotations.add(annotation);
        }
    }

    protected void setImageWindow() {
        this.imageView.setPixelWidthHeight((int)((this.pd.display1D ? 0.6 : 1.0) * (double)this.xPixels0), this.yPixels);
        this.imageView.setXY0(this.getSpectrumAt(0), (int)Math.floor(this.xPixel10 - this.imageView.xPixels), this.yPixel0);
    }

    private boolean findNearestMaxMin() {
        if (this.nSpectra > 1 && this.iSpectrumClicked < 0) {
            return false;
        }
        this.xValueMovedTo = this.getSpectrum().findXForPeakNearest(this.xValueMovedTo);
        this.setXPixelMovedTo(this.xValueMovedTo, Double.MAX_VALUE, 0, 0);
        return true;
    }

    void setXPixelMovedTo(double x1, double x2, int xPixel1, int xPixel2) {
        if (x1 == Double.MAX_VALUE && x2 == Double.MAX_VALUE) {
            this.xPixelMovedTo = xPixel1;
            this.xPixelMovedTo2 = xPixel2;
            if (this.isLinked && this.sticky2Dcursor) {
                this.pd.setlinkedXMove(this, this.toX(this.xPixelMovedTo), false);
            }
            return;
        }
        if (x1 != Double.MAX_VALUE) {
            this.xPixelMovedTo = this.toPixelX(x1);
            if (this.fixX(this.xPixelMovedTo) != this.xPixelMovedTo) {
                this.xPixelMovedTo = -1;
            }
            this.xPixelMovedTo2 = -1;
            if (x1 != 1.0E10) {
                this.setSpectrumClicked(this.getFixedSelectedSpectrumIndex());
            }
        }
        if (x2 != Double.MAX_VALUE) {
            this.xPixelMovedTo2 = this.toPixelX(x2);
        }
    }

    private void processPendingMeasurement(int xPixel, int yPixel, int clickCount) {
        if (!this.isInPlotRegion(xPixel, yPixel)) {
            this.pendingMeasurement = null;
            return;
        }
        double x = this.toX(xPixel);
        double y = this.toY(yPixel);
        double x0 = x;
        switch (clickCount) {
            case 0: {
                this.pendingMeasurement.setPt2(this.toX(xPixel), this.toY(yPixel));
                break;
            }
            case 2: 
            case 3: {
                JDXSpectrum spec = this.spectra.get(this.iSpectrumClicked);
                this.setScale(this.iSpectrumClicked);
                if (clickCount != 3) {
                    Measurement m = this.findMeasurement(this.selectedSpectrumMeasurements, xPixel, yPixel, 1);
                    if (m != null) {
                        x = m.getXVal();
                        y = m.getYVal();
                    } else {
                        m = this.findMeasurement(this.selectedSpectrumMeasurements, xPixel, yPixel, 2);
                        if (m != null) {
                            x = m.getXVal2();
                            y = m.getYVal2();
                        } else {
                            x = this.getNearestPeak(spec, x, y);
                        }
                    }
                }
                this.pendingMeasurement = new Measurement(spec, x, y);
                this.pendingMeasurement.setPt2(x0, y);
                break;
            }
            case -3: 
            case -2: 
            case 1: {
                this.setScale(this.getSpectrumIndex(this.pendingMeasurement.spec));
                if (clickCount != 3 && this.findNearestMaxMin()) {
                    xPixel = this.xPixelMovedTo;
                }
                x = this.toX(xPixel);
                y = this.toY(yPixel);
                this.pendingMeasurement.setPt2(x, y);
                if (this.pendingMeasurement.text.length() == 0) {
                    this.pendingMeasurement = null;
                    break;
                }
                this.setMeasurement(this.pendingMeasurement);
                if (clickCount == 1) {
                    this.setSpectrumClicked(this.getSpectrumIndex(this.pendingMeasurement.spec));
                    this.pendingMeasurement = new Measurement(this.pendingMeasurement.spec, x, y);
                    break;
                }
                this.pendingMeasurement = null;
                break;
            }
            case 5: {
                if (this.findNearestMaxMin()) {
                    int iSpec = this.getFixedSelectedSpectrumIndex();
                    if (Double.isNaN(this.lastXMax) || this.lastSpecClicked != iSpec || this.pendingMeasurement == null) {
                        this.lastXMax = this.xValueMovedTo;
                        this.lastSpecClicked = iSpec;
                        this.pendingMeasurement = new Measurement(this.spectra.get(iSpec), this.xValueMovedTo, this.yValueMovedTo);
                        break;
                    }
                    this.pendingMeasurement.setPt2(this.xValueMovedTo, this.yValueMovedTo);
                    if (this.pendingMeasurement.text.length() > 0) {
                        this.setMeasurement(this.pendingMeasurement);
                    }
                    this.pendingMeasurement = null;
                    this.lastXMax = Double.NaN;
                    break;
                }
                this.lastXMax = Double.NaN;
            }
        }
    }

    private boolean checkIntegralNormalizationClick(int xPixel, int yPixel) {
        if (this.selectedSpectrumIntegrals == null) {
            return false;
        }
        Integral integral = (Integral)this.findMeasurement(this.selectedSpectrumIntegrals, xPixel, yPixel, -5);
        if (integral == null) {
            return false;
        }
        this.selectedIntegral = integral;
        this.pd.normalizeIntegral();
        this.updateDialog(Annotation.AType.Integration, -1);
        this.setSpectrumClicked(this.getSpectrumIndex(integral.spec));
        return true;
    }

    private double getNearestPeak(JDXSpectrum spec, double x, double y) {
        double x0 = Coordinate.getNearestXWithYAbove(spec.getXYCoords(), x, y, spec.isInverted(), false);
        double x1 = Coordinate.getNearestXWithYAbove(spec.getXYCoords(), x, y, spec.isInverted(), true);
        return Double.isNaN(x0) ? x1 : (Double.isNaN(x1) ? x0 : (Math.abs(x0 - x) < Math.abs(x1 - x) ? x0 : x1));
    }

    private Measurement findMeasurement(MeasurementData measurements, int xPixel, int yPixel, int iPt) {
        if (measurements == null || measurements.size() == 0) {
            return null;
        }
        if (iPt == 0) {
            Measurement m = this.findMeasurement(measurements, xPixel, yPixel, -1);
            if (m != null || measurements.get(0) instanceof Integral) {
                return m;
            }
            return this.findMeasurement(measurements, xPixel, yPixel, -2);
        }
        int i = measurements.size();
        block5: while (--i >= 0) {
            int y2;
            int y1;
            int x1;
            int x2;
            Measurement m = (Measurement)measurements.get(i);
            if (m instanceof Integral) {
                x1 = x2 = this.toPixelX(m.getXVal2());
                y1 = this.toPixelYint(m.getYVal());
                y2 = this.toPixelYint(m.getYVal2());
            } else {
                x1 = this.toPixelX(m.getXVal());
                x2 = this.toPixelX(m.getXVal2());
                y2 = iPt == -2 ? this.yPixel1 - 2 : this.toPixelY(m.getYVal());
                y1 = y2;
            }
            switch (iPt) {
                case 1: {
                    if (Math.abs(xPixel - x1) + Math.abs(yPixel - y1) >= 4) continue block5;
                    return m;
                }
                case 2: {
                    if (Math.abs(xPixel - x2) + Math.abs(yPixel - y2) >= 4) continue block5;
                    return m;
                }
                case -5: {
                    y1 = y2 = (y1 + y2) / 2;
                    x2 = x1 + 20;
                }
                default: {
                    if (!GraphSet.isOnLine(xPixel, yPixel, x1, y1, x2, y2)) continue block5;
                    return m;
                }
            }
        }
        return null;
    }

    private void setMeasurement(Measurement m) {
        int iSpec = this.getSpectrumIndex(m.spec);
        AnnotationData ad = this.getDialog(Annotation.AType.Measurements, iSpec);
        if (ad == null) {
            ad = new MeasurementData(Annotation.AType.Measurements, m.spec);
            this.addDialog(iSpec, Annotation.AType.Measurements, ad);
        }
        ad.getData().add(new Measurement(m));
        this.updateDialog(Annotation.AType.Measurements, -1);
    }

    private boolean checkArrowUpDownClick(int xPixel, int yPixel) {
        double f;
        boolean ok = false;
        double d = this.isArrowClick(xPixel, yPixel, ArrowType.UP) ? RT2 : (f = this.isArrowClick(xPixel, yPixel, ArrowType.DOWN) ? 1.0 / RT2 : 0.0);
        if (f != 0.0) {
            if (this.nSplit > 1) {
                this.setSpectrumSelected(this.iSpectrumMovedTo);
            }
            if ((this.nSpectra == 1 || this.iSpectrumSelected >= 0) && this.spectra.get(this.getFixedSelectedSpectrumIndex()).isTransmittance()) {
                f = 1.0 / f;
            }
            this.viewData.scaleSpectrum(this.imageView == null ? this.iSpectrumSelected : -2, f);
            ok = true;
        } else if (this.isArrowClick(xPixel, yPixel, ArrowType.RESET)) {
            this.clearViews();
            if (this.showAllStacked && !this.stackSelected) {
                this.closeDialogsExcept(Annotation.AType.NONE);
            }
            this.viewData.resetScaleFactors();
            this.updateDialogs();
            ok = true;
        }
        if (ok && this.imageView != null) {
            this.update2dImage(false);
            this.resetPinsFromView();
        }
        return ok;
    }

    private boolean checkArrowLeftRightClick(int xPixel, int yPixel) {
        if (this.haveLeftRightArrows) {
            int dx;
            int n = this.isArrowClick(xPixel, yPixel, ArrowType.LEFT) ? -1 : (dx = this.isArrowClick(xPixel, yPixel, ArrowType.RIGHT) ? 1 : 0);
            if (dx != 0) {
                this.setSpectrumClicked((this.iSpectrumSelected + dx) % this.nSpectra);
                return true;
            }
            if (this.isArrowClick(xPixel, yPixel, ArrowType.HOME)) {
                if (this.showAllStacked) {
                    this.showAllStacked = false;
                    this.setSpectrumClicked(this.getFixedSelectedSpectrumIndex());
                } else {
                    this.showAllStacked = this.allowStacking;
                    this.setSpectrumSelected(-1);
                    this.stackSelected = false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean isArrowClick(int xPixel, int yPixel, ArrowType type) {
        switch (type) {
            case UP: 
            case DOWN: 
            case RESET: {
                int pt = (this.yPixel00 + this.yPixel11) / 2 + (type == ArrowType.UP ? -1 : (type == ArrowType.DOWN ? 1 : 0)) * 15;
                return Math.abs(this.xVArrows - xPixel) < 10 && Math.abs(pt - yPixel) < 10;
            }
            case LEFT: 
            case RIGHT: 
            case HOME: {
                int pt = this.xHArrows + (type == ArrowType.LEFT ? -1 : (type == ArrowType.RIGHT ? 1 : 0)) * 15;
                return Math.abs(pt - xPixel) < 10 && Math.abs(this.yHArrows - yPixel) < 10;
            }
        }
        return false;
    }

    private void setWidgetValueByUser(PlotWidget pw) {
        String sval = pw == this.cur2Dy ? "" + this.imageView.toSubspectrumIndex(pw.yPixel0) : (pw == this.pin1Dx01 ? Math.min(this.pin1Dx0.getXVal(), this.pin1Dx1.getXVal()) + " - " + Math.max(this.pin1Dx0.getXVal(), this.pin1Dx1.getXVal()) : (pw == this.pin1Dy01 ? Math.min(this.pin1Dy0.getYVal(), this.pin1Dy1.getYVal()) + " - " + Math.max(this.pin1Dy0.getYVal(), this.pin1Dy1.getYVal()) : (pw == this.pin2Dx01 ? Math.min(this.pin2Dx0.getXVal(), this.pin2Dx1.getXVal()) + " - " + Math.max(this.pin2Dx0.getXVal(), this.pin2Dx1.getXVal()) : (pw == this.pin2Dy01 ? (int)Math.min(this.pin2Dy0.getYVal(), this.pin2Dy1.getYVal()) + " - " + (int)Math.max(this.pin2Dy0.getYVal(), this.pin2Dy1.getYVal()) : "" + pw.getValue()))));
        if ((sval = this.pd.getInput("New value?", "Set Slider", sval)) == null) {
            return;
        }
        sval = sval.trim();
        try {
            if (pw == this.pin1Dx01 || pw == this.pin1Dy01 || pw == this.pin2Dx01 || pw == this.pin2Dy01) {
                int pt = sval.indexOf("-", 1);
                if (pt < 0) {
                    return;
                }
                double val1 = Double.valueOf(sval.substring(0, pt));
                double val2 = Double.valueOf(sval.substring(pt + 1));
                if (pw == this.pin1Dx01) {
                    this.doZoom(val1, this.pin1Dy0.getYVal(), val2, this.pin1Dy1.getYVal(), true, false, false, true, true);
                } else if (pw == this.pin1Dy01) {
                    this.doZoom(this.pin1Dx0.getXVal(), val1, this.pin1Dx1.getXVal(), val2, this.imageView == null, this.imageView == null, false, false, true);
                } else if (pw == this.pin2Dx01) {
                    this.imageView.setView0(this.imageView.toPixelX0(val1), this.pin2Dy0.yPixel0, this.imageView.toPixelX0(val2), this.pin2Dy1.yPixel0);
                    this.doZoom(val1, this.pin1Dy0.getYVal(), val2, this.pin1Dy1.getYVal(), false, false, false, true, true);
                } else if (pw == this.pin2Dy01) {
                    this.imageView.setView0(this.pin2Dx0.xPixel0, this.imageView.toPixelY0(val1), this.pin2Dx1.xPixel0, this.imageView.toPixelY0(val2));
                    this.doZoom(this.imageView.toX(this.imageView.xPixel0), this.getScale().minY, this.imageView.toX(this.imageView.xPixel0 + this.imageView.xPixels - 1), this.getScale().maxY, false, false, false, false, true);
                }
            } else {
                double val = Double.valueOf(sval);
                if (pw.isXtype) {
                    double val2 = pw == this.pin1Dx0 || pw == this.cur2Dx0 || pw == this.pin2Dx0 ? this.pin1Dx1.getXVal() : this.pin1Dx0.getXVal();
                    this.doZoom(val, 0.0, val2, 0.0, !pw.is2D, false, false, true, true);
                } else if (pw == this.cur2Dy) {
                    this.setCurrentSubSpectrum((int)val);
                } else if (pw == this.pin2Dy0 || pw == this.pin2Dy1) {
                    int val2 = pw == this.pin2Dy0 ? this.pin2Dy1.yPixel0 : this.pin2Dy0.yPixel0;
                    this.imageView.setView0(this.pin2Dx0.xPixel0, this.imageView.toPixelY((int)val), this.pin2Dx1.xPixel0, val2);
                } else {
                    double val2 = pw == this.pin1Dy0 ? this.pin1Dy1.getYVal() : this.pin1Dy0.getYVal();
                    this.doZoom(this.pin1Dx0.getXVal(), val, this.pin1Dx1.getXVal(), val2, this.imageView == null, this.imageView == null, false, false, true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeAllHighlights(JDXSpectrum spec) {
        if (spec == null) {
            this.highlights.clear();
        } else {
            int i = this.highlights.size();
            while (--i >= 0) {
                if (this.highlights.get((int)i).spectrum != spec) continue;
                this.highlights.remove(i);
            }
        }
    }

    private Coordinate setCoordClicked(int xPixel, double x, double y) {
        if (y == 0.0) {
            this.nextClickForSetPeak = false;
        }
        if (Double.isNaN(x)) {
            this.pd.coordClicked = null;
            this.pd.coordsClicked = null;
            return null;
        }
        this.lastClickX = x;
        this.pd.coordClicked = new Coordinate(this.lastClickX, y);
        this.pd.coordsClicked = this.getSpectrum().getXYCoords();
        this.pd.xPixelClicked = this.lastPixelX = xPixel;
        return this.pd.coordClicked;
    }

    private void setWidgets(boolean needNewPins, int subIndex, boolean doDraw1DObjects) {
        if (needNewPins || this.pin1Dx0 == null) {
            if (this.zoomBox1D == null) {
                this.newPins();
            } else {
                this.resetPinPositions();
            }
        }
        this.setDerivedPins(subIndex);
        this.setPinSliderPositions(doDraw1DObjects);
    }

    private void newPins() {
        this.zoomBox1D = new PlotWidget("zoomBox1D");
        this.pin1Dx0 = new PlotWidget("pin1Dx0");
        this.pin1Dx1 = new PlotWidget("pin1Dx1");
        this.pin1Dy0 = new PlotWidget("pin1Dy0");
        this.pin1Dy1 = new PlotWidget("pin1Dy1");
        this.pin1Dx01 = new PlotWidget("pin1Dx01");
        this.pin1Dy01 = new PlotWidget("pin1Dy01");
        this.cur1D2x1 = new PlotWidget("cur1D2x1");
        this.cur1D2x1.color = ScriptToken.PEAKTABCOLOR;
        this.cur1D2x2 = new PlotWidget("cur1D2x2");
        this.cur1D2x2.color = ScriptToken.PEAKTABCOLOR;
        if (this.imageView != null) {
            this.zoomBox2D = new PlotWidget("zoomBox2D");
            this.pin2Dx0 = new PlotWidget("pin2Dx0");
            this.pin2Dx1 = new PlotWidget("pin2Dx1");
            this.pin2Dy0 = new PlotWidget("pin2Dy0");
            this.pin2Dy1 = new PlotWidget("pin2Dy1");
            this.pin2Dx01 = new PlotWidget("pin2Dx01");
            this.pin2Dy01 = new PlotWidget("pin2Dy01");
            this.cur2Dx0 = new PlotWidget("cur2Dx0");
            this.cur2Dx1 = new PlotWidget("cur2Dx1");
            this.cur2Dy = new PlotWidget("cur2Dy");
            this.pin2Dy0.setY(0.0, this.imageView.toPixelY0(0.0));
            int n = this.getSpectrumAt(0).getSubSpectra().size();
            this.pin2Dy1.setY(n, this.imageView.toPixelY0(n));
        }
        this.setWidgetX(this.pin1Dx0, this.getScale().minX);
        this.setWidgetX(this.pin1Dx1, this.getScale().maxX);
        this.setWidgetY(this.pin1Dy0, this.getScale().minY);
        this.setWidgetY(this.pin1Dy1, this.getScale().maxY);
        this.widgets = new PlotWidget[]{this.zoomBox1D, this.zoomBox2D, this.pin1Dx0, this.pin1Dx01, this.pin1Dx1, this.pin1Dy0, this.pin1Dy01, this.pin1Dy1, this.pin2Dx0, this.pin2Dx01, this.pin2Dx1, this.pin2Dy0, this.pin2Dy01, this.pin2Dy1, this.cur2Dx0, this.cur2Dx1, this.cur2Dy, this.cur1D2x1, this.cur1D2x2};
    }

    private void setWidgetX(PlotWidget pw, double x) {
        pw.setX(x, this.toPixelX0(x));
    }

    private void setWidgetY(PlotWidget pw, double y) {
        pw.setY(y, this.toPixelY0(y));
    }

    private void resetPinsFromView() {
        if (this.pin1Dx0 == null) {
            return;
        }
        this.setWidgetX(this.pin1Dx0, this.getScale().minXOnScale);
        this.setWidgetX(this.pin1Dx1, this.getScale().maxXOnScale);
        this.setWidgetY(this.pin1Dy0, this.getScale().minYOnScale);
        this.setWidgetY(this.pin1Dy1, this.getScale().maxYOnScale);
    }

    private void resetPinPositions() {
        this.resetX(this.pin1Dx0);
        this.resetY(this.pin1Dy0);
        this.resetY(this.pin1Dy1);
        if (this.imageView == null) {
            if (this.gs2dLinkedX != null) {
                this.resetX(this.cur1D2x1);
            }
            if (this.gs2dLinkedY != null) {
                this.resetX(this.cur1D2x2);
            }
        } else {
            this.pin2Dy0.setY(this.pin2Dy0.getYVal(), this.imageView.toPixelY0(this.pin2Dy0.getYVal()));
            this.pin2Dy1.setY(this.pin2Dy1.getYVal(), this.imageView.toPixelY0(this.pin2Dy1.getYVal()));
        }
    }

    private void resetX(PlotWidget p) {
        this.setWidgetX(p, p.getXVal());
    }

    private void resetY(PlotWidget p) {
        this.setWidgetY(p, p.getYVal());
    }

    private void setPinSliderPositions(boolean doDraw1DObjects) {
        this.pin1Dx1.yPixel0 = this.pin1Dx01.yPixel0 = this.yPixel0 - 5;
        this.pin1Dx0.yPixel0 = this.pin1Dx01.yPixel0;
        this.pin1Dx1.yPixel1 = this.pin1Dx01.yPixel1 = this.yPixel0;
        this.pin1Dx0.yPixel1 = this.pin1Dx01.yPixel1;
        this.cur1D2x1.yPixel1 = this.cur1D2x2.yPixel1 = this.yPixel0 - 5;
        this.cur1D2x1.yPixel0 = this.cur1D2x2.yPixel0 = this.yPixel1 + 6;
        if (this.imageView == null) {
            this.pin1Dy1.xPixel0 = this.pin1Dy01.xPixel0 = this.xPixel1 + 5;
            this.pin1Dy0.xPixel0 = this.pin1Dy01.xPixel0;
            this.pin1Dy1.xPixel1 = this.pin1Dy01.xPixel1 = this.xPixel1;
            this.pin1Dy0.xPixel1 = this.pin1Dy01.xPixel1;
        } else {
            this.pin1Dy1.xPixel0 = this.pin1Dy01.xPixel0 = this.imageView.xPixel1 + 15;
            this.pin1Dy0.xPixel0 = this.pin1Dy01.xPixel0;
            this.pin1Dy1.xPixel1 = this.pin1Dy01.xPixel1 = this.imageView.xPixel1 + 10;
            this.pin1Dy0.xPixel1 = this.pin1Dy01.xPixel1;
            this.pin2Dx1.yPixel0 = this.pin2Dx01.yPixel0 = this.yPixel0 - 5;
            this.pin2Dx0.yPixel0 = this.pin2Dx01.yPixel0;
            this.pin2Dx1.yPixel1 = this.pin2Dx01.yPixel1 = this.yPixel0;
            this.pin2Dx0.yPixel1 = this.pin2Dx01.yPixel1;
            this.pin2Dy1.xPixel0 = this.pin2Dy01.xPixel0 = this.imageView.xPixel1 + 5;
            this.pin2Dy0.xPixel0 = this.pin2Dy01.xPixel0;
            this.pin2Dy1.xPixel1 = this.pin2Dy01.xPixel1 = this.imageView.xPixel1;
            this.pin2Dy0.xPixel1 = this.pin2Dy01.xPixel1;
            this.cur2Dx0.yPixel0 = this.cur2Dx1.yPixel0 = this.yPixel1 + 6;
            this.cur2Dx0.yPixel1 = this.cur2Dx1.yPixel1 = this.yPixel0 - 5;
            this.cur2Dx0.yPixel0 = this.cur2Dx1.yPixel0 = this.yPixel1 + 6;
            this.cur2Dx1.yPixel1 = this.cur2Dx1.yPixel1 = this.yPixel0 - 5;
            this.cur2Dy.xPixel0 = doDraw1DObjects ? (this.xPixel1 + this.imageView.xPixel0) / 2 : this.imageView.xPixel0 - 6;
            this.cur2Dy.xPixel1 = this.imageView.xPixel1 + 5;
        }
    }

    private void setDerivedPins(int subIndex) {
        this.triggered = true;
        if (this.gs2dLinkedX != null) {
            this.cur1D2x1.setX(this.cur1D2x1.getXVal(), this.toPixelX(this.cur1D2x1.getXVal()));
        }
        if (this.gs2dLinkedY != null) {
            this.cur1D2x2.setX(this.cur1D2x2.getXVal(), this.toPixelX(this.cur1D2x2.getXVal()));
        }
        this.pin1Dx01.setX(0.0, (this.pin1Dx0.xPixel0 + this.pin1Dx1.xPixel0) / 2);
        this.pin1Dy01.setY(0.0, (this.pin1Dy0.yPixel0 + this.pin1Dy1.yPixel0) / 2);
        this.pin1Dx01.setEnabled(Math.min(this.pin1Dx0.xPixel0, this.pin1Dx1.xPixel0) > this.xPixel0 || Math.max(this.pin1Dx0.xPixel0, this.pin1Dx1.xPixel0) < this.xPixel1);
        this.pin1Dy01.setEnabled(Math.min(this.pin1Dy0.yPixel0, this.pin1Dy1.yPixel0) > Math.min(this.toPixelY(this.getScale().minY), this.toPixelY(this.getScale().maxY)) || Math.max(this.pin1Dy0.yPixel0, this.pin1Dy1.yPixel0) < Math.max(this.toPixelY(this.getScale().minY), this.toPixelY(this.getScale().maxY)));
        if (this.imageView == null) {
            return;
        }
        double x = this.pin1Dx0.getXVal();
        this.cur2Dx0.setX(x, this.imageView.toPixelX(x));
        x = this.pin1Dx1.getXVal();
        this.cur2Dx1.setX(x, this.imageView.toPixelX(x));
        x = this.imageView.toX(this.imageView.xPixel0);
        this.pin2Dx0.setX(x, this.imageView.toPixelX0(x));
        x = this.imageView.toX(this.imageView.xPixel1);
        this.pin2Dx1.setX(x, this.imageView.toPixelX0(x));
        this.pin2Dx01.setX(0.0, (this.pin2Dx0.xPixel0 + this.pin2Dx1.xPixel0) / 2);
        double y = this.imageView.imageHeight - 1 - this.imageView.yView1;
        this.pin2Dy0.setY(y, this.imageView.toPixelY0(y));
        y = this.imageView.imageHeight - 1 - this.imageView.yView2;
        this.pin2Dy1.setY(y, this.imageView.toPixelY0(y));
        this.pin2Dy01.setY(0.0, (this.pin2Dy0.yPixel0 + this.pin2Dy1.yPixel0) / 2);
        this.cur2Dy.yPixel0 = this.cur2Dy.yPixel1 = this.imageView.toPixelY(subIndex);
        this.pin2Dx01.setEnabled(Math.min(this.pin2Dx0.xPixel0, this.pin2Dx1.xPixel0) != this.imageView.xPixel0 || Math.max(this.pin2Dx0.xPixel0, this.pin2Dx1.xPixel1) != this.imageView.xPixel1);
        this.pin2Dy01.setEnabled(Math.min(this.pin2Dy0.yPixel0, this.pin2Dy1.yPixel0) != this.yPixel0 || Math.max(this.pin2Dy0.yPixel0, this.pin2Dy1.yPixel1) != this.yPixel1);
    }

    synchronized void doZoom(double initX, double initY, double finalX, double finalY, boolean is1D, boolean is1DY, boolean checkRange, boolean checkLinked, boolean addZoom) {
        double y2;
        double y1;
        boolean isXOnly;
        boolean is2D;
        boolean is2DGrayScaleChange;
        System.out.println("xoZoom " + initX + " " + finalX + " dif=" + (initX - finalX));
        if (initX == finalX) {
            initX = this.getScale().minXOnScale;
            finalX = this.getScale().maxXOnScale;
        } else if (this.isLinked && checkLinked) {
            this.pd.doZoomLinked(this, initX, finalX, addZoom, checkRange, is1D);
        }
        if (initX > finalX) {
            double tempX = initX;
            initX = finalX;
            finalX = tempX;
        }
        if (initY > finalY) {
            double tempY = initY;
            initY = finalY;
            finalY = tempY;
        }
        boolean bl = is2DGrayScaleChange = !is1D && this.imageView != null && (this.imageView.minZ != initY || this.imageView.maxZ != finalY);
        if (!this.zoomEnabled && !is2DGrayScaleChange) {
            return;
        }
        if (checkRange) {
            if (!this.getScale().isInRangeX(initX) && !this.getScale().isInRangeX(finalX)) {
                return;
            }
            if (!this.getScale().isInRangeX(initX)) {
                initX = this.getScale().minX;
            } else if (!this.getScale().isInRangeX(finalX)) {
                finalX = this.getScale().maxX;
            }
        }
        ScaleData[] viewScales = this.viewData.getScaleData();
        int[] startIndices = new int[this.nSpectra];
        int[] endIndices = new int[this.nSpectra];
        this.graphsTemp.clear();
        List<JDXSpectrum> subspecs = this.getSpectrumAt(0).getSubSpectra();
        boolean dontUseSubspecs = subspecs == null || subspecs.size() == 2;
        boolean bl2 = is2D = !this.getSpectrumAt(0).is1D();
        if (!is2D && !dontUseSubspecs) {
            this.graphsTemp.add(this.getSpectrum());
            if (!ScaleData.setDataPointIndices(this.graphsTemp, initX, finalX, 3, startIndices, endIndices)) {
                return;
            }
        } else if (!ScaleData.setDataPointIndices(this.spectra, initX, finalX, 3, startIndices, endIndices)) {
            return;
        }
        boolean bl3 = isXOnly = (y1 = initY) == (y2 = finalY);
        if (isXOnly) {
            double f;
            double d = f = !is2DGrayScaleChange && is1D ? (f = this.getScale().spectrumScaleFactor) : 1.0;
            if (Math.abs(f - 1.0) < 1.0E-4) {
                y1 = this.getScale().minYOnScale;
                y2 = this.getScale().maxYOnScale;
            }
        }
        ScaleData[] yScales = null;
        if (isXOnly || is1DY) {
            this.getCurrentView();
            yScales = this.viewData.getNewScales(this.iSpectrumSelected, isXOnly, y1, y2);
        }
        this.getView(initX, finalX, y1, y2, startIndices, endIndices, viewScales, yScales);
        this.setXPixelMovedTo(1.0E10, Double.MAX_VALUE, 0, 0);
        this.setWidgetX(this.pin1Dx0, initX);
        this.setWidgetX(this.pin1Dx1, finalX);
        this.setWidgetY(this.pin1Dy0, y1);
        this.setWidgetY(this.pin1Dy1, y2);
        if (this.imageView == null) {
            this.updateDialogs();
        } else {
            int isub = this.getSpectrumAt(0).getSubIndex();
            int ifix = this.imageView.fixSubIndex(isub);
            if (ifix != isub) {
                this.setCurrentSubSpectrum(ifix);
            }
            if (is2DGrayScaleChange) {
                this.update2dImage(false);
            }
        }
        if (addZoom) {
            this.addCurrentZoom();
        }
    }

    private void updateDialogs() {
        this.updateDialog(Annotation.AType.PeakList, -1);
        this.updateDialog(Annotation.AType.Measurements, -1);
    }

    private void setCurrentSubSpectrum(int i) {
        JDXSpectrum spec0 = this.getSpectrumAt(0);
        i = spec0.setCurrentSubSpectrum(i);
        if (spec0.isForcedSubset()) {
            this.viewData.setXRangeForSubSpectrum(this.getSpectrum().getXYCoords());
        }
        this.pd.notifySubSpectrumChange(i, this.getSpectrum());
    }

    private void addCurrentZoom() {
        if (this.viewList.size() > this.currentZoomIndex + 1) {
            int i = this.viewList.size() - 1;
            while (i > this.currentZoomIndex) {
                this.viewList.remove(i);
                --i;
            }
        }
        this.viewList.add(this.viewData);
        ++this.currentZoomIndex;
    }

    private void setZoomTo(int i) {
        this.currentZoomIndex = i;
        this.viewData = this.viewList.get(i);
        this.resetPinsFromView();
    }

    void clearViews() {
        if (this.isLinked) {
            this.pd.clearLinkViews(this);
        }
        this.setZoom(0.0, 0.0, 0.0, 0.0);
        int i = this.viewList.size();
        while (--i >= 1) {
            this.viewList.remove(i);
        }
    }

    private void drawAll(Object g, int iSplit, boolean needNewPins) {
        int subIndex = this.getSpectrumAt(0).getSubIndex();
        boolean bl = this.is2DSpectrum = !(this.getSpectrumAt(0).is1D() || !this.isLinked && !this.pd.getBoolean(ScriptToken.DISPLAY2D) || this.imageView == null && !this.get2DImage());
        if (this.imageView != null) {
            if (this.is2DSpectrum) {
                this.setPositionForFrame(iSplit);
            }
            this.draw2DImage(g);
        }
        int iSelected = this.stackSelected || !this.showAllStacked ? this.iSpectrumSelected : -1;
        boolean doYScale = !this.showAllStacked || this.nSpectra == 1 || iSelected >= 0;
        boolean doDraw1DObjects = this.imageView == null || this.pd.display1D;
        int n = iSelected >= 0 ? 1 : 0;
        int iSpectrumForScale = this.getFixedSelectedSpectrumIndex();
        if (doDraw1DObjects) {
            this.fillBox(g, this.xPixel0, this.yPixel0, this.xPixel1, this.yPixel1, ScriptToken.PLOTAREACOLOR);
            if (iSelected < 0) {
                doYScale = true;
                int i = 0;
                while (i < this.nSpectra) {
                    if (this.doPlot(i, iSplit) && n++ != 0) {
                        doYScale &= this.viewData.areYScalesSame(i - 1, i);
                    }
                    ++i;
                }
            }
        }
        int iSpecForFrame = this.nSpectra == 1 ? 0 : (!this.showAllStacked ? this.iSpectrumMovedTo : this.iSpectrumSelected);
        boolean addCurrentBox = !this.isLinked && this.isSplittable && (!this.isSplittable || this.nSplit == 1 || this.pd.currentSplitPoint == iSplit);
        boolean drawUpDownArrows = !(!this.pd.isCurrentGraphSet(this) || !this.zoomEnabled || !this.spectra.get(0).isScalable() || !addCurrentBox && this.nSpectra != 1 || this.nSplit != 1 && this.pd.currentSplitPoint != this.iSpectrumMovedTo || this.isDrawNoSpectra());
        boolean addSplitBox = this.isSplittable;
        this.drawFrame(g, iSpecForFrame, addCurrentBox, addSplitBox, drawUpDownArrows);
        if (this.pd.isCurrentGraphSet(this) && iSplit == this.pd.currentSplitPoint && (n < 2 || this.iSpectrumSelected >= 0)) {
            this.haveSelectedSpectrum = true;
        }
        boolean bl2 = this.showAllStacked && this.nSpectra > 1 ? this.allowStackedYScale && doYScale : (this.haveSingleYScale = true);
        if (doDraw1DObjects) {
            int yOffsetPixels = (int)((float)this.yPixels * ((float)this.yStackOffsetPercent / 100.0f));
            this.haveLeftRightArrows = false;
            int i = 0;
            int offset = 0;
            while (i < this.nSpectra) {
                if (this.doPlot(i, iSplit)) {
                    boolean doDraw1DY;
                    boolean isGrey = this.stackSelected && this.iSpectrumSelected >= 0 && this.iSpectrumSelected != i;
                    IntegralData ig = !this.reversePlot && this.getShowAnnotation(Annotation.AType.Integration, i) && (!this.showAllStacked || this.iSpectrumSelected == i) ? (IntegralData)this.getDialog(Annotation.AType.Integration, i).getData() : null;
                    this.setScale(i);
                    JDXSpectrum spec = this.spectra.get(i);
                    if (this.nSplit > 1) {
                        iSpectrumForScale = i;
                    }
                    boolean doDrawWidgets = !isGrey && (this.nSplit == 1 || this.showAllStacked || this.iSpectrumSelected == iSplit);
                    boolean bl3 = doDraw1DY = doDrawWidgets && this.haveSelectedSpectrum && i == iSpectrumForScale;
                    if (doDrawWidgets) {
                        this.resetPinsFromView();
                        this.drawWidgets(g, subIndex, needNewPins, doDraw1DObjects, doDraw1DY, false);
                    }
                    if (this.haveSingleYScale && i == iSpectrumForScale) {
                        this.drawGrid(g);
                        if (this.pd.isPrinting && this.nSplit > 1) {
                            this.drawSpectrumSource(g, i);
                        }
                    }
                    if (doDrawWidgets) {
                        this.drawWidgets(g, subIndex, false, doDraw1DObjects, doDraw1DY, true);
                    }
                    if (this.haveSingleYScale && !this.isDrawNoSpectra() && i == iSpectrumForScale && (this.nSpectra == 1 || this.iSpectrumSelected >= 0)) {
                        this.drawHighlightsAndPeakTabs(g, i);
                    }
                    if ((n == 1 && this.iSpectrumSelected < 0 || this.iSpectrumSelected == i && this.pd.isCurrentGraphSet(this)) && this.pd.titleOn && !this.pd.titleDrawn) {
                        this.drawTitle(g, this.height, this.width, this.pd.getDrawTitle(this.pd.isPrinting));
                        this.pd.titleDrawn = true;
                    }
                    if (this.haveSingleYScale && i == iSpectrumForScale) {
                        if (this.pd.getBoolean(ScriptToken.YSCALEON)) {
                            this.drawYScale(g, this);
                        }
                        if (this.pd.getBoolean(ScriptToken.YUNITSON)) {
                            this.drawYUnits(g);
                        }
                    }
                    this.drawSpectrum(g, i, offset, isGrey, ig);
                    if ((this.nSplit > 1 ? i == this.iSpectrumMovedTo : this.isLinked || i == iSpectrumForScale) && !this.pd.isPrinting && this.xPixelMovedTo >= 0 && spec.isContinuous()) {
                        this.drawSpectrumPointer(g, spec, ig);
                    }
                    if (this.nSpectra > 1 && this.nSplit == 1 && this.pd.isCurrentGraphSet(this)) {
                        this.haveLeftRightArrows = true;
                        if (!this.pd.isPrinting) {
                            this.setScale(0);
                            iSpecForFrame = this.iSpectrumSelected;
                            if (this.nSpectra != 2) {
                                this.setPlotColor(g, (iSpecForFrame + this.nSpectra - 1) % this.nSpectra);
                                this.fillArrow(g, ArrowType.LEFT, this.yHArrows, this.xHArrows - 9, true);
                                this.setCurrentBoxColor(g);
                                this.fillArrow(g, ArrowType.LEFT, this.yHArrows, this.xHArrows - 9, false);
                            }
                            if (iSpecForFrame >= 0) {
                                this.setPlotColor(g, iSpecForFrame);
                                this.fillCircle(g, this.xHArrows, this.yHArrows, true);
                            }
                            this.setCurrentBoxColor(g);
                            this.fillCircle(g, this.xHArrows, this.yHArrows, false);
                            this.setPlotColor(g, (iSpecForFrame + 1) % this.nSpectra);
                            this.fillArrow(g, ArrowType.RIGHT, this.yHArrows, this.xHArrows + 9, true);
                            this.setCurrentBoxColor(g);
                            this.fillArrow(g, ArrowType.RIGHT, this.yHArrows, this.xHArrows + 9, false);
                        }
                    }
                    offset -= yOffsetPixels;
                }
                ++i;
            }
            if (this.pd.getBoolean(ScriptToken.XSCALEON)) {
                this.drawXScale(g, this);
            }
            if (this.pd.getBoolean(ScriptToken.XUNITSON)) {
                this.drawXUnits(g);
            }
        } else {
            if (this.pd.getBoolean(ScriptToken.XSCALEON)) {
                this.drawXScale(g, this.imageView);
            }
            if (this.pd.getBoolean(ScriptToken.YSCALEON)) {
                this.drawYScale(g, this.imageView);
            }
            if (subIndex >= 0) {
                this.draw2DUnits(g);
            }
            this.drawWidgets(g, subIndex, needNewPins, doDraw1DObjects, true, false);
            this.drawWidgets(g, subIndex, needNewPins, doDraw1DObjects, true, true);
        }
        if (this.annotations != null) {
            this.drawAnnotations(g, this.annotations, null);
        }
    }

    private void drawSpectrumSource(Object g, int i) {
        this.pd.owner.printFilePath(g, this.pd.thisWidth - this.pd.right, this.yPixel0, this.spectra.get(i).getFilePath());
    }

    private boolean doPlot(int i, int iSplit) {
        boolean ok;
        boolean isGrey = this.stackSelected && this.iSpectrumSelected >= 0 && this.iSpectrumSelected != i;
        boolean bl = ok = this.showAllStacked || this.iSpectrumSelected == -1 || this.iSpectrumSelected == i;
        return this.nSplit > 1 ? i == iSplit : ok && (!this.pd.isPrinting || !isGrey);
    }

    private void hideAllDialogsExceptCurrent() {
        AnnotationDialog annotationDialog;
        if (this.dialogs == null) {
            return;
        }
        boolean getInt = false;
        boolean getMeas = false;
        boolean getPeak = false;
        for (Map.Entry<String, AnnotationData> e : this.dialogs.entrySet()) {
            AnnotationData ad = e.getValue();
            if (!this.isVisible(ad)) continue;
            switch (ad.getAType()) {
                case Integration: {
                    getInt = true;
                    break;
                }
                case Measurements: {
                    getMeas = true;
                    break;
                }
                case PeakList: {
                    getPeak = true;
                }
            }
        }
        if (getInt) {
            annotationDialog = this.pd.owner.showDialog(Annotation.AType.Integration);
        }
        if (getMeas) {
            annotationDialog = this.pd.owner.showDialog(Annotation.AType.Measurements);
        }
        if (getPeak) {
            annotationDialog = this.pd.owner.showDialog(Annotation.AType.PeakList);
        }
    }

    private void drawSpectrumPointer(Object g, JDXSpectrum spec, IntegralData ig) {
        this.setColor(g, ScriptToken.PEAKTABCOLOR);
        int iHandle = this.pd.integralShiftMode;
        if (ig != null) {
            if (!(this.pd.ctrlPressed && !this.pd.isIntegralDrag || this.isOnSpectrum(this.pd.mouseX, this.pd.mouseY, -1))) {
                ig = null;
            } else if (iHandle == 0) {
                iHandle = this.getShiftMode(this.pd.mouseX, this.pd.mouseY);
            }
        }
        double y0 = this.yValueMovedTo;
        this.yValueMovedTo = ig == null ? spec.getYValueAt(this.xValueMovedTo) : ig.getPercentYValueAt(this.xValueMovedTo);
        this.setCoordStr(this.xValueMovedTo, this.yValueMovedTo);
        if (iHandle != 0) {
            this.setPlotColor(g, 0);
            int x = iHandle < 0 ? this.xPixelPlot1 : this.xPixelPlot0;
            int y = iHandle < 0 ? this.yPixelPlot0 : this.yPixelPlot1;
            this.drawHandle(g, x, y, false);
            return;
        }
        if (ig != null) {
            this.setStrokeBold(g, true);
        }
        if (Double.isNaN(y0) || this.pendingMeasurement != null) {
            this.drawLine(g, this.xPixelMovedTo, this.yPixel0, this.xPixelMovedTo, this.yPixel1);
            if (this.xPixelMovedTo2 >= 0) {
                this.drawLine(g, this.xPixelMovedTo2, this.yPixel0, this.xPixelMovedTo2, this.yPixel1);
            }
            this.yValueMovedTo = Double.NaN;
        } else {
            int y;
            int n = y = ig == null ? this.toPixelY(this.yValueMovedTo) : this.toPixelYint(this.yValueMovedTo / 100.0);
            if (y == this.fixY(y)) {
                this.drawLine(g, this.xPixelMovedTo, y - 10, this.xPixelMovedTo, y + 10);
            }
        }
        if (ig != null) {
            this.setStrokeBold(g, false);
        }
    }

    private void setScale(int i) {
        this.viewData.setScale(i, this.xPixels, this.yPixels, this.spectra.get(i).isInverted());
    }

    private void draw2DUnits(Object g) {
        String nucleusX = this.getSpectrumAt((int)0).nucleusX;
        String nucleusY = this.getSpectrumAt((int)0).nucleusY;
        this.setColor(g, ScriptToken.PLOTCOLOR);
        this.drawUnits(g, nucleusX, this.imageView.xPixel1 + 5 * this.pd.scalingFactor, this.yPixel1, 1.0, 1.0);
        this.drawUnits(g, nucleusY, this.imageView.xPixel0 - 5 * this.pd.scalingFactor, this.yPixel0, 1.0, 0.0);
    }

    private void drawPeakTabs(Object g, JDXSpectrum spec) {
        ArrayList<PeakInfo> list;
        ArrayList<PeakInfo> arrayList = list = this.nSpectra == 1 || this.iSpectrumSelected >= 0 ? spec.getPeakList() : null;
        if (list != null && list.size() > 0) {
            if (this.piMouseOver != null && this.piMouseOver.spectrum == spec && this.pd.isMouseUp()) {
                this.setColor(g, 240, 240, 240);
                this.drawPeak(g, this.piMouseOver, true);
                spec.setHighlightedPeak(this.piMouseOver);
            } else {
                spec.setHighlightedPeak(null);
            }
            this.setColor(g, ScriptToken.PEAKTABCOLOR);
            int i = list.size();
            while (--i >= 0) {
                this.drawPeak(g, (PeakInfo)list.get(i), false);
            }
        }
    }

    private void drawPeak(Object g, PeakInfo pi, boolean isFull) {
        double xMax;
        if (this.pd.isPrinting) {
            return;
        }
        double xMin = pi.getXMin();
        if (xMin != (xMax = pi.getXMax())) {
            this.drawBar(g, pi, xMin, xMax, null, isFull);
        }
    }

    private void drawWidgets(Object g, int subIndex, boolean needNewPins, boolean doDraw1DObjects, boolean doDraw1DY, boolean postGrid) {
        this.setWidgets(needNewPins, subIndex, doDraw1DObjects);
        if (this.pd.isPrinting && (this.imageView == null ? !this.cur1D2Locked : this.sticky2Dcursor)) {
            return;
        }
        if (!this.pd.isPrinting && !postGrid) {
            if (doDraw1DObjects) {
                this.fillBox(g, this.xPixel0, this.pin1Dx0.yPixel1, this.xPixel1, this.pin1Dx1.yPixel1 + 2, ScriptToken.GRIDCOLOR);
                this.fillBox(g, this.pin1Dx0.xPixel0, this.pin1Dx0.yPixel1, this.pin1Dx1.xPixel0, this.pin1Dx1.yPixel1 + 2, ScriptToken.PLOTCOLOR);
            } else {
                this.fillBox(g, this.imageView.xPixel0, this.pin2Dx0.yPixel1, this.imageView.xPixel1, this.pin2Dx0.yPixel1 + 2, ScriptToken.GRIDCOLOR);
                this.fillBox(g, this.pin2Dx0.xPixel0, this.pin2Dx0.yPixel1, this.pin2Dx1.xPixel0, this.pin2Dx1.yPixel1 + 2, ScriptToken.PLOTCOLOR);
                this.fillBox(g, this.pin2Dy0.xPixel1, this.yPixel1, this.pin2Dy1.xPixel1 + 2, this.yPixel0, ScriptToken.GRIDCOLOR);
                this.fillBox(g, this.pin2Dy0.xPixel1, this.pin2Dy0.yPixel1, this.pin2Dy1.xPixel1 + 2, this.pin2Dy1.yPixel0, ScriptToken.PLOTCOLOR);
            }
            this.fillBox(g, this.pin1Dy0.xPixel1, this.yPixel1, this.pin1Dy1.xPixel1 + 2, this.yPixel0, ScriptToken.GRIDCOLOR);
            if (doDraw1DY) {
                this.fillBox(g, this.pin1Dy0.xPixel1, this.pin1Dy0.yPixel1, this.pin1Dy1.xPixel1 + 2, this.pin1Dy1.yPixel0, ScriptToken.PLOTCOLOR);
            }
        }
        int i = 0;
        while (i < this.widgets.length) {
            block14: {
                boolean isLockedCursor;
                PlotWidget pw;
                block16: {
                    boolean isPin1Dy;
                    block15: {
                        pw = this.widgets[i];
                        if (pw == null || !pw.isPinOrCursor && !this.zoomEnabled) break block14;
                        isLockedCursor = pw == this.cur1D2x1 || pw == this.cur1D2x2 || pw == this.cur2Dx0 || pw == this.cur2Dx1 || pw == this.cur2Dy;
                        if ((pw.isPin || !pw.isPinOrCursor) == postGrid) break block14;
                        if (!pw.is2D) break block15;
                        if (pw != this.cur2Dx0 || doDraw1DObjects) break block16;
                        break block14;
                    }
                    boolean bl = isPin1Dy = pw == this.pin1Dy0 || pw == this.pin1Dy1 || pw == this.pin1Dy01;
                    if ((this.imageView != null && doDraw1DObjects == isPin1Dy || isPin1Dy && !doDraw1DY || pw == this.cur1D2x1 && this.gs2dLinkedX == null || pw == this.cur1D2x2 && this.gs2dLinkedY == null || pw == this.zoomBox1D && (this.pd.isIntegralDrag || this.pd.integralShiftMode != 0)) && (!this.isLinked || this.imageView != null)) break block14;
                }
                if (!this.pd.isPrinting || isLockedCursor) {
                    if (pw.isPinOrCursor) {
                        this.setColor(g, pw.color);
                        this.drawLine(g, pw.xPixel0, pw.yPixel0, pw.xPixel1, pw.yPixel1);
                        pw.isVisible = true;
                        if (pw.isPin) {
                            this.drawHandle(g, pw.xPixel0, pw.yPixel0, !pw.isEnabled);
                        }
                    } else if (pw.xPixel1 != pw.xPixel0) {
                        this.fillBox(g, pw.xPixel0, pw.yPixel0, pw.xPixel1, pw.yPixel1, pw == this.zoomBox1D && this.pd.shiftPressed ? ScriptToken.ZOOMBOXCOLOR2 : ScriptToken.ZOOMBOXCOLOR);
                    }
                }
            }
            ++i;
        }
    }

    private void drawBar(Object g, PeakInfo pi, double startX, double endX, ScriptToken whatColor, boolean isFullHeight) {
        int x2;
        int x1 = this.toPixelX(startX);
        if (x1 > (x2 = this.toPixelX(endX))) {
            int tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        x1 = this.fixX(x1);
        if ((x2 = this.fixX(x2)) - x1 < 3) {
            x1 -= 2;
            x2 += 2;
        }
        if (pi != null) {
            pi.setPixelRange(x1, x2);
        }
        this.fillBox(g, x1, this.yPixel0, x2, this.yPixel0 + (isFullHeight ? this.yPixels : 5), whatColor);
        if (pi != null && !isFullHeight) {
            x1 = (x1 + x2) / 2;
            this.fillBox(g, x1 - 1, this.yPixel0, x1 + 1, this.yPixel0 + 7, whatColor);
        }
    }

    private void drawSpectrum(Object g, int index, int yOffset, boolean isGrey, IntegralData ig) {
        JDXSpectrum spec = this.spectra.get(index);
        this.drawPlot(g, index, spec.getXYCoords(), spec.isContinuous(), yOffset, isGrey, null);
        if (ig != null) {
            if (this.haveIntegralDisplayed(index)) {
                this.drawPlot(g, index, this.getIntegrationGraph(index).getXYCoords(), true, yOffset, false, ig);
            }
            this.drawIntegralValues(g, index, yOffset);
        }
        if (this.getIntegrationRatios(index) != null) {
            this.drawAnnotations(g, this.getIntegrationRatios(index), ScriptToken.INTEGRALPLOTCOLOR);
        }
        if (this.pendingMeasurement != null && this.pendingMeasurement.spec == spec) {
            this.drawMeasurement(g, this.pendingMeasurement);
        }
        this.drawMeasurements(g, index);
    }

    private MeasurementData getMeasurements(Annotation.AType type, int iSpec) {
        AnnotationData ad = this.getDialog(type, iSpec);
        return ad == null || ad.getData().size() == 0 || !ad.getState() ? null : ad.getData();
    }

    private void drawPlot(Object g, int index, Coordinate[] xyCoords, boolean isContinuous, int yOffset, boolean isGrey, IntegralData ig) {
        boolean fillPeaks;
        boolean isIntegral = ig != null;
        BitSet bsDraw = ig == null ? null : ig.getBitSet();
        boolean bl = fillPeaks = !isIntegral && !isGrey && !isIntegral && this.pendingIntegral != null && this.pendingIntegral.spec == this.spectra.get(index);
        int iColor = isGrey ? -2 : (isIntegral ? -1 : (!this.allowStacking ? 0 : index));
        this.setPlotColor(g, iColor);
        boolean plotOn = true;
        int y0 = this.toPixelY(0.0);
        fillPeaks &= y0 == this.fixY(y0);
        int iFirst = this.viewData.getStartingPointIndex(index);
        int iLast = this.viewData.getEndingPointIndex(index);
        if (isContinuous) {
            --iLast;
            int i = iFirst;
            while (i <= iLast) {
                int y1;
                Coordinate point1 = xyCoords[i];
                Coordinate point2 = xyCoords[i + 1];
                int n = y1 = isIntegral ? this.toPixelYint(point1.getYVal()) : this.toPixelY(point1.getYVal());
                if (y1 != Integer.MIN_VALUE) {
                    int y2;
                    int n2 = y2 = isIntegral ? this.toPixelYint(point2.getYVal()) : this.toPixelY(point2.getYVal());
                    if (y2 != Integer.MIN_VALUE) {
                        int x1 = this.toPixelX(point1.getXVal());
                        int x2 = this.toPixelX(point2.getXVal());
                        y1 = this.fixY(yOffset + y1);
                        y2 = this.fixY(yOffset + y2);
                        if (isIntegral) {
                            if (i == iFirst) {
                                this.xPixelPlot1 = x1;
                                this.yPixelPlot0 = y1;
                            }
                            this.xPixelPlot0 = x2;
                            this.yPixelPlot1 = y2;
                        }
                        if (x2 != x1 || y1 != y2) {
                            if (fillPeaks && this.pendingIntegral.overlaps(point1.getXVal(), point2.getXVal())) {
                                this.setColor(g, ScriptToken.INTEGRALPLOTCOLOR);
                                this.drawLine(g, x1, y0, x1, y1);
                                this.setPlotColor(g, iColor);
                            } else if (y1 != y2 || y1 != this.yPixel0 && y1 != this.yPixel1) {
                                if (bsDraw != null && bsDraw.get(i) != plotOn) {
                                    plotOn = bsDraw.get(i);
                                    if (!this.pd.isPrinting && this.pd.integralShiftMode != 0) {
                                        this.setPlotColor(g, 0);
                                    } else if (plotOn) {
                                        this.setColor(g, ScriptToken.INTEGRALPLOTCOLOR);
                                    } else {
                                        this.setPlotColor(g, -3);
                                    }
                                }
                                if (!this.pd.isPrinting || plotOn) {
                                    this.drawLine(g, x1, y1, x2, y2);
                                }
                            }
                        }
                    }
                }
                ++i;
            }
        } else {
            int y;
            int i = iFirst;
            while (i <= iLast) {
                Coordinate point = xyCoords[i];
                int y2 = this.toPixelY(point.getYVal());
                if (y2 != Integer.MIN_VALUE) {
                    int x1 = this.toPixelX(point.getXVal());
                    int y1 = this.toPixelY(Math.max(this.getScale().minYOnScale, 0.0));
                    if ((y1 = this.fixY(yOffset + y1)) != (y2 = this.fixY(yOffset + y2)) || y1 != this.yPixel0 && y1 != this.yPixel1) {
                        this.drawLine(g, x1, y1, x1, y2);
                    }
                }
                ++i;
            }
            if (this.getScale().isYZeroOnScale() && (y = yOffset + this.toPixelY(this.getScale().spectrumYRef)) == this.fixY(y)) {
                this.drawLine(g, this.xPixel1, y, this.xPixel0, y);
            }
        }
    }

    private void drawFrame(Object g, int iSpec, boolean addCurrentBox, boolean addSplitBox, boolean drawUpDownArrows) {
        if (!this.pd.gridOn || this.pd.isPrinting) {
            this.setColor(g, ScriptToken.GRIDCOLOR);
            this.drawRect(g, this.xPixel0, this.yPixel0, this.xPixels, this.yPixels);
            if (this.pd.isPrinting) {
                return;
            }
        }
        this.setCurrentBoxColor(g);
        if (drawUpDownArrows) {
            if (iSpec >= 0) {
                this.setPlotColor(g, iSpec);
                this.fillArrow(g, ArrowType.UP, this.xVArrows, (this.yPixel00 + this.yPixel11) / 2 - 9, true);
                this.fillArrow(g, ArrowType.DOWN, this.xVArrows, (this.yPixel00 + this.yPixel11) / 2 + 9, true);
                this.setCurrentBoxColor(g);
            }
            this.fillArrow(g, ArrowType.UP, this.xVArrows, (this.yPixel00 + this.yPixel11) / 2 - 9, false);
            this.fillCircle(g, this.xVArrows, (this.yPixel00 + this.yPixel11) / 2, false);
            this.fillArrow(g, ArrowType.DOWN, this.xVArrows, (this.yPixel00 + this.yPixel11) / 2 + 9, false);
        }
        if (this.imageView != null) {
            return;
        }
        if (addCurrentBox) {
            int x1 = this.xPixel00 + 10;
            int x2 = this.xPixel11 - 10;
            int y1 = this.yPixel00 + 1;
            int y2 = this.yPixel11 - 2;
            this.drawLine(g, x1, y1, x2, y1);
            this.drawLine(g, x2, y1, x2, y2);
            this.drawLine(g, x1, y2, x2, y2);
            if (addSplitBox) {
                this.fillBox(g, this.xPixel11 - 20, this.yPixel00 + 1, this.xPixel11 - 10, this.yPixel00 + 11, null);
            }
        }
    }

    private void drawGrid(Object g) {
        int x;
        double val;
        double lastX;
        if (!this.pd.gridOn || this.imageView != null) {
            return;
        }
        this.setColor(g, ScriptToken.GRIDCOLOR);
        if (Double.isNaN(this.getScale().firstX)) {
            lastX = this.getScale().maxXOnScale + this.getScale().steps[0] / 2.0;
            val = this.getScale().minXOnScale;
            while (val < lastX) {
                x = this.toPixelX(val);
                this.drawLine(g, x, this.yPixel0, x, this.yPixel1);
                val += this.getScale().steps[0];
            }
        } else {
            lastX = this.getScale().maxXOnScale * 1.0001;
            val = this.getScale().firstX;
            while (val <= lastX) {
                x = this.toPixelX(val);
                this.drawLine(g, x, this.yPixel0, x, this.yPixel1);
                val += this.getScale().steps[0];
            }
        }
        val = this.getScale().firstY;
        while (val < this.getScale().maxYOnScale + this.getScale().steps[1] / 2.0) {
            int y = this.toPixelY(val);
            if (y == this.fixY(y)) {
                this.drawLine(g, this.xPixel0, y, this.xPixel1, y);
            }
            val += this.getScale().steps[1];
        }
    }

    private void drawXScale(Object g, XYScaleConverter c) {
        this.setColor(g, ScriptToken.SCALECOLOR);
        if (this.pd.isPrinting) {
            this.drawLine(g, c.getXPixel0(), this.yPixel1, c.getXPixel0() + c.getXPixels() - 1, this.yPixel1);
        }
        DecimalFormat formatter = this.getScale().formatters[0];
        this.pd.setFont(g, c.getXPixels(), 0, this.pd.isPrinting ? 10 : 12, false);
        int y1 = this.yPixel1;
        int y2 = this.yPixel1 + 4 * this.pd.scalingFactor;
        int y3 = this.yPixel1 + 2 * this.pd.scalingFactor;
        int h = this.getFontHeight(g);
        double dx = c.toPixelX(this.getScale().steps[0]) - c.toPixelX(0.0);
        double maxWidth = Math.abs(dx * 0.95);
        double firstX = this.getScale().firstX - this.getScale().steps[0];
        double lastX = (this.getScale().maxXOnScale + this.getScale().steps[0]) * 1.0001;
        int pass = 0;
        while (pass < 2) {
            if (pass == 1) {
                ScaleData.fixScale(this.mapX);
            }
            double prevX = 1.0E10;
            double val = firstX;
            while (val <= lastX) {
                int x = c.toPixelX(val);
                Double d = val;
                switch (pass) {
                    case 0: {
                        String s = formatter.format(val);
                        this.mapX.put(d, s);
                        this.drawTick(g, x, y1, y2, c);
                        dx = Math.abs(prevX - val);
                        int ntick = this.getScale().minorTickCounts[0];
                        if (ntick != 0) {
                            double step = dx / (double)ntick;
                            int i = 1;
                            while (i < ntick) {
                                double x1 = val - (double)i * step;
                                this.drawTick(g, c.toPixelX(x1), y1, y3, c);
                                ++i;
                            }
                        }
                        prevX = val;
                        break;
                    }
                    case 1: {
                        int n;
                        String s = this.mapX.get(d);
                        if (s == null || x != c.fixX(x)) break;
                        int w = this.getStringWidth(g, s);
                        int n2 = n = x + w / 2 == c.fixX(x + w / 2) ? 2 : 0;
                        if (n > 0) {
                            this.drawString(g, s, x - w / n, y2 + h);
                        }
                        val += Math.floor((double)w / maxWidth) * this.getScale().steps[0];
                    }
                }
                val += this.getScale().steps[0];
            }
            ++pass;
        }
        this.mapX.clear();
    }

    private void drawTick(Object g, int x, int y1, int y2, XYScaleConverter c) {
        if (x == c.fixX(x)) {
            this.drawLine(g, x, y1, x, y2);
        }
    }

    private void drawYScale(Object g, XYScaleConverter c) {
        ScaleData sd = c.getScale();
        DecimalFormat formatter = sd.formatters[1];
        this.pd.setFont(g, c.getXPixels(), 0, this.pd.isPrinting ? 10 : 12, false);
        int h = this.getFontHeight(g);
        double max = sd.maxYOnScale + sd.steps[1] / 2.0;
        int yLast = Integer.MIN_VALUE;
        this.setColor(g, ScriptToken.SCALECOLOR);
        int pass = 0;
        while (pass < 2) {
            if (pass == 1) {
                ScaleData.fixScale(this.mapX);
            }
            double val = sd.firstY;
            while (val < max) {
                Double d = val;
                int x1 = c.getXPixel0();
                int y = c.toPixelY(val);
                if (y == c.fixY(y)) {
                    if (pass == 0) {
                        this.drawLine(g, x1, y, x1 - 3 * this.pd.scalingFactor, y);
                    }
                    if (Math.abs(y - yLast) > h) {
                        yLast = y;
                        switch (pass) {
                            case 0: {
                                String s = formatter.format(val);
                                this.mapX.put(d, s);
                                break;
                            }
                            case 1: {
                                String s = this.mapX.get(d);
                                if (s == null) break;
                                if (s.startsWith("0") && s.contains("E")) {
                                    s = "0";
                                }
                                this.drawString(g, s, x1 - 4 * this.pd.scalingFactor - this.getStringWidth(g, s), y + h / 3);
                            }
                        }
                    }
                }
                val += sd.steps[1];
            }
            ++pass;
        }
        this.mapX.clear();
    }

    private void drawXUnits(Object g) {
        String units = this.spectra.get(0).getAxisLabel(true);
        if (units != null) {
            this.drawUnits(g, units, this.xPixel1 + 25 * this.pd.scalingFactor, this.yPixel1 + 5 * this.pd.scalingFactor, 1.0, 1.0);
        }
    }

    private void drawUnits(Object g, String s, int x, int y, double hOff, double vOff) {
        this.setColor(g, ScriptToken.UNITSCOLOR);
        this.pd.setFont(g, (this.imageView == null ? this : this.imageView).getXPixels(), 2, 10, false);
        this.drawString(g, s, (int)((double)x - (double)this.getStringWidth(g, s) * hOff), (int)((double)y + (double)this.getFontHeight(g) * vOff));
    }

    private void drawYUnits(Object g) {
        String units = this.spectra.get(0).getAxisLabel(false);
        if (units != null) {
            this.drawUnits(g, units, (this.pd.isPrinting ? 30 : 5) * this.pd.scalingFactor, this.yPixel0 + (this.pd.isPrinting ? 0 : 5) * this.pd.scalingFactor, 0.0, -1.0);
        }
    }

    private void drawHighlightsAndPeakTabs(Object g, int iSpec) {
        MeasurementData md = this.getMeasurements(Annotation.AType.PeakList, iSpec);
        JDXSpectrum spec = this.spectra.get(iSpec);
        if (this.pd.isPrinting) {
            if (md != null) {
                this.setColor(g, ScriptToken.PEAKTABCOLOR);
                this.printPeakList(g, spec, (PeakData)md);
            }
            return;
        }
        if (md == null) {
            int i = 0;
            while (i < this.highlights.size()) {
                Highlight hl = this.highlights.get(i);
                if (hl.spectrum == spec) {
                    this.pd.setHighlightColor(hl.color);
                    this.drawBar(g, null, hl.x1, hl.x2, ScriptToken.HIGHLIGHTCOLOR, true);
                }
                ++i;
            }
            this.drawPeakTabs(g, spec);
        }
        if (md != null) {
            int y = spec.isInverted() ? this.yPixel1 - 10 * this.pd.scalingFactor : this.yPixel0;
            this.setColor(g, ScriptToken.PEAKTABCOLOR);
            int i = md.size();
            while (--i >= 0) {
                Measurement m = (Measurement)md.get(i);
                int x = this.toPixelX(m.getXVal());
                this.drawLine(g, x, y, x, y + 10 * this.pd.scalingFactor);
            }
            if (this.isVisible(this.getDialog(Annotation.AType.PeakList, iSpec)) && (y = this.toPixelY(((PeakData)md).getThresh())) == this.fixY(y) && !this.pd.isPrinting) {
                this.drawLine(g, this.xPixel0, y, this.xPixel1, y);
            }
        }
    }

    private void printPeakList(Object g, JDXSpectrum spec, PeakData data) {
        String[][] sdata = data.getMeasurementListArray(null);
        if (sdata.length == 0) {
            return;
        }
        this.pd.setFont(g, this.xPixels, 0, 8, false);
        int h = this.getFontHeight(g);
        int[] xs = new int[data.size()];
        int[] xs0 = new int[data.size()];
        int dx = 0;
        int s5 = 5 * this.pd.scalingFactor;
        int s10 = 10 * this.pd.scalingFactor;
        int s15 = 15 * this.pd.scalingFactor;
        int s25 = 25 * this.pd.scalingFactor;
        int i = 0;
        while (i < sdata.length) {
            xs0[i] = this.toPixelX(Double.parseDouble(sdata[i][1]));
            if (i == 0) {
                xs[i] = xs0[i];
            } else {
                xs[i] = Math.max(xs[i - 1] + h, xs0[i] + h);
                dx += xs[i] - xs0[i];
            }
            ++i;
        }
        if (xs[0] - (dx /= 2 * sdata.length) < this.xPixel0 + s25) {
            dx = xs[0] - (this.xPixel0 + s25);
        }
        i = 0;
        while (i < sdata.length) {
            int n = i++;
            xs[n] = xs[n] - dx;
        }
        boolean inverted = spec.isInverted();
        int y4 = this.getStringWidth(g, "99.9999");
        int y2 = sdata[0].length >= 6 ? this.getStringWidth(g, "99.99") : 0;
        int f = inverted ? -1 : 1;
        int y = (inverted ? this.yPixel1 : this.yPixel0) + f * (y2 + y4 + s15);
        int i2 = 0;
        while (i2 < sdata.length) {
            this.drawLine(g, xs[i2], y, xs[i2], y + s5 * f);
            this.drawLine(g, xs[i2], y + s5 * f, xs0[i2], y + s10 * f);
            this.drawLine(g, xs0[i2], y + s10 * f, xs0[i2], y + s15 * f);
            if (y2 > 0 && sdata[i2][4].length() > 0) {
                this.drawLine(g, (xs[i2] + xs[i2 - 1]) / 2, y - y4 + s5, (xs[i2] + xs[i2 - 1]) / 2, y - y4 - s5);
            }
            ++i2;
        }
        y -= f * 2 * this.pd.scalingFactor;
        if (y2 > 0) {
            this.drawStringRotated(g, 90, xs[0] - s15, y, "  ppm");
            this.drawStringRotated(g, 90, xs[0] - s15, y - y4 - s5, " Hz");
        }
        i2 = data.size();
        while (--i2 >= 0) {
            this.drawStringRotated(g, 90 * f, xs[i2] + f * h / 3, y, sdata[i2][1]);
            if (y2 <= 0 || sdata[i2][4].length() <= 0) continue;
            int x = (xs[i2] + xs[i2 - 1]) / 2 + h / 3;
            this.drawStringRotated(g, 90, x, y - y4 - s5, sdata[i2][4]);
        }
    }

    private void drawStringRotated(Object g, int angle, int x, int y, String s) {
        this.rotatePlot(g, -angle, x, y);
        this.drawString(g, s, x, y);
        this.rotatePlot(g, angle, x, y);
    }

    private void drawAnnotations(Object g, List<Annotation> annotations, ScriptToken whatColor) {
        this.pd.setFont(g, this.xPixels, 1, 12, false);
        int i = annotations.size();
        while (--i >= 0) {
            Annotation note = annotations.get(i);
            this.setAnnotationColor(g, note, whatColor);
            XYScaleConverter c = note.is2D ? this.imageView : this;
            int x = c.toPixelX(note.getXVal());
            int y = note.isPixels() ? (int)((double)(this.yPixel0 + 10 * this.pd.scalingFactor) - note.getYVal()) : (note.is2D ? this.imageView.toPixelY((int)note.getYVal()) : this.toPixelY(note.getYVal()));
            this.drawString(g, note.getText(), x + note.offsetX * this.pd.scalingFactor, y - note.offsetY * this.pd.scalingFactor);
        }
    }

    private void drawIntegralValues(Object g, int iSpec, int yOffset) {
        MeasurementData integrals = this.getMeasurements(Annotation.AType.Integration, iSpec);
        if (integrals != null) {
            if (this.pd.isPrinting) {
                this.pd.setFont(g, this.xPixels, 0, 8, false);
            } else {
                this.pd.setFont(g, this.xPixels, 1, 12, false);
            }
            this.setColor(g, ScriptToken.INTEGRALPLOTCOLOR);
            int h = this.getFontHeight(g);
            this.setStrokeBold(g, true);
            int i = integrals.size();
            while (--i >= 0) {
                Measurement in = (Measurement)integrals.get(i);
                if (in.getValue() == 0.0) continue;
                int x = this.toPixelX(in.getXVal2());
                int y1 = yOffset * this.pd.scalingFactor + this.toPixelYint(in.getYVal());
                int y2 = yOffset * this.pd.scalingFactor + this.toPixelYint(in.getYVal2());
                if (x != this.fixX(x) || y1 != this.fixY(y1) || y2 != this.fixY(y2)) continue;
                if (!this.pd.isPrinting) {
                    this.drawLine(g, x, y1, x, y2);
                }
                String s = "  " + in.getText();
                this.drawString(g, s, x, (y1 + y2) / 2 + h / 3);
            }
            this.setStrokeBold(g, false);
        }
        if (iSpec == this.getFixedSelectedSpectrumIndex()) {
            this.selectedSpectrumIntegrals = integrals;
        }
    }

    private void drawMeasurements(Object g, int iSpec) {
        MeasurementData md = this.getMeasurements(Annotation.AType.Measurements, iSpec);
        if (md != null) {
            int i = md.size();
            while (--i >= 0) {
                this.drawMeasurement(g, (Measurement)md.get(i));
            }
        }
        if (iSpec == this.getFixedSelectedSpectrumIndex()) {
            this.selectedSpectrumMeasurements = md;
        }
    }

    private void drawMeasurement(Object g, Measurement m) {
        if (m.text.length() == 0 && m != this.pendingMeasurement) {
            return;
        }
        this.pd.setFont(g, this.xPixels, 1, 12, false);
        this.setColor(g, 0, 0, 0);
        int x1 = this.toPixelX(m.getXVal());
        int y1 = this.toPixelY(m.getYVal());
        int x2 = this.toPixelX(m.getXVal2());
        if (x1 != this.fixX(x1) || x2 != this.fixX(x2)) {
            return;
        }
        boolean drawString = Math.abs(x1 - x2) >= 2;
        boolean drawBaseLine = this.getScale().isYZeroOnScale() && m.spec.isHNMR();
        int x = (x1 + x2) / 2;
        this.setStrokeBold(g, true);
        if (drawString) {
            this.drawLine(g, x1, y1, x2, y1);
        }
        if (drawBaseLine) {
            this.drawLine(g, x1 + 1, this.yPixel1 - 1, x2, this.yPixel1 - 1);
        }
        this.setStrokeBold(g, false);
        if (drawString) {
            this.drawString(g, m.getText(), x + m.offsetX, y1 - m.offsetY);
        }
        if (drawBaseLine) {
            this.drawLine(g, x1, this.yPixel1, x1, this.yPixel1 - 6 * this.pd.scalingFactor);
            this.drawLine(g, x2, this.yPixel1, x2, this.yPixel1 - 6 * this.pd.scalingFactor);
        }
    }

    private PlotWidget getPinSelected(int xPixel, int yPixel) {
        if (this.widgets != null) {
            int i = 0;
            while (i < this.widgets.length) {
                if (this.widgets[i] != null && this.widgets[i].isPinOrCursor && this.widgets[i].selected(xPixel, yPixel)) {
                    return this.widgets[i];
                }
                ++i;
            }
        }
        return null;
    }

    void set2DCrossHairs(int xPixel, int yPixel) {
        if (xPixel == this.imageView.fixX(xPixel) && yPixel == this.fixY(yPixel)) {
            double x = this.imageView.toX(xPixel);
            this.pin1Dx1.setX(x, this.toPixelX(x));
            this.cur2Dx1.setX(x, xPixel);
            this.setCurrentSubSpectrum(this.imageView.toSubspectrumIndex(yPixel));
            if (this.isLinked) {
                double y = this.imageView.toY(yPixel);
                this.pd.set2DCrossHairsLinked(this, x, y, !this.sticky2Dcursor);
            }
        }
    }

    private void reset2D(boolean isX) {
        if (isX) {
            this.imageView.setView0(this.imageView.xPixel0, this.pin2Dy0.yPixel0, this.imageView.xPixel1, this.pin2Dy1.yPixel0);
            this.doZoom(0.0, this.getScale().minY, 0.0, this.getScale().maxY, true, false, false, false, true);
        } else {
            this.imageView.setView0(this.pin2Dx0.xPixel0, this.imageView.yPixel0, this.pin2Dx1.xPixel0, this.imageView.yPixel1);
        }
    }

    private boolean setAnnotationText(Annotation a) {
        String sval = this.pd.getInput("New text?", "Set Label", a.getText());
        if (sval == null) {
            return false;
        }
        if (sval.length() == 0) {
            this.annotations.remove(a);
        } else {
            a.setText(sval);
        }
        return true;
    }

    private void checkIntegral(double x1, double x2, boolean isFinal) {
        AnnotationData ad = this.getDialog(Annotation.AType.Integration, -1);
        if (ad == null) {
            return;
        }
        Integral integral = ((IntegralData)ad.getData()).addIntegralRegion(x1, x2);
        if (isFinal && ad instanceof AnnotationDialog) {
            ((AnnotationDialog)ad).update(null);
        }
        this.selectedSpectrumIntegrals = null;
        this.pendingIntegral = isFinal ? null : integral;
    }

    private void setToolTipForPixels(int xPixel, int yPixel) {
        PlotWidget pw = this.getPinSelected(xPixel, yPixel);
        DecimalFormat formatterX = this.getScale().formatters[0];
        DecimalFormat formatterY = this.getScale().formatters[1];
        if (pw != null) {
            String s;
            if (this.setStartupPinTip()) {
                return;
            }
            if (pw == this.pin1Dx01 || pw == this.pin2Dx01) {
                s = String.valueOf(formatterX.format(Math.min(this.pin1Dx0.getXVal(), this.pin1Dx1.getXVal()))) + " - " + formatterX.format(Math.max(this.pin1Dx0.getXVal(), this.pin1Dx1.getXVal()));
            } else if (pw == this.pin1Dy01) {
                s = String.valueOf(formatterY.format(Math.min(this.pin1Dy0.getYVal(), this.pin1Dy1.getYVal()))) + " - " + formatterX.format(Math.max(this.pin1Dy0.getYVal(), this.pin1Dy1.getYVal()));
            } else if (pw == this.cur2Dy) {
                int isub = this.imageView.toSubspectrumIndex(pw.yPixel0);
                s = this.get2DYLabel(isub, formatterX);
            } else {
                s = pw == this.pin2Dy01 ? (int)Math.min(this.pin2Dy0.getYVal(), this.pin2Dy1.getYVal()) + " - " + (int)Math.max(this.pin2Dy0.getYVal(), this.pin2Dy1.getYVal()) : (pw.isXtype ? formatterX.format(pw.getXVal()) : (pw.is2D ? "" + (int)pw.getYVal() : formatterY.format(pw.getYVal())));
            }
            this.pd.setToolTipText(s);
            return;
        }
        if (this.imageView != null) {
            if (this.imageView.fixX(xPixel) == xPixel && this.fixY(yPixel) == yPixel) {
                int isub = this.imageView.toSubspectrumIndex(yPixel);
                String s = String.valueOf(formatterX.format(this.imageView.toX(xPixel))) + " " + this.getSpectrum().getAxisLabel(true) + ",  " + this.get2DYLabel(isub, formatterX);
                this.pd.setToolTipText(this.pd.display1D ? s : "");
                this.pd.coordStr = s;
                return;
            }
            if (!this.pd.display1D) {
                this.pd.setToolTipText("");
                this.pd.coordStr = "";
                return;
            }
        }
        double xPt = this.toX(this.fixX(xPixel));
        double yPt = this.imageView != null && this.imageView.isXWithinRange(xPixel) ? (double)this.imageView.toSubspectrumIndex(this.fixY(yPixel)) : this.toY(this.fixY(yPixel));
        String xx = this.setCoordStr(xPt, yPt);
        int iSpec = this.getFixedSelectedSpectrumIndex();
        if (!this.isInPlotRegion(xPixel, yPixel)) {
            yPt = Double.NaN;
        } else if (this.nSpectra != 1 && this.haveIntegralDisplayed(iSpec)) {
            yPt = this.getIntegrationGraph(iSpec).getPercentYValueAt(xPt);
            xx = String.valueOf(xx) + ", " + JSVTextFormat.getDecimalFormat("#0.0").format(yPt);
        }
        this.pd.setToolTipText((String)(this.pendingMeasurement != null || this.selectedMeasurement != null || this.selectedIntegral != null ? (this.pd.hasFocus() ? "Press ESC to delete " + (this.selectedIntegral != null ? "integral, DEL to delete all visible, or N to normalize" : (this.pendingMeasurement == null ? "\"" + this.selectedMeasurement.text + "\" or DEL to delete all visible" : "measurement")) : "") : (Double.isNaN(yPt) ? null : xx)));
    }

    private String setCoordStr(double xPt, double yPt) {
        String xx = this.getScale().formatters[0].format(xPt);
        this.pd.coordStr = "(" + xx + (this.haveSingleYScale || this.iSpectrumSelected >= 0 ? ", " + this.getScale().formatters[1].format(yPt) : "") + ")";
        return xx;
    }

    private boolean setStartupPinTip() {
        if (this.pd.startupPinTip == null) {
            return false;
        }
        this.pd.setToolTipText(this.pd.startupPinTip);
        this.pd.startupPinTip = null;
        return true;
    }

    private String get2DYLabel(int isub, NumberFormat formatterX) {
        JDXSpectrum spec = this.getSpectrumAt(0).getSubSpectra().get(isub);
        return String.valueOf(formatterX.format(spec.getY2D())) + (spec.y2DUnits.equals("HZ") ? " HZ (" + formatterX.format(spec.getY2DPPM()) + " PPM)" : "");
    }

    private boolean isOnSpectrum(int xPixel, int yPixel, int index) {
        boolean isIntegral;
        Coordinate[] xyCoords = null;
        boolean isContinuous = true;
        boolean bl = isIntegral = index < 0;
        if (isIntegral) {
            AnnotationData ad = this.getDialog(Annotation.AType.Integration, -1);
            if (ad == null) {
                return false;
            }
            xyCoords = ((IntegralData)ad.getData()).getXYCoords();
            index = this.getFixedSelectedSpectrumIndex();
        } else {
            this.setScale(index);
            JDXSpectrum spec = this.spectra.get(index);
            xyCoords = spec.xyCoords;
            isContinuous = spec.isContinuous();
        }
        int yOffset = index * (int)((float)this.yPixels * ((float)this.yStackOffsetPercent / 100.0f));
        int ix0 = this.viewData.getStartingPointIndex(index);
        int ix1 = this.viewData.getEndingPointIndex(index);
        if (isContinuous) {
            int i = ix0;
            while (i < ix1) {
                int y2;
                Coordinate point1 = xyCoords[i];
                Coordinate point2 = xyCoords[i + 1];
                int x1 = this.toPixelX(point1.getXVal());
                int x2 = this.toPixelX(point2.getXVal());
                int y1 = isIntegral ? this.toPixelYint(point1.getYVal()) : this.toPixelY(point1.getYVal());
                int n = y2 = isIntegral ? this.toPixelYint(point2.getYVal()) : this.toPixelY(point2.getYVal());
                if (y1 != Integer.MIN_VALUE && y2 != Integer.MIN_VALUE && GraphSet.isOnLine(xPixel, yPixel, x1, y1 = yOffset + this.fixY(y1), x2, y2 = yOffset + this.fixY(y2))) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = ix0;
            while (i <= ix1) {
                Coordinate point = xyCoords[i];
                int y2 = this.toPixelY(point.getYVal());
                if (y2 != Integer.MIN_VALUE) {
                    int x1 = this.toPixelX(point.getXVal());
                    int y1 = this.toPixelY(Math.max(this.getScale().minYOnScale, 0.0));
                    if (((y1 = this.fixY(y1)) != (y2 = this.fixY(y2)) || y1 != this.yPixel0 && y1 != this.yPixel1) && GraphSet.isOnLine(xPixel, yPixel, x1, y1, x1, y2)) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    private static double distance(int dx, int dy) {
        return Math.sqrt(dx * dx + dy * dy);
    }

    private static GraphSet findCompatibleGraphSet(List<GraphSet> graphSets, JDXSpectrum spec) {
        int i = 0;
        while (i < graphSets.size()) {
            if (JDXSpectrum.areXScalesCompatible(spec, graphSets.get(i).getSpectrum(), false, false)) {
                return graphSets.get(i);
            }
            ++i;
        }
        return null;
    }

    private static boolean isGoodEvent(PlotWidget zOrP, PlotWidget p, boolean asX) {
        return p == null ? Math.abs(zOrP.xPixel1 - zOrP.xPixel0) > 5 && Math.abs(zOrP.yPixel1 - zOrP.yPixel0) > 5 : (asX ? Math.abs(zOrP.xPixel0 - p.xPixel0) > 5 : Math.abs(zOrP.yPixel0 - p.yPixel0) > 5);
    }

    private static boolean isOnLine(int xPixel, int yPixel, int x1, int y1, int x2, int y2) {
        int dx1 = Math.abs(x1 - xPixel);
        if (dx1 < 2 && Math.abs(y1 - yPixel) < 2) {
            return true;
        }
        int dx2 = x2 - xPixel;
        if (Math.abs(dx2) < 2 && Math.abs(y2 - yPixel) < 2) {
            return true;
        }
        int dy12 = y1 - y2;
        if (Math.abs(dy12) > 2 && y1 < yPixel == y2 < yPixel) {
            return false;
        }
        int dx12 = x1 - x2;
        if (Math.abs(dx12) > 2 && x1 < xPixel == x2 < xPixel) {
            return false;
        }
        return GraphSet.distance(dx1, y1 - yPixel) + GraphSet.distance(dx2, yPixel - y2) < GraphSet.distance(dx12, dy12) + 2.0;
    }

    private static void setFractionalPositions(PanelData pd, List<GraphSet> graphSets, PanelData.LinkMode linkMode) {
        int n = graphSets.size();
        double f = 0.0;
        int n2d = 1;
        double y = 0.0;
        boolean bl = pd.isLinked = linkMode != PanelData.LinkMode.NONE;
        if (linkMode == PanelData.LinkMode.NONE) {
            GraphSet gs;
            int i = 0;
            while (i < n) {
                gs = graphSets.get(i);
                f += (double)((gs.getSpectrumAt(0).is1D() ? 1 : n2d) * gs.nSplit);
                ++i;
            }
            f = 1.0 / f;
            i = 0;
            while (i < n) {
                gs = graphSets.get(i);
                gs.isLinked = false;
                double g = gs.getSpectrumAt(0).is1D() ? f : (double)n2d * f;
                gs.fX0 = 0.0;
                gs.fY0 = y;
                gs.fracX = 1.0;
                gs.fracY = g;
                y += g * (double)gs.nSplit;
                ++i;
            }
        } else {
            GraphSet gs;
            int i;
            GraphSet gs2d = null;
            int i2d = -1;
            if (n == 2 || n == 3) {
                i = 0;
                while (i < n) {
                    gs = graphSets.get(i);
                    if (!gs.getSpectrum().is1D()) {
                        gs2d = gs;
                        if (i2d >= 0) {
                            i = -2;
                        }
                        i2d = i;
                        break;
                    }
                    ++i;
                }
            }
            if (i2d == -2 || i2d == -1 && n != 2) {
                GraphSet.setFractionalPositions(pd, graphSets, PanelData.LinkMode.NONE);
                return;
            }
            i = 0;
            while (i < n) {
                gs = graphSets.get(i);
                gs.isLinked = true;
                JDXSpectrum s1 = gs.getSpectrumAt(0);
                boolean is1D = s1.is1D();
                if (is1D) {
                    if (gs2d != null) {
                        JDXSpectrum s2 = gs2d.getSpectrumAt(0);
                        if (JDXSpectrum.areLinkableX(s1, s2)) {
                            gs.gs2dLinkedX = gs2d;
                        }
                        if (JDXSpectrum.areLinkableY(s1, s2)) {
                            gs.gs2dLinkedY = gs2d;
                        }
                    }
                    gs.fX0 = 0.0;
                    gs.fY0 = y;
                    gs.fracX = gs2d == null ? 1.0 : 0.5;
                    gs.fracY = n == 3 || gs2d == null ? 0.5 : 1.0;
                    y += 0.5;
                } else {
                    gs.fX0 = 0.5;
                    gs.fY0 = 0.0;
                    gs.fracX = 0.5;
                    gs.fracY = 1.0;
                }
                ++i;
            }
        }
    }

    String addAnnotation(List<String> args, String title) {
        Annotation annotation;
        if (args.size() == 0 || args.size() == 1 && args.get(0).equalsIgnoreCase("none")) {
            this.annotations = null;
            this.lastAnnotation = null;
            return null;
        }
        if (args.size() < 4 && this.lastAnnotation == null) {
            this.lastAnnotation = this.getAnnotation((this.getScale().maxXOnScale + this.getScale().minXOnScale) / 2.0, (this.getScale().maxYOnScale + this.getScale().minYOnScale) / 2.0, title, false, false, 0, 0);
        }
        if ((annotation = this.getAnnotation(args, this.lastAnnotation)) == null) {
            return null;
        }
        if (this.annotations == null && args.size() == 1 && args.get(0).charAt(0) == '\"') {
            String s = annotation.getText();
            this.getSpectrum().setTitle(s);
            return s;
        }
        this.lastAnnotation = annotation;
        this.addAnnotation(annotation, false);
        return null;
    }

    void addHighlight(double x1, double x2, JDXSpectrum spec, Object oColor) {
        Highlight hl;
        if (spec == null) {
            spec = this.getSpectrumAt(0);
        }
        if (!this.highlights.contains(hl = new Highlight(x1, x2, spec, oColor == null ? this.pd.getHighlightColor() : oColor))) {
            this.highlights.add(hl);
        }
    }

    void addPeakHighlight(PeakInfo peakInfo) {
        int i = this.spectra.size();
        while (--i >= 0) {
            String peak;
            JDXSpectrum spec = this.spectra.get(i);
            this.removeAllHighlights(spec);
            if (peakInfo == null || peakInfo.isClearAll() || spec != peakInfo.spectrum || (peak = peakInfo.toString()) == null) continue;
            String xMin = JSVParser.getQuotedAttribute(peak, "xMin");
            String xMax = JSVParser.getQuotedAttribute(peak, "xMax");
            if (xMin == null || xMax == null) {
                return;
            }
            float x1 = JSVParser.parseFloat(xMin);
            float x2 = JSVParser.parseFloat(xMax);
            if (Float.isNaN(x1) || Float.isNaN(x2)) {
                return;
            }
            this.pd.addHighlight(this, x1, x2, spec, 200, 200, 200, 200);
            spec.setSelectedPeak(peakInfo);
            if (this.getScale().isInRangeX(x1) || this.getScale().isInRangeX(x2) || (double)x1 < this.getScale().minX && this.getScale().maxX < (double)x2) continue;
            this.setZoomTo(0);
        }
    }

    void advanceSubSpectrum(int dir) {
        JDXSpectrum spec0 = this.getSpectrumAt(0);
        int i = spec0.advanceSubSpectrum(dir);
        if (spec0.isForcedSubset()) {
            this.viewData.setXRangeForSubSpectrum(this.getSpectrum().getXYCoords());
        }
        this.pd.notifySubSpectrumChange(i, this.getSpectrum());
    }

    synchronized boolean checkSpectrumClickedEvent(int xPixel, int yPixel, int clickCount) {
        if (this.nextClickForSetPeak) {
            return false;
        }
        if (clickCount > 0 && this.checkArrowLeftRightClick(xPixel, yPixel)) {
            return true;
        }
        if (clickCount > 1 || this.pendingMeasurement != null || !this.isInPlotRegion(xPixel, yPixel)) {
            return false;
        }
        if (clickCount == 0) {
            boolean isOnIntegral = this.isOnSpectrum(xPixel, yPixel, -1);
            this.pd.integralShiftMode = isOnIntegral ? this.getShiftMode(xPixel, yPixel) : 0;
            boolean bl = this.pd.isIntegralDrag = this.pd.integralShiftMode == 0 && (isOnIntegral || this.haveIntegralDisplayed(-1) && this.findMeasurement(this.getIntegrationGraph(-1), xPixel, yPixel, 0) != null);
            if (this.pd.integralShiftMode != 0) {
                return false;
            }
        }
        if (!this.showAllStacked) {
            return false;
        }
        this.stackSelected = false;
        int i = 0;
        while (i < this.nSpectra) {
            if (this.isOnSpectrum(xPixel, yPixel, i)) {
                boolean isNew = i != this.iSpectrumSelected;
                this.iPreviousSpectrumClicked = i;
                this.setSpectrumClicked(this.iPreviousSpectrumClicked);
                return isNew;
            }
            ++i;
        }
        if (this.isDialogOpen()) {
            return false;
        }
        this.setSpectrumClicked(-1);
        this.stackSelected = false;
        return false;
    }

    private int getShiftMode(int xPixel, int yPixel) {
        return this.isStartEndIntegral(xPixel, false) ? yPixel : (this.isStartEndIntegral(xPixel, true) ? -yPixel : 0);
    }

    private boolean isDialogOpen() {
        return this.isVisible(this.getDialog(Annotation.AType.Integration, -1)) || this.isVisible(this.getDialog(Annotation.AType.Measurements, -1)) || this.isVisible(this.getDialog(Annotation.AType.PeakList, -1));
    }

    private boolean isStartEndIntegral(int xPixel, boolean isEnd) {
        return isEnd ? this.xPixelPlot1 - xPixel < 20 : xPixel - this.xPixelPlot0 < 20;
    }

    synchronized boolean checkWidgetEvent(int xPixel, int yPixel, boolean isPress) {
        if (!this.zoomEnabled || !this.triggered) {
            return false;
        }
        this.triggered = false;
        if (isPress) {
            PlotWidget widget = this.getPinSelected(xPixel, yPixel);
            if (widget == null) {
                yPixel = this.fixY(yPixel);
                if (xPixel < this.xPixel1) {
                    if (this.pd.shiftPressed) {
                        this.setSpectrumClicked(this.iPreviousSpectrumClicked);
                    }
                    xPixel = this.fixX(xPixel);
                    this.zoomBox1D.setX(this.toX(xPixel), xPixel);
                    this.zoomBox1D.yPixel0 = yPixel;
                    widget = this.zoomBox1D;
                } else if (this.imageView != null && xPixel < this.imageView.xPixel1) {
                    this.zoomBox2D.setX(this.imageView.toX(xPixel), this.imageView.fixX(xPixel));
                    this.zoomBox2D.yPixel0 = yPixel;
                    widget = this.zoomBox2D;
                }
            }
            this.pd.thisWidget = widget;
            return true;
        }
        this.nextClickForSetPeak = false;
        PlotWidget widget = this.pd.thisWidget;
        if (widget == null) {
            return false;
        }
        if (widget == this.zoomBox1D) {
            this.zoomBox1D.xPixel1 = this.fixX(xPixel);
            this.zoomBox1D.yPixel1 = this.fixY(yPixel);
            if (this.pd.isIntegralDrag && this.zoomBox1D.xPixel0 != this.zoomBox1D.xPixel1) {
                this.checkIntegral(this.zoomBox1D.getXVal(), this.toX(this.zoomBox1D.xPixel1), false);
            }
            return true;
        }
        if (widget == this.zoomBox2D) {
            this.zoomBox2D.xPixel1 = this.imageView.fixX(xPixel);
            this.zoomBox2D.yPixel1 = this.fixY(yPixel);
            return true;
        }
        if (widget == this.cur2Dy) {
            this.cur2Dy.yPixel0 = this.cur2Dy.yPixel1 = (yPixel = this.fixY(yPixel));
            this.setCurrentSubSpectrum(this.imageView.toSubspectrumIndex(yPixel));
            return true;
        }
        if (widget == this.cur2Dx0 || widget == this.cur2Dx1) {
            return true;
        }
        if (widget == this.pin1Dx0 || widget == this.pin1Dx1 || widget == this.pin1Dx01) {
            xPixel = this.fixX(xPixel);
            widget.setX(this.toX0(xPixel), xPixel);
            if (widget == this.pin1Dx01) {
                int dp = xPixel - (this.pin1Dx0.xPixel0 + this.pin1Dx1.xPixel0) / 2;
                System.out.println("dif1: " + (this.toX0(this.pin1Dx1.xPixel0) - this.toX0(this.pin1Dx0.xPixel0)) + " " + dp);
                System.out.println("dif1: " + (this.toX0(this.pin1Dx0.xPixel0) - this.toX0(this.pin1Dx0.xPixel0 + dp)));
                int dp1 = dp < 0 ? dp : dp;
                int dp2 = dp < 0 ? dp : dp;
                xPixel = this.pin1Dx0.xPixel0 + dp2;
                int xPixel1 = this.pin1Dx1.xPixel0 + dp1;
                if (dp == 0 || this.fixX(xPixel) != xPixel || this.fixX(xPixel1) != xPixel1) {
                    return true;
                }
                this.pin1Dx0.setX(this.toX0(xPixel), xPixel);
                this.pin1Dx1.setX(this.toX0(xPixel1), xPixel1);
            }
            this.doZoom(this.pin1Dx0.getXVal(), 0.0, this.pin1Dx1.getXVal(), 0.0, true, false, false, true, false);
            return true;
        }
        if (widget == this.pin1Dy0 || widget == this.pin1Dy1 || widget == this.pin1Dy01) {
            yPixel = this.fixY(yPixel);
            widget.setY(this.toY0(yPixel), yPixel);
            if (widget == this.pin1Dy01) {
                double y1;
                int dp = yPixel - (this.pin1Dy0.yPixel0 + this.pin1Dy1.yPixel0) / 2 + 1;
                yPixel = this.pin1Dy0.yPixel0 + dp;
                int yPixel1 = this.pin1Dy1.yPixel0 + dp;
                double y0 = this.toY0(yPixel);
                if (Math.min(y0, y1 = this.toY0(yPixel1)) == this.getScale().minY || Math.max(y0, y1) == this.getScale().maxY) {
                    return true;
                }
                this.pin1Dy0.setY(y0, yPixel);
                this.pin1Dy1.setY(y1, yPixel1);
            }
            this.doZoom(0.0, this.pin1Dy0.getYVal(), 0.0, this.pin1Dy1.getYVal(), this.imageView == null, this.imageView == null, false, false, false);
            return true;
        }
        if (widget == this.pin2Dx0 || widget == this.pin2Dx1 || widget == this.pin2Dx01) {
            xPixel = this.imageView.fixX(xPixel);
            widget.setX(this.imageView.toX0(xPixel), xPixel);
            if (widget == this.pin2Dx01) {
                int dp = xPixel - (this.pin2Dx0.xPixel0 + this.pin2Dx1.xPixel0) / 2 + 1;
                xPixel = this.pin2Dx0.xPixel0 + dp;
                int xPixel1 = this.pin2Dx1.xPixel0 + dp;
                if (this.imageView.fixX(xPixel) != xPixel || this.imageView.fixX(xPixel1) != xPixel1) {
                    return true;
                }
                this.pin2Dx0.setX(this.imageView.toX0(xPixel), xPixel);
                this.pin2Dx1.setX(this.imageView.toX0(xPixel1), xPixel1);
            }
            if (!GraphSet.isGoodEvent(this.pin2Dx0, this.pin2Dx1, true)) {
                this.reset2D(true);
                return false;
            }
            this.imageView.setView0(this.pin2Dx0.xPixel0, this.pin2Dy0.yPixel0, this.pin2Dx1.xPixel0, this.pin2Dy1.yPixel0);
            this.doZoom(this.pin2Dx0.getXVal(), this.getScale().minY, this.pin2Dx1.getXVal(), this.getScale().maxY, false, false, false, true, false);
            return true;
        }
        if (widget == this.pin2Dy0 || widget == this.pin2Dy1 || widget == this.pin2Dy01) {
            yPixel = this.fixY(yPixel);
            widget.setY(this.imageView.toSubspectrumIndex(yPixel), yPixel);
            if (widget == this.pin2Dy01) {
                int dp = yPixel - (this.pin2Dy0.yPixel0 + this.pin2Dy1.yPixel0) / 2 + 1;
                yPixel = this.pin2Dy0.yPixel0 + dp;
                int yPixel1 = this.pin2Dy1.yPixel0 + dp;
                if (yPixel != this.fixY(yPixel) || yPixel1 != this.fixY(yPixel1)) {
                    return true;
                }
                this.pin2Dy0.setY(this.imageView.toSubspectrumIndex(yPixel), yPixel);
                this.pin2Dy1.setY(this.imageView.toSubspectrumIndex(yPixel1), yPixel1);
            }
            if (!GraphSet.isGoodEvent(this.pin2Dy0, this.pin2Dy1, false)) {
                this.reset2D(false);
                return false;
            }
            this.imageView.setView0(this.pin2Dx0.xPixel0, this.pin2Dy0.yPixel0, this.pin2Dx1.xPixel1, this.pin2Dy1.yPixel1);
            this.update2dImage(false);
            return true;
        }
        return false;
    }

    void clearAllViews() {
        this.clearViews();
    }

    void clearIntegrals() {
        this.checkIntegral(Double.NaN, 0.0, false);
    }

    void clearMeasurements() {
        this.removeDialog(this.getFixedSelectedSpectrumIndex(), Annotation.AType.Measurements);
    }

    static List<GraphSet> createGraphSetsAndSetLinkMode(PanelData pd, JSVPanel jsvp, List<JDXSpectrum> spectra, int startIndex, int endIndex, PanelData.LinkMode linkMode) {
        ArrayList<GraphSet> graphSets = new ArrayList<GraphSet>();
        int i = 0;
        while (i < spectra.size()) {
            GraphSet graphSet;
            JDXSpectrum spec = spectra.get(i);
            GraphSet graphSet2 = graphSet = linkMode == PanelData.LinkMode.NONE ? GraphSet.findCompatibleGraphSet(graphSets, spec) : null;
            if (graphSet == null) {
                graphSet = jsvp.getNewGraphSet();
                graphSets.add(graphSet);
            }
            graphSet.addSpec(spec);
            ++i;
        }
        GraphSet.setFractionalPositions(pd, graphSets, linkMode);
        i = graphSets.size();
        while (--i >= 0) {
            ((GraphSet)graphSets.get(i)).initGraphSet(startIndex, endIndex);
            JSVLogger.info("JSVGraphSet " + (i + 1) + " nSpectra = " + ((GraphSet)graphSets.get((int)i)).nSpectra);
        }
        return graphSets;
    }

    synchronized void drawGraphSet(Object og, int width, int height, int left, int right, int top, int bottom, boolean isResized) {
        this.zoomEnabled = this.pd.getBoolean(ScriptToken.ENABLEZOOM);
        this.height = height * this.pd.scalingFactor;
        this.width = width * this.pd.scalingFactor;
        this.left = left * this.pd.scalingFactor;
        this.right = right * this.pd.scalingFactor;
        this.top = top * this.pd.scalingFactor;
        this.bottom = bottom * this.pd.scalingFactor;
        this.haveSelectedSpectrum = false;
        this.selectedSpectrumIntegrals = null;
        this.selectedSpectrumMeasurements = null;
        if (!this.pd.isPrinting && this.widgets != null) {
            int j = 0;
            while (j < this.widgets.length) {
                if (this.widgets[j] != null) {
                    this.widgets[j].isVisible = false;
                }
                ++j;
            }
        }
        int iSplit = 0;
        while (iSplit < this.nSplit) {
            this.setPositionForFrame(iSplit);
            this.drawAll(og, iSplit, isResized || this.nSplit > 1);
            ++iSplit;
        }
        this.setPositionForFrame(this.nSplit > 1 ? this.pd.currentSplitPoint : 0);
        if (this.pd.isPrinting) {
            return;
        }
    }

    synchronized void escapeKeyPressed(boolean isDEL) {
        if (this.zoomBox1D != null) {
            this.zoomBox1D.xPixel1 = 0;
            this.zoomBox1D.xPixel0 = 0;
        }
        if (this.zoomBox2D != null) {
            this.zoomBox2D.xPixel1 = 0;
            this.zoomBox2D.xPixel0 = 0;
        }
        if (!this.inPlotMove) {
            return;
        }
        if (this.pendingMeasurement != null) {
            this.pendingMeasurement = null;
            return;
        }
        this.pd.thisWidget = null;
        this.pendingMeasurement = null;
        if (this.selectedSpectrumMeasurements != null && this.selectedMeasurement != null) {
            if (isDEL) {
                this.selectedSpectrumMeasurements.clear(this.getScale().minXOnScale, this.getScale().maxXOnScale);
            } else {
                this.selectedSpectrumMeasurements.remove(this.selectedMeasurement);
            }
            this.selectedMeasurement = null;
            this.updateDialog(Annotation.AType.Measurements, -1);
        }
        if (this.selectedSpectrumIntegrals != null && this.selectedIntegral != null) {
            if (isDEL) {
                this.selectedSpectrumIntegrals.clear(this.getScale().minXOnScale, this.getScale().maxXOnScale);
            } else {
                this.selectedSpectrumIntegrals.remove(this.selectedIntegral);
            }
            this.selectedIntegral = null;
            this.updateDialog(Annotation.AType.Integration, -1);
        }
    }

    static GraphSet findGraphSet(List<GraphSet> graphSets, int xPixel, int yPixel) {
        int i = graphSets.size();
        while (--i >= 0) {
            if (!graphSets.get(i).hasPoint(xPixel, yPixel)) continue;
            return graphSets.get(i);
        }
        return null;
    }

    PeakInfo findMatchingPeakInfo(PeakInfo pi) {
        PeakInfo pi2 = null;
        int i = 0;
        while (i < this.spectra.size()) {
            pi2 = this.spectra.get(i).findMatchingPeakInfo(pi);
            if (pi2 != null) break;
            ++i;
        }
        return pi2;
    }

    int getCurrentSpectrumIndex() {
        return this.nSpectra == 1 ? 0 : this.iSpectrumSelected;
    }

    Integral getSelectedIntegral() {
        return this.selectedIntegral;
    }

    boolean getShowAnnotation(Annotation.AType type, int i) {
        AnnotationData id = this.getDialog(type, i);
        return id != null && id.getState();
    }

    String getSolutionColor() {
        JDXSpectrum spectrum = this.getSpectrum();
        return spectrum.canShowSolutionColor() ? Visible.Colour(spectrum.getXYCoords(), spectrum.getYUnits()) : "255,255,255";
    }

    boolean hasFileLoaded(String filePath) {
        int i = this.spectra.size();
        while (--i >= 0) {
            if (!this.spectra.get(i).getFilePathForwardSlash().equals(filePath)) continue;
            return true;
        }
        return false;
    }

    boolean haveSelectedSpectrum() {
        return this.haveSelectedSpectrum;
    }

    synchronized void mouseClickedEvent(int xPixel, int yPixel, int clickCount, boolean isControlDown) {
        boolean is2D;
        this.selectedMeasurement = null;
        this.selectedIntegral = null;
        boolean isNextClick = this.nextClickForSetPeak;
        this.nextClickForSetPeak = false;
        if (this.checkArrowUpDownClick(xPixel, yPixel)) {
            return;
        }
        this.lastClickX = Double.NaN;
        this.lastPixelX = Integer.MAX_VALUE;
        if (this.isSplitWidget(xPixel, yPixel)) {
            this.splitStack(this.pd.graphSets, this.nSplit == 1);
            return;
        }
        PlotWidget pw = this.getPinSelected(xPixel, yPixel);
        if (pw != null) {
            this.setWidgetValueByUser(pw);
            return;
        }
        boolean bl = is2D = this.imageView != null && xPixel == this.imageView.fixX(xPixel) && yPixel == this.fixY(yPixel);
        if (clickCount == 2 && this.iSpectrumClicked == -1 && this.iPreviousSpectrumClicked >= 0) {
            this.setSpectrumClicked(this.iPreviousSpectrumClicked);
        }
        if (!is2D && isControlDown) {
            this.setSpectrumClicked(this.iPreviousSpectrumClicked);
            if (this.pendingMeasurement != null) {
                this.processPendingMeasurement(xPixel, yPixel, -3);
            } else if (this.iSpectrumClicked >= 0) {
                this.processPendingMeasurement(xPixel, yPixel, 3);
            }
            return;
        }
        this.lastXMax = Double.NaN;
        if (clickCount == 2) {
            if (is2D) {
                if (this.sticky2Dcursor) {
                    this.addAnnotation(this.getAnnotation(this.imageView.toX(xPixel), this.imageView.toSubspectrumIndex(yPixel), this.pd.coordStr, false, true, 5, 5), true);
                }
                this.sticky2Dcursor = !this.sticky2Dcursor;
                this.set2DCrossHairs(xPixel, yPixel);
                return;
            }
            if (this.isInTopBar(xPixel, yPixel)) {
                this.doZoom(this.toX0(this.xPixel0), 0.0, this.toX0(this.xPixel1), 0.0, true, false, false, true, true);
            } else if (this.isInRightBar(xPixel, yPixel)) {
                this.doZoom(this.getScale().minXOnScale, this.viewList.get((int)0).getScale().minYOnScale, this.getScale().maxXOnScale, this.viewList.get((int)0).getScale().maxYOnScale, true, true, false, false, false);
            } else if (this.isInTopBar2D(xPixel, yPixel)) {
                this.reset2D(true);
            } else if (this.isInRightBar2D(xPixel, yPixel)) {
                this.reset2D(false);
            } else if (this.pendingMeasurement != null) {
                this.processPendingMeasurement(xPixel, yPixel, -2);
            } else if (this.iSpectrumClicked >= 0) {
                this.processPendingMeasurement(xPixel, yPixel, 2);
            }
            return;
        }
        if (is2D) {
            Coordinate xy;
            Annotation a;
            if (this.annotations != null && (a = this.findAnnotation2D(xy = new Coordinate(this.imageView.toX(xPixel), this.imageView.toSubspectrumIndex(yPixel)))) != null && this.setAnnotationText(a)) {
                return;
            }
            this.sticky2Dcursor = false;
            this.set2DCrossHairs(xPixel, yPixel);
            return;
        }
        if (this.isInPlotRegion(xPixel, yPixel)) {
            if (this.selectedSpectrumIntegrals != null && this.checkIntegralNormalizationClick(xPixel, yPixel)) {
                return;
            }
            if (this.pendingMeasurement != null) {
                this.processPendingMeasurement(xPixel, yPixel, 1);
                return;
            }
            this.setCoordClicked(xPixel, this.toX(xPixel), this.toY(yPixel));
            this.updateDialog(Annotation.AType.PeakList, -1);
            if (isNextClick) {
                this.shiftSpectrum(Double.NaN, Double.NaN);
                return;
            }
        } else {
            this.setCoordClicked(0, Double.NaN, 0.0);
        }
        this.pd.notifyPeakPickedListeners(null);
    }

    private void updateDialog(Annotation.AType type, int iSpec) {
        AnnotationData ad = this.getDialog(type, iSpec);
        if (ad != null && ad.getState() && this.isVisible(ad)) {
            ((AnnotationDialog)ad).update(this.pd.coordClicked);
        }
    }

    private boolean isVisible(AnnotationData ad) {
        return ad instanceof AnnotationDialog && ad.isVisible();
    }

    synchronized void mouseReleasedEvent() {
        if (this.pd.integralShiftMode != 0) {
            this.pd.integralShiftMode = 0;
            this.zoomBox1D.xPixel1 = this.zoomBox1D.xPixel0;
            return;
        }
        if (this.iSpectrumMovedTo >= 0) {
            this.setScale(this.iSpectrumMovedTo);
        }
        PlotWidget thisWidget = this.pd.thisWidget;
        if (this.pd.isIntegralDrag) {
            if (GraphSet.isGoodEvent(this.zoomBox1D, null, true)) {
                this.checkIntegral(this.toX(this.zoomBox1D.xPixel0), this.toX(this.zoomBox1D.xPixel1), true);
            }
            this.zoomBox1D.xPixel0 = 0;
            this.zoomBox1D.xPixel1 = 0;
            this.pendingIntegral = null;
            this.pd.isIntegralDrag = false;
        } else if (thisWidget == this.zoomBox2D) {
            if (!GraphSet.isGoodEvent(this.zoomBox2D, null, true)) {
                return;
            }
            this.imageView.setZoom(this.zoomBox2D.xPixel0, this.zoomBox2D.yPixel0, this.zoomBox2D.xPixel1, this.zoomBox2D.yPixel1);
            this.zoomBox2D.xPixel1 = this.zoomBox2D.xPixel0;
            this.doZoom(this.imageView.toX(this.imageView.xPixel0), this.getScale().minY, this.imageView.toX(this.imageView.xPixel0 + this.imageView.xPixels - 1), this.getScale().maxY, false, false, false, true, true);
        } else if (thisWidget == this.zoomBox1D) {
            if (!GraphSet.isGoodEvent(this.zoomBox1D, null, true)) {
                return;
            }
            int x1 = this.zoomBox1D.xPixel1;
            boolean doY = this.pd.shiftPressed;
            this.doZoom(this.toX(this.zoomBox1D.xPixel0), doY ? this.toY(this.zoomBox1D.yPixel0) : 0.0, this.toX(x1), doY ? this.toY(this.zoomBox1D.yPixel1) : 0.0, true, doY, true, true, true);
            this.zoomBox1D.xPixel1 = this.zoomBox1D.xPixel0;
        } else if (thisWidget == this.pin1Dx0 || thisWidget == this.pin1Dx1 || thisWidget == this.cur2Dx0 || thisWidget == this.cur2Dx1) {
            this.addCurrentZoom();
        }
    }

    synchronized void mouseMovedEvent(int xPixel, int yPixel) {
        if (this.nSpectra > 1) {
            int iFrame = this.getSplitPoint(yPixel);
            this.setPositionForFrame(iFrame);
            this.setSpectrumMovedTo(this.nSplit > 1 ? iFrame : this.iSpectrumSelected);
            if (this.iSpectrumMovedTo >= 0) {
                this.setScale(this.iSpectrumMovedTo);
            }
        }
        this.inPlotMove = this.isInPlotRegion(xPixel, yPixel);
        this.setXPixelMovedTo(Double.MAX_VALUE, Double.MAX_VALUE, this.inPlotMove ? xPixel : -1, -1);
        if (this.inPlotMove) {
            this.xValueMovedTo = this.toX(this.xPixelMovedTo);
            this.yValueMovedTo = this.getSpectrum().getYValueAt(this.xValueMovedTo);
        }
        if (this.pd.integralShiftMode != 0) {
            AnnotationData ad = this.getDialog(Annotation.AType.Integration, -1);
            Coordinate[] xy = ((IntegralData)ad.getData()).getXYCoords();
            double y = xy[this.pd.integralShiftMode > 0 ? xy.length - 1 : 0].getYVal();
            ((IntegralData)ad.getData()).shiftY(this.pd.integralShiftMode, this.toPixelYint(y) + yPixel - (this.pd.integralShiftMode > 0 ? this.yPixelPlot1 : this.yPixelPlot0), this.yPixel0, this.yPixels);
        } else if (!this.pd.isIntegralDrag) {
            if (this.pendingMeasurement != null) {
                this.processPendingMeasurement(xPixel, yPixel, 0);
                this.setToolTipForPixels(xPixel, yPixel);
            } else {
                this.selectedMeasurement = this.inPlotMove && this.selectedSpectrumMeasurements != null ? this.findMeasurement(this.selectedSpectrumMeasurements, xPixel, yPixel, 0) : null;
                this.selectedIntegral = null;
                if (this.inPlotMove && this.selectedSpectrumIntegrals != null && this.selectedMeasurement == null) {
                    this.selectedIntegral = (Integral)this.findMeasurement(this.selectedSpectrumIntegrals, xPixel, yPixel, 0);
                    if (this.selectedIntegral == null) {
                        this.selectedIntegral = (Integral)this.findMeasurement(this.selectedSpectrumIntegrals, xPixel, yPixel, -5);
                    }
                }
                this.setToolTipForPixels(xPixel, yPixel);
                if (this.imageView == null) {
                    JDXSpectrum spec;
                    int iSpec;
                    this.piMouseOver = null;
                    int n = iSpec = this.nSplit > 1 ? this.iSpectrumMovedTo : this.iSpectrumClicked;
                    if (!this.isDrawNoSpectra() && iSpec >= 0 && (spec = this.spectra.get(iSpec)).getPeakList() != null) {
                        this.coordTemp.setXVal(this.toX(xPixel));
                        this.coordTemp.setYVal(this.toY(yPixel));
                        this.piMouseOver = spec.findPeakByCoord(xPixel, this.coordTemp);
                    }
                } else if (!this.pd.display1D && this.sticky2Dcursor) {
                    this.set2DCrossHairs(xPixel, yPixel);
                }
            }
        }
    }

    void nextView() {
        if (this.currentZoomIndex + 1 < this.viewList.size()) {
            this.setZoomTo(this.currentZoomIndex + 1);
        }
    }

    void previousView() {
        if (this.currentZoomIndex > 0) {
            this.setZoomTo(this.currentZoomIndex - 1);
        }
    }

    void resetView() {
        this.setZoomTo(0);
    }

    void removeAllHighlights() {
        this.removeAllHighlights(null);
    }

    void removeHighlight(int index) {
        this.highlights.remove(index);
    }

    void removeHighlight(double x1, double x2) {
        int i = this.highlights.size();
        while (--i >= 0) {
            Highlight h = this.highlights.get(i);
            if (h.x1 != x1 || h.x2 != x2) continue;
            this.highlights.remove(i);
        }
    }

    void scaleYBy(double factor) {
        if (this.imageView == null && !this.zoomEnabled) {
            return;
        }
        this.viewData.scaleSpectrum(this.imageView == null ? this.iSpectrumSelected : -2, factor);
        if (this.imageView != null) {
            this.update2dImage(false);
            this.resetPinsFromView();
        }
        this.pd.refresh();
    }

    boolean selectSpectrum(String filePath, String type, String model) {
        boolean haveFound = false;
        int i = this.spectra.size();
        while (--i >= 0) {
            if (filePath != null && !this.getSpectrumAt(i).getFilePathForwardSlash().equals(filePath) || !this.getSpectrumAt(i).matchesPeakTypeModel(type, model)) continue;
            this.setSpectrumSelected(i);
            if (this.nSplit > 1) {
                this.splitStack(this.pd.graphSets, true);
            }
            haveFound = true;
        }
        if (this.nSpectra > 1 && !haveFound && this.iSpectrumSelected >= 0 && !this.pd.isCurrentGraphSet(this)) {
            this.setSpectrumSelected(Integer.MIN_VALUE);
        }
        return haveFound;
    }

    PeakInfo selectPeakByFileIndex(String filePath, String index) {
        int i = this.spectra.size();
        while (--i >= 0) {
            PeakInfo pi = this.getSpectrumAt(i).selectPeakByFileIndex(filePath, index);
            if (pi == null) continue;
            return pi;
        }
        return null;
    }

    void setSelected(int i) {
        if (i < 0) {
            this.bsSelected.clear();
            this.setSpectrumClicked(-1);
            return;
        }
        this.bsSelected.set(i);
        this.setSpectrumClicked(this.bsSelected.cardinality() == 1 ? i : -1);
        if (this.nSplit > 1 && i >= 0) {
            this.pd.currentSplitPoint = i;
        }
    }

    void setSelectedIntegral(double val) {
        JDXSpectrum spec = this.selectedIntegral.getSpectrum();
        this.getIntegrationGraph(this.getSpectrumIndex(spec)).setSelectedIntegral(this.selectedIntegral, val);
    }

    void setShowAnnotation(Annotation.AType type, Boolean tfToggle) {
        AnnotationData id = this.getDialog(type, -1);
        if (id == null) {
            if (tfToggle != null && tfToggle != Boolean.TRUE) {
                return;
            }
            if (type == Annotation.AType.PeakList) {
                this.pd.owner.showDialog(type);
            }
            return;
        }
        if (tfToggle == null) {
            if (id instanceof AnnotationDialog) {
                ((AnnotationDialog)id).setVisible(tfToggle != null && ((AnnotationDialog)id).isVisible());
            } else {
                id.setState(!id.getState());
            }
            return;
        }
        id.setState(tfToggle);
    }

    boolean checkIntegral(Parameters parameters, String value) {
        JDXSpectrum spec = this.getSpectrum();
        if (!spec.canIntegrate() || this.reversePlot) {
            return false;
        }
        int iSpec = this.getFixedSelectedSpectrumIndex();
        AnnotationData ad = this.getDialog(Annotation.AType.Integration, -1);
        if (value == null && ad != null) {
            return true;
        }
        switch (IntegralData.IntMode.getMode(value.toUpperCase())) {
            case ON: {
                this.integrate(iSpec, parameters);
                break;
            }
            case OFF: {
                this.integrate(iSpec, null);
                break;
            }
            case TOGGLE: {
                this.integrate(iSpec, ad == null ? parameters : null);
                break;
            }
            case AUTO: {
                if (ad == null) {
                    this.checkIntegral(parameters, "ON");
                    ad = this.getDialog(Annotation.AType.Integration, -1);
                }
                if (ad == null) break;
                ((IntegralData)ad.getData()).autoIntegrate();
                break;
            }
            case LIST: {
                this.pd.owner.showDialog(Annotation.AType.Integration);
                break;
            }
            case MARK: {
                if (ad == null) {
                    this.checkIntegral(parameters, "ON");
                    ad = this.getDialog(Annotation.AType.Integration, -1);
                }
                if (ad == null) break;
                ((IntegralData)ad.getData()).addMarks(value.substring(4).trim());
                break;
            }
            case MIN: {
                if (ad == null) break;
                try {
                    double val = Double.parseDouble(ScriptToken.getTokens(value).get(1));
                    ((IntegralData)ad.getData()).setMinimumIntegral(val);
                }
                catch (Exception exception) {}
                break;
            }
            case UPDATE: {
                if (ad == null) break;
                ((IntegralData)ad.getData()).update(parameters);
            }
        }
        this.updateDialog(Annotation.AType.Integration, -1);
        return true;
    }

    void setSpectrum(int iSpec, boolean fromSplit) {
        if (fromSplit) {
            if (this.nSplit > 1) {
                this.setSpectrumClicked(iSpec);
            }
        } else {
            this.setSpectrumClicked(iSpec);
            this.stackSelected = false;
            this.showAllStacked = false;
        }
    }

    void setSpectrum(JDXSpectrum spec) {
        int pt = this.getFixedSelectedSpectrumIndex();
        this.spectra.remove(pt);
        this.spectra.add(pt, spec);
        this.pendingMeasurement = null;
        this.clearViews();
        this.viewData.newSpectrum(this.spectra);
    }

    void setZoom(double x1, double y1, double x2, double y2) {
        this.setZoomTo(0);
        if (x1 == 0.0 && x2 == 0.0 && y1 == 0.0 && y2 == 0.0) {
            this.newPins();
            this.imageView = null;
            x1 = this.getScale().minXOnScale;
            x2 = this.getScale().maxXOnScale;
        } else {
            this.doZoom(x1, y1, x2, y2, true, y1 != y2, false, true, true);
        }
    }

    boolean shiftSpectrum(double dx, double x1) {
        JDXSpectrum spec = this.getSpectrum();
        if (!spec.isNMR() || !spec.is1D()) {
            return false;
        }
        if (x1 == Double.MAX_VALUE || dx == Double.MAX_VALUE) {
            dx = -spec.addSpecShift(0.0);
        } else {
            if (x1 == Double.MIN_VALUE) {
                this.nextClickForSetPeak = true;
                this.pd.owner.showMessage("Click on or beside a peak to set its chemical shift.", "Set Reference");
                return false;
            }
            if (Double.isNaN(dx) || dx == Double.MIN_VALUE) {
                double x0;
                double d = x0 = dx == Double.MIN_VALUE ? this.lastClickX : this.getNearestPeak(spec, this.lastClickX, this.toY(this.pd.mouseY));
                if (Double.isNaN(x0)) {
                    return false;
                }
                if (Double.isNaN(x1)) {
                    try {
                        String s = this.pd.getInput("New chemical shift (set blank to reset)", "Set Reference", "" + x0).trim();
                        x1 = s.length() == 0 ? x0 - spec.addSpecShift(0.0) : Double.parseDouble(s);
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                dx = x1 - x0;
            }
        }
        if (dx == 0.0) {
            return false;
        }
        spec.addSpecShift(dx);
        if (this.annotations != null) {
            int i = this.annotations.size();
            while (--i >= 0) {
                if (this.annotations.get((int)i).spec != spec) continue;
                this.annotations.get(i).addSpecShift(dx);
            }
        }
        if (this.dialogs != null) {
            for (Map.Entry<String, AnnotationData> e : this.dialogs.entrySet()) {
                if (e.getValue().getSpectrum() != spec) continue;
                e.getValue().addSpecShift(dx);
            }
        }
        this.getScale().addSpecShift(dx);
        if (!Double.isNaN(this.lastClickX)) {
            this.lastClickX += dx;
        }
        this.updateDialogs();
        this.doZoom(0.0, this.getScale().minYOnScale, 0.0, this.getScale().maxYOnScale, true, true, false, true, false);
        this.pd.repaint();
        return true;
    }

    void toPeak(int istep) {
        Coordinate coord;
        JDXSpectrum spec;
        int iPeak;
        istep *= this.drawXAxisLeftToRight ? 1 : -1;
        if (Double.isNaN(this.lastClickX)) {
            this.lastPixelX = 0;
            this.lastClickX = 0;
        }
        if ((iPeak = (spec = this.getSpectrum()).setNextPeak(coord = this.setCoordClicked(this.lastPixelX, this.lastClickX, 0.0), istep)) < 0) {
            return;
        }
        PeakInfo peak = spec.getPeakList().get(iPeak);
        spec.setSelectedPeak(peak);
        this.setCoordClicked(peak.getXPixel(), peak.getX(), 0.0);
        this.pd.notifyPeakPickedListeners(new PeakPickEvent(this.pd.owner, this.pd.coordClicked, peak));
    }

    void scaleSelectedBy(double f) {
        int i = this.bsSelected.nextSetBit(0);
        while (i >= 0) {
            this.viewData.scaleSpectrum(i, f);
            i = this.bsSelected.nextSetBit(i + 1);
        }
    }

    public String toString() {
        return "gs: " + this.nSpectra + " " + this.spectra + " " + this.spectra.get(0).getFilePath();
    }

    void setXPointer(JDXSpectrum spec, double x) {
        if (spec != null) {
            this.setSpectrumClicked(this.getSpectrumIndex(spec));
        }
        this.xValueMovedTo = this.lastClickX = x;
        this.lastPixelX = this.toPixelX(x);
        this.setXPixelMovedTo(x, Double.MAX_VALUE, 0, 0);
        this.yValueMovedTo = Double.NaN;
    }

    void setXPointer2(JDXSpectrum spec, double x) {
        if (spec != null) {
            this.setSpectrumClicked(this.getSpectrumIndex(spec));
        }
        this.setXPixelMovedTo(Double.MAX_VALUE, x, 0, 0);
    }

    boolean hasCurrentMeasurement(Annotation.AType type) {
        return (type == Annotation.AType.Integration ? this.selectedSpectrumIntegrals : this.selectedSpectrumMeasurements) != null;
    }

    AnnotationData getDialog(Annotation.AType type, int iSpec) {
        if (iSpec == -1) {
            iSpec = this.getCurrentSpectrumIndex();
        }
        if (this.dialogs == null || iSpec < 0) {
            return null;
        }
        return this.dialogs.get((Object)((Object)type) + "_" + iSpec);
    }

    void removeDialog(int iSpec, Annotation.AType type) {
        if (this.dialogs == null || iSpec < 0) {
            return;
        }
        this.dialogs.remove((Object)((Object)type) + "_" + iSpec);
    }

    void addDialog(int iSpec, Annotation.AType type, AnnotationData dialog) {
        if (iSpec < 0) {
            iSpec = this.getSpectrumIndex(dialog.getSpectrum());
            dialog = null;
        }
        if (this.dialogs == null) {
            this.dialogs = new Hashtable<String, AnnotationData>();
        }
        String key = (Object)((Object)type) + "_" + iSpec;
        dialog.setKey(key);
        this.dialogs.put(key, dialog);
    }

    void removeDialog(AnnotationDialog dialog) {
        String key = dialog.getKey();
        this.dialogs.remove(key);
        MeasurementData data = dialog.getData();
        if (data != null) {
            this.dialogs.put(key, data);
        }
    }

    public MeasurementData getPeakListing(int iSpec, Parameters p, boolean forceNew) {
        if (iSpec < 0) {
            iSpec = this.getCurrentSpectrumIndex();
        }
        if (iSpec < 0) {
            return null;
        }
        AnnotationData dialog = this.getDialog(Annotation.AType.PeakList, -1);
        if (dialog == null) {
            if (!forceNew) {
                return null;
            }
            dialog = new PeakData(Annotation.AType.PeakList, this.getSpectrum());
            this.addDialog(iSpec, Annotation.AType.PeakList, dialog);
        }
        ((PeakData)dialog.getData()).setPeakList(p, null, this.viewData.getScale());
        if (dialog instanceof AnnotationDialog) {
            ((AnnotationDialog)dialog).setFields();
        }
        return dialog.getData();
    }

    public void setPeakListing(Boolean tfToggle) {
        boolean isON;
        AnnotationDialog ad;
        AnnotationData dialog = this.getDialog(Annotation.AType.PeakList, -1);
        AnnotationDialog annotationDialog = ad = dialog instanceof AnnotationDialog ? (AnnotationDialog)dialog : null;
        boolean bl = tfToggle == null ? ad == null || !ad.isVisible() : (isON = tfToggle.booleanValue());
        if (isON) {
            this.pd.owner.showDialog(Annotation.AType.PeakList);
        } else if (dialog instanceof AnnotationDialog) {
            ((AnnotationDialog)dialog).setVisible(false);
        }
    }

    boolean haveIntegralDisplayed(int i) {
        AnnotationData ad = this.getDialog(Annotation.AType.Integration, i);
        return ad != null && ad.getState();
    }

    IntegralData getIntegrationGraph(int i) {
        AnnotationData ad = this.getDialog(Annotation.AType.Integration, i);
        return ad == null ? null : (IntegralData)ad.getData();
    }

    public void setIntegrationRatios(String value) {
        int iSpec = this.getFixedSelectedSpectrumIndex();
        if (this.aIntegrationRatios == null) {
            this.aIntegrationRatios = new Object[this.nSpectra];
        }
        this.aIntegrationRatios[iSpec] = IntegralData.getIntegrationRatiosFromString(this.getSpectrum(), value);
    }

    ArrayList<Annotation> getIntegrationRatios(int i) {
        return (ArrayList)(this.aIntegrationRatios == null ? null : this.aIntegrationRatios[i]);
    }

    boolean integrate(int iSpec, Parameters parameters) {
        JDXSpectrum spec = this.getSpectrumAt(iSpec);
        if (parameters == null || !spec.canIntegrate()) {
            this.removeDialog(iSpec, Annotation.AType.Integration);
            return false;
        }
        this.addDialog(iSpec, Annotation.AType.Integration, new IntegralData(spec, parameters));
        return true;
    }

    public IntegralData getIntegration(int iSpec, Parameters p, boolean forceNew) {
        if (iSpec < 0) {
            iSpec = this.getCurrentSpectrumIndex();
        }
        if (iSpec < 0) {
            return null;
        }
        AnnotationData dialog = this.getDialog(Annotation.AType.Integration, -1);
        if (dialog == null) {
            if (!forceNew) {
                return null;
            }
            this.addDialog(iSpec, Annotation.AType.Integration, new IntegralData(this.getSpectrum(), p));
        }
        return (IntegralData)dialog.getData();
    }

    public Map<String, Object> getMeasurementInfo(Annotation.AType type, int iSpec) {
        MeasurementData md;
        switch (type) {
            case PeakList: {
                md = this.getPeakListing(iSpec, null, false);
                break;
            }
            case Integration: {
                md = this.getIntegration(iSpec, null, false);
                break;
            }
            default: {
                return null;
            }
        }
        if (md == null) {
            return null;
        }
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        md.getInfo(info);
        return info;
    }

    Map<String, Object> getInfo(String key, int iSpec) {
        Hashtable<String, Object> spectraInfo = new Hashtable<String, Object>();
        if ("viewInfo".equalsIgnoreCase(key)) {
            return this.getScale().getInfo(spectraInfo);
        }
        ArrayList<Map<String, Object>> specInfo = new ArrayList<Map<String, Object>>();
        spectraInfo.put("spectra", specInfo);
        int i = 0;
        while (i < this.nSpectra) {
            if (iSpec < 0 || i == iSpec) {
                JDXSpectrum spec = this.spectra.get(i);
                Map<String, Object> info = spec.getInfo(key);
                if (iSpec >= 0 && key != null && (info.size() == 2 || key.equalsIgnoreCase("id"))) {
                    if (info.size() == 2) {
                        info.remove("id");
                    }
                    return info;
                }
                Parameters.putInfo(key, info, "type", spec.getDataType());
                Parameters.putInfo(key, info, "titleLabel", spec.getTitleLabel());
                Parameters.putInfo(key, info, "filePath", spec.getFilePath().replace('\\', '/'));
                Parameters.putInfo(key, info, "PeakList", Parameters.isMatch(key, "PeakList") ? this.getMeasurementInfo(Annotation.AType.PeakList, i) : null);
                Parameters.putInfo(key, info, "Integration", Parameters.isMatch(key, "Integration") ? this.getMeasurementInfo(Annotation.AType.Integration, i) : null);
                if (iSpec >= 0) {
                    return info;
                }
                specInfo.add(info);
            }
            ++i;
        }
        return spectraInfo;
    }

    String getTitle(boolean forPrinting) {
        return this.nSpectra == 1 || this.iSpectrumSelected >= 0 && (!forPrinting || this.nSplit == 1) ? this.getSpectrum().getTitle() : null;
    }

    public ScaleData getCurrentView() {
        this.setScale(this.getFixedSelectedSpectrumIndex());
        return this.viewData.getScale();
    }

    public void set2DXY(double x, double y, boolean isLocked) {
        if (this.gs2dLinkedX != null) {
            this.cur1D2x1.setX(x, this.toPixelX(x));
        }
        if (this.gs2dLinkedY != null) {
            this.cur1D2x2.setX(y, this.toPixelX(y));
        }
        this.cur1D2Locked = isLocked;
    }

    public void dialogsToFront() {
        if (this.dialogs == null) {
            return;
        }
        for (Map.Entry<String, AnnotationData> e : this.dialogs.entrySet()) {
            AnnotationData ad = e.getValue();
            if (!this.isVisible(ad)) continue;
            ((AnnotationDialog)ad).setVisible(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ArrowType {
        LEFT,
        RIGHT,
        UP,
        DOWN,
        RESET,
        HOME;

    }

    private class Highlight {
        double x1;
        double x2;
        Object color;
        JDXSpectrum spectrum;

        public String toString() {
            return "highlight " + this.x1 + " " + this.x2 + " " + this.spectrum;
        }

        Highlight(double x1, double x2, JDXSpectrum spec, Object color) {
            this.x1 = x1;
            this.x2 = x2;
            this.color = color;
            this.spectrum = spec;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Highlight)) {
                return false;
            }
            Highlight hl = (Highlight)obj;
            return hl.x1 == this.x1 && hl.x2 == this.x2;
        }
    }
}

