/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import jspecview.common.Annotation;
import jspecview.common.AwtAnnotationDialog;
import jspecview.common.AwtPanel;
import jspecview.common.AwtPrintLayoutDialog;
import jspecview.common.JSVFileFilter;
import jspecview.common.JSVPanel;
import jspecview.common.PanelData;
import jspecview.common.PrintLayout;
import jspecview.common.ScriptInterface;
import jspecview.export.Exporter;
import jspecview.util.JSVBase64;
import jspecview.util.JSVFileManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogHelper {
    private String thisKey;
    private ActionListener eventListener;
    private Map<String, Object> options;
    private JPanel leftPanel;
    private Insets buttonInsets = new Insets(5, 5, 5, 5);
    private Insets cbInsets = new Insets(0, 0, 2, 2);
    private int iRow;
    private ScriptInterface si;
    private PrintLayout lastPrintLayout;
    private JFileChooser fc;
    public String dirLastOpened;
    public boolean useDirLastOpened;
    public boolean useDirLastExported;
    public String dirLastExported;

    public DialogHelper(ScriptInterface si) {
        this.si = si;
    }

    public DialogHelper(String thisKey, Map<String, Object> options, JPanel leftPanel, ActionListener eventListener) {
        this.thisKey = thisKey;
        this.options = options;
        this.leftPanel = leftPanel;
        this.eventListener = eventListener;
    }

    protected void addButton(JButton selectAllButton) {
        this.leftPanel.add((Component)selectAllButton, new GridBagConstraints(0, this.iRow++, 3, 1, 0.0, 0.0, 10, 0, this.buttonInsets, 0, 0));
    }

    protected JTextField addInputOption(String name, String label, String value, String units, String defaultValue, boolean visible) {
        String key = String.valueOf(this.thisKey) + "_" + name;
        if (value == null && (value = (String)this.options.get(key)) == null) {
            value = defaultValue;
            this.options.put(key, value);
        }
        JTextField obj = new JTextField(value);
        if (visible) {
            obj.setPreferredSize(new Dimension(75, 25));
            obj.addActionListener(this.eventListener);
            this.addPanelLine(name, label, obj, units);
        }
        return obj;
    }

    protected JComboBox<String> addSelectOption(String name, String label, String[] info, int iPt, boolean visible) {
        JComboBox<String> obj = new JComboBox<String>(info);
        obj.setSelectedIndex(iPt);
        if (visible) {
            obj.setActionCommand(name);
            obj.addActionListener(this.eventListener);
            this.addPanelLine(name, label, obj, null);
        }
        return obj;
    }

    private void addPanelLine(String name, String label, JComponent obj, String units) {
        this.leftPanel.add((Component)new JLabel(label == null ? name : label), new GridBagConstraints(0, this.iRow, 1, 1, 0.0, 0.0, 13, 0, this.cbInsets, 0, 0));
        if (units == null) {
            this.leftPanel.add((Component)obj, new GridBagConstraints(1, this.iRow, 2, 1, 0.0, 0.0, 17, 0, this.cbInsets, 0, 0));
        } else {
            this.leftPanel.add((Component)obj, new GridBagConstraints(1, this.iRow, 1, 1, 0.0, 0.0, 10, 0, this.cbInsets, 0, 0));
            this.leftPanel.add((Component)new JLabel(units), new GridBagConstraints(2, this.iRow, 1, 1, 0.0, 0.0, 17, 0, this.cbInsets, 0, 0));
        }
        ++this.iRow;
    }

    protected synchronized JTable getDataTable(AwtAnnotationDialog ad, String[][] data, String[] columnNames, int[] columnWidths, int height) {
        LegendTableModel tableModel = new LegendTableModel(columnNames, data);
        JTable table = new JTable(tableModel);
        table.setSelectionMode(0);
        table.setDefaultRenderer(String.class, new TitleRenderer());
        table.setCellSelectionEnabled(true);
        table.getSelectionModel().addListSelectionListener(ad);
        ad.columnSelector = table.getColumnModel().getSelectionModel();
        ad.columnSelector.addListSelectionListener(ad);
        int n = 0;
        int i = 0;
        while (i < columnNames.length) {
            table.getColumnModel().getColumn(i).setPreferredWidth(columnWidths[i]);
            n += columnWidths[i];
            ++i;
        }
        table.setPreferredScrollableViewportSize(new Dimension(n, height));
        return table;
    }

    private void saveImage(JSVPanel jsvp, Exporter.ExportType itype) {
        this.setFileChooser(itype);
        String name = this.getSuggestedFileName(itype);
        File file = this.getFile(name, (Component)((Object)jsvp), true);
        if (file == null) {
            return;
        }
        Image image = ((Component)((Object)jsvp)).createImage(jsvp.getWidth(), jsvp.getHeight());
        ((Component)((Object)jsvp)).paint(image.getGraphics());
        try {
            ImageIO.write((RenderedImage)((Object)image), itype.toString().toLowerCase(), file);
        }
        catch (IOException e) {
            jsvp.showMessage(e.getMessage(), "Error Saving Image");
        }
    }

    public String print(Frame frame, String pdfFileName) {
        String printJobTitle;
        ByteArrayOutputStream os;
        String s;
        PrintLayout pl;
        JSVPanel jsvp;
        boolean isBase64;
        block10: {
            if (!this.si.isSigned()) {
                return "Error: Applet must be signed for the PRINT command.";
            }
            boolean isJob = pdfFileName == null || pdfFileName.length() == 0;
            isBase64 = !isJob && pdfFileName.toLowerCase().startsWith("base64");
            jsvp = this.si.getSelectedPanel();
            if (jsvp == null) {
                return null;
            }
            jsvp.getPanelData().closeAllDialogsExcept(Annotation.AType.NONE);
            pl = new AwtPrintLayoutDialog(frame, this.lastPrintLayout, isJob).getPrintLayout();
            if (pl == null) {
                return null;
            }
            this.lastPrintLayout = pl;
            if (isJob && pl.asPDF) {
                isJob = false;
                pdfFileName = "PDF";
            }
            if (!isBase64 && !isJob) {
                File file;
                this.setFileChooser(Exporter.ExportType.PDF);
                if (pdfFileName.equals("?") || pdfFileName.equalsIgnoreCase("PDF")) {
                    pdfFileName = this.getSuggestedFileName(Exporter.ExportType.PDF);
                }
                if ((file = this.getFile(pdfFileName, (Component)((Object)jsvp), true)) == null) {
                    return null;
                }
                this.dirLastExported = file.getParent();
                this.si.setProperty("directoryLastExporteFile", this.dirLastExported);
                pdfFileName = file.getAbsolutePath();
            }
            s = null;
            os = isJob ? null : (isBase64 ? new ByteArrayOutputStream() : new FileOutputStream(pdfFileName));
            printJobTitle = jsvp.getPanelData().getPrintJobTitle(true);
            if (!pl.showTitle || (printJobTitle = jsvp.getInput("Title?", "Title for Printing", printJobTitle)) != null) break block10;
            return null;
        }
        try {
            ((AwtPanel)jsvp).printPanel(pl, os, printJobTitle);
            s = isBase64 ? JSVBase64.getBase64(os.toByteArray()).toString() : "OK";
        }
        catch (Exception e) {
            jsvp.showMessage(e.getMessage(), "File Error");
        }
        return s;
    }

    public void setFileChooser(Exporter.ExportType imode) {
        if (this.fc == null) {
            this.fc = new JFileChooser();
        }
        JSVFileFilter filter = new JSVFileFilter();
        this.fc.resetChoosableFileFilters();
        switch (imode) {
            case UNK: {
                filter = new JSVFileFilter();
                filter.addExtension("xml");
                filter.addExtension("aml");
                filter.addExtension("cml");
                filter.setDescription("CML/XML Files");
                this.fc.setFileFilter(filter);
                filter = new JSVFileFilter();
                filter.addExtension("jdx");
                filter.addExtension("dx");
                filter.setDescription("JCAMP-DX Files");
                this.fc.setFileFilter(filter);
                break;
            }
            case SOURCE: 
            case DIF: 
            case FIX: 
            case SQZ: 
            case PAC: 
            case XY: 
            case DIFDUP: {
                filter.addExtension("jdx");
                filter.addExtension("dx");
                filter.setDescription("JCAMP-DX Files");
                break;
            }
            default: {
                filter.addExtension(imode.toString().toLowerCase());
                filter.setDescription((Object)((Object)imode) + " Files");
            }
        }
        this.fc.setFileFilter(filter);
    }

    public File showFileOpenDialog(Frame frame) {
        this.setFileChooser(Exporter.ExportType.UNK);
        return this.getFile("", frame, false);
    }

    public void exportSpectrum(JFrame frame, String type) {
        JSVPanel jsvp = this.si.getSelectedPanel();
        if (jsvp == null) {
            return;
        }
        Exporter.ExportType itype = Exporter.ExportType.getType(type);
        switch (itype) {
            case PDF: {
                this.print(frame, "PDF");
                break;
            }
            case PNG: 
            case JPG: {
                this.saveImage(jsvp, itype);
                break;
            }
            default: {
                this.setFileChooser(itype);
                Exporter.exportSpectrum(this.si, frame, this, type);
                jsvp.getFocusNow(true);
            }
        }
    }

    public File getFile(String name, Component c, boolean isSave) {
        int returnVal;
        this.fc.setSelectedFile(new File(name));
        if (isSave) {
            if (this.useDirLastExported) {
                this.fc.setCurrentDirectory(new File(this.dirLastExported));
            }
        } else if (this.useDirLastOpened) {
            this.fc.setCurrentDirectory(new File(this.dirLastOpened));
        }
        int n = returnVal = isSave ? this.fc.showSaveDialog(c) : this.fc.showOpenDialog(c);
        if (returnVal != 0) {
            return null;
        }
        File file = this.fc.getSelectedFile();
        if (isSave) {
            int option;
            this.dirLastExported = file.getParent();
            this.si.setProperty("directoryLastExportedFile", this.dirLastExported);
            if (file.exists() && (option = JOptionPane.showConfirmDialog(c, "Overwrite " + file.getName() + "?", "Confirm Overwrite Existing File", 0, 3)) == 1) {
                return null;
            }
        } else {
            this.dirLastOpened = file.getParent();
            this.si.setProperty("directoryLastOpenedFile", this.dirLastOpened);
        }
        return file;
    }

    public String getSuggestedFileName(Exporter.ExportType imode) {
        PanelData pd = this.si.getSelectedPanel().getPanelData();
        String sourcePath = pd.getSpectrum().getFilePath();
        String newName = JSVFileManager.getName(sourcePath);
        int pt = newName.lastIndexOf(".");
        String name = pt < 0 ? newName : newName.substring(0, pt);
        String ext = ".jdx";
        boolean isPrint = false;
        switch (imode) {
            case SOURCE: 
            case DIF: 
            case FIX: 
            case SQZ: 
            case PAC: 
            case XY: 
            case DIFDUP: {
                ext = ".jdx";
                break;
            }
            case AML: {
                ext = ".xml";
                break;
            }
            case PNG: 
            case JPG: 
            case PDF: {
                isPrint = true;
            }
            default: {
                ext = "." + imode.toString().toLowerCase();
            }
        }
        if (this.si.getCurrentSource().isView) {
            name = pd.getPrintJobTitle(isPrint);
        }
        name = String.valueOf(name) + ext;
        return name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LegendTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        String[] columnNames;
        Object[][] data;

        public LegendTableModel(String[] columnNames, String[][] data) {
            this.columnNames = columnNames;
            this.data = data;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return " " + this.data[row][col] + " ";
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }

    class TitleRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public TitleRenderer() {
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object title, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setHorizontalAlignment(column == 0 ? 0 : 4);
            this.setText(title.toString());
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }
}

