/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.List;
import jspecview.common.Annotation;
import jspecview.common.AwtColoredAnnotation;
import jspecview.common.AwtPanel;
import jspecview.common.AwtParameters;
import jspecview.common.GraphSet;
import jspecview.common.ImageView;
import jspecview.common.JDXSpectrum;
import jspecview.common.ScriptToken;
import jspecview.common.ViewData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AwtGraphSet
extends GraphSet {
    private AwtPanel jsvp;
    private BufferedImage image2D;
    private Color[] plotColors;
    private static Color veryLightGrey = new Color(200, 200, 200);
    BasicStroke strokeBasic = new BasicStroke();
    BasicStroke strokeBold = new BasicStroke(2.0f);

    @Override
    protected void disposeImage() {
        this.image2D = null;
        this.jsvp = null;
        this.pd = null;
        this.highlights = null;
        this.plotColors = null;
    }

    AwtGraphSet(AwtPanel jsvp) {
        this.jsvp = jsvp;
        this.pd = jsvp.pd;
    }

    @Override
    protected void initGraphSet(int startIndex, int endIndex) {
        this.setPlotColors(AwtParameters.defaultPlotColors);
        super.initGraphSet(startIndex, endIndex);
    }

    @Override
    void setPlotColors(Object oColors) {
        Color[] colors = (Color[])oColors;
        if (colors.length > this.nSpectra) {
            Color[] tmpPlotColors = new Color[this.nSpectra];
            System.arraycopy(colors, 0, tmpPlotColors, 0, this.nSpectra);
            colors = tmpPlotColors;
        } else if (this.nSpectra > colors.length) {
            Color[] tmpPlotColors = new Color[this.nSpectra];
            int numAdditionColors = this.nSpectra - colors.length;
            System.arraycopy(colors, 0, tmpPlotColors, 0, colors.length);
            int i = 0;
            int j = colors.length;
            while (i < numAdditionColors) {
                tmpPlotColors[j] = AwtGraphSet.generateRandomColor();
                ++i;
                ++j;
            }
            colors = tmpPlotColors;
        }
        this.plotColors = colors;
    }

    private static Color generateRandomColor() {
        int blue;
        int green;
        int red;
        Color randomColor;
        while ((randomColor = new Color(red = (int)(Math.random() * 255.0), green = (int)(Math.random() * 255.0), blue = (int)(Math.random() * 255.0))).equals(Color.blue)) {
        }
        return randomColor;
    }

    @Override
    void setPlotColor0(Object oColor) {
        this.plotColors[0] = (Color)oColor;
    }

    Color getPlotColor(int index) {
        if (index >= this.plotColors.length) {
            return null;
        }
        return this.plotColors[index];
    }

    @Override
    protected void setColor(Object g, ScriptToken whatColor) {
        if (whatColor != null) {
            ((Graphics)g).setColor(whatColor == ScriptToken.PLOTCOLOR ? this.plotColors[0] : this.jsvp.getColor(whatColor));
        }
    }

    @Override
    protected void setPlotColor(Object g, int i) {
        Color c;
        switch (i) {
            case -3: {
                c = veryLightGrey;
                break;
            }
            case -2: {
                c = Color.GRAY;
                break;
            }
            case -1: {
                c = this.jsvp.getColor(ScriptToken.INTEGRALPLOTCOLOR);
                break;
            }
            default: {
                c = this.plotColors[i];
            }
        }
        ((Graphics)g).setColor(c);
    }

    @Override
    protected void draw2DImage(Object g) {
        if (this.imageView != null) {
            ((Graphics)g).drawImage(this.image2D, this.imageView.xPixel0, this.imageView.yPixel0, this.imageView.xPixel0 + this.imageView.xPixels - 1, this.imageView.yPixel0 + this.imageView.yPixels - 1, this.imageView.xView1, this.imageView.yView1, this.imageView.xView2, this.imageView.yView2, null);
        }
    }

    @Override
    protected boolean get2DImage() {
        this.imageView = new ImageView();
        this.imageView.set(((ViewData)this.viewList.get(0)).getScale());
        if (!this.update2dImage(true)) {
            return false;
        }
        this.imageView.resetZoom();
        this.sticky2Dcursor = true;
        return true;
    }

    @Override
    protected boolean update2dImage(boolean isCreation) {
        this.imageView.set(this.viewData.getScale());
        JDXSpectrum spec = this.getSpectrumAt(0);
        int[] buffer = this.imageView.get2dBuffer(spec, !isCreation);
        if (buffer == null) {
            this.image2D = null;
            this.imageView = null;
            return false;
        }
        if (isCreation) {
            buffer = this.imageView.adjustView(spec, this.viewData);
            this.imageView.resetView();
        }
        this.image2D = new BufferedImage(this.imageView.imageWidth, this.imageView.imageHeight, 10);
        WritableRaster raster = this.image2D.getRaster();
        raster.setSamples(0, 0, this.imageView.imageWidth, this.imageView.imageHeight, 0, buffer);
        this.setImageWindow();
        return true;
    }

    @Override
    Annotation getAnnotation(double x, double y, String text, boolean isPixels, boolean is2d, int offsetX, int offsetY) {
        return new AwtColoredAnnotation(this.getSpectrum(), x, y, text, Color.BLACK, isPixels, is2d, offsetX, offsetY);
    }

    @Override
    Annotation getAnnotation(List<String> args, Annotation lastAnnotation) {
        return AwtColoredAnnotation.getAnnotation(this.getSpectrum(), args, (AwtColoredAnnotation)lastAnnotation);
    }

    @Override
    protected void fillBox(Object g, int x0, int y0, int x1, int y1, ScriptToken whatColor) {
        this.setColor(g, whatColor);
        ((Graphics)g).fillRect(Math.min(x0, x1), Math.min(y0, y1), Math.abs(x0 - x1), Math.abs(y0 - y1));
    }

    @Override
    protected void drawTitle(Object g, int height, int width, String title) {
        this.jsvp.drawTitle(g, height, width, title);
    }

    @Override
    protected void drawHandle(Object g, int x, int y, boolean outlineOnly) {
        if (outlineOnly) {
            ((Graphics)g).drawRect(x - 2, y - 2, 4, 4);
        } else {
            ((Graphics)g).fillRect(x - 2, y - 2, 5, 5);
        }
    }

    @Override
    protected void drawLine(Object g, int x0, int y0, int x1, int y1) {
        ((Graphics)g).drawLine(x0, y0, x1, y1);
    }

    @Override
    protected void drawRect(Object g, int x0, int y0, int nx, int ny) {
        ((Graphics)g).drawRect(x0, y0, nx, ny);
    }

    @Override
    protected void setCurrentBoxColor(Object g) {
        ((Graphics)g).setColor(Color.MAGENTA);
    }

    @Override
    protected void drawString(Object g, String s, int x, int y) {
        ((Graphics)g).drawString(s, x, y);
    }

    @Override
    protected int getFontHeight(Object g) {
        return ((Graphics)g).getFontMetrics().getHeight();
    }

    @Override
    protected int getStringWidth(Object g, String s) {
        if (s == null) {
            return 0;
        }
        return ((Graphics)g).getFontMetrics().stringWidth(s);
    }

    @Override
    protected void rotatePlot(Object g, int angle, int x, int y) {
        ((Graphics2D)g).rotate(Math.PI * (double)angle / 180.0, x, y);
    }

    @Override
    protected void setAnnotationColor(Object g, Annotation note, ScriptToken whatColor) {
        if (whatColor != null) {
            this.setColor(g, whatColor);
            return;
        }
        Color color = null;
        if (note instanceof AwtColoredAnnotation) {
            color = ((AwtColoredAnnotation)note).getColor();
        }
        if (color == null) {
            color = Color.BLACK;
        }
        ((Graphics)g).setColor(color);
    }

    @Override
    protected void setColor(Object g, int red, int green, int blue) {
        ((Graphics)g).setColor(new Color(red, green, blue));
    }

    @Override
    protected void setStrokeBold(Object g, boolean tf) {
        ((Graphics2D)g).setStroke(tf ? this.strokeBold : this.strokeBasic);
    }

    @Override
    protected void fillArrow(Object g, GraphSet.ArrowType type, int x, int y, boolean doFill) {
        int f = 1;
        switch (type) {
            case LEFT: 
            case UP: {
                f = -1;
            }
        }
        int[] axPoints = new int[]{x - 5, x - 5, x + 5, x + 5, x + 8, x, x - 8};
        int[] ayPoints = new int[]{y + 5 * f, y - f, y - f, y + 5 * f, y + 5 * f, y + 10 * f, y + 5 * f};
        switch (type) {
            case LEFT: 
            case RIGHT: {
                if (doFill) {
                    ((Graphics)g).fillPolygon(ayPoints, axPoints, 7);
                    break;
                }
                ((Graphics)g).drawPolygon(ayPoints, axPoints, 7);
                break;
            }
            case UP: 
            case DOWN: {
                if (doFill) {
                    ((Graphics)g).fillPolygon(axPoints, ayPoints, 7);
                    break;
                }
                ((Graphics)g).drawPolygon(axPoints, ayPoints, 7);
            }
        }
    }

    @Override
    protected void fillCircle(Object g, int x, int y, boolean doFill) {
        if (doFill) {
            ((Graphics)g).fillOval(x - 4, y - 4, 8, 8);
        } else {
            ((Graphics)g).drawOval(x - 4, y - 4, 8, 8);
        }
    }
}

