/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jspecview.common.Annotation;
import jspecview.common.AnnotationData;
import jspecview.common.AnnotationDialog;
import jspecview.common.AwtDialog;
import jspecview.common.AwtPeakListDialog;
import jspecview.common.DialogHelper;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVPanel;
import jspecview.common.MeasurementData;
import jspecview.common.Parameters;
import jspecview.common.ScriptInterface;
import jspecview.util.JSVTextFormat;

abstract class AwtAnnotationDialog
extends AwtDialog
implements AnnotationDialog,
ListSelectionListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    protected Annotation.AType thisType;
    protected String subType;
    protected ScriptInterface si;
    protected JSVPanel jsvp;
    protected JDXSpectrum spec;
    protected String thisKey;
    private JPanel leftPanel;
    private JPanel rightPanel;
    protected JButton showHideButton;
    private JButton clearButton;
    private JButton applyButton;
    protected static final Map<String, Object> options = new HashMap<String, Object>();
    private Object[] myOptions;
    private String[] unitOptions;
    private String[] formatOptions;
    private Integer unitPtr;
    protected JTextField txtFormat;
    protected JTextField txtFontSize;
    protected JComboBox<String> cmbUnits;
    ActionListener eventListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            AwtAnnotationDialog.this.doEvent(e);
        }
    };
    protected DialogHelper dialogHelper;
    protected JTable dataTable;
    protected String[][] tableData;
    protected boolean addUnits;
    private JSplitPane mainSplitPane;
    private boolean isON = true;
    protected Parameters myParams = new Parameters("MeasurementData");
    protected MeasurementData xyData;
    protected DecimalFormat numberFormatter;
    private String key;
    private int iRowSelected = -1;
    private int iColSelected = -1;
    ListSelectionModel columnSelector;
    protected int iRowColSelected = -1;
    private int lastChanged = 0;

    protected abstract void addControls();

    protected abstract void createData();

    protected abstract void updateValues();

    protected abstract void tableCellSelectedEvent(int var1, int var2);

    protected AwtAnnotationDialog(ScriptInterface si, JDXSpectrum spec, JSVPanel jsvp) {
        this.si = si;
        this.jsvp = jsvp;
        this.spec = spec;
        this.setModal(false);
        this.setPosition((Component)((Object)jsvp), this.getPosXY());
        this.setResizable(true);
    }

    protected void setup() {
        this.getContentPane().removeAll();
        this.subType = this.spec.getTypeLabel();
        this.thisKey = (Object)((Object)this.thisType) + "_" + this.subType;
        this.myOptions = (Object[])options.get(this.thisKey);
        if (this.myOptions == null) {
            this.myOptions = this.spec.getDefaultAnnotationInfo(this.thisType);
            options.put(this.thisKey, this.myOptions);
        }
        this.unitOptions = (String[])this.myOptions[0];
        this.formatOptions = (String[])this.myOptions[1];
        this.unitPtr = (Integer)options.get(String.valueOf(this.thisKey) + "_unitPtr");
        if (this.unitPtr == null) {
            this.unitPtr = (Integer)this.myOptions[2];
        }
        try {
            this.jbInit();
            this.pack();
            this.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.showHideButton = this.newJButton();
        this.showHideButton.setText("Show");
        this.showHideButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JButton b = (JButton)e.getSource();
                AwtAnnotationDialog.this.showHide(b.getText().equals("Show"));
            }
        });
        this.clearButton = this.newJButton();
        this.clearButton.setText("Clear");
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtAnnotationDialog.this.clear();
            }
        });
        this.applyButton = this.newJButton();
        this.applyButton.setText("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtAnnotationDialog.this.applyButtonPressed();
            }
        });
        this.leftPanel = new JPanel(new GridBagLayout());
        this.dialogHelper = new DialogHelper(this.thisKey, options, this.leftPanel, this.eventListener);
        this.addControls();
        this.addTopControls();
        this.leftPanel.setMinimumSize(new Dimension(200, 300));
        this.dialogHelper.addButton(this.applyButton);
        this.dialogHelper.addButton(this.showHideButton);
        if (!(this instanceof AwtPeakListDialog)) {
            this.dialogHelper.addButton(this.clearButton);
        }
        this.dialogHelper = null;
        this.rightPanel = new JPanel();
        JScrollPane scrollPane = new JScrollPane(this.rightPanel);
        this.mainSplitPane = new JSplitPane(1);
        this.mainSplitPane.setOneTouchExpandable(true);
        this.mainSplitPane.setResizeWeight(0.0);
        this.mainSplitPane.setRightComponent(scrollPane);
        this.mainSplitPane.setLeftComponent(this.leftPanel);
        this.setPreferredSize(new Dimension(600, 370));
        this.getContentPane().removeAll();
        this.getContentPane().add(this.mainSplitPane);
        this.checkEnables();
    }

    protected void applyButtonPressed() {
        this.apply();
    }

    protected void checkEnables() {
        boolean isShow = this.si.getSelectedPanel().getPanelData().getShowAnnotation(this.thisType);
        this.showHideButton.setText(isShow ? "Hide" : "Show");
    }

    protected void loadData(String[][] data, String[] header, int[] widths) {
        try {
            this.tableData = data;
            this.rightPanel.removeAll();
            this.dataTable = new DialogHelper(this.si).getDataTable(this, data, header, widths, this.leftPanel.getHeight() - 50);
            JScrollPane scrollPane = new JScrollPane(this.dataTable);
            this.mainSplitPane.setRightComponent(scrollPane);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.validate();
        this.repaint();
    }

    protected JButton newJButton() {
        JButton b = new JButton();
        b.setPreferredSize(new Dimension(120, 25));
        return b;
    }

    private void addTopControls() {
        String key = String.valueOf(this.thisKey) + "_format";
        String format = (String)options.get(key);
        if (format == null) {
            format = this.formatOptions[this.unitPtr == null ? 0 : this.unitPtr];
            options.put(key, format);
        }
        this.txtFormat = this.dialogHelper.addInputOption("numberFormat", "Number Format", format, null, null, false);
        if (this.unitPtr != null) {
            this.cmbUnits = this.dialogHelper.addSelectOption("Units", null, this.unitOptions, this.unitPtr, this.addUnits);
        }
    }

    protected void showHide(boolean isShow) {
        this.setState(isShow);
        if (isShow) {
            this.applyButtonPressed();
        }
        this.jsvp.doRepaint();
        this.checkEnables();
    }

    protected void clear() {
        if (this.xyData != null) {
            this.xyData.clear();
            this.apply();
        }
    }

    protected void done() {
        this.jsvp.getPanelData().removeDialog(this);
        if (this.xyData != null) {
            this.xyData.setState(this.isON);
        }
        this.dispose();
        this.jsvp.doRepaint();
    }

    protected void doEvent(ActionEvent e) {
        if (e.getActionCommand().equals("Units")) {
            this.txtFormat.setText(this.formatOptions[this.cmbUnits.getSelectedIndex()]);
            return;
        }
        if (e.getSource() instanceof JTextField) {
            this.applyButtonPressed();
            return;
        }
    }

    public void reEnable() {
        this.setVisible(true);
        this.setState(true);
        this.apply();
    }

    public void apply() {
        this.updateValues();
        this.checkEnables();
        this.jsvp.doRepaint();
    }

    public boolean getState() {
        return this.isON;
    }

    public void setState(boolean b) {
        this.isON = b;
    }

    public Parameters getParameters() {
        return this.myParams;
    }

    public void setFields() {
    }

    public Annotation.AType getAType() {
        return this.thisType;
    }

    public JDXSpectrum getSpectrum() {
        return this.spec;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public MeasurementData getData() {
        if (this.xyData == null) {
            this.createData();
        }
        return this.xyData;
    }

    public void setData(AnnotationData data) {
        this.myParams = data.getParameters();
        this.xyData = (MeasurementData)data;
    }

    public void addSpecShift(double dx) {
        if (this.xyData != null) {
            this.xyData.addSpecShift(dx);
        }
    }

    protected void setParams() {
        this.myParams.numberFormat = this.txtFormat.getText();
        this.numberFormatter = JSVTextFormat.getDecimalFormat("#" + this.myParams.numberFormat);
    }

    public synchronized void valueChanged(ListSelectionEvent e) {
        try {
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (e.getValueIsAdjusting()) {
                if (lsm == this.columnSelector) {
                    this.iColSelected = lsm.getLeadSelectionIndex();
                    this.lastChanged = 1;
                } else {
                    this.iRowSelected = lsm.getLeadSelectionIndex();
                    this.lastChanged = 2;
                }
                return;
            }
            if (lsm == this.columnSelector != (this.lastChanged == 1)) {
                return;
            }
            int icolrow = this.iRowSelected * 1000 + this.iColSelected;
            if (icolrow != this.iRowColSelected) {
                this.tableCellSelectedEvent(this.iRowSelected, this.iColSelected);
                this.iRowColSelected = icolrow;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void windowActivated(WindowEvent arg0) {
    }

    public void windowClosed(WindowEvent arg0) {
        this.done();
    }

    public void windowClosing(WindowEvent arg0) {
    }

    public void windowDeactivated(WindowEvent arg0) {
    }

    public void windowDeiconified(WindowEvent arg0) {
    }

    public void windowIconified(WindowEvent arg0) {
    }

    public void windowOpened(WindowEvent arg0) {
    }
}

