/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import jspecview.application.AboutDialog;
import jspecview.application.MainFrame;
import jspecview.application.TextDialog;
import jspecview.common.JSVPanel;
import jspecview.common.JSVPanelNode;
import jspecview.common.PanelData;
import jspecview.common.ScriptToken;

public class AppToolBar
extends JToolBar {
    private static final long serialVersionUID = 1L;
    MainFrame mainFrame;
    private JButton previousButton = new JButton();
    private JButton nextButton = new JButton();
    private JButton resetButton = new JButton();
    private JButton clearButton = new JButton();
    private JButton openButton = new JButton();
    private JButton propertiesButton = new JButton();
    private JButton errorLogButton = new JButton();
    JToggleButton gridToggleButton = new JToggleButton();
    JToggleButton coordsToggleButton = new JToggleButton();
    private JButton printButton = new JButton();
    private JToggleButton revPlotToggleButton = new JToggleButton();
    private JButton aboutButton = new JButton();
    private JButton spectraButton = new JButton();
    private JButton overlayKeyButton = new JButton();
    private ImageIcon openIcon;
    private ImageIcon printIcon;
    private ImageIcon gridIcon;
    private ImageIcon coordinatesIcon;
    private ImageIcon reverseIcon;
    private ImageIcon previousIcon;
    private ImageIcon nextIcon;
    private ImageIcon resetIcon;
    private ImageIcon clearIcon;
    private ImageIcon informationIcon;
    private ImageIcon aboutIcon;
    private ImageIcon spectrumIcon;
    private ImageIcon overlayKeyIcon;
    private ImageIcon errorLogIcon;
    private ImageIcon errorLogYellowIcon;
    private ImageIcon errorLogRedIcon;

    public AppToolBar(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.jbInit();
    }

    private void getIcons() {
        Class<?> cl = this.getClass();
        this.openIcon = new ImageIcon(cl.getResource("icons/open24.gif"));
        this.printIcon = new ImageIcon(cl.getResource("icons/print24.gif"));
        this.gridIcon = new ImageIcon(cl.getResource("icons/grid24.gif"));
        this.coordinatesIcon = new ImageIcon(cl.getResource("icons/coords24.gif"));
        this.reverseIcon = new ImageIcon(cl.getResource("icons/reverse24.gif"));
        this.previousIcon = new ImageIcon(cl.getResource("icons/previous24.gif"));
        this.nextIcon = new ImageIcon(cl.getResource("icons/next24.gif"));
        this.resetIcon = new ImageIcon(cl.getResource("icons/reset24.gif"));
        this.clearIcon = new ImageIcon(cl.getResource("icons/clear24.gif"));
        this.informationIcon = new ImageIcon(cl.getResource("icons/information24.gif"));
        this.aboutIcon = new ImageIcon(cl.getResource("icons/about24.gif"));
        this.spectrumIcon = new ImageIcon(cl.getResource("icons/overlay24.gif"));
        this.overlayKeyIcon = new ImageIcon(cl.getResource("icons/overlayKey24.gif"));
        this.errorLogIcon = new ImageIcon(cl.getResource("icons/errorLog24.gif"));
        this.errorLogRedIcon = new ImageIcon(cl.getResource("icons/errorLogRed24.gif"));
        this.errorLogYellowIcon = new ImageIcon(cl.getResource("icons/errorLogYellow24.gif"));
    }

    public void setSelections(JSVPanel jsvp) {
        if (jsvp != null) {
            PanelData pd = jsvp.getPanelData();
            this.gridToggleButton.setSelected(pd.getBoolean(ScriptToken.GRIDON));
            this.coordsToggleButton.setSelected(pd.getBoolean(ScriptToken.COORDINATESON));
            this.revPlotToggleButton.setSelected(pd.getBoolean(ScriptToken.REVERSEPLOT));
        }
    }

    private void jbInit() {
        this.getIcons();
        AppToolBar.setButton(this.previousButton, "Previous View", this.previousIcon, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppToolBar.this.mainFrame.runScript("zoom previous");
            }
        });
        AppToolBar.setButton(this.nextButton, "Next View", this.nextIcon, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppToolBar.this.mainFrame.runScript("zoom next");
            }
        });
        AppToolBar.setButton(this.resetButton, "Reset", this.resetIcon, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppToolBar.this.mainFrame.runScript("zoom out");
            }
        });
        AppToolBar.setButton(this.clearButton, "Clear Views", this.clearIcon, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppToolBar.this.mainFrame.runScript("zoom clear");
            }
        });
        AppToolBar.setButton(this.openButton, "Open", this.openIcon, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppToolBar.this.mainFrame.showFileOpenDialog();
            }
        });
        AppToolBar.setButton(this.propertiesButton, "Properties", this.informationIcon, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppToolBar.this.mainFrame.showProperties();
            }
        });
        AppToolBar.setButton(this.errorLogButton, "Error Log", this.errorLogIcon, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextDialog.showError(AppToolBar.this.mainFrame);
            }
        });
        AppToolBar.setButton(this.gridToggleButton, "Toggle Grid", this.gridIcon, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppToolBar.this.setBoolean(ScriptToken.GRIDON, e);
                AppToolBar.this.mainFrame.requestRepaint();
            }
        });
        AppToolBar.setButton(this.coordsToggleButton, "Toggle Coordinates", this.coordinatesIcon, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppToolBar.this.setBoolean(ScriptToken.COORDINATESON, e);
                AppToolBar.this.mainFrame.requestRepaint();
            }
        });
        AppToolBar.setButton(this.printButton, "Print", this.printIcon, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppToolBar.this.mainFrame.print("");
            }
        });
        AppToolBar.setButton(this.revPlotToggleButton, "Reverse Plot", this.reverseIcon, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppToolBar.this.setBoolean(ScriptToken.REVERSEPLOT, e);
                AppToolBar.this.mainFrame.requestRepaint();
            }
        });
        AppToolBar.setButton(this.aboutButton, "About JSpecView", this.aboutIcon, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new AboutDialog(AppToolBar.this.mainFrame);
            }
        });
        AppToolBar.setButton(this.spectraButton, "Overlay Display", this.spectrumIcon, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppToolBar.this.spectrumButton_actionPerformed(e);
            }
        });
        AppToolBar.setButton(this.overlayKeyButton, "Display Key for Overlaid Spectra", this.overlayKeyIcon, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppToolBar.this.mainFrame.toggleOverlayKey();
            }
        });
        this.overlayKeyButton.setEnabled(false);
        this.add((Component)this.openButton, null);
        this.add((Component)this.printButton, null);
        this.addSeparator();
        this.add((Component)this.gridToggleButton, null);
        this.add((Component)this.coordsToggleButton, null);
        this.add((Component)this.revPlotToggleButton, null);
        this.addSeparator();
        this.add((Component)this.previousButton, null);
        this.add((Component)this.nextButton, null);
        this.add((Component)this.resetButton, null);
        this.add((Component)this.clearButton, null);
        this.addSeparator();
        this.add((Component)this.spectraButton, null);
        this.add((Component)this.overlayKeyButton, null);
        this.addSeparator();
        this.add((Component)this.propertiesButton, null);
        this.add((Component)this.errorLogButton, null);
        this.errorLogButton.setVisible(true);
        this.addSeparator();
        this.add((Component)this.aboutButton, null);
    }

    private static void setButton(AbstractButton button, String tip, ImageIcon icon, ActionListener actionListener) {
        button.setBorder(null);
        button.setToolTipText(tip);
        button.setIcon(icon);
        button.addActionListener(actionListener);
    }

    void setError(boolean isError, boolean isWarningOnly) {
        this.errorLogButton.setIcon(isWarningOnly ? this.errorLogYellowIcon : (isError ? this.errorLogRedIcon : this.errorLogIcon));
        this.errorLogButton.setEnabled(isError);
    }

    protected void setBoolean(ScriptToken st, ActionEvent e) {
        boolean isOn = ((JToggleButton)e.getSource()).isSelected();
        this.mainFrame.runScript((Object)((Object)st) + " " + isOn);
    }

    public void setMenuEnables(JSVPanelNode node) {
        if (node == null) {
            return;
        }
        this.setSelections(node.jsvp);
        this.spectraButton.setIcon(this.spectrumIcon);
        this.spectraButton.setToolTipText("View Spectra");
    }

    protected void spectrumButton_actionPerformed(ActionEvent e) {
        this.mainFrame.checkOverlay();
    }
}

