/*
 * Decompiled with CFR 0.152.
 */
package jspecview.applet;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import jspecview.applet.JSVApplet;
import jspecview.applet.JSVAppletPopupMenu;
import jspecview.application.TextDialog;
import jspecview.common.AwtOverlayLegendDialog;
import jspecview.common.AwtPanel;
import jspecview.common.AwtParameters;
import jspecview.common.Coordinate;
import jspecview.common.DialogHelper;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVAppletInterface;
import jspecview.common.JSVDialog;
import jspecview.common.JSVDropTargetListener;
import jspecview.common.JSVPanel;
import jspecview.common.JSVPanelNode;
import jspecview.common.JSVTree;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PanelListener;
import jspecview.common.Parameters;
import jspecview.common.PeakPickEvent;
import jspecview.common.RepaintManager;
import jspecview.common.ScriptInterface;
import jspecview.common.ScriptToken;
import jspecview.common.ScriptTokenizer;
import jspecview.common.SubSpecChangeEvent;
import jspecview.common.ViewDialog;
import jspecview.common.ViewPanel;
import jspecview.common.ZoomEvent;
import jspecview.export.Exporter;
import jspecview.source.FileReader;
import jspecview.source.JDXSource;
import jspecview.util.JSVEscape;
import jspecview.util.JSVFileManager;
import jspecview.util.JSVLogger;
import jspecview.util.JSVTextFormat;
import netscape.javascript.JSObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSVAppletPrivate
implements PanelListener,
ScriptInterface,
JSVAppletInterface {
    private JSVAppletPopupMenu appletPopupMenu;
    protected Thread commandWatcherThread;
    private JDXSource currentSource;
    private DialogHelper dialogHelper;
    protected JSVApplet jsvApplet;
    private JFrame offWindowFrame;
    private AwtOverlayLegendDialog overlayLegendDialog;
    private List<JSVPanelNode> panelNodes = new ArrayList<JSVPanelNode>();
    private AwtParameters parameters = new AwtParameters("applet");
    private RepaintManager repaintManager;
    private JSVPanel selectedPanel;
    private JSVTree spectraTree;
    private ViewPanel spectrumPanel;
    private ViewDialog viewDialog;
    private String appletID;
    private String fullName;
    private String syncID;
    private int fileCount;
    private int nViews;
    private int scriptLevelCount;
    boolean isNewWindow;
    private JDXSpectrum.IRMode irMode = JDXSpectrum.IRMode.NO_CONVERT;
    private boolean allowCompoundMenu = true;
    private boolean allowMenu = true;
    private boolean autoIntegrate;
    private boolean interfaceOverlaid;
    private boolean loadImaginary = false;
    private Boolean obscureTitleFromUser;
    private int initialStartIndex = -1;
    private int initialEndIndex = -1;
    private String integrationRatios;
    private String appletReadyCallbackFunctionName;
    private String coordCallbackFunctionName;
    private String loadFileCallbackFunctionName;
    private String peakCallbackFunctionName;
    private String syncCallbackFunctionName;
    private DropTargetListener dtl;
    private JSVPanel prevPanel;
    List<String> scriptQueue;
    private String returnFromJmolModel;

    JSVAppletPrivate(JSVApplet jsvApplet) {
        this.jsvApplet = jsvApplet;
        this.repaintManager = new RepaintManager(this);
        this.dialogHelper = new DialogHelper(this);
        this.init();
    }

    @Override
    public boolean isPro() {
        return this.isSigned();
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public JDXSource getCurrentSource() {
        return this.currentSource;
    }

    @Override
    public void setCurrentSource(JDXSource source) {
        this.currentSource = source;
    }

    @Override
    public int getFileCount() {
        return this.fileCount;
    }

    @Override
    public void setFileCount(int n) {
        this.fileCount = n;
    }

    @Override
    public void setIntegrationRatios(String value) {
        this.integrationRatios = value;
    }

    @Override
    public String getIntegrationRatios() {
        return this.integrationRatios;
    }

    @Override
    public void setIRMode(JDXSpectrum.IRMode mode) {
        this.irMode = mode;
    }

    @Override
    public JDXSpectrum.IRMode getIRMode() {
        return this.irMode;
    }

    JSVApplet getJsvApplet() {
        return this.jsvApplet;
    }

    @Override
    public void setLoadImaginary(boolean TF) {
        this.loadImaginary = TF;
    }

    @Override
    public List<JSVPanelNode> getPanelNodes() {
        return this.panelNodes;
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public Object getPopupMenu() {
        return this.appletPopupMenu;
    }

    @Override
    public int incrementScriptLevelCount(int n) {
        return this.scriptLevelCount += n;
    }

    @Override
    public JSVPanel getSelectedPanel() {
        return this.selectedPanel;
    }

    @Override
    public Object getSpectraTree() {
        return this.spectraTree;
    }

    @Override
    public int incrementViewCount(int n) {
        return this.nViews += n;
    }

    void dispose() {
        this.dialogHelper = null;
        try {
            if (this.viewDialog != null) {
                this.viewDialog.dispose();
            }
            this.viewDialog = null;
            if (this.overlayLegendDialog != null) {
                this.overlayLegendDialog.dispose();
            }
            this.overlayLegendDialog = null;
            if (this.commandWatcherThread != null) {
                this.commandWatcherThread.interrupt();
                this.commandWatcherThread = null;
            }
            if (this.panelNodes != null) {
                int i = this.panelNodes.size();
                while (--i >= 0) {
                    this.panelNodes.get(i).dispose();
                    this.panelNodes.remove(i);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, Object> getPropertyAsJavaObject(String key) {
        return JSViewer.getPropertyAsJavaObject(this, key);
    }

    @Override
    public String getPropertyAsJSON(String key) {
        return JSVEscape.toJSON(null, this.getPropertyAsJavaObject(key), false);
    }

    @Override
    public String getCoordinate() {
        return JSViewer.getCoordinate(this);
    }

    @Override
    public void loadInline(String data) {
        this.openDataOrFile(data, null, null, null, -1, -1, true);
        this.jsvApplet.getContentPane().validate();
        this.spectrumPanel.validate();
    }

    @Override
    public String exportSpectrum(String type, int n) {
        return ((AwtPanel)this.getSelectedPanel()).export(type, n);
    }

    @Override
    public void setFilePath(String tmpFilePath) {
        this.runScript("load " + JSVEscape.escape(tmpFilePath));
    }

    @Override
    public void setSpectrumNumber(int n) {
        this.runScript((Object)((Object)ScriptToken.SPECTRUMNUMBER) + " " + n);
    }

    @Override
    public void reversePlot() {
        this.toggle(ScriptToken.REVERSEPLOT);
    }

    @Override
    public void toggleGrid() {
        this.toggle(ScriptToken.GRIDON);
    }

    @Override
    public void toggleCoordinate() {
        this.toggle(ScriptToken.COORDINATESON);
    }

    @Override
    public void toggleIntegration() {
        this.toggle(ScriptToken.INTEGRATE);
    }

    private void toggle(ScriptToken st) {
        JSVPanel jsvp = this.getSelectedPanel();
        if (jsvp != null) {
            this.runScript((Object)((Object)st) + " TOGGLE");
        }
    }

    @Override
    public void addHighlight(double x1, double x2, int r, int g, int b, int a) {
        JSViewer.addHighLight(this, x1, x2, r, g, b, a);
    }

    @Override
    public void removeAllHighlights() {
        JSViewer.removeAllHighlights(this);
    }

    @Override
    public void removeHighlight(double x1, double x2) {
        JSViewer.removeHighlights(this, x1, x2);
    }

    @Override
    public void syncScript(String peakScript) {
        JSViewer.syncScript(this, peakScript);
    }

    @Override
    public void writeStatus(String msg) {
        JSVLogger.info(msg);
    }

    private void init() {
        this.spectraTree = new JSVTree(this);
        this.scriptQueue = new ArrayList<String>();
        this.commandWatcherThread = new Thread(new CommandWatcher());
        this.commandWatcherThread.setName("CommmandWatcherThread");
        this.commandWatcherThread.start();
        this.initParams(this.jsvApplet.getParameter("script"));
        if (this.appletReadyCallbackFunctionName != null && this.fullName != null) {
            this.callToJavaScript(this.appletReadyCallbackFunctionName, new Object[]{this.appletID, this.fullName, Boolean.TRUE, this.jsvApplet});
        }
        if (this.isSigned()) {
            new DropTarget(this.jsvApplet, this.getDropListener());
        }
    }

    private DropTargetListener getDropListener() {
        if (this.dtl == null) {
            this.dtl = new JSVDropTargetListener(this);
        }
        return this.dtl;
    }

    void initParams(String params) {
        this.parseInitScript(params);
        this.newAppletPanel();
        this.appletPopupMenu = new JSVAppletPopupMenu(this, this.allowMenu, this.parameters.getBoolean(ScriptToken.ENABLEZOOM));
        this.runScriptNow(params);
    }

    private void newAppletPanel() {
        JSVLogger.info("newAppletPanel");
        this.jsvApplet.getContentPane().removeAll();
        this.spectrumPanel = new ViewPanel(new BorderLayout());
        this.jsvApplet.getContentPane().add(this.spectrumPanel);
    }

    @Override
    public void sendPanelChange(JSVPanel jsvp) {
        if (jsvp == this.prevPanel) {
            return;
        }
        this.prevPanel = jsvp;
        JSViewer.sendPanelChange(this, jsvp);
    }

    protected void showOverlayKey(boolean visible) {
        JSViewer.setOverlayLegendVisibility(this, this.getSelectedPanel(), visible);
    }

    void showHeader() {
        this.getSelectedPanel().showHeader(this.jsvApplet);
    }

    public void print() {
        this.print("");
    }

    @Override
    public String print(String pdfFileName) {
        boolean needWindow = false;
        if (needWindow) {
            this.newWindow(true);
        }
        String s = this.dialogHelper.print(this.offWindowFrame, pdfFileName);
        if (needWindow) {
            this.newWindow(false);
        }
        return s;
    }

    void newWindow(boolean isSelected) {
        this.isNewWindow = isSelected;
        if (isSelected) {
            this.offWindowFrame = new JFrame("JSpecView");
            this.offWindowFrame.setSize(this.jsvApplet.getSize());
            final Dimension d = this.spectrumPanel.getSize();
            this.offWindowFrame.add(this.spectrumPanel);
            this.offWindowFrame.validate();
            this.offWindowFrame.setVisible(true);
            this.jsvApplet.remove(this.spectrumPanel);
            this.validateAndRepaint();
            this.offWindowFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    JSVAppletPrivate.this.windowClosingEvent(d);
                }
            });
        } else {
            this.jsvApplet.getContentPane().add(this.spectrumPanel);
            this.validateAndRepaint();
            this.offWindowFrame.removeAll();
            this.offWindowFrame.dispose();
            this.offWindowFrame = null;
        }
    }

    protected void windowClosingEvent(Dimension d) {
        this.spectrumPanel.setSize(d);
        this.jsvApplet.getContentPane().add(this.spectrumPanel);
        this.jsvApplet.setVisible(true);
        this.validateAndRepaint();
        this.offWindowFrame.removeAll();
        this.offWindowFrame.dispose();
        this.appletPopupMenu.windowMenuItem.setSelected(false);
        this.isNewWindow = false;
    }

    @Override
    public void repaint() {
        this.jsvApplet.repaint();
    }

    @Override
    public void validateAndRepaint() {
        this.jsvApplet.validate();
        this.jsvApplet.repaint();
    }

    void exportSpectrumViaMenu(String type) {
        if (!this.isSigned()) {
            JSVLogger.info(this.exportSpectrum(type, -1));
            return;
        }
        this.dialogHelper.exportSpectrum(this.offWindowFrame, type);
        this.getSelectedPanel().getFocusNow(true);
    }

    @Override
    public void syncLoad(String filePath) {
        this.newAppletPanel();
        JSVLogger.info("JSVP syncLoad reading " + filePath);
        this.openDataOrFile(null, null, null, filePath, -1, -1, false);
        this.jsvApplet.getContentPane().validate();
        this.spectrumPanel.validate();
    }

    private void callToJavaScript(String callback, Object[] params) {
        try {
            JSObject jso = JSObject.getWindow((Applet)this.jsvApplet);
            if (callback.length() > 0) {
                if (callback.indexOf(".") > 0) {
                    String[] mods = JSVTextFormat.split(callback, '.');
                    int i = 0;
                    while (i < mods.length - 1) {
                        jso = (JSObject)jso.getMember(mods[i]);
                        ++i;
                    }
                    callback = mods[mods.length - 1];
                }
                JSVLogger.info("JSVApplet calling " + jso + " " + callback);
                jso.call(callback, params);
            }
        }
        catch (Exception npe) {
            JSVLogger.warn("EXCEPTION-> " + npe.getMessage());
        }
    }

    private void parseInitScript(String params) {
        if (params == null) {
            params = "";
        }
        ScriptTokenizer allParamTokens = new ScriptTokenizer(params, true);
        if (JSVLogger.debugging) {
            JSVLogger.info("Running in DEBUG mode");
        }
        block17: while (allParamTokens.hasMoreTokens()) {
            String token = allParamTokens.nextToken();
            ScriptTokenizer eachParam = new ScriptTokenizer(token, false);
            String key = eachParam.nextToken();
            if (key.equalsIgnoreCase("SET")) {
                key = eachParam.nextToken();
            }
            key = key.toUpperCase();
            ScriptToken st = ScriptToken.getScriptToken(key);
            String value = ScriptToken.getValue(st, eachParam, token);
            if (JSVLogger.debugging) {
                JSVLogger.info("KEY-> " + key + " VALUE-> " + value + " : " + (Object)((Object)st));
            }
            try {
                switch (st) {
                    default: {
                        this.parameters.set(null, st, value);
                        break;
                    }
                    case UNKNOWN: {
                        break;
                    }
                    case APPLETID: {
                        this.appletID = value;
                        this.fullName = String.valueOf(this.appletID) + "__" + this.syncID + "__";
                        break;
                    }
                    case APPLETREADYCALLBACKFUNCTIONNAME: {
                        this.appletReadyCallbackFunctionName = value;
                        break;
                    }
                    case AUTOINTEGRATE: {
                        this.autoIntegrate = Parameters.isTrue(value);
                        break;
                    }
                    case COMPOUNDMENUON: {
                        this.allowCompoundMenu = Boolean.parseBoolean(value);
                        break;
                    }
                    case COORDCALLBACKFUNCTIONNAME: 
                    case LOADFILECALLBACKFUNCTIONNAME: 
                    case PEAKCALLBACKFUNCTIONNAME: 
                    case SYNCCALLBACKFUNCTIONNAME: {
                        this.execSetCallback(st, value);
                        break;
                    }
                    case ENDINDEX: {
                        this.initialEndIndex = Integer.parseInt(value);
                        break;
                    }
                    case INTERFACE: {
                        this.execSetInterface(value);
                        break;
                    }
                    case IRMODE: {
                        this.irMode = JDXSpectrum.IRMode.getMode(value);
                        break;
                    }
                    case MENUON: {
                        this.allowMenu = Boolean.parseBoolean(value);
                        break;
                    }
                    case OBSCURE: {
                        if (this.obscureTitleFromUser != null) continue block17;
                        this.obscureTitleFromUser = Boolean.valueOf(value);
                        break;
                    }
                    case STARTINDEX: {
                        this.initialStartIndex = Integer.parseInt(value);
                        break;
                    }
                    case SYNCID: {
                        this.syncID = value;
                        this.fullName = String.valueOf(this.appletID) + "__" + this.syncID + "__";
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void openDataOrFile(String data, String name, List<JDXSpectrum> specs, String url, int firstSpec, int lastSpec, boolean isAppend) {
        int status = JSVTree.openDataOrFile(this, data, name, specs, url, firstSpec, lastSpec, isAppend);
        if (status == -1) {
            return;
        }
        if (status != 0) {
            this.setSelectedPanel(null);
            return;
        }
        this.appletPopupMenu.setCompoundMenu(this.panelNodes, this.allowCompoundMenu);
        JSVLogger.info(String.valueOf(this.jsvApplet.getAppletInfo()) + " File " + this.currentSource.getFilePath() + " Loaded Successfully");
    }

    protected void processCommand(String script) {
        this.runScriptNow(script);
    }

    @Override
    public boolean runScriptNow(String params) {
        return JSViewer.runScriptNow(this, params);
    }

    private void checkCallbacks() {
        Coordinate actualCoord;
        if (this.coordCallbackFunctionName == null && this.peakCallbackFunctionName == null) {
            return;
        }
        Coordinate coord = new Coordinate();
        Coordinate coordinate = actualCoord = this.peakCallbackFunctionName == null ? null : new Coordinate();
        if (!this.getSelectedPanel().getPanelData().getPickedCoordinates(coord, actualCoord)) {
            return;
        }
        int iSpec = this.spectrumPanel.getCurrentSpectrumIndex();
        if (actualCoord == null) {
            this.callToJavaScript(this.coordCallbackFunctionName, new Object[]{coord.getXVal(), coord.getYVal(), iSpec + 1});
        } else {
            this.callToJavaScript(this.peakCallbackFunctionName, new Object[]{coord.getXVal(), coord.getYVal(), actualCoord.getXVal(), actualCoord.getYVal(), iSpec + 1});
        }
    }

    @Override
    public void setSelectedPanel(JSVPanel jsvp) {
        this.spectrumPanel.setSelectedPanel(jsvp, this.panelNodes);
        this.selectedPanel = jsvp;
        this.spectraTree.setSelectedPanel(this, jsvp);
        this.jsvApplet.validate();
        if (jsvp != null) {
            jsvp.setEnabled(true);
            jsvp.setFocusable(true);
        }
    }

    void doAdvanced(String filePath) {
    }

    @Override
    public void panelEvent(Object eventObj) {
        if (eventObj instanceof PeakPickEvent) {
            JSViewer.processPeakPickEvent(this, eventObj, false);
        } else if (!(eventObj instanceof ZoomEvent)) {
            boolean cfr_ignored_0 = eventObj instanceof SubSpecChangeEvent;
        }
    }

    @Override
    public void runScript(String script) {
        if (this.scriptQueue == null) {
            this.processCommand(script);
        } else {
            this.scriptQueue.add(script);
        }
    }

    @Override
    public String execExport(JSVPanel jsvp, String value) {
        if (jsvp != null && this.isPro()) {
            this.writeStatus(Exporter.exportCmd(jsvp, ScriptToken.getTokens(value), false));
        }
        return null;
    }

    @Override
    public void execSetCallback(ScriptToken st, String value) {
        switch (st) {
            case LOADFILECALLBACKFUNCTIONNAME: {
                this.loadFileCallbackFunctionName = value;
                break;
            }
            case PEAKCALLBACKFUNCTIONNAME: {
                this.peakCallbackFunctionName = value;
                break;
            }
            case SYNCCALLBACKFUNCTIONNAME: {
                this.syncCallbackFunctionName = value;
                break;
            }
            case COORDCALLBACKFUNCTIONNAME: {
                this.coordCallbackFunctionName = value;
            }
        }
    }

    @Override
    public String getSolnColour() {
        return this.getSelectedPanel().getPanelData().getSolutionColor();
    }

    @Override
    public void execClose(String value, boolean fromScript) {
        JSVTree.close(this, value);
        if (!fromScript) {
            this.validateAndRepaint();
        }
    }

    @Override
    public String execLoad(String value) {
        JSVTree.load(this, value);
        if (this.getSelectedPanel() == null) {
            return null;
        }
        if (this.loadFileCallbackFunctionName != null) {
            this.callToJavaScript(this.loadFileCallbackFunctionName, new Object[]{this.appletID, value});
        }
        return null;
    }

    @Override
    public void execHidden(boolean b) {
    }

    @Override
    public void execSetInterface(String value) {
        this.interfaceOverlaid = value.equalsIgnoreCase("single") || value.equalsIgnoreCase("overlay");
    }

    @Override
    public void execScriptComplete(String msg, boolean isOK) {
        this.validateAndRepaint();
    }

    @Override
    public JSVPanel setSpectrum(String value) {
        return JSVTree.setSpectrum(this, value);
    }

    @Override
    public void execSetAutoIntegrate(boolean b) {
        this.autoIntegrate = b;
    }

    @Override
    public PanelData getPanelData() {
        return this.getSelectedPanel().getPanelData();
    }

    @Override
    public JSVDialog getOverlayLegend(JSVPanel jsvp) {
        this.overlayLegendDialog = new AwtOverlayLegendDialog(null, this.getSelectedPanel());
        return this.overlayLegendDialog;
    }

    @Override
    public synchronized void syncToJmol(String msg) {
        if (this.syncCallbackFunctionName == null) {
            return;
        }
        JSVLogger.info("JSV>Jmol " + msg);
        this.callToJavaScript(this.syncCallbackFunctionName, new Object[]{this.fullName, msg});
    }

    @Override
    public void setVisible(boolean b) {
        this.spectrumPanel.setVisible(b);
    }

    @Override
    public void showProperties() {
        TextDialog.showProperties(this.jsvApplet, this.getPanelData().getSpectrum());
    }

    @Override
    public void updateBoolean(ScriptToken st, boolean TF) {
    }

    @Override
    public void checkCallbacks(String title) {
        this.checkCallbacks();
    }

    @Override
    public JSVPanelNode setOverlayVisibility(JSVPanelNode node) {
        JSViewer.setOverlayLegendVisibility(this, this.getSelectedPanel(), this.appletPopupMenu.overlayKeyMenuItem.isSelected());
        return node;
    }

    @Override
    public void setNode(JSVPanelNode panelNode, boolean fromTree) {
        if (panelNode.jsvp != this.getSelectedPanel()) {
            this.setSelectedPanel(panelNode.jsvp);
        }
        this.sendPanelChange(panelNode.jsvp);
        this.spectrumPanel.validate();
        this.validateAndRepaint();
    }

    @Override
    public void closeSource(JDXSource source) {
        System.out.println("JSVAppletrivate closeSource " + source);
        JSVTree.closeSource(this, source);
    }

    public void process(List<JDXSpectrum> specs) {
        JDXSpectrum.process(specs, this.irMode);
    }

    @Override
    public void setCursorObject(Object c) {
        this.jsvApplet.setCursor((Cursor)c);
    }

    @Override
    public boolean getAutoCombine() {
        return this.interfaceOverlaid;
    }

    @Override
    public URL getDocumentBase() {
        return this.jsvApplet.getDocumentBase();
    }

    @Override
    public JDXSource createSource(String data, String filePath, URL base, int firstSpec, int lastSpec) throws Exception {
        return FileReader.createJDXSource(JSVFileManager.getBufferedReaderForString(data), filePath, base, this.obscureTitleFromUser == Boolean.TRUE, this.loadImaginary, -1, -1);
    }

    @Override
    public JSVPanel getNewJSVPanel(List<JDXSpectrum> specs) {
        AwtPanel jsvp = AwtPanel.getJSVPanel(this, specs, this.initialStartIndex, this.initialEndIndex, this.appletPopupMenu);
        this.initialStartIndex = -1;
        this.initialEndIndex = -1;
        jsvp.getPanelData().addListener(this);
        this.parameters.setFor(jsvp, null, true);
        return jsvp;
    }

    @Override
    public JSVPanel getNewJSVPanel(JDXSpectrum spec) {
        if (spec == null) {
            this.initialStartIndex = -1;
            this.initialEndIndex = -1;
            return null;
        }
        ArrayList<JDXSpectrum> specs = new ArrayList<JDXSpectrum>();
        specs.add(spec);
        AwtPanel jsvp = AwtPanel.getJSVPanel(this, specs, this.initialStartIndex, this.initialEndIndex, this.appletPopupMenu);
        jsvp.getPanelData().addListener(this);
        this.parameters.setFor(jsvp, null, true);
        return jsvp;
    }

    @Override
    public JSVPanelNode getNewPanelNode(String id, String fileName, JDXSource source, JSVPanel jsvp) {
        return new JSVPanelNode(id, fileName, source, jsvp);
    }

    @Override
    public boolean getAutoShowLegend() {
        return false;
    }

    @Override
    public void checkOverlay() {
        if (this.spectrumPanel != null) {
            this.spectrumPanel.markSelectedPanels(this.panelNodes);
        }
        this.viewDialog = new ViewDialog(this, this.spectrumPanel, false);
    }

    @Override
    public void setReturnFromJmolModel(String model) {
        this.returnFromJmolModel = model;
    }

    @Override
    public String getReturnFromJmolModel() {
        return this.returnFromJmolModel;
    }

    @Override
    public void setPropertiesFromPreferences(JSVPanel jsvp, boolean includeMeasures) {
        if (this.autoIntegrate) {
            jsvp.getPanelData().integrateAll(this.parameters);
        }
    }

    @Override
    public void requestRepaint() {
        if (this.getSelectedPanel() != null) {
            this.repaintManager.refresh();
        }
    }

    @Override
    public void repaintCompleted() {
        this.repaintManager.repaintDone();
    }

    @Override
    public void setLoaded(String fileName, String filePath) {
    }

    @Override
    public void setMenuEnables(JSVPanelNode node, boolean isSplit) {
    }

    @Override
    public void setRecentURL(String filePath) {
    }

    @Override
    public void updateRecentMenus(String filePath) {
    }

    @Override
    public void execTest(String value) {
        String data = "##TITLE= Acetophenone\n##JCAMP-DX= 5.01\n##DATA TYPE= MASS SPECTRUM\n##DATA CLASS= XYPOINTS\n##ORIGIN= UWI, Mona, JAMAICA\n##OWNER= public domain\n##LONGDATE= 2012/02/19 22:20:06.0416 -0600 $$ export date from JSpecView\n##BLOCK_ID= 4\n##$URL= http://wwwchem.uwimona.edu.jm/spectra\n##SPECTROMETER/DATA SYSTEM= Finnigan\n##.INSTRUMENT PARAMETERS= LOW RESOLUTION\n##.SPECTROMETER TYPE= TRAP\n##.INLET= GC\n##.IONIZATION MODE= EI+\n##MOLFORM= C 8 H 8 O\n##$MODELS= \n<Models>\n<ModelData id=\"acetophenone\" type=\"MOL\">\nacetophenone\nDSViewer          3D                             0\n\n17 17  0  0  0  0  0  0  0  0999 V2000\n-1.6931    0.0078    0.0000 C   0  0  0  0  0  0  0  0  0  1\n-0.2141    0.0078    0.0000 C   0  0  0  0  0  0  0  0  0  2\n2.5839    0.0872    0.0000 C   0  0  0  0  0  0  0  0  0  3\n0.4615    1.2373   -0.0005 C   0  0  0  0  0  0  0  0  0  4\n0.5257   -1.1809    0.0001 C   0  0  0  0  0  0  0  0  0  5\n1.9188   -1.1393    0.0005 C   0  0  0  0  0  0  0  0  0  6\n1.8539    1.2756   -0.0001 C   0  0  0  0  0  0  0  0  0  7\n-0.1262    2.1703   -0.0009 H   0  0  0  0  0  0  0  0  0  8\n0.0144   -2.1556    0.0002 H   0  0  0  0  0  0  0  0  0  9\n2.4947   -2.0764    0.0009 H   0  0  0  0  0  0  0  0  0 10\n2.3756    2.2439   -0.0001 H   0  0  0  0  0  0  0  0  0 11\n3.6838    0.1161    0.0003 H   0  0  0  0  0  0  0  0  0 12\n-2.3403    1.0639    0.0008 O   0  0  0  0  0  0  0  0  0 13\n-2.3832   -1.3197   -0.0010 C   0  0  0  0  0  0  0  0  0 14\n-2.0973   -1.8988    0.9105 H   0  0  0  0  0  0  0  0  0 15\n-2.0899   -1.9018   -0.9082 H   0  0  0  0  0  0  0  0  0 16\n-3.4920   -1.1799   -0.0059 H   0  0  0  0  0  0  0  0  0 17\n1  2  1  0  0  0\n2  5  4  0  0  0\n2  4  4  0  0  0\n3 12  1  0  0  0\n4  7  4  0  0  0\n5  6  4  0  0  0\n6 10  1  0  0  0\n6  3  4  0  0  0\n7  3  4  0  0  0\n7 11  1  0  0  0\n8  4  1  0  0  0\n9  5  1  0  0  0\n13  1  2  0  0  0\n14 16  1  0  0  0\n14  1  1  0  0  0\n14 15  1  0  0  0\n17 14  1  0  0  0\nM  END\n</ModelData>\n<ModelData id=\"2\" type=\"MOL\">\nacetophenone m/z 120\nDSViewer          3D                             0\n\n17 17  0  0  0  0  0  0  0  0999 V2000\n-1.6931    0.0078    0.0000 C   0  0  0  0  0  0  0  0  0  1\n-0.2141    0.0078    0.0000 C   0  0  0  0  0  0  0  0  0  2\n2.5839    0.0872    0.0000 C   0  0  0  0  0  0  0  0  0  3\n0.4615    1.2373   -0.0005 C   0  0  0  0  0  0  0  0  0  4\n0.5257   -1.1809    0.0001 C   0  0  0  0  0  0  0  0  0  5\n1.9188   -1.1393    0.0005 C   0  0  0  0  0  0  0  0  0  6\n1.8539    1.2756   -0.0001 C   0  0  0  0  0  0  0  0  0  7\n-0.1262    2.1703   -0.0009 H   0  0  0  0  0  0  0  0  0  8\n0.0144   -2.1556    0.0002 H   0  0  0  0  0  0  0  0  0  9\n2.4947   -2.0764    0.0009 H   0  0  0  0  0  0  0  0  0 10\n2.3756    2.2439   -0.0001 H   0  0  0  0  0  0  0  0  0 11\n3.6838    0.1161    0.0003 H   0  0  0  0  0  0  0  0  0 12\n-2.3403    1.0639    0.0008 O   0  0  0  0  0  0  0  0  0 13\n-2.3832   -1.3197   -0.0010 C   0  0  0  0  0  0  0  0  0 14\n-2.0973   -1.8988    0.9105 H   0  0  0  0  0  0  0  0  0 15\n-2.0899   -1.9018   -0.9082 H   0  0  0  0  0  0  0  0  0 16\n-3.4920   -1.1799   -0.0059 H   0  0  0  0  0  0  0  0  0 17\n1  2  1  0  0  0\n2  5  4  0  0  0\n2  4  4  0  0  0\n3 12  1  0  0  0\n4  7  4  0  0  0\n5  6  4  0  0  0\n6 10  1  0  0  0\n6  3  4  0  0  0\n7  3  4  0  0  0\n7 11  1  0  0  0\n8  4  1  0  0  0\n9  5  1  0  0  0\n13  1  2  0  0  0\n14 16  1  0  0  0\n14  1  1  0  0  0\n14 15  1  0  0  0\n17 14  1  0  0  0\nM  END\nacetophenone m/z 105\n\ncreated with ArgusLab version 4.0.1\n13 13  0  0  0  0  0  0  0  0  0 V2000\n-1.6931    0.0078    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n-0.2141    0.0078    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n2.5839    0.0872    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n0.4615    1.2373   -0.0005 C   0  0  0  0  0  0  0  0  0  0  0  0\n0.5257   -1.1809    0.0001 C   0  0  0  0  0  0  0  0  0  0  0  0\n1.9188   -1.1393    0.0005 C   0  0  0  0  0  0  0  0  0  0  0  0\n1.8539    1.2756   -0.0001 C   0  0  0  0  0  0  0  0  0  0  0  0\n-2.3403    1.0639    0.0008 O   0  0  0  0  0  0  0  0  0  0  0  0\n-0.1262    2.1703   -0.0009 H   0  0  0  0  0  0  0  0  0  0  0  0\n0.0144   -2.1556    0.0002 H   0  0  0  0  0  0  0  0  0  0  0  0\n2.4947   -2.0764    0.0009 H   0  0  0  0  0  0  0  0  0  0  0  0\n2.3756    2.2439   -0.0001 H   0  0  0  0  0  0  0  0  0  0  0  0\n3.6838    0.1161    0.0003 H   0  0  0  0  0  0  0  0  0  0  0  0\n1  2  1  0  0  0  0\n1  8  2  0  0  0  0\n2  4  4  0  0  0  0\n2  5  4  0  0  0  0\n3  6  4  0  0  0  0\n3  7  4  0  0  0  0\n3 13  1  0  0  0  0\n4  7  4  0  0  0  0\n4  9  1  0  0  0  0\n5  6  4  0  0  0  0\n5 10  1  0  0  0  0\n6 11  1  0  0  0  0\n7 12  1  0  0  0  0\nM  END\nacetophenone m/z 77\n\ncreated with ArgusLab version 4.0.1\n11 11  0  0  0  0  0  0  0  0  0 V2000\n-0.2141    0.0078    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n2.5839    0.0872    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n0.4615    1.2373   -0.0005 C   0  0  0  0  0  0  0  0  0  0  0  0\n0.5257   -1.1809    0.0001 C   0  0  0  0  0  0  0  0  0  0  0  0\n1.9188   -1.1393    0.0005 C   0  0  0  0  0  0  0  0  0  0  0  0\n1.8539    1.2756   -0.0001 C   0  0  0  0  0  0  0  0  0  0  0  0\n-0.1262    2.1703   -0.0009 H   0  0  0  0  0  0  0  0  0  0  0  0\n0.0144   -2.1556    0.0002 H   0  0  0  0  0  0  0  0  0  0  0  0\n2.4947   -2.0764    0.0009 H   0  0  0  0  0  0  0  0  0  0  0  0\n2.3756    2.2439   -0.0001 H   0  0  0  0  0  0  0  0  0  0  0  0\n3.6838    0.1161    0.0003 H   0  0  0  0  0  0  0  0  0  0  0  0\n1  3  4  0  0  0  0\n1  4  4  0  0  0  0\n2  5  4  0  0  0  0\n2  6  4  0  0  0  0\n2 11  1  0  0  0  0\n3  6  4  0  0  0  0\n3  7  1  0  0  0  0\n4  5  4  0  0  0  0\n4  8  1  0  0  0  0\n5  9  1  0  0  0  0\n6 10  1  0  0  0  0\nM  END\n</ModelData>\n</Models>\n##$PEAKS= \n<Peaks type=\"MS\" xUnits=\"M/Z\" yUnits=\"RELATIVE ABUNDANCE\" >\n<PeakData id=\"1\" title=\"molecular ion (~120)\" peakShape=\"sharp\" model=\"2.1\"  xMax=\"121\" xMin=\"119\"  yMax=\"100\" yMin=\"0\" />\n<PeakData id=\"2\" title=\"fragment 1 (~105)\" peakShape=\"sharp\" model=\"2.2\"  xMax=\"106\" xMin=\"104\"  yMax=\"100\" yMin=\"0\" />\n<PeakData id=\"3\" title=\"fragment 2 (~77)\" peakShape=\"sharp\" model=\"2.3\"  xMax=\"78\" xMin=\"76\"  yMax=\"100\" yMin=\"0\" />\n</Peaks>\n##XUNITS= M/Z\n##YUNITS= RELATIVE ABUNDANCE\n##XFACTOR= 1E0\n##YFACTOR= 1E0\n##FIRSTX= 0\n##FIRSTY= 0\n##LASTX= 121\n##NPOINTS= 19\n##XYPOINTS= (XY..XY)\n0.000000, 0.000000 \n38.000000, 5.200000 \n39.000000, 8.000000 \n43.000000, 21.900000 \n50.000000, 20.200000 \n51.000000, 41.900000 \n52.000000, 4.000000 \n63.000000, 3.800000 \n74.000000, 6.600000 \n75.000000, 3.700000 \n76.000000, 4.600000 \n77.000000, 100.000000 \n78.000000, 10.400000 \n89.000000, 1.000000 \n91.000000, 1.000000 \n105.000000, 80.800000 \n106.000000, 6.000000 \n120.000000, 23.100000 \n121.000000, 2.000000 \n##END=";
        this.loadInline(data);
    }

    @Override
    public void setProperty(String key, String value) {
    }

    @Override
    public String getFileAsString(String value) {
        return JSVFileManager.getFileAsString(value, this.jsvApplet.getDocumentBase());
    }

    class CommandWatcher
    implements Runnable {
        CommandWatcher() {
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            Thread.currentThread().setPriority(1);
            commandDelay = 200;
            while (JSVAppletPrivate.this.commandWatcherThread != null) {
                try {
                    Thread.sleep(commandDelay);
                    if (JSVAppletPrivate.this.commandWatcherThread == null || JSVAppletPrivate.this.scriptQueue.size() <= 0 || (scriptItem = JSVAppletPrivate.this.scriptQueue.remove(0)) == null) continue;
                    JSVAppletPrivate.this.processCommand(scriptItem);
                    continue;
                }
                catch (InterruptedException ie) {
                    JSVLogger.info("CommandWatcher InterruptedException!");
                    break;
                }
                catch (Exception ie) {
                    s = "script processing ERROR:\n\n" + ie.toString();
                    i = 0;
                    ** while (i < ie.getStackTrace().length)
                }
lbl-1000:
                // 1 sources

                {
                    s = String.valueOf(s) + "\n" + ie.getStackTrace()[i].toString();
                    ++i;
                    continue;
                }
lbl19:
                // 1 sources

                JSVLogger.info("CommandWatcher Exception! " + s);
                break;
            }
            JSVAppletPrivate.this.commandWatcherThread = null;
        }
    }
}

