/*
 * Decompiled with CFR 0.152.
 */
package jspecview.applet;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import jspecview.applet.JSVAppletPrivate;
import jspecview.common.AwtPopupMenu;
import jspecview.common.JSVPanelNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JSVAppletPopupMenu
extends AwtPopupMenu {
    JSVAppletPrivate applet;
    private ActionListener exportActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JSVAppletPopupMenu.this.applet.exportSpectrumViaMenu(e.getActionCommand());
        }
    };
    private static final long serialVersionUID = 1L;
    private JMenu aboutMenu = new JMenu();
    private JMenu fileMenu = new JMenu();
    private JMenuItem printMenuItem = new JMenuItem();
    private JMenu saveAsMenu = new JMenu();
    private JMenu viewMenu = new JMenu();
    private JMenu zoomMenu = new JMenu();
    private JMenuItem versionMenuItem = new JMenuItem();
    private JMenuItem headerMenuItem = new JMenuItem();
    JCheckBoxMenuItem windowMenuItem = new JCheckBoxMenuItem();

    JSVAppletPopupMenu(JSVAppletPrivate applet, boolean allowMenu, boolean enableZoom) {
        super(applet);
        this.isApplet = true;
        this.applet = applet;
        super.jbInit();
        if (!allowMenu) {
            this.fileMenu.setEnabled(false);
            this.viewMenu.setEnabled(false);
            this.spectraMenuItem.setEnabled(false);
            this.scriptMenuItem.setEnabled(false);
            this.printMenuItem.setEnabled(false);
        }
        this.zoomMenu.setEnabled(enableZoom);
    }

    @Override
    protected void jbInit() {
    }

    @Override
    protected void setPopupMenu() {
        this.aboutMenu.setText("About");
        this.fileMenu.setText("File");
        this.fileMenu.add(this.saveAsMenu);
        if (this.applet.isSigned()) {
            this.appletExportAsMenu = new JMenu();
            this.fileMenu.add(this.appletExportAsMenu);
        }
        this.appletSaveAsJDXMenu = new JMenu();
        AwtPopupMenu.setMenus(this.saveAsMenu, this.appletSaveAsJDXMenu, this.appletExportAsMenu, this.exportActionListener);
        this.viewMenu.setText("View");
        this.zoomMenu.setText("Zoom");
        this.headerMenuItem.setText("Show Header...");
        this.headerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JSVAppletPopupMenu.this.applet.showHeader();
            }
        });
        this.windowMenuItem.setText("Window");
        this.windowMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JSVAppletPopupMenu.this.applet.newWindow(e.getStateChange() == 1);
            }
        });
        this.overlayKeyMenuItem.setEnabled(false);
        this.overlayKeyMenuItem.setText("Show Overlay Key...");
        this.overlayKeyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JSVAppletPopupMenu.this.overlayKeyMenuItem_actionPerformed();
            }
        });
        this.setOverlayItems();
        this.printMenuItem.setActionCommand("Print");
        this.printMenuItem.setEnabled(this.applet.isSigned());
        this.printMenuItem.setText("Print...");
        this.printMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JSVAppletPopupMenu.this.applet.print();
            }
        });
        this.versionMenuItem.setText("<html><h3>" + this.applet.getJsvApplet().getAppletInfo() + "</h3></html>");
        this.viewMenu.add(this.gridCheckBoxMenuItem);
        this.viewMenu.add(this.coordsCheckBoxMenuItem);
        this.viewMenu.add(this.reversePlotCheckBoxMenuItem);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.headerMenuItem);
        this.viewMenu.add(this.overlayKeyMenuItem);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.windowMenuItem);
        this.zoomMenu.add(this.nextMenuItem);
        this.zoomMenu.add(this.previousMenuItem);
        this.zoomMenu.add(this.resetMenuItem);
        this.zoomMenu.add(this.clearMenuItem);
        this.zoomMenu.add(this.userZoomMenuItem);
        this.aboutMenu.add(this.versionMenuItem);
        this.add(this.fileMenu);
        this.add(this.viewMenu);
        this.add(this.zoomMenu);
        this.add(this.spectraMenuItem);
        this.add(this.overlayStackOffsetMenuItem);
        this.addSeparator();
        this.setProcessingMenu(this);
        this.addSeparator();
        this.add(this.scriptMenuItem);
        this.addSeparator();
        this.add(this.printMenuItem);
        this.addSeparator();
        this.add(this.aboutMenu);
    }

    protected void overlayKeyMenuItem_actionPerformed() {
        this.overlayKeyMenuItem.setSelected(!this.overlayKeyMenuItem.isSelected());
        boolean visible = this.overlayKeyMenuItem.isSelected();
        this.applet.showOverlayKey(visible);
    }

    public void setCompoundMenu(List<JSVPanelNode> panelNodes, boolean allowSelection) {
        this.spectraMenuItem.setEnabled(allowSelection && panelNodes.size() > 1);
        this.spectraMenuItem.setEnabled(true);
    }
}

