/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.xml;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Chapter;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocListener;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementTags;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.MarkupAttributes;
import com.lowagie.text.Meta;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Row;
import com.lowagie.text.Section;
import com.lowagie.text.SimpleTable;
import com.lowagie.text.StringCompare;
import com.lowagie.text.Table;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeMap;

public class XmlWriter
extends DocWriter
implements DocListener {
    public static final byte[] PROLOG = XmlWriter.getISOBytes("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
    public static final byte[] DOCTYPE = XmlWriter.getISOBytes("<!DOCTYPE ITEXT SYSTEM \"");
    public static final byte[] DTD = XmlWriter.getISOBytes("http://itext.sourceforge.net/itext.dtd");
    private static final String[] xmlCode = new String[256];
    private TreeMap itext = new TreeMap(new StringCompare());

    static {
        int i = 0;
        while (i < 10) {
            XmlWriter.xmlCode[i] = "&#00" + i + ";";
            ++i;
        }
        i = 10;
        while (i < 32) {
            XmlWriter.xmlCode[i] = "&#0" + i + ";";
            ++i;
        }
        i = 32;
        while (i < 128) {
            XmlWriter.xmlCode[i] = String.valueOf((char)i);
            ++i;
        }
        XmlWriter.xmlCode[10] = "<newline />\n";
        XmlWriter.xmlCode[34] = "&quot;";
        XmlWriter.xmlCode[39] = "&apos;";
        XmlWriter.xmlCode[38] = "&amp;";
        XmlWriter.xmlCode[60] = "&lt;";
        XmlWriter.xmlCode[62] = "&gt;";
        i = 128;
        while (i < 256) {
            XmlWriter.xmlCode[i] = "&#" + i + ";";
            ++i;
        }
    }

    protected XmlWriter(Document doc, OutputStream os) {
        super(doc, os);
        this.document.addDocListener(this);
        try {
            os.write(PROLOG);
            os.write(DOCTYPE);
            os.write(DTD);
            os.write(34);
            os.write(62);
            os.write(10);
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
    }

    protected XmlWriter(Document doc, OutputStream os, String dtd) {
        super(doc, os);
        this.document.addDocListener(this);
        try {
            os.write(PROLOG);
            os.write(DOCTYPE);
            os.write(XmlWriter.getISOBytes(dtd));
            os.write(34);
            os.write(62);
            os.write(10);
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
    }

    public static XmlWriter getInstance(Document document, OutputStream os) {
        return new XmlWriter(document, os);
    }

    public static XmlWriter getInstance(Document document, OutputStream os, String dtd) {
        return new XmlWriter(document, os, dtd);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean add(Element element) throws DocumentException {
        if (this.pause) {
            return false;
        }
        try {
            switch (element.type()) {
                case 1: {
                    this.itext.put("title", ((Meta)element).content());
                    return true;
                }
                case 2: {
                    this.itext.put("subject", ((Meta)element).content());
                    return true;
                }
                case 3: {
                    this.itext.put("keywords", ((Meta)element).content());
                    return true;
                }
                case 4: {
                    this.itext.put("author", ((Meta)element).content());
                    return true;
                }
            }
            this.write(element, 1);
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public void open() {
        super.open();
        try {
            this.itext.put("producer", "iTextXML by lowagie.com");
            this.itext.put("creationdate", new Date().toString());
            this.writeStart("itext");
            Iterator i = this.itext.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                this.write(key, (String)this.itext.get(key));
            }
            this.os.write(62);
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
    }

    public boolean newPage() throws DocumentException {
        if (this.pause || !this.open) {
            return false;
        }
        try {
            this.writeStart("newpage");
            this.writeEnd();
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public void close() {
        try {
            this.os.write(10);
            this.writeEnd("itext");
            super.close();
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void write(Element element, int indent) throws IOException {
        switch (element.type()) {
            case 10: {
                chunk = (Chunk)element;
                try {
                    image = chunk.getImage();
                    this.write(image, indent);
                    return;
                }
                catch (NullPointerException image) {
                    this.addTabs(indent);
                    attributes = chunk.getAttributes();
                    if (chunk.font().isStandardFont() && attributes == null && !XmlWriter.hasMarkupAttributes(chunk)) {
                        this.write(XmlWriter.encode(chunk.content(), indent));
                        return;
                    }
                    if (attributes != null && attributes.get("NEWPAGE") != null) {
                        this.writeStart("newpage");
                        this.writeEnd();
                        return;
                    }
                    this.writeStart("chunk");
                    if (!chunk.font().isStandardFont()) {
                        this.write(chunk.font());
                    }
                    if (attributes == null) ** GOTO lbl31
                    i = attributes.keySet().iterator();
                    ** while (i.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    key = (String)i.next();
                    if (key.equals("LOCALGOTO") || key.equals("LOCALDESTINATION") || key.equals("GENERICTAG")) {
                        value = (String)attributes.get(key);
                        this.write(key.toLowerCase(), value);
                    }
                    if (!key.equals("SUBSUPSCRIPT")) continue;
                    this.write(key.toLowerCase(), String.valueOf((Float)attributes.get(key)));
                    continue;
                }
lbl31:
                // 2 sources

                if (XmlWriter.hasMarkupAttributes(chunk)) {
                    this.writeMarkupAttributes(chunk);
                }
                this.os.write(62);
                this.write(XmlWriter.encode(chunk.content(), indent));
                this.writeEnd("chunk");
                return;
            }
            case 11: {
                phrase = (Phrase)element;
                this.addTabs(indent);
                this.writeStart("phrase");
                this.write("leading", String.valueOf(phrase.leading()));
                this.write(phrase.font());
                if (XmlWriter.hasMarkupAttributes(phrase)) {
                    this.writeMarkupAttributes(phrase);
                }
                this.os.write(62);
                i = phrase.iterator();
                while (i.hasNext()) {
                    this.write((Element)i.next(), indent + 1);
                }
                this.addTabs(indent);
                this.writeEnd("phrase");
                return;
            }
            case 17: {
                anchor = (Anchor)element;
                this.addTabs(indent);
                this.writeStart("anchor");
                this.write("leading", String.valueOf(anchor.leading()));
                this.write(anchor.font());
                if (anchor.name() != null) {
                    this.write("name", anchor.name());
                }
                if (anchor.reference() != null) {
                    this.write("reference", anchor.reference());
                }
                if (XmlWriter.hasMarkupAttributes(anchor)) {
                    this.writeMarkupAttributes(anchor);
                }
                this.os.write(62);
                i = anchor.iterator();
                while (i.hasNext()) {
                    this.write((Element)i.next(), indent + 1);
                }
                this.addTabs(indent);
                this.writeEnd("anchor");
                return;
            }
            case 12: {
                paragraph = (Paragraph)element;
                this.addTabs(indent);
                this.writeStart("paragraph");
                this.write("leading", String.valueOf(paragraph.leading()));
                this.write(paragraph.font());
                this.write("align", ElementTags.getAlignment(paragraph.alignment()));
                if (paragraph.indentationLeft() != 0.0f) {
                    this.write("indentationleft", String.valueOf(paragraph.indentationLeft()));
                }
                if (paragraph.indentationRight() != 0.0f) {
                    this.write("indentationright", String.valueOf(paragraph.indentationRight()));
                }
                if (XmlWriter.hasMarkupAttributes(paragraph)) {
                    this.writeMarkupAttributes(paragraph);
                }
                this.os.write(62);
                i = paragraph.iterator();
                while (i.hasNext()) {
                    this.write((Element)i.next(), indent + 1);
                }
                this.addTabs(indent);
                this.writeEnd("paragraph");
                return;
            }
            case 13: {
                section = (Section)element;
                this.addTabs(indent);
                this.writeStart("section");
                this.writeSection(section, indent);
                this.writeEnd("section");
                return;
            }
            case 16: {
                chapter = (Chapter)element;
                this.addTabs(indent);
                this.writeStart("chapter");
                if (XmlWriter.hasMarkupAttributes(chapter)) {
                    this.writeMarkupAttributes((MarkupAttributes)chapter);
                }
                this.writeSection(chapter, indent);
                this.writeEnd("chapter");
                return;
            }
            case 14: {
                list = (List)element;
                this.addTabs(indent);
                this.writeStart("list");
                this.write("numbered", String.valueOf(list.isNumbered()));
                this.write("symbolindent", String.valueOf(list.symbolIndent()));
                if (list.first() != 1) {
                    this.write("first", String.valueOf(list.first()));
                }
                if (list.indentationLeft() != 0.0f) {
                    this.write("indentationleft", String.valueOf(list.indentationLeft()));
                }
                if (list.indentationRight() != 0.0f) {
                    this.write("indentationright", String.valueOf(list.indentationRight()));
                }
                if (!list.isNumbered()) {
                    this.write("listsymbol", list.symbol().content());
                }
                this.write(list.symbol().font());
                if (XmlWriter.hasMarkupAttributes(list)) {
                    this.writeMarkupAttributes(list);
                }
                this.os.write(62);
                i = list.getItems().iterator();
                while (i.hasNext()) {
                    this.write((Element)i.next(), indent + 1);
                }
                this.addTabs(indent);
                this.writeEnd("list");
                return;
            }
            case 15: {
                listItem = (ListItem)element;
                this.addTabs(indent);
                this.writeStart("listitem");
                this.write("leading", String.valueOf(listItem.leading()));
                this.write(listItem.font());
                this.write("align", ElementTags.getAlignment(listItem.alignment()));
                if (listItem.indentationLeft() != 0.0f) {
                    this.write("indentationleft", String.valueOf(listItem.indentationLeft()));
                }
                if (listItem.indentationRight() != 0.0f) {
                    this.write("indentationright", String.valueOf(listItem.indentationRight()));
                }
                if (XmlWriter.hasMarkupAttributes(listItem)) {
                    this.writeMarkupAttributes(listItem);
                }
                this.os.write(62);
                i = listItem.iterator();
                while (i.hasNext()) {
                    this.write((Element)i.next(), indent + 1);
                }
                this.addTabs(indent);
                this.writeEnd("listitem");
                return;
            }
            case 20: {
                cell = (Cell)element;
                this.addTabs(indent);
                this.writeStart("cell");
                this.write(cell);
                this.write("horizontalalign", ElementTags.getAlignment(cell.horizontalAlignment()));
                this.write("verticalalign", ElementTags.getAlignment(cell.verticalAlignment()));
                if (cell.cellWidth() != null) {
                    this.write("width", cell.cellWidth());
                }
                if (cell.colspan() != 1) {
                    this.write("colspan", String.valueOf(cell.colspan()));
                }
                if (cell.rowspan() != 1) {
                    this.write("rowspan", String.valueOf(cell.rowspan()));
                }
                if (cell.header()) {
                    this.write("header", String.valueOf(true));
                }
                if (cell.noWrap()) {
                    this.write("nowrap", String.valueOf(true));
                }
                if (cell.leading() != -1.0f) {
                    this.write("leading", String.valueOf(cell.leading()));
                }
                if (XmlWriter.hasMarkupAttributes(cell)) {
                    this.writeMarkupAttributes(cell);
                }
                this.os.write(62);
                i = cell.getElements();
                while (i.hasNext()) {
                    this.write((Element)i.next(), indent + 1);
                }
                this.addTabs(indent);
                this.writeEnd("cell");
                return;
            }
            case 21: {
                row = (Row)element;
                this.addTabs(indent);
                this.writeStart("row");
                if (XmlWriter.hasMarkupAttributes(row)) {
                    this.writeMarkupAttributes(row);
                }
                this.os.write(62);
                i = 0;
                while (i < row.columns()) {
                    cell = (Element)row.getCell(i);
                    if (cell != null) {
                        this.write(cell, indent + 1);
                    }
                    ++i;
                }
                this.addTabs(indent);
                this.writeEnd("row");
                return;
            }
            case 22: {
                try {
                    table = (Table)element;
                }
                catch (ClassCastException cce) {
                    try {
                        table = ((SimpleTable)element).createTable();
                    }
                    catch (BadElementException e) {
                        throw new ExceptionConverter(e);
                    }
                }
                table.complete();
                this.addTabs(indent);
                this.writeStart("table");
                this.write("columns", String.valueOf(table.columns()));
                this.os.write(32);
                this.write("width");
                this.os.write(61);
                this.os.write(34);
                if (!"".equals(table.absWidth())) {
                    this.write(table.absWidth());
                } else {
                    this.write(String.valueOf(table.widthPercentage()));
                    this.write("%");
                }
                this.os.write(34);
                this.write("align", ElementTags.getAlignment(table.alignment()));
                this.write("cellpadding", String.valueOf(table.cellpadding()));
                this.write("cellspacing", String.valueOf(table.cellspacing()));
                this.os.write(32);
                this.write("widths");
                this.os.write(61);
                this.os.write(34);
                widths = table.getProportionalWidths();
                this.write(String.valueOf(widths[0]));
                i = 1;
                while (i < widths.length) {
                    this.write(";");
                    this.write(String.valueOf(widths[i]));
                    ++i;
                }
                this.os.write(34);
                this.write((Rectangle)table);
                if (XmlWriter.hasMarkupAttributes((Element)table)) {
                    this.writeMarkupAttributes((MarkupAttributes)table);
                }
                this.os.write(62);
                iterator = table.iterator();
                while (iterator.hasNext()) {
                    row = (Row)iterator.next();
                    this.write(row, indent + 1);
                }
                this.addTabs(indent);
                this.writeEnd("table");
                return;
            }
            case 29: {
                annotation = (Annotation)element;
                this.addTabs(indent);
                this.writeStart("annotation");
                if (annotation.title() != null) {
                    this.write("title", annotation.title());
                }
                if (annotation.content() != null) {
                    this.write("content", annotation.content());
                }
                if (XmlWriter.hasMarkupAttributes(annotation)) {
                    this.writeMarkupAttributes(annotation);
                }
                this.writeEnd();
                return;
            }
            case 32: 
            case 34: 
            case 35: {
                image = (Image)element;
                if (image.url() == null) {
                    return;
                }
                this.addTabs(indent);
                this.writeStart("image");
                this.write("url", image.url().toString());
                if ((image.alignment() & 2) > 0) {
                    this.write("align", "Right");
                } else if ((image.alignment() & 1) > 0) {
                    this.write("align", "Middle");
                } else {
                    this.write("align", "Left");
                }
                if ((image.alignment() & 8) > 0) {
                    this.write("underlying", String.valueOf(true));
                }
                if ((image.alignment() & 4) > 0) {
                    this.write("textwrap", String.valueOf(true));
                }
                if (image.alt() != null) {
                    this.write("alt", image.alt());
                }
                if (image.hasAbsolutePosition()) {
                    this.write("absolutex", String.valueOf(image.absoluteX()));
                    this.write("absolutey", String.valueOf(image.absoluteY()));
                }
                this.write("plainwidth", String.valueOf(image.plainWidth()));
                this.write("plainheight", String.valueOf(image.plainHeight()));
                if (XmlWriter.hasMarkupAttributes(image)) {
                    this.writeMarkupAttributes(image);
                }
                this.writeEnd();
                return;
            }
        }
    }

    private void writeSection(Section section, int indent) throws IOException {
        Iterator i;
        this.write("numberdepth", String.valueOf(section.numberDepth()));
        this.write("depth", String.valueOf(section.depth()));
        this.write("indent", String.valueOf(section.indentation()));
        if (section.indentationLeft() != 0.0f) {
            this.write("indentationleft", String.valueOf(section.indentationLeft()));
        }
        if (section.indentationRight() != 0.0f) {
            this.write("indentationright", String.valueOf(section.indentationRight()));
        }
        this.os.write(62);
        if (section.title() != null) {
            this.addTabs(indent + 1);
            this.writeStart("title");
            this.write("leading", String.valueOf(section.title().leading()));
            this.write("align", ElementTags.getAlignment(section.title().alignment()));
            if (section.title().indentationLeft() != 0.0f) {
                this.write("indentationleft", String.valueOf(section.title().indentationLeft()));
            }
            if (section.title().indentationRight() != 0.0f) {
                this.write("indentationright", String.valueOf(section.title().indentationRight()));
            }
            this.write(section.title().font());
            this.os.write(62);
            i = section.title().iterator();
            if (section.depth() > 0) {
                i.next();
            }
            while (i.hasNext()) {
                this.write((Element)i.next(), indent + 2);
            }
            this.addTabs(indent + 1);
            this.writeEnd("title");
        }
        i = section.iterator();
        while (i.hasNext()) {
            this.write((Element)i.next(), indent + 1);
        }
        this.addTabs(indent);
    }

    private void write(Rectangle rectangle) throws IOException {
        if (rectangle.borderWidth() != -1.0f) {
            this.write("borderwidth", String.valueOf(rectangle.borderWidth()));
            if (rectangle.hasBorder(4)) {
                this.write("left", String.valueOf(true));
            }
            if (rectangle.hasBorder(8)) {
                this.write("right", String.valueOf(true));
            }
            if (rectangle.hasBorder(1)) {
                this.write("top", String.valueOf(true));
            }
            if (rectangle.hasBorder(2)) {
                this.write("bottom", String.valueOf(true));
            }
        }
        if (rectangle.borderColor() != null) {
            this.write("red", String.valueOf(rectangle.borderColor().getRed()));
            this.write("green", String.valueOf(rectangle.borderColor().getGreen()));
            this.write("blue", String.valueOf(rectangle.borderColor().getBlue()));
        }
        if (rectangle.backgroundColor() != null) {
            this.write("bgred", String.valueOf(rectangle.backgroundColor().getRed()));
            this.write("bggreen", String.valueOf(rectangle.backgroundColor().getGreen()));
            this.write("bgblue", String.valueOf(rectangle.backgroundColor().getBlue()));
        }
    }

    static final String encode(String string, int indent) {
        int n = string.length();
        int pos = 0;
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < n) {
            char character = string.charAt(i);
            switch (character) {
                case ' ': {
                    if (i - pos > 60) {
                        pos = i;
                        buf.append("\n");
                        XmlWriter.addTabs(buf, indent);
                        break;
                    }
                }
                default: {
                    buf.append(xmlCode[character]);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    static final void addTabs(StringBuffer buf, int indent) {
        int i = 0;
        while (i < indent) {
            buf.append("\t");
            ++i;
        }
    }

    private void write(Font font) throws IOException {
        this.write("font", font.getFamilyname());
        if (font.size() != -1.0f) {
            this.write("size", String.valueOf(font.size()));
        }
        if (font.style() != -1) {
            this.os.write(32);
            this.write("fontstyle");
            this.os.write(61);
            this.os.write(34);
            switch (font.style() & 3) {
                case 0: {
                    this.write("normal");
                    break;
                }
                case 1: {
                    this.write("bold");
                    break;
                }
                case 2: {
                    this.write("italic");
                    break;
                }
                case 3: {
                    this.write("bold");
                    this.write(", ");
                    this.write("italic");
                }
            }
            if ((font.style() & 4) > 0) {
                this.write(", ");
                this.write("underline");
            }
            if ((font.style() & 8) > 0) {
                this.write(", ");
                this.write("line-through");
            }
            this.os.write(34);
        }
        if (font.color() != null) {
            this.write("red", String.valueOf(font.color().getRed()));
            this.write("green", String.valueOf(font.color().getGreen()));
            this.write("blue", String.valueOf(font.color().getBlue()));
        }
    }
}

