/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

public class Int2IntHash {
    int entryCount;
    Entry[] entries;

    public Int2IntHash(int n) {
        this.entries = new Entry[n];
    }

    public synchronized int get(int n) {
        Entry[] entryArray = this.entries;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.key == n) {
                return entry.value;
            }
            entry = entry.next;
        }
        return Integer.MIN_VALUE;
    }

    public synchronized void put(int n, int n2) {
        Entry[] entryArray = this.entries;
        int n3 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.key == n) {
                entry.value = n2;
                return;
            }
            entry = entry.next;
        }
        if (this.entryCount > entryArray.length) {
            this.rehash();
        }
        entryArray = this.entries;
        n3 = (n & Integer.MAX_VALUE) % entryArray.length;
        entryArray[n3] = new Entry(n, n2, entryArray[n3]);
        ++this.entryCount;
    }

    private void rehash() {
        Entry[] entryArray = this.entries;
        int n = entryArray.length;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        int n3 = n;
        while (--n3 >= 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.key & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
        this.entries = entryArray2;
    }

    static class Entry {
        int key;
        int value;
        Entry next;

        Entry(int n, int n2, Entry entry) {
            this.key = n;
            this.value = n2;
            this.next = entry;
        }
    }
}

