/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.thread;

import org.jmol.api.MinimizerInterface;
import org.jmol.thread.JmolThread;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class MinimizationThread
extends JmolThread {
    private final MinimizerInterface minimizer;

    public MinimizationThread(MinimizerInterface minimizerInterface, Viewer viewer) {
        this.setViewer(viewer, "MinimizationThread");
        this.minimizer = minimizerInterface;
    }

    protected void run1(int n) throws InterruptedException {
        while (true) {
            switch (n) {
                case -1: {
                    this.lastRepaintTime = this.startTime;
                    if (!this.minimizer.startMinimization()) {
                        return;
                    }
                    this.viewer.startHoverWatcher(false);
                    n = 0;
                    break;
                }
                case 0: {
                    if (!this.minimizer.minimizationOn() || this.checkInterrupted()) {
                        n = -2;
                        break;
                    }
                    this.currentTime = System.currentTimeMillis();
                    int n2 = (int)(this.currentTime - this.lastRepaintTime);
                    int n3 = 33 - n2;
                    if (!this.runSleep(n3, 1)) {
                        return;
                    }
                    n = 1;
                    break;
                }
                case 1: {
                    this.lastRepaintTime = this.currentTime = System.currentTimeMillis();
                    n = this.minimizer.stepMinimization() ? 0 : -2;
                    break;
                }
                case -2: {
                    this.minimizer.endMinimization();
                    this.viewer.startHoverWatcher(true);
                    return;
                }
            }
        }
    }

    protected void oops(Exception exception) {
        if (this.minimizer.minimizationOn()) {
            Logger.error(exception.toString());
        }
    }
}

