/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import org.jmol.api.SymmetryInterface;
import org.jmol.render.CageRenderer;
import org.jmol.shape.Uccage;
import org.jmol.util.BoxInfo;
import org.jmol.util.C;
import org.jmol.util.P3;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.TextFormat;

public class UccageRenderer
extends CageRenderer {
    byte fid;
    private final P3[] verticesT = new P3[8];
    private P3 fset0;
    private P3 cell0;
    private P3 cell1;
    private P3 offset;
    private P3 offsetT;

    public UccageRenderer() {
        int n = 8;
        while (--n >= 0) {
            this.verticesT[n] = new P3();
        }
        this.fset0 = P3.new3(555.0f, 555.0f, 1.0f);
        this.cell0 = new P3();
        this.cell1 = new P3();
        this.offset = new P3();
        this.offsetT = new P3();
    }

    protected void initRenderer() {
        this.tickEdges = BoxInfo.uccageTickEdges;
        this.draw000 = false;
    }

    protected boolean render() {
        this.imageFontScaling = this.viewer.getImageFontScaling();
        this.font3d = this.g3d.getFont3DScaled(((Uccage)this.shape).font3d, this.imageFontScaling);
        int n = this.viewer.getObjectMad(5);
        if (n == 0 || this.viewer.isJmolDataFrame() || this.viewer.isNavigating() && this.viewer.getBoolean(603979888)) {
            return false;
        }
        this.colix = this.viewer.getObjectColix(5);
        boolean bl = C.isColixTranslucent(this.colix);
        if (!this.isExport && bl != this.g3d.isPass2()) {
            return bl;
        }
        this.render1(n);
        return false;
    }

    private void render1(int n) {
        boolean bl;
        this.g3d.setColix(this.colix);
        SymmetryInterface symmetryInterface = this.viewer.getCurrentUnitCell();
        if (symmetryInterface == null) {
            return;
        }
        this.isPolymer = symmetryInterface.isPolymer();
        this.isSlab = symmetryInterface.isSlab();
        P3[] p3Array = symmetryInterface.getUnitCellVertices();
        this.offset.setT(symmetryInterface.getCartesianOffset());
        P3 p3 = symmetryInterface.getUnitCellMultiplier();
        boolean bl2 = bl = p3 != null;
        if (!bl) {
            p3 = this.fset0;
        }
        SimpleUnitCell.ijkToPoint3f((int)p3.x, this.cell0, 0);
        SimpleUnitCell.ijkToPoint3f((int)p3.y, this.cell1, 1);
        if (p3.z < 0.0f) {
            this.cell0.scale(-1.0f / p3.z);
            this.cell1.scale(-1.0f / p3.z);
        }
        P3[] p3Array2 = this.viewer.getAxisPoints();
        boolean bl3 = this.viewer.getObjectMad(1) == 0 || this.viewer.getFloat(0x22000002) < 2.0f || p3Array2 == null;
        P3[] p3Array3 = p3Array2;
        int n2 = (int)this.cell0.x;
        while ((float)n2 < this.cell1.x) {
            int n3 = (int)this.cell0.y;
            while ((float)n3 < this.cell1.y) {
                int n4 = (int)this.cell0.z;
                while ((float)n4 < this.cell1.z) {
                    int n5;
                    int n6;
                    int n7;
                    if (bl) {
                        this.offsetT.set(n2, n3, n4);
                        this.offsetT.scale(Math.abs(p3.z));
                        symmetryInterface.toCartesian(this.offsetT, true);
                        this.offsetT.add(this.offset);
                        p3Array3 = n2 == 0 && n3 == 0 && n4 == 0 ? p3Array2 : null;
                        n7 = bl3 || p3Array3 == null ? 0 : 3;
                        n6 = 255;
                        n5 = 255;
                    } else {
                        this.offsetT.setT(this.offset);
                        n7 = bl3 ? 0 : 3;
                        n6 = 255;
                        n5 = 255;
                    }
                    int n8 = 8;
                    while (--n8 >= 0) {
                        this.verticesT[n8].add2(p3Array[n8], this.offsetT);
                    }
                    this.renderCage(n, this.verticesT, p3Array3, n7, n6, n5, Math.abs(p3.z));
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        if (this.viewer.getBoolean(603979828) && !this.viewer.isPreviewOnly() && !symmetryInterface.isPeriodic()) {
            this.renderInfo(symmetryInterface);
        }
    }

    private String nfformat(float f) {
        return TextFormat.formatDecimal(f, 3);
    }

    private void renderInfo(SymmetryInterface symmetryInterface) {
        if (this.isExport || !this.g3d.setColix(this.viewer.getColixBackgroundContrast())) {
            return;
        }
        this.fid = this.g3d.getFontFidFS("Monospaced", 14.0f * this.imageFontScaling);
        this.g3d.setFontFid(this.fid);
        int n = (int)Math.floor(15.0f * this.imageFontScaling);
        int n2 = (int)Math.floor(5.0f * this.imageFontScaling);
        int n3 = n;
        String string = symmetryInterface.getSpaceGroupName();
        if (this.isPolymer) {
            string = "polymer";
        } else if (this.isSlab) {
            string = "slab";
        }
        if (string != null & !string.equals("-- [--]")) {
            this.g3d.drawStringNoSlab(string, null, n2, n3 += n, 0, (short)0);
        }
        this.g3d.drawStringNoSlab("a=" + this.nfformat(symmetryInterface.getUnitCellInfoType(0)) + "\u00c5", null, n2, n3 += n, 0, (short)0);
        if (!this.isPolymer) {
            this.g3d.drawStringNoSlab("b=" + this.nfformat(symmetryInterface.getUnitCellInfoType(1)) + "\u00c5", null, n2, n3 += n, 0, (short)0);
        }
        if (!this.isPolymer && !this.isSlab) {
            this.g3d.drawStringNoSlab("c=" + this.nfformat(symmetryInterface.getUnitCellInfoType(2)) + "\u00c5", null, n2, n3 += n, 0, (short)0);
        }
        if (!this.isPolymer) {
            if (!this.isSlab) {
                this.g3d.drawStringNoSlab("\u03b1=" + this.nfformat(symmetryInterface.getUnitCellInfoType(3)) + "\u00b0", null, n2, n3 += n, 0, (short)0);
                this.g3d.drawStringNoSlab("\u03b2=" + this.nfformat(symmetryInterface.getUnitCellInfoType(4)) + "\u00b0", null, n2, n3 += n, 0, (short)0);
            }
            this.g3d.drawStringNoSlab("\u03b3=" + this.nfformat(symmetryInterface.getUnitCellInfoType(5)) + "\u00b0", null, n2, n3 += n, 0, (short)0);
        }
    }
}

