/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import org.jmol.api.SymmetryInterface;
import org.jmol.render.ShapeRenderer;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.P3;
import org.jmol.util.P3i;
import org.jmol.util.P4;
import org.jmol.util.V3;

public abstract class MeshRenderer
extends ShapeRenderer {
    protected Mesh mesh;
    protected P3[] vertices;
    protected short[] normixes;
    protected P3i[] screens;
    protected V3[] transformedVectors;
    protected int vertexCount;
    protected float imageFontScaling;
    protected float scalePixelsPerMicron;
    protected int diameter;
    protected float width;
    protected boolean isTranslucent;
    protected boolean frontOnly;
    protected boolean antialias;
    protected boolean haveBsDisplay;
    protected boolean selectedPolyOnly;
    protected boolean isGhostPass;
    protected P4 thePlane;
    protected P3 latticeOffset = new P3();
    protected final P3 pt1f = new P3();
    protected final P3 pt2f = new P3();
    protected final P3i pt1i = new P3i();
    protected P3i pt2i = new P3i();
    protected final P3i pt3i = new P3i();
    protected int exportPass;
    protected boolean needTranslucent;
    private boolean doRender;
    protected boolean volumeRender;
    protected BS bsPolygons;
    protected boolean isTranslucentInherit;
    protected boolean renderLow;
    protected BS bsPolygonsToExport = new BS();

    protected boolean render() {
        this.needTranslucent = false;
        this.antialias = this.g3d.isAntialiased();
        MeshCollection meshCollection = (MeshCollection)this.shape;
        int n = meshCollection.meshCount;
        while (--n >= 0) {
            this.renderMesh(meshCollection.meshes[n]);
        }
        return this.needTranslucent;
    }

    public boolean renderMesh(Mesh mesh) {
        return this.renderMesh2(mesh);
    }

    protected boolean renderMesh2(Mesh mesh) {
        this.mesh = mesh;
        if (!this.setVariables()) {
            return false;
        }
        if (!this.doRender) {
            return mesh.title != null;
        }
        this.latticeOffset.set(0.0f, 0.0f, 0.0f);
        int n = this.vertexCount;
        while (--n >= 0) {
            if (this.vertices[n] == null) continue;
            this.viewer.transformPtScr(this.vertices[n], this.screens[n]);
        }
        if (mesh.lattice == null || mesh.modelIndex < 0) {
            this.render2(this.isExport);
        } else {
            SymmetryInterface symmetryInterface = mesh.unitCell;
            if (symmetryInterface == null) {
                symmetryInterface = this.viewer.getModelUnitCell(mesh.modelIndex);
            }
            if (symmetryInterface == null) {
                symmetryInterface = mesh.getUnitCell();
            }
            if (symmetryInterface != null) {
                P3 p3 = new P3();
                P3i p3i = new P3i();
                P3i p3i2 = P3i.new3((int)mesh.lattice.x, (int)mesh.lattice.y, (int)mesh.lattice.z);
                symmetryInterface.setMinMaxLatticeParameters(p3i, p3i2);
                for (int i = p3i.x; i < p3i2.x; ++i) {
                    for (int j = p3i.y; j < p3i2.y; ++j) {
                        for (int k = p3i.z; k < p3i2.z; ++k) {
                            this.latticeOffset.set(i, j, k);
                            symmetryInterface.toCartesian(this.latticeOffset, false);
                            int n2 = this.vertexCount;
                            while (--n2 >= 0) {
                                p3.setT(this.vertices[n2]);
                                p3.add(this.latticeOffset);
                                this.viewer.transformPtScr(p3, this.screens[n2]);
                            }
                            this.render2(this.isExport);
                        }
                    }
                }
            }
        }
        if (this.screens != null) {
            this.viewer.freeTempScreens(this.screens);
        }
        return true;
    }

    private boolean setVariables() {
        if (this.mesh.visibilityFlags == 0) {
            return false;
        }
        if (this.mesh.bsSlabGhost != null) {
            this.g3d.setColix(this.mesh.slabColix);
        }
        this.isGhostPass = this.mesh.bsSlabGhost != null && (this.isExport ? this.exportPass == 2 : this.g3d.isPass2());
        this.isTranslucentInherit = this.isGhostPass && C.getColixTranslucent3(this.mesh.slabColix, false, 0.0f) == 1;
        boolean bl = this.isTranslucent = this.isGhostPass || C.isColixTranslucent(this.mesh.colix);
        if (this.isTranslucent || this.volumeRender || this.mesh.bsSlabGhost != null) {
            this.needTranslucent = true;
        }
        boolean bl2 = this.doRender = this.setColix(this.mesh.colix) || this.mesh.showContourLines;
        if (!this.doRender || this.isGhostPass && !(this.doRender = this.g3d.setColix(this.mesh.slabColix))) {
            this.vertices = this.mesh.vertices;
            return true;
        }
        P3[] p3Array = this.vertices = this.mesh.scale3d == 0.0f && this.mesh.mat4 == null ? this.mesh.vertices : this.mesh.getOffsetVertices(this.thePlane);
        if (this.mesh.lineData == null) {
            this.vertexCount = this.mesh.vertexCount;
            if (this.vertexCount == 0) {
                return false;
            }
            this.normixes = this.mesh.normixes;
            if (this.normixes == null || this.vertices == null) {
                return false;
            }
            this.haveBsDisplay = this.mesh.bsDisplay != null;
            boolean bl3 = this.selectedPolyOnly = this.isGhostPass || this.mesh.bsSlabDisplay != null;
            this.bsPolygons = this.isGhostPass ? this.mesh.bsSlabGhost : (this.selectedPolyOnly ? this.mesh.bsSlabDisplay : null);
            this.renderLow = !this.isExport && !this.viewer.checkMotionRendering(1073742018);
            this.frontOnly = this.renderLow || !this.viewer.getSlabEnabled() && this.mesh.frontOnly && !this.mesh.isTwoSided && !this.selectedPolyOnly;
            this.screens = this.viewer.allocTempScreens(this.vertexCount);
            if (this.frontOnly) {
                this.transformedVectors = this.g3d.getTransformedVertexVectors();
            }
            if (this.transformedVectors == null) {
                this.frontOnly = false;
            }
        }
        return true;
    }

    protected boolean setColix(short s) {
        if (this.isGhostPass) {
            return true;
        }
        if (this.volumeRender && !this.isTranslucent) {
            s = C.getColixTranslucent3(s, true, 0.8f);
        }
        this.colix = s;
        if (C.isColixLastAvailable(s)) {
            this.g3d.setColor(this.mesh.color);
        }
        return this.g3d.setColix(s);
    }

    protected boolean isPolygonDisplayable(int n) {
        return true;
    }

    protected void render2(boolean bl) {
        this.render2b(bl);
    }

    protected void render2b(boolean bl) {
        if (!this.g3d.setColix(this.isGhostPass ? this.mesh.slabColix : this.colix)) {
            return;
        }
        if (this.renderLow || this.mesh.showPoints || this.mesh.polygonCount == 0) {
            this.renderPoints();
        }
        if (!this.renderLow && (this.isGhostPass ? this.mesh.slabMeshType == 1073742018 : this.mesh.drawTriangles)) {
            this.renderTriangles(false, this.mesh.showTriangles, false);
        }
        if (!this.renderLow && (this.isGhostPass ? this.mesh.slabMeshType == 1073741938 : this.mesh.fillTriangles)) {
            this.renderTriangles(true, this.mesh.showTriangles, bl);
        }
    }

    protected void renderPoints() {
        if (this.mesh.isTriangleSet) {
            int[][] nArray = this.mesh.polygonIndexes;
            BS bS = BSUtil.newBitSet(this.mesh.vertexCount);
            if (this.haveBsDisplay) {
                bS.setBits(0, this.mesh.vertexCount);
                bS.andNot(this.mesh.bsDisplay);
            }
            int n = this.mesh.polygonCount;
            while (--n >= 0) {
                if (!this.isPolygonDisplayable(n)) continue;
                int[] nArray2 = nArray[n];
                if (this.frontOnly && this.transformedVectors[this.normixes[n]].z < 0.0f) continue;
                int n2 = nArray2.length - 1;
                while (--n2 >= 0) {
                    int n3 = nArray2[n2];
                    if (bS.get(n3)) continue;
                    bS.set(n3);
                    if (this.renderLow) {
                        P3i p3i = this.screens[n3];
                        this.g3d.drawPixel(p3i.x, p3i.y, p3i.z);
                        continue;
                    }
                    this.g3d.fillSphereI(4, this.screens[n3]);
                }
            }
            return;
        }
        int n = this.vertexCount;
        while (--n >= 0) {
            if (this.frontOnly && !(this.transformedVectors[this.normixes[n]].z >= 0.0f)) continue;
            this.g3d.fillSphereI(4, this.screens[n]);
        }
    }

    protected void renderTriangles(boolean bl, boolean bl2, boolean bl3) {
        int[][] nArray = this.mesh.polygonIndexes;
        short s = this.colix = this.isGhostPass ? this.mesh.slabColix : this.mesh.colix;
        if (this.isTranslucentInherit) {
            this.colix = C.copyColixTranslucency(this.mesh.slabColix, this.mesh.colix);
        }
        this.g3d.setColix(this.colix);
        if (bl3) {
            if (this.frontOnly && bl) {
                this.frontOnly = false;
            }
            this.bsPolygonsToExport.clearAll();
        }
        int n = this.mesh.polygonCount;
        while (--n >= 0) {
            int n2;
            short s2;
            if (!this.isPolygonDisplayable(n)) continue;
            int[] nArray2 = nArray[n];
            int n3 = nArray2[0];
            int n4 = nArray2[1];
            int n5 = nArray2[2];
            if (this.haveBsDisplay && (!this.mesh.bsDisplay.get(n3) || !this.mesh.bsDisplay.get(n4) || !this.mesh.bsDisplay.get(n5))) continue;
            if (n4 == n5) {
                this.drawLine(n3, n4, bl, this.vertices[n3], this.vertices[n4], this.screens[n3], this.screens[n4]);
                continue;
            }
            if (this.mesh.isTriangleSet) {
                s2 = this.normixes[n];
                if (!this.g3d.isDirectedTowardsCamera(s2)) continue;
                if (bl) {
                    if (bl2) {
                        this.g3d.fillTriangle(this.screens[n3], this.colix, s2, this.screens[n4], this.colix, s2, this.screens[n5], this.colix, s2, 0.1f);
                        continue;
                    }
                    this.g3d.fillTriangle3CN(this.screens[n3], this.colix, s2, this.screens[n4], this.colix, s2, this.screens[n5], this.colix, s2);
                    continue;
                }
                n2 = nArray2[3];
                if (bl2) {
                    n2 = 7;
                }
                if ((n2 & 1) == 1) {
                    this.drawLine(n3, n4, true, this.vertices[n3], this.vertices[n4], this.screens[n3], this.screens[n4]);
                }
                if ((n2 & 2) == 2) {
                    this.drawLine(n4, n5, true, this.vertices[n4], this.vertices[n5], this.screens[n4], this.screens[n5]);
                }
                if ((n2 & 4) != 4) continue;
                this.drawLine(n3, n5, true, this.vertices[n3], this.vertices[n5], this.screens[n3], this.screens[n5]);
                continue;
            }
            s2 = this.normixes[n3];
            short s3 = this.normixes[n4];
            short s4 = this.normixes[n5];
            n2 = this.checkNormals(s2, s3, s4);
            if (bl && n2 != 7) continue;
            switch (nArray2.length) {
                case 3: {
                    if (bl) {
                        if (bl3) {
                            this.bsPolygonsToExport.set(n);
                            break;
                        }
                        if (bl2) {
                            this.g3d.fillTriangle(this.screens[n3], this.colix, s2, this.screens[n4], this.colix, s3, this.screens[n5], this.colix, s4, 0.1f);
                            break;
                        }
                        this.g3d.fillTriangle3CN(this.screens[n3], this.colix, s2, this.screens[n4], this.colix, s3, this.screens[n5], this.colix, s4);
                        break;
                    }
                    this.drawTriangle(this.screens[n3], this.colix, this.screens[n4], this.colix, this.screens[n5], this.colix, n2, 1);
                    break;
                }
                case 4: {
                    int n6 = nArray2[3];
                    short s5 = this.normixes[n6];
                    if (this.frontOnly && (n2 != 7 || this.transformedVectors[s5].z < 0.0f)) break;
                    if (bl) {
                        if (bl3) {
                            this.bsPolygonsToExport.set(n);
                            break;
                        }
                        this.g3d.fillQuadrilateral3i(this.screens[n3], this.colix, s2, this.screens[n4], this.colix, s3, this.screens[n5], this.colix, s4, this.screens[n6], this.colix, s5);
                        break;
                    }
                    this.g3d.drawQuadrilateral(this.colix, this.screens[n3], this.screens[n4], this.screens[n5], this.screens[n6]);
                }
            }
        }
        if (bl3) {
            this.exportSurface(this.colix);
        }
    }

    protected void drawTriangle(P3i p3i, short s, P3i p3i2, short s2, P3i p3i3, short s3, int n, int n2) {
        if (!this.antialias && n2 == 1) {
            this.g3d.drawTriangle3C(p3i, s, p3i2, s2, p3i3, s3, n);
            return;
        }
        if (this.antialias) {
            n2 <<= 1;
        }
        if ((n & 1) == 1) {
            this.g3d.fillCylinderXYZ(s, s2, (byte)1, n2, p3i.x, p3i.y, p3i.z, p3i2.x, p3i2.y, p3i2.z);
        }
        if ((n & 2) == 2) {
            this.g3d.fillCylinderXYZ(s2, s3, (byte)1, n2, p3i2.x, p3i2.y, p3i2.z, p3i3.x, p3i3.y, p3i3.z);
        }
        if ((n & 4) == 4) {
            this.g3d.fillCylinderXYZ(s, s3, (byte)1, n2, p3i.x, p3i.y, p3i.z, p3i3.x, p3i3.y, p3i3.z);
        }
    }

    protected int checkNormals(short s, short s2, short s3) {
        int n = 7;
        if (this.frontOnly) {
            if (this.transformedVectors[s].z < 0.0f) {
                n ^= 1;
            }
            if (this.transformedVectors[s2].z < 0.0f) {
                n ^= 2;
            }
            if (this.transformedVectors[s3].z < 0.0f) {
                n ^= 4;
            }
        }
        return n;
    }

    protected void drawLine(int n, int n2, boolean bl, P3 p3, P3 p32, P3i p3i, P3i p3i2) {
        byte by;
        byte by2 = n != n2 && !bl ? (byte)0 : (by = this.width < 0.0f || (double)this.width == -0.0 || n != n2 && this.isTranslucent ? (byte)2 : 3);
        if (this.width == 0.0f) {
            if (this.diameter == 0) {
                int n3 = this.mesh.diameter > 0 ? this.mesh.diameter : (this.diameter = n == n2 ? 7 : 3);
            }
            if (this.exportType == 1) {
                this.pt1f.setT(p3);
                this.pt1f.add(p32);
                this.pt1f.scale(0.5f);
                this.viewer.transformPtScr(this.pt1f, this.pt1i);
                this.diameter = (int)Math.floor(this.viewer.unscaleToScreen(this.pt1i.z, this.diameter) * 1000.0f);
            }
            if (n == n2) {
                this.g3d.fillSphereI(this.diameter, p3i);
            } else {
                this.g3d.fillCylinder(by, this.diameter, p3i, p3i2);
            }
        } else {
            this.pt1f.setT(p3);
            this.pt1f.add(p32);
            this.pt1f.scale(0.5f);
            this.viewer.transformPtScr(this.pt1f, this.pt1i);
            int n4 = (int)Math.floor(Math.abs(this.width) * 1000.0f);
            this.diameter = (int)(this.exportType == 1 ? (float)n4 : this.viewer.scaleToScreen(this.pt1i.z, n4));
            if (this.diameter == 0) {
                this.diameter = 1;
            }
            this.viewer.transformPt3f(p3, this.pt1f);
            this.viewer.transformPt3f(p32, this.pt2f);
            this.g3d.fillCylinderBits(by, this.diameter, this.pt1f, this.pt2f);
        }
    }

    protected void exportSurface(short s) {
        this.mesh.normals = this.mesh.getNormals(this.vertices, null);
        this.mesh.bsPolygons = this.bsPolygonsToExport;
        this.mesh.offset = this.latticeOffset;
        this.g3d.drawSurface(this.mesh, s);
        this.mesh.normals = null;
        this.mesh.bsPolygons = null;
    }
}

