/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import org.jmol.api.JmolLineReader;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.SB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CifDataReader {
    private JmolLineReader reader;
    private BufferedReader br;
    private String line;
    public String str;
    public int ich;
    public int cch;
    public boolean wasUnQuoted;
    public String strPeeked;
    public int ichPeeked;
    public int fieldCount;
    public String[] loopData;
    public SB fileHeader = new SB();
    private boolean isHeader = true;
    Map<String, Object> data;
    Map<String, Object> allData;

    public CifDataReader(JmolLineReader jmolLineReader) {
        this.reader = jmolLineReader;
    }

    public CifDataReader(BufferedReader bufferedReader) {
        this.br = bufferedReader;
    }

    public String getFileHeader() {
        return this.fileHeader.toString();
    }

    public static Map<String, Object> readCifData(BufferedReader bufferedReader) {
        CifDataReader cifDataReader = new CifDataReader(bufferedReader);
        return cifDataReader.getAllCifData();
    }

    private Map<String, Object> getAllCifData() {
        this.line = "";
        this.allData = new Hashtable<String, Object>();
        JmolList<Hashtable<String, Object>> jmolList = new JmolList<Hashtable<String, Object>>();
        this.allData.put("models", jmolList);
        try {
            String string;
            while ((string = this.getNextToken()) != null) {
                if (string.startsWith("global_") || string.startsWith("data_")) {
                    this.data = new Hashtable<String, Object>();
                    jmolList.addLast((Hashtable<String, Object>)this.data);
                    this.data.put("name", string);
                    continue;
                }
                if (string.startsWith("loop_")) {
                    this.getCifLoopData();
                    continue;
                }
                if (string.indexOf("_") != 0) {
                    Logger.warn("CIF ERROR ? should be an underscore: " + string);
                    continue;
                }
                String string2 = this.getNextToken();
                if (string2 == null) {
                    Logger.warn("CIF ERROR ? end of file; data missing: " + string);
                    continue;
                }
                this.data.put(string, string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.br != null) {
                this.br.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.allData;
    }

    public String readLine() {
        try {
            String string = this.line = this.reader != null ? this.reader.readNextLine() : this.br.readLine();
            if (this.line == null) {
                return null;
            }
            if (this.isHeader) {
                if (this.line.startsWith("#")) {
                    this.fileHeader.append(this.line).appendC('\n');
                } else {
                    this.isHeader = false;
                }
            }
            return this.line;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean getData() throws Exception {
        for (int i = 0; i < this.fieldCount; ++i) {
            this.loopData[i] = this.getNextDataToken();
            if (this.loopData[i] != null) continue;
            return false;
        }
        return true;
    }

    public String getNextToken() throws Exception {
        while (!this.hasMoreTokens()) {
            if (this.setStringNextLine() != null) continue;
            return null;
        }
        return this.nextToken();
    }

    private void setString(String string) {
        this.str = this.line = string;
        this.cch = string == null ? 0 : string.length();
        this.ich = 0;
    }

    private String setStringNextLine() throws Exception {
        this.setString(this.readLine());
        if (this.line == null || this.line.length() == 0) {
            return this.line;
        }
        if (this.line.charAt(0) != ';') {
            if (this.str.startsWith("###non-st#")) {
                this.ich = 10;
            }
            return this.line;
        }
        this.ich = 1;
        String string = '\u0001' + this.line.substring(1) + '\n';
        while (this.readLine() != null) {
            if (this.line.startsWith(";")) {
                string = string.substring(0, string.length() - 1) + '\u0001' + this.line.substring(1);
                break;
            }
            string = string + this.line + '\n';
        }
        this.setString(string);
        return string;
    }

    private boolean hasMoreTokens() {
        if (this.str == null) {
            return false;
        }
        int n = 35;
        while (this.ich < this.cch) {
            char c = this.str.charAt(this.ich);
            n = c;
            if (c != ' ' && n != 9) break;
            ++this.ich;
        }
        return this.ich < this.cch && n != 35;
    }

    private String nextToken() {
        if (this.ich == this.cch) {
            return null;
        }
        int n = this.ich;
        char c = this.str.charAt(n);
        if (c != '\'' && c != '\"' && c != '\u0001') {
            this.wasUnQuoted = true;
            while (this.ich < this.cch && (c = this.str.charAt(this.ich)) != ' ' && c != '\t') {
                ++this.ich;
            }
            if (this.ich == n + 1 && (this.str.charAt(n) == '.' || this.str.charAt(n) == '?')) {
                return "\u0000";
            }
            String string = this.str.substring(n, this.ich);
            return string;
        }
        this.wasUnQuoted = false;
        char c2 = c;
        boolean bl = false;
        while (++this.ich < this.cch) {
            c = this.str.charAt(this.ich);
            if (bl && (c == ' ' || c == '\t')) break;
            bl = c == c2;
        }
        if (this.ich == this.cch) {
            if (bl) {
                return this.str.substring(n + 1, this.ich - 1);
            }
            return this.str.substring(n, this.ich);
        }
        ++this.ich;
        return this.str.substring(n + 1, this.ich - 2);
    }

    public String getNextDataToken() throws Exception {
        String string = this.peekToken();
        if (string == null) {
            return null;
        }
        if (this.wasUnQuoted && (string.charAt(0) == '_' || string.startsWith("loop_") || string.startsWith("data_") || string.startsWith("stop_") || string.startsWith("global_"))) {
            return null;
        }
        return this.getTokenPeeked();
    }

    public String peekToken() throws Exception {
        while (!this.hasMoreTokens()) {
            if (this.setStringNextLine() != null) continue;
            return null;
        }
        int n = this.ich;
        this.strPeeked = this.nextToken();
        this.ichPeeked = this.ich;
        this.ich = n;
        return this.strPeeked;
    }

    public String getTokenPeeked() {
        this.ich = this.ichPeeked;
        return this.strPeeked;
    }

    public String fullTrim(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && "\n\t ".indexOf(string.charAt(n)) >= 0; ++n) {
        }
        while (n < n2 && "\n\t ".indexOf(string.charAt(n2 - 1)) >= 0) {
            --n2;
        }
        return string.substring(n, n2);
    }

    private void getCifLoopData() throws Exception {
        String string;
        JmolList<String> jmolList = new JmolList<String>();
        while ((string = this.peekToken()) != null && string.charAt(0) == '_') {
            string = this.getTokenPeeked();
            jmolList.addLast(string);
            this.data.put(string, new JmolList());
        }
        this.fieldCount = jmolList.size();
        if (this.fieldCount == 0) {
            return;
        }
        this.loopData = new String[this.fieldCount];
        while (this.getData()) {
            for (int i = 0; i < this.fieldCount; ++i) {
                ((JmolList)this.data.get(jmolList.get(i))).addLast(this.loopData[i]);
            }
        }
    }
}

