/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export.image;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.jmol.api.ApiPlatform;
import org.jmol.export.image.GenericCRCEncoder;
import org.jmol.viewer.Viewer;

public class GenericPngEncoder
extends GenericCRCEncoder {
    public static final int FILTER_NONE = 0;
    public static final int FILTER_SUB = 1;
    public static final int FILTER_UP = 2;
    public static final int FILTER_LAST = 2;
    private Object image;
    private int width;
    private int height;
    private boolean encodeAlpha;
    private int filter = 0;
    private int bytesPerPixel;
    private int compressionLevel;
    private String type;
    private Integer transparentColor;
    private ApiPlatform apiPlatform;
    private byte[] scanLines;
    private int byteWidth;

    public static byte[] getBytesType(ApiPlatform apiPlatform, Object object, int n, int n2, String string, int[] nArray) {
        GenericPngEncoder genericPngEncoder = new GenericPngEncoder(apiPlatform, object, false, 0, n);
        genericPngEncoder.type = (string + "0000").substring(0, 4);
        if (n2 != 0) {
            genericPngEncoder.transparentColor = n2;
        }
        return genericPngEncoder.pngEncode(nArray);
    }

    public GenericPngEncoder(ApiPlatform apiPlatform, Object object, boolean bl, int n, int n2) {
        this.apiPlatform = apiPlatform;
        this.image = object;
        this.compressionLevel = n2 >= 0 && n2 <= 9 ? n2 : 0;
    }

    private byte[] pngEncode(int[] nArray) {
        byte[] byArray = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        if (this.image == null) {
            return null;
        }
        this.width = this.apiPlatform.getImageWidth(this.image);
        this.height = this.apiPlatform.getImageHeight(this.image);
        this.writeBytes(byArray);
        this.writeHeader();
        nArray[0] = this.bytePos + 4;
        this.writeText(GenericPngEncoder.getJmolTypeText(this.type, 0, 0));
        this.writeText("Software\u0000Jmol " + Viewer.getJmolVersion());
        this.writeText("Creation Time\u0000" + this.apiPlatform.getDateFormat());
        if (!this.encodeAlpha && this.transparentColor != null) {
            this.writeTransparentColor(this.transparentColor);
        }
        return !this.writeImageData() ? null : this.getBytes();
    }

    public static void setJmolTypeText(int n, byte[] byArray, int n2, int n3, String string) {
        String string2 = "iTXt" + GenericPngEncoder.getJmolTypeText(string, n2, n3);
        GenericCRCEncoder genericCRCEncoder = new GenericCRCEncoder();
        genericCRCEncoder.setData(byArray, n);
        genericCRCEncoder.writeString(string2);
        genericCRCEncoder.writeCRC();
    }

    private static String getJmolTypeText(String string, int n, int n2) {
        String string2 = "000000000" + n;
        string2 = string2.substring(string2.length() - 9);
        String string3 = "000000000" + n2;
        string3 = string3.substring(string3.length() - 9);
        return "Jmol Type\u0000" + string + (string.equals("PNG") ? "0" : "") + string2 + "+" + string3;
    }

    private void writeHeader() {
        this.writeInt4(13);
        this.startPos = this.bytePos;
        this.writeString("IHDR");
        this.writeInt4(this.width);
        this.writeInt4(this.height);
        this.writeByte(8);
        this.writeByte(this.encodeAlpha ? 6 : 2);
        this.writeByte(0);
        this.writeByte(0);
        this.writeByte(0);
        this.writeCRC();
    }

    private void writeText(String string) {
        this.writeInt4(string.length());
        this.startPos = this.bytePos;
        this.writeString("iTXt" + string);
        this.writeCRC();
    }

    private void writeTransparentColor(int n) {
        this.writeInt4(6);
        this.startPos = this.bytePos;
        this.writeString("tRNS");
        this.writeInt2(n >> 16 & 0xFF);
        this.writeInt2(n >> 8 & 0xFF);
        this.writeInt2(n & 0xFF);
        this.writeCRC();
    }

    private boolean writeImageData() {
        this.bytesPerPixel = this.encodeAlpha ? 4 : 3;
        this.byteWidth = this.width * this.bytesPerPixel;
        int n = this.byteWidth + 1;
        int n2 = 0;
        Deflater deflater = new Deflater(this.compressionLevel);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
        try {
            int n3;
            for (int i = this.height; i > 0; i -= n3) {
                n3 = Math.max(1, Math.min(Short.MAX_VALUE / n, i));
                this.scanLines = new byte[n * n3];
                int n4 = this.width * n3;
                int[] nArray = new int[n4];
                if ((nArray = this.apiPlatform.grabPixels(this.image, this.width, this.height, nArray, n2, n3)) == null) {
                    return false;
                }
                int n5 = 0;
                for (int j = 0; j < n4; ++j) {
                    if (j % this.width == 0) {
                        this.scanLines[n5++] = (byte)this.filter;
                    }
                    this.scanLines[n5++] = (byte)(nArray[j] >> 16 & 0xFF);
                    this.scanLines[n5++] = (byte)(nArray[j] >> 8 & 0xFF);
                    this.scanLines[n5++] = (byte)(nArray[j] & 0xFF);
                    if (!this.encodeAlpha) continue;
                    this.scanLines[n5++] = (byte)(nArray[j] >> 24 & 0xFF);
                }
                deflaterOutputStream.write(this.scanLines, 0, n5);
                n2 += n3;
            }
            deflaterOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.writeInt4(byArray.length);
            this.startPos = this.bytePos;
            this.writeString("IDAT");
            this.writeBytes(byArray);
            this.writeCRC();
            this.writeEnd();
            deflater.finish();
            return true;
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
            return false;
        }
    }

    private void writeEnd() {
        this.writeInt4(0);
        this.startPos = this.bytePos;
        this.writeString("IEND");
        this.writeCRC();
    }
}

