/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import org.jmol.util.ArrayUtil;
import org.jmol.util.MeshSurface;
import org.jmol.util.P3;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;

class MeshData {
    MeshData() {
    }

    static MeshSurface getCircleData() {
        int n = 10;
        int n2 = 360 / n;
        int n3 = n2 + 1;
        int[][] nArray = ArrayUtil.newInt2(n2);
        for (int i = 0; i < n2; ++i) {
            nArray[i] = new int[]{i, (i + 1) % n2, n2};
        }
        Tuple3f[] tuple3fArray = new P3[n3];
        Tuple3f[] tuple3fArray2 = new P3[n3];
        for (int i = 0; i < n2; ++i) {
            float f = (float)Math.cos((double)(i * n) / 180.0 * Math.PI);
            float f2 = (float)Math.sin((double)(i * n) / 180.0 * Math.PI);
            tuple3fArray[i] = P3.new3(f, f2, 0.0f);
            tuple3fArray2[i] = P3.new3(0.0f, 0.0f, 1.0f);
        }
        tuple3fArray[n2] = P3.new3(0.0f, 0.0f, 0.0f);
        tuple3fArray2[n2] = P3.new3(0.0f, 0.0f, 1.0f);
        return MeshSurface.newMesh(false, tuple3fArray, 0, nArray, tuple3fArray2, 0);
    }

    static MeshSurface getTriangleData(P3 p3, P3 p32, P3 p33) {
        Tuple3f[] tuple3fArray = new P3[]{p3, p32, p33};
        V3 v3 = new V3();
        V3 v32 = new V3();
        v3.setT(p33);
        v3.sub(p3);
        v32.setT(p32);
        v32.sub(p3);
        v32.cross(v32, v3);
        v32.normalize();
        Tuple3f[] tuple3fArray2 = new V3[]{v32, v32, v32};
        int[][] nArrayArray = new int[][]{{0, 1, 2}};
        return MeshSurface.newMesh(false, tuple3fArray, 0, nArrayArray, tuple3fArray2, 0);
    }

    static MeshSurface getConeData() {
        int n = 10;
        int n2 = 360 / n;
        Tuple3f[] tuple3fArray = new P3[n2 + 1];
        int[][] nArray = ArrayUtil.newInt2(n2);
        for (int i = 0; i < n2; ++i) {
            nArray[i] = new int[]{i, (i + 1) % n2, n2};
        }
        double d = (double)n / 180.0 * Math.PI;
        for (int i = 0; i < n2; ++i) {
            float f = (float)Math.cos((double)i * d);
            float f2 = (float)Math.sin((double)i * d);
            tuple3fArray[i] = P3.new3(f, f2, 0.0f);
        }
        tuple3fArray[n2] = P3.new3(0.0f, 0.0f, 1.0f);
        return MeshSurface.newMesh(false, tuple3fArray, 0, nArray, tuple3fArray, 0);
    }

    static MeshSurface getCylinderData(boolean bl) {
        float f;
        float f2;
        int n;
        int n2 = 10;
        int n3 = 360 / n2 * 2;
        int n4 = n3 / 2;
        int[][] nArray = ArrayUtil.newInt2(n3);
        int n5 = -1;
        for (int i = 0; i < n4; ++i) {
            if (bl) {
                nArray[++n5] = new int[]{i + n4, (i + 1) % n4, i};
                nArray[++n5] = new int[]{i + n4, (i + 1) % n4 + n4, (i + 1) % n4};
                continue;
            }
            nArray[++n5] = new int[]{i, (i + 1) % n4, i + n4};
            nArray[++n5] = new int[]{(i + 1) % n4, (i + 1) % n4 + n4, i + n4};
        }
        Tuple3f[] tuple3fArray = new P3[n3];
        Tuple3f[] tuple3fArray2 = new P3[n3];
        for (n = 0; n < n4; ++n) {
            f2 = (float)Math.cos((double)(n * n2) / 180.0 * Math.PI);
            f = (float)Math.sin((double)(n * n2) / 180.0 * Math.PI);
            tuple3fArray[n] = P3.new3(f2, f, 0.0f);
            tuple3fArray2[n] = P3.new3(f2, f, 0.0f);
        }
        for (n = 0; n < n4; ++n) {
            f2 = (float)Math.cos(((double)n + 0.5) * (double)n2 / 180.0 * Math.PI);
            f = (float)Math.sin(((double)n + 0.5) * (double)n2 / 180.0 * Math.PI);
            tuple3fArray[n + n4] = P3.new3(f2, f, 1.0f);
            tuple3fArray2[n + n4] = tuple3fArray2[n];
        }
        if (bl) {
            for (n = 0; n < n4; ++n) {
                tuple3fArray2[n].scale(-1.0f);
            }
        }
        return MeshSurface.newMesh(false, tuple3fArray, 0, nArray, tuple3fArray2, 0);
    }

    static class Data {
        private int[][] faces;
        private Tuple3f[] normals;
        private int nVertices;
        private int nNormals;

        Data() {
        }

        int[][] getFaces() {
            return this.faces;
        }

        int getVertexCount() {
            return this.nVertices;
        }

        int getNormalCount() {
            return this.nNormals;
        }

        Tuple3f[] getNormals() {
            return this.normals;
        }
    }
}

