/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapterBondIterator;
import org.jmol.util.BS;

class BondIterator
extends JmolAdapterBondIterator {
    private BS bsAtoms;
    private Bond[] bonds;
    private int ibond;
    private Bond bond;
    private int bondCount;

    BondIterator(AtomSetCollection atomSetCollection) {
        this.bsAtoms = atomSetCollection.bsAtoms;
        this.bonds = atomSetCollection.getBonds();
        this.bondCount = atomSetCollection.getBondCount();
        this.ibond = 0;
    }

    public boolean hasNext() {
        if (this.ibond == this.bondCount) {
            return false;
        }
        while ((this.bond = this.bonds[this.ibond++]) == null || this.bsAtoms != null && (!this.bsAtoms.get(this.bond.atomIndex1) || !this.bsAtoms.get(this.bond.atomIndex2))) {
            if (this.ibond != this.bondCount) continue;
            return false;
        }
        return true;
    }

    public Object getAtomUniqueID1() {
        return this.bond.atomIndex1;
    }

    public Object getAtomUniqueID2() {
        return this.bond.atomIndex2;
    }

    public int getEncodedOrder() {
        return this.bond.order;
    }

    public float getRadius() {
        return this.bond.radius;
    }

    public short getColix() {
        return this.bond.colix;
    }
}

